/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.View;
import org.anyline.metadata.differ.MetadataDiffer;

public class ViewsDiffer
implements MetadataDiffer {
    private LinkedHashMap<String, View> adds = new LinkedHashMap();
    private LinkedHashMap<String, View> drops = new LinkedHashMap();
    private LinkedHashMap<String, View> updates = new LinkedHashMap();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static ViewsDiffer compare(LinkedHashMap<String, View> origins, LinkedHashMap<String, View> dests) {
        ViewsDiffer differ = new ViewsDiffer();
        LinkedHashMap<String, View> adds = new LinkedHashMap<String, View>();
        LinkedHashMap<String, View> drops = new LinkedHashMap<String, View>();
        LinkedHashMap<String, View> updates = new LinkedHashMap<String, View>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            View origin = origins.get(key);
            View dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.put(key, origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public LinkedHashMap<String, View> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, View> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, View> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, View> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, View> getUpdates() {
        return this.updates;
    }

    public void setUpdates(LinkedHashMap<String, View> updates) {
        this.updates = updates;
    }
}

