/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.differ.MetadataDiffer;

public class PrimaryDiffer
implements MetadataDiffer {
    private List<PrimaryKey> adds = new ArrayList<PrimaryKey>();
    private List<PrimaryKey> drops = new ArrayList<PrimaryKey>();
    private List<PrimaryKey> updates = new ArrayList<PrimaryKey>();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static PrimaryDiffer compare(LinkedHashMap<String, PrimaryKey> origins, LinkedHashMap<String, PrimaryKey> dests) {
        PrimaryDiffer differ = new PrimaryDiffer();
        ArrayList<PrimaryKey> adds = new ArrayList<PrimaryKey>();
        ArrayList<PrimaryKey> drops = new ArrayList<PrimaryKey>();
        ArrayList<PrimaryKey> updates = new ArrayList<PrimaryKey>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            PrimaryKey origin = origins.get(key);
            PrimaryKey dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public List<PrimaryKey> getAdds() {
        return this.adds;
    }

    public void setAdds(List<PrimaryKey> adds) {
        this.adds = adds;
    }

    public List<PrimaryKey> getDrops() {
        return this.drops;
    }

    public void setDrops(List<PrimaryKey> drops) {
        this.drops = drops;
    }

    public List<PrimaryKey> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<PrimaryKey> updates) {
        this.updates = updates;
    }
}

