/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Index;
import org.anyline.metadata.differ.MetadataDiffer;

public class IndexesDiffer
implements MetadataDiffer {
    private LinkedHashMap<String, Index> adds = new LinkedHashMap();
    private LinkedHashMap<String, Index> drops = new LinkedHashMap();
    private LinkedHashMap<String, Index> updates = new LinkedHashMap();

    public static IndexesDiffer compare(LinkedHashMap<String, Index> origins, LinkedHashMap<String, Index> dests) {
        IndexesDiffer differ = new IndexesDiffer();
        LinkedHashMap<String, Index> adds = new LinkedHashMap<String, Index>();
        LinkedHashMap<String, Index> drops = new LinkedHashMap<String, Index>();
        LinkedHashMap<String, Index> updates = new LinkedHashMap<String, Index>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Index<Object> origin = origins.get(key);
            Index<Object> dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.put(key, origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public LinkedHashMap<String, Index> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Index> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Index> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Index> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Index> getUpdates() {
        return this.updates;
    }

    public void setUpdates(LinkedHashMap<String, Index> updates) {
        this.updates = updates;
    }
}

