/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.entity.DefaultOrder;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.OriginRow;
import org.anyline.entity.PageNavi;
import org.anyline.entity.PageNaviConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageNavi
implements PageNavi,
Serializable,
Cloneable {
    protected static final long serialVersionUID = 3593100423479113410L;
    protected static final Logger log = LoggerFactory.getLogger(DefaultPageNavi.class);
    protected static final String BR = "\n";
    protected static final String TAB = "\t";
    protected static final String BR_TAB = "\n\t";
    protected int dataSize = 0;
    protected long totalRow = 0L;
    protected long totalPage = 0L;
    protected long curPage = 1L;
    protected int pageRange = 10;
    protected int pageRows = 10;
    protected long displayPageFirst = 0L;
    protected long displayPageLast = 0L;
    protected Boolean requiredTotal = null;
    protected Boolean autoCount = PageNaviConfig.IS_AUTO_COUNT;
    protected String baseLink = null;
    protected OrderStore orders = null;
    protected int calType = 0;
    protected long firstRow = 0L;
    protected long lastRow = -1L;
    protected boolean lazy = false;
    protected String flag = "";
    protected long lazyPeriod = 0L;
    protected String lazyKey = null;
    protected int type = 0;
    protected Map<String, List<Object>> params = null;
    protected String method = "post";
    protected String style = "";
    protected boolean showStat = true;
    protected boolean showJump = true;
    protected boolean showVol = true;
    protected String loadMoreFormat = "";

    public DefaultPageNavi() {
    }

    public DefaultPageNavi(long page) {
        this.curPage = page;
    }

    public DefaultPageNavi(long page, int vol) {
        this.curPage = page;
        this.pageRows = vol;
    }

    public DefaultPageNavi(long totalRow, long curPage, int pageRows, String baseLink) {
        this.totalRow = totalRow;
        this.curPage = curPage;
        this.setPageRows(pageRows);
        this.baseLink = baseLink;
    }

    public DefaultPageNavi(long curPage, int pageRows, String baseLink) {
        this.curPage = curPage;
        this.setPageRows(pageRows);
        this.baseLink = baseLink;
    }

    public DefaultPageNavi(String baseLink) {
        this.curPage = 1L;
        this.baseLink = baseLink;
    }

    public static PageNavi parse(DataRow row) {
        if (null == row) {
            return null;
        }
        PageNavi navi = row.entity(DefaultPageNavi.class, new String[0]);
        return navi;
    }

    @Override
    public PageNavi scope(long first, long last) {
        this.setFirstRow(first);
        this.setLastRow(last);
        this.setCalType(1);
        this.autoCount(false);
        return this;
    }

    @Override
    public PageNavi limit(long offset, int rows) {
        this.setFirstRow(offset);
        this.setLastRow(offset + (long)rows - 1L);
        this.setCalType(1);
        this.autoCount(false);
        return this;
    }

    @Override
    public PageNavi autoCount(boolean auto) {
        this.autoCount = auto;
        return this;
    }

    @Override
    public Boolean autoCount() {
        return this.autoCount;
    }

    @Override
    public PageNavi setDataSize(int size) {
        this.dataSize = size;
        return this;
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    @Override
    public PageNavi setCalType(int type) {
        this.calType = type;
        return this;
    }

    @Override
    public int getCalType() {
        return this.calType;
    }

    @Override
    public PageNavi calculate() {
        PageNaviConfig config;
        long totalPage = (this.totalRow - 1L) / (long)this.pageRows + 1L;
        if (this.curPage > totalPage && null != (config = PageNaviConfig.getInstance(this.style)) && config.VAR_LIMIT_SCOPE) {
            this.curPage = totalPage;
        }
        this.setTotalPage(totalPage);
        this.setDisplayPageFirst(NumberUtil.min(this.curPage, totalPage) - (long)(this.pageRange / 2));
        if (this.displayPageFirst > totalPage - (long)this.pageRange) {
            this.setDisplayPageFirst(totalPage - (long)this.pageRange + 1L);
        }
        if (this.displayPageFirst < 1L) {
            this.setDisplayPageFirst(1L);
        }
        this.setDisplayPageLast(this.displayPageFirst + (long)this.pageRange - 1L);
        if (this.displayPageLast > totalPage) {
            this.setDisplayPageLast(totalPage);
        }
        return this;
    }

    @Override
    public long getFirstRow() {
        if (this.calType == 0) {
            if (this.curPage <= 0L) {
                return 0L;
            }
            return (this.curPage - 1L) * (long)this.pageRows;
        }
        return this.firstRow;
    }

    @Override
    public long getLastRow() {
        if (this.calType == 0) {
            if (this.curPage == 0L) {
                return this.pageRows - 1;
            }
            return this.curPage * (long)this.pageRows - 1L;
        }
        return this.lastRow;
    }

    @Override
    public long getDisplayPageFirst() {
        return this.displayPageFirst;
    }

    @Override
    public PageNavi setDisplayPageFirst(long displayPageFirst) {
        this.displayPageFirst = displayPageFirst;
        return this;
    }

    @Override
    public long getDisplayPageLast() {
        return this.displayPageLast;
    }

    @Override
    public PageNavi setDisplayPageLast(long displayPageLast) {
        this.displayPageLast = displayPageLast;
        return this;
    }

    @Override
    public PageNavi addParam(String key, Object value) {
        List<Object> values;
        if (null == key || null == value) {
            return this;
        }
        if (null == this.params) {
            this.params = new HashMap<String, List<Object>>();
        }
        if (null == (values = this.params.get(key))) {
            values = new ArrayList<Object>();
        }
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        this.params.put(key, values);
        return this;
    }

    @Override
    public Object getParams(String key) {
        List<Object> result = null;
        if (null != this.params) {
            result = this.params.get(key);
        }
        return result;
    }

    @Override
    public Object getParam(String key) {
        Object result = null;
        if (null != this.params) {
            Object values = this.getParams(key);
            result = null != values && values instanceof List ? ((List)values).get(0) : values;
        }
        return result;
    }

    @Override
    public String getOrderText(boolean require) {
        return null;
    }

    public String getOrderText(boolean require, OrderStore store, String delimiter) {
        Object result = "";
        if (null == this.orders) {
            this.orders = store;
        } else if (null != store) {
            for (Order order : store.getOrders()) {
                this.orders.order(order);
            }
        }
        if (null != this.orders) {
            result = this.orders.getRunText(delimiter);
        }
        if (require && ((String)result).length() == 0) {
            result = "ORDER BY " + ConfigTable.DEFAULT_PRIMARY_KEY;
        }
        return result;
    }

    @Override
    public PageNavi order(Order order, boolean override) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(order, override);
        return this;
    }

    @Override
    public OrderStore getOrders() {
        return this.orders;
    }

    @Override
    public PageNavi order(Order order) {
        return this.order(order, true);
    }

    @Override
    public PageNavi order(String order, Order.TYPE type, boolean override) {
        return this.order(new DefaultOrder(order, type), override);
    }

    @Override
    public PageNavi order(String order, Order.TYPE type) {
        return this.order(order, type, true);
    }

    @Override
    public PageNavi order(String order, String type, boolean override) {
        return this.order(new DefaultOrder(order, type), override);
    }

    @Override
    public PageNavi order(String order, String type) {
        return this.order(order, type, true);
    }

    @Override
    public PageNavi order(String order, boolean override) {
        return this.order(new DefaultOrder(order), override);
    }

    @Override
    public PageNavi order(String order) {
        return this.order(order, true);
    }

    @Override
    public PageNavi setTotalRow(long totalRow) {
        this.totalRow = totalRow;
        this.calculate();
        return this;
    }

    @Override
    public PageNavi setTotalPage(long totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    @Override
    public PageNavi setCurPage(long curPage) {
        this.curPage = curPage;
        return this;
    }

    @Override
    public PageNavi setPageRows(int pageRows) {
        if (pageRows > 0) {
            this.pageRows = pageRows;
        }
        return this;
    }

    @Override
    public long getTotalRow() {
        return this.totalRow;
    }

    @Override
    public long getTotalPage() {
        return this.totalPage;
    }

    @Override
    public long getCurPage() {
        return this.curPage;
    }

    @Override
    public int getPageRows() {
        return this.pageRows;
    }

    @Override
    public String getBaseLink() {
        return this.baseLink;
    }

    @Override
    public PageNavi setBaseLink(String baseLink) {
        this.baseLink = baseLink;
        return this;
    }

    @Override
    public PageNavi setFirstRow(long firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @Override
    public PageNavi setLastRow(long lastRow) {
        this.lastRow = lastRow;
        return this;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public long getLazyPeriod() {
        return this.lazyPeriod;
    }

    @Override
    public PageNavi setLazy(long ms) {
        this.lazy = true;
        this.lazyPeriod = ms;
        return this;
    }

    @Override
    public PageNavi setLazyPeriod(long ms) {
        this.lazy = true;
        this.lazyPeriod = ms;
        return this;
    }

    @Override
    public PageNavi setLazyKey(String key) {
        this.lazyKey = key;
        return this;
    }

    @Override
    public String getLazyKey() {
        return this.lazyKey;
    }

    @Override
    public String getFlag() {
        return this.flag;
    }

    @Override
    public PageNavi setFlag(String flag) {
        this.flag = flag;
        return this;
    }

    @Override
    public boolean isShowStat() {
        return this.showStat;
    }

    @Override
    public PageNavi setShowStat(boolean showStat) {
        this.showStat = showStat;
        return this;
    }

    @Override
    public boolean isShowJump() {
        return this.showJump;
    }

    @Override
    public PageNavi setShowJump(boolean showJump) {
        this.showJump = showJump;
        return this;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public PageNavi setType(int type) {
        this.type = type;
        return this;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public PageNavi setStyle(String style) {
        this.style = style;
        return this;
    }

    @Override
    public String getGuide() {
        return this.loadMoreFormat;
    }

    @Override
    public PageNavi setGuide(String guide) {
        this.loadMoreFormat = guide;
        return this;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public PageNavi setMethod(String method) {
        this.method = method;
        return this;
    }

    @Override
    public boolean isShowVol() {
        return this.showVol;
    }

    @Override
    public PageNavi setShowVol(boolean showVol) {
        this.showVol = showVol;
        return this;
    }

    public String html(String adapter, String method) {
        String layout_html;
        PageNaviConfig config = PageNaviConfig.getInstance(this.style);
        if (null == config) {
            config = new PageNaviConfig();
        }
        boolean get = false;
        if ("get".equalsIgnoreCase(method)) {
            get = true;
        }
        this.calculate();
        StringBuilder navi = new StringBuilder();
        StringBuilder index = new StringBuilder();
        StringBuilder stat = new StringBuilder();
        StringBuilder vol = new StringBuilder();
        StringBuilder jump = new StringBuilder();
        Object configVarKey = "";
        if (null == this.flag) {
            this.flag = "";
        }
        if (get) {
            String params = null;
            if (config.VAR_CLIENT_SET_VOL_ENABLE) {
                params = config.KEY_PAGE_ROWS + "=" + this.pageRows;
            }
            if (null != params) {
                this.baseLink = this.baseLink.contains("?") ? this.baseLink + "&" + params : this.baseLink + "?" + params;
            }
        }
        String totalRowFormat = NumberUtil.format(this.totalRow, "###,##0");
        String totalPageFormat = NumberUtil.format(this.totalPage, "###,##0");
        String curPageFormat = NumberUtil.format(this.curPage, "###,##0");
        if ("ajax".equals(adapter)) {
            configVarKey = config.KEY_ID_FLAG + this.flag;
        }
        if ("html".equals(adapter)) {
            navi.append("<link rel=\"stylesheet\" href=\"" + config.STYLE_FILE_PATH + "\" type=\"text/css\"/>\n");
            navi.append("<script type=\"text/javascript\" src=\"" + config.SCRIPT_FILE_PATH + "\"></script>\n");
        }
        if ("html".equals(adapter)) {
            navi.append("<form class=\"form\" action=\"" + this.baseLink + "\" method=\"post\">\n");
        }
        if ("ajax".equals(adapter)) {
            navi.append("<div class=\"form\">\n");
        }
        navi.append("<input type='hidden' id='hid_cur_page_" + this.flag + "' name='" + config.KEY_PAGE_NO + "' class='anyline-navi-cur-page' value='" + this.curPage + "'/>\n");
        navi.append("<input type='hidden' id='hid_total_page_" + this.flag + "' name='" + config.KEY_TOTAL_PAGE + "' class='anyline-navi-total-page' value='" + this.totalPage + "'/>\n");
        navi.append("<input type='hidden' id='hid_total_row_" + this.flag + "' name='" + config.KEY_TOTAL_ROW + "' class='anyline-navi-total-row' value='" + this.totalRow + "'/>\n");
        if (config.VAR_CLIENT_SET_VOL_ENABLE) {
            navi.append("<input type='hidden' id='hid_page_rows_key_" + this.flag + "'  class='anyline-navi-page-rows-key' value='" + config.KEY_PAGE_ROWS + "'/>\n");
            navi.append("<input type='hidden' id='hid_page_rows_" + this.flag + "' name='" + config.KEY_PAGE_ROWS + "' class='anyline-navi-page-rows' value='" + this.pageRows + "'/>\n");
        }
        if ("ajax".equals(adapter)) {
            navi.append("<input type='hidden' class='" + config.KEY_ID_FLAG + "' value='" + this.flag + "'/>");
        }
        navi.append(this.createHidParams(config));
        navi.append("<div class=\"anyline-navi\">\n");
        String statFormat = config.STYLE_STAT_FORMAT;
        statFormat = statFormat.replace("${totalRow}", totalRowFormat).replace("${curPage}", curPageFormat).replace("${totalPage}", totalPageFormat);
        statFormat = statFormat.replace("${total-row}", totalRowFormat).replace("${cur-page}", curPageFormat).replace("${total-page}", totalPageFormat);
        if (this.showStat) {
            stat.append(statFormat).append(BR);
        }
        int range = config.VAR_PAGE_RANGE;
        long fr = NumberUtil.max(1L, this.curPage - (long)(range / 2));
        long to = fr + (long)range - 1L;
        boolean match = false;
        if (this.totalPage > (long)range && this.curPage > (long)(range / 2)) {
            match = true;
        }
        if (match) {
            to = this.curPage + (long)(range / 2);
        }
        if (this.totalPage - this.curPage < (long)(range / 2)) {
            fr = this.totalPage - (long)range;
        }
        fr = NumberUtil.max(fr, 1L);
        to = NumberUtil.min(to, this.totalPage);
        if (this.type == 0) {
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.info("[vol set][enable:{}][vol:{}][sort:{}]", new Object[]{config.VAR_CLIENT_SET_VOL_ENABLE, this.pageRows, config.CONFIG_PAGE_VAL_SET_SORT});
            }
            if (config.VAR_CLIENT_SET_VOL_ENABLE) {
                if (config.CONFIG_PAGE_VAL_SET_SORT == 2) {
                    vol.append(config.STYLE_PAGE_VOL.replace("{navi-conf}", (CharSequence)configVarKey).replace("{navi-conf-key}", this.flag));
                } else {
                    String[] nums = config.VAR_PAGE_VOL_NUMBERS.split(",");
                    String clazz = config.VAR_PAGE_VOL_CLASS;
                    if (BasicUtil.isEmpty((Object)clazz)) {
                        clazz = "navi-rows-set";
                    }
                    vol.append("<select class='").append(clazz).append("' id='navi_val_set_").append(this.flag).append("' onchange='_navi_change_vol(").append((String)configVarKey).append(")'>");
                    for (String num : nums) {
                        vol.append("<option value='").append(num).append("' id='navi_val_set_").append(this.flag).append("_item_").append(num).append("'");
                        if (this.pageRows == BasicUtil.parseInt(num, 0)) {
                            vol.append(" selected=\"selected\"");
                        }
                        vol.append(">").append(num).append(" \u6761/\u9875</option>\n");
                    }
                    vol.append("</select>");
                }
            }
            if (config.VAR_SHOW_INDEX_ELLIPSIS) {
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, method, "navi-button navi-prev-button", config.STYLE_BUTTON_PREV, NumberUtil.max(this.curPage - 1L, 1L), (String)configVarKey);
                }
                if (config.VAR_SHOW_INDEX) {
                    if (fr < 2L) {
                        fr = 2L;
                    }
                    if (to > this.totalPage - 1L) {
                        to = this.totalPage - 1L;
                    }
                    index.append("<div class='navi-num-border'>\n");
                    this.createPageTag(index, method, "navi-num-item", "1", 1L, (String)configVarKey);
                    if (fr > 2L) {
                        this.createPageTag(index, method, "navi-num-item", config.STYLE_INDEX_ELLIPSIS, 0L, (String)configVarKey);
                    }
                    for (long i = fr; i <= to; ++i) {
                        this.createPageTag(index, method, "navi-num-item", "" + i, i, (String)configVarKey);
                    }
                    if (to < this.totalPage - 1L) {
                        this.createPageTag(index, method, "navi-num-item", config.STYLE_INDEX_ELLIPSIS, 0L, (String)configVarKey);
                    }
                    if (this.totalPage > 1L) {
                        this.createPageTag(index, method, "navi-num-item", "" + this.totalPage, this.totalPage, (String)configVarKey);
                    }
                    index.append("</div>\n");
                }
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, method, "navi-button navi-next-button", config.STYLE_BUTTON_NEXT, (int)NumberUtil.min(this.curPage + 1L, this.totalPage), (String)configVarKey);
                }
            } else {
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, method, "navi-button navi-first-button", config.STYLE_BUTTON_FIRST, 1L, (String)configVarKey);
                    this.createPageTag(index, method, "navi-button navi-prev-button", config.STYLE_BUTTON_PREV, NumberUtil.max(this.curPage - 1L, 1L), (String)configVarKey);
                }
                if (config.VAR_SHOW_INDEX) {
                    index.append("<div class='navi-num-border'>\n");
                    for (long i = fr; i <= to; ++i) {
                        this.createPageTag(index, method, "navi-num-item", "" + i, i, (String)configVarKey);
                    }
                    index.append("</div>\n");
                }
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, method, "navi-button navi-next-button", config.STYLE_BUTTON_NEXT, (int)NumberUtil.min(this.curPage + 1L, this.totalPage), (String)configVarKey);
                    this.createPageTag(index, method, "navi-button navi-last-button", config.STYLE_BUTTON_LAST, this.totalPage, (String)configVarKey);
                }
            }
            if (this.showJump) {
                jump.append(config.STYLE_LABEL_JUMP).append("<input type='text' value='").append(this.curPage).append("' class='navi-go-txt anyline-jump-txt' id='hid_jump_txt_" + this.flag + "' onkeydown='_navi_jump_enter(" + (String)configVarKey + ")'/>").append(config.STYLE_LABEL_JUMP_PAGE).append("<span class='navi-go-button' onclick='_navi_jump(" + (String)configVarKey + ")'>").append(config.STYLE_BUTTON_JUMP).append("</span>\n");
            }
        } else if (this.type == 1) {
            if (this.curPage + 1L <= this.totalPage) {
                this.createPageTag(index, method, "navi-more-button", this.loadMoreFormat, (int)NumberUtil.min(this.curPage + 1L, this.totalPage + 1L), (String)configVarKey);
            } else {
                index.append(config.STYLE_PAGE_OVER);
            }
        }
        if (null == (layout_html = config.VAR_COMPONENT_LAYOUT)) {
            layout_html = "${navi-stat}${navi-index}${navi-vol}${navi-jump}";
        }
        layout_html = layout_html.replace("${stat}", stat.toString());
        layout_html = layout_html.replace("${index}", index.toString());
        layout_html = layout_html.replace("${vol}", vol.toString());
        layout_html = layout_html.replace("${jump}", jump.toString());
        layout_html = layout_html.replace("${navi-stat}", stat.toString());
        layout_html = layout_html.replace("${navi-index}", index.toString());
        layout_html = layout_html.replace("${navi-vol}", vol.toString());
        layout_html = layout_html.replace("${navi-jump}", jump.toString());
        navi.append(layout_html);
        navi.append("</div>");
        if ("html".equals(adapter)) {
            navi.append("</form>\n");
        }
        if ("ajax".equals(adapter)) {
            navi.append("</div>\n");
        }
        return navi.toString();
    }

    private void createPageTag(StringBuilder builder, String method, String clazz, String tag, long page, String configFlag) {
        boolean get = false;
        if ("get".equalsIgnoreCase(method)) {
            get = true;
        }
        builder.append("<span class ='").append(clazz);
        if (page == this.curPage && 0 == this.type) {
            if (clazz.contains("navi-num-item")) {
                builder.append(" navi-num-item-cur");
            } else {
                builder.append(" navi-disabled");
            }
            builder.append("'");
        } else {
            builder.append("'");
            if (page > 0L && !get) {
                builder.append(" onclick='_navi_go(").append(page);
                if (BasicUtil.isNotEmpty(configFlag)) {
                    builder.append(",").append(configFlag);
                }
                builder.append(")'");
            }
        }
        builder.append(">");
        if (get) {
            PageNaviConfig config = PageNaviConfig.getInstance(this.style);
            if (null == config) {
                config = new PageNaviConfig();
            }
            builder.append("<a href='").append(this.baseLink);
            if (this.baseLink.contains("?")) {
                builder.append("&");
            } else {
                builder.append("?");
            }
            builder.append(config.KEY_PAGE_NO).append("=").append(page).append("'>").append(tag).append("</a>");
        } else {
            builder.append(tag);
        }
        builder.append("</span>\n");
    }

    private String createHidParams(PageNaviConfig config) {
        Object html = "";
        try {
            if (null != this.params) {
                for (String key : this.params.keySet()) {
                    List<Object> values = this.params.get(key);
                    html = (String)html + this.createHidParam(key, values);
                }
            }
            html = (String)html + this.createHidParam(config.KEY_SHOW_STAT, this.showStat);
            html = (String)html + this.createHidParam(config.KEY_SHOW_JUMP, this.showJump);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return html;
    }

    @Override
    public String createHidParam(String name, Object values) {
        Object html = "";
        if (null == values) {
            html = "<input type='hidden' name='" + name + "' value=''>\n";
        } else if (values instanceof Collection) {
            Collection list = (Collection)values;
            for (Object obj : list) {
                html = (String)html + "<input type='hidden' name='" + name + "' value='" + String.valueOf(obj) + "'>\n";
            }
        } else {
            html = (String)html + "<input type='hidden' name='" + name + "' value='" + String.valueOf(values) + "'>\n";
        }
        return html;
    }

    @Override
    @Transient
    public String getHtml() {
        return this.html("html", "get");
    }

    @Transient
    public String html() {
        return this.html("html", "get");
    }

    @Override
    @Transient
    public String html(String adapter) {
        return this.html(adapter, "get");
    }

    @Override
    @Transient
    public String getForm() {
        return this.html("html", "post");
    }

    @Override
    @Transient
    public String form() {
        return this.html("html", "post");
    }

    @Override
    @Transient
    public String ajax() {
        return this.html("ajax", "post");
    }

    @Override
    public PageNavi clone() {
        PageNavi clone = null;
        try {
            clone = (PageNavi)super.clone();
        }
        catch (Exception e) {
            clone = new DefaultPageNavi();
        }
        return clone;
    }

    @Override
    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        ((DataRow)row).put("page", (Object)this.curPage);
        ((DataRow)row).put("vol", (Object)this.pageRows);
        ((DataRow)row).put("total", (Object)this.totalRow);
        ((DataRow)row).put("auto_count", (Object)this.autoCount);
        return row;
    }
}

