/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import org.anyline.adapter.KeyAdapter;
import org.anyline.entity.Aggregation;
import org.anyline.entity.AggregationConfig;
import org.anyline.entity.AnyData;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.geometry.Point;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.DefaultOgnlMemberAccess;
import org.anyline.util.EscapeUtil;
import org.anyline.util.NumberUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSet
implements Collection<DataRow>,
Serializable,
AnyData<DataSet> {
    private static final long serialVersionUID = 6443551515441660101L;
    protected static final Logger log = LoggerFactory.getLogger(DataSet.class);
    private LinkedHashMap<String, Column> metadatas = null;
    private Boolean override = null;
    private boolean result = true;
    private String code = null;
    private Exception exception = null;
    private String message = null;
    private PageNavi navi = null;
    private List<String> head = null;
    private List<DataRow> rows = null;
    private List<String> primaryKeys = null;
    private String datalink = null;
    private String dataSource = null;
    private Catalog catalog = null;
    private Schema schema = null;
    private LinkedHashMap<String, Table> tables = new LinkedHashMap();
    private long createTime = 0L;
    private long expires = -1L;
    private boolean isFromCache = false;
    private Map<String, Object> tags = new HashMap<String, Object>();
    protected DataRow attributes = null;
    public Select select = new Select();
    public Format format = new Format();
    public Parse parse = new Parse();

    public DataSet creatIndex(String key) {
        return this;
    }

    public DataSet() {
        this.rows = new ArrayList<DataRow>();
        this.createTime = System.currentTimeMillis();
    }

    public DataSet(List<Map<String, Object>> list) {
        this.rows = new ArrayList<DataRow>();
        if (null == list) {
            return;
        }
        for (Map<String, Object> map : list) {
            DataRow row = new DataRow(map);
            this.rows.add(row);
        }
    }

    public DataSet(KeyAdapter.KEY_CASE keyCase, List<Map<String, Object>> list) {
        this.rows = new ArrayList<DataRow>();
        if (null == list) {
            return;
        }
        for (Map<String, Object> map : list) {
            DataRow row = new DataRow(keyCase, map);
            this.rows.add(row);
        }
    }

    public static DataSet build(Collection<?> list, String ... fields) {
        return DataSet.parse(list, fields);
    }

    public static DataSet parse(Collection<?> list, String ... fields) {
        DataSet set = new DataSet();
        if (null != list) {
            for (Object obj : list) {
                DataRow row = null;
                row = obj instanceof DataRow ? (DataRow)obj : (obj instanceof Collection ? DataRow.parseList((Collection)obj, fields) : DataRow.parse(obj, fields));
                set.add(row);
            }
        }
        return set;
    }

    public static DataSet parseJson(KeyAdapter.KEY_CASE keyCase, String json) {
        if (null != json) {
            try {
                return DataSet.parseJson(keyCase, BeanUtil.JSON_MAPPER.readTree(json));
            }
            catch (Exception e) {
                log.error("parse json exception:", (Throwable)e);
            }
        }
        return null;
    }

    public static DataSet parseJson(String json) {
        return DataSet.parseJson(KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static DataSet parseJson(KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        DataSet set = new DataSet();
        if (null != json && json.isArray()) {
            for (JsonNode item : json) {
                set.add(DataRow.parseJson(keyCase, item));
            }
        }
        return set;
    }

    public static DataSet parseJson(JsonNode json) {
        return DataSet.parseJson(KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public Boolean getOverride() {
        return this.override;
    }

    public void setOverride(Boolean override) {
        this.override = override;
        for (DataRow row : this.rows) {
            row.setOverride(override);
        }
    }

    public DataSet attr(String key, Object value) {
        return this.setAttribute(key, value);
    }

    public DataSet setAttribute(String key, Object value) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        this.attributes.put(key, value);
        return this;
    }

    public Object attr(String key) {
        return this.getAttribute(key);
    }

    public Object getAttribute(String key) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        return this.attributes.get(key);
    }

    public DataRow getAttributes() {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        return this.attributes;
    }

    public DataSet setAttributes(DataRow attributes) {
        this.attributes = attributes;
        return this;
    }

    public DataSet setMetadata(LinkedHashMap<String, Column> metadatas) {
        this.metadatas = metadatas;
        return this;
    }

    public DataSet setMetadata(String name, Column column) {
        if (null == this.metadatas) {
            this.metadatas = new LinkedHashMap();
        }
        this.metadatas.put(name.toUpperCase(), column);
        return this;
    }

    public DataSet setMetadata(Column column) {
        if (null != column) {
            return this.setMetadata(column.getName(), column);
        }
        return this;
    }

    public LinkedHashMap<String, Column> getMetadatas() {
        return this.metadatas;
    }

    public Column getMetadata(String column) {
        if (null == this.metadatas) {
            return null;
        }
        return this.metadatas.get(column.toUpperCase());
    }

    public String getMetadataTypeName(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getTypeName();
        }
        return null;
    }

    public Integer getMetadataType(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getType();
        }
        return null;
    }

    public String getMetadataFullType(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getFullType();
        }
        return null;
    }

    public String getMetadataClassName(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getClassName();
        }
        return null;
    }

    public DataSet Camel() {
        for (DataRow row : this.rows) {
            row.Camel();
        }
        return this;
    }

    public DataSet camel_() {
        for (DataRow row : this.rows) {
            row.camel_();
        }
        return this;
    }

    public DataSet camel() {
        return this.camel(false);
    }

    public DataSet camel(boolean lower) {
        for (DataRow row : this.rows) {
            row.camel(lower);
        }
        return this;
    }

    public DataSet setIsNew(boolean bol) {
        for (DataRow row : this.rows) {
            row.setIsNew(bol);
        }
        return this;
    }

    public DataSet remove(String ... keys) {
        for (DataRow row : this.rows) {
            for (String key : keys) {
                row.remove(key);
            }
        }
        return this;
    }

    public DataSet compress() {
        for (DataRow row : this.rows) {
            row.compress();
        }
        return this;
    }

    public DataSet compress(String ... keys) {
        for (DataRow row : this.rows) {
            row.compress(keys);
        }
        return this;
    }

    public DataSet trim() {
        for (DataRow row : this.rows) {
            row.trim();
        }
        return this;
    }

    public DataSet trim(String ... keys) {
        for (DataRow row : this.rows) {
            row.trim(keys);
        }
        return this;
    }

    public DataSet sbc2dbc() {
        for (DataRow row : this.rows) {
            row.sbc2dbc();
        }
        return this;
    }

    public DataSet sbc2dbc(String ... keys) {
        for (DataRow row : this.rows) {
            row.sbc2dbc(keys);
        }
        return this;
    }

    public DataSet addPrimaryKey(boolean applyItem, String ... pks) {
        if (null != pks) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : pks) {
                list.add(pk);
            }
            this.addPrimaryKey(applyItem, list);
        }
        return this;
    }

    public DataSet addPrimaryKey(String ... pks) {
        return this.addPrimaryKey(true, pks);
    }

    public DataSet addPrimaryKey(boolean applyItem, Collection<String> pks) {
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        if (null == pks) {
            return this;
        }
        for (String pk : pks) {
            if (BasicUtil.isEmpty((Object)pk) || this.primaryKeys.contains(pk = DataSet.key(pk))) continue;
            this.primaryKeys.add(pk);
        }
        if (applyItem) {
            for (DataRow row : this.rows) {
                row.setPrimaryKey(false, this.primaryKeys);
            }
        }
        return this;
    }

    public DataSet addPrimaryKey(Collection<String> pks) {
        return this.addPrimaryKey(true, pks);
    }

    public DataSet setPrimaryKey(boolean applyItem, String ... pks) {
        if (null != pks) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : pks) {
                list.add(pk);
            }
            this.setPrimaryKey(applyItem, list);
        }
        return this;
    }

    public DataSet setPrimaryKey(String ... pks) {
        return this.setPrimaryKey(true, pks);
    }

    public DataSet setPrimaryKey(boolean applyItem, Collection<String> pks) {
        if (null == pks) {
            return this;
        }
        this.primaryKeys = new ArrayList<String>();
        this.addPrimaryKey(applyItem, pks);
        return this;
    }

    public DataSet setPrimaryKey(Collection<String> pks) {
        return this.setPrimaryKey(true, pks);
    }

    public DataSet set(int index, DataRow item) {
        this.rows.set(index, item);
        return this;
    }

    public boolean hasPrimaryKeys() {
        return null != this.primaryKeys && !this.primaryKeys.isEmpty();
    }

    public Column getPrimaryColumn() {
        LinkedHashMap<String, Column> columns = this.getPrimaryColumns();
        if (!columns.isEmpty()) {
            return columns.values().iterator().next();
        }
        String pk = null;
        List<String> pks = this.getPrimaryKeys();
        if (!pks.isEmpty()) {
            pk = pks.get(0);
        }
        if (null == pk) {
            pk = DataRow.DEFAULT_PRIMARY_KEY;
        }
        Column column = null;
        column = null != this.metadatas ? this.metadatas.get(pk.toUpperCase()) : new Column(pk);
        return column;
    }

    public LinkedHashMap<String, Column> getPrimaryColumns() {
        List<String> pks;
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        if (null != this.metadatas) {
            for (Column column : this.metadatas.values()) {
                if (column.isPrimaryKey() != 1) continue;
                columns.put(column.getName().toUpperCase(), column);
            }
        }
        if (columns.isEmpty() && null != (pks = this.getPrimaryKeys())) {
            for (String pk : pks) {
                Column column = null;
                if (null != this.metadatas) {
                    column = this.metadatas.get(pk.toUpperCase());
                }
                if (null == column) {
                    column = new Column(pk);
                }
                columns.put(pk.toUpperCase(), column);
            }
        }
        return columns;
    }

    public List<String> getPrimaryKeys() {
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        return this.primaryKeys;
    }

    public DataSet tag(String key, Object value) {
        this.tags.put(key, value);
        return this;
    }

    public DataSet setTag(String key, Object value) {
        this.tags.put(key, value);
        return this;
    }

    public Object tag(String key) {
        return this.tags.get(key);
    }

    public Object getTag(String key) {
        return this.tags.get(key);
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public DataSet addHead(String col) {
        if (null == this.head) {
            this.head = new ArrayList<String>();
        }
        if ("ROW_NUMBER".equals(col)) {
            return this;
        }
        if (this.head.contains(col)) {
            return this;
        }
        this.head.add(col);
        return this;
    }

    public List<String> getHead() {
        return this.head;
    }

    public int indexOf(Object obj) {
        return this.rows.indexOf(obj);
    }

    public DataSet ellipsis(int length, String ... columns) {
        for (DataRow row : this.rows) {
            row.ellipsis(length, columns);
        }
        return this;
    }

    public DataSet truncates(int begin, int end) {
        if (!this.rows.isEmpty()) {
            if (begin < 0) {
                begin = 0;
            }
            if (end >= this.rows.size()) {
                end = this.rows.size() - 1;
            }
            if (begin >= this.rows.size()) {
                begin = this.rows.size() - 1;
            }
            if (end <= 0) {
                end = 0;
            }
            this.rows = this.rows.subList(begin, end);
        }
        return this;
    }

    public DataSet truncates(int begin) {
        if (begin < 0) {
            begin = this.rows.size() + begin;
            int end = this.rows.size() - 1;
            return this.truncates(begin, end);
        }
        return this.truncates(begin, this.rows.size() - 1);
    }

    public DataRow truncate(int begin) {
        return this.truncate(begin, this.rows.size() - 1);
    }

    public DataRow truncate(int begin, int end) {
        this.truncates(begin, end);
        if (!this.rows.isEmpty()) {
            return this.rows.get(0);
        }
        return null;
    }

    public DataSet cuts(int begin) {
        if (begin < 0) {
            begin = this.rows.size() + begin;
            int end = this.rows.size() - 1;
            return this.cuts(begin, end);
        }
        return this.cuts(begin, this.rows.size() - 1);
    }

    public DataSet cuts(int begin, int end) {
        DataSet result = new DataSet();
        if (this.rows.isEmpty()) {
            return result;
        }
        if (begin < 0) {
            begin = 0;
        }
        if (end >= this.rows.size()) {
            end = this.rows.size() - 1;
        }
        if (begin >= this.rows.size()) {
            begin = this.rows.size() - 1;
        }
        if (end <= 0) {
            end = 0;
        }
        for (int i = begin; i <= end; ++i) {
            result.add(this.rows.get(i));
        }
        return result;
    }

    public DataRow cut(int begin) {
        return this.cut(begin, this.rows.size() - 1);
    }

    public DataRow cut(int begin, int end) {
        DataSet result = this.cuts(begin, end);
        if (!result.isEmpty()) {
            return result.getRow(0);
        }
        return null;
    }

    @Override
    public int size() {
        int result = 0;
        if (null != this.rows) {
            result = this.rows.size();
        }
        return result;
    }

    public long total() {
        if (null != this.navi) {
            return this.navi.getTotalRow();
        }
        return this.rows.size();
    }

    public int count(boolean empty, String key) {
        int result = 0;
        if (empty || BasicUtil.isEmpty((Object)key)) {
            result = this.rows.size();
        } else {
            for (DataRow row : this.rows) {
                if (!row.isNotEmpty(key)) continue;
                ++result;
            }
        }
        return result;
    }

    public int getSize() {
        return this.size();
    }

    public boolean isException() {
        return null != this.exception;
    }

    public boolean isFromCache() {
        return this.isFromCache;
    }

    public DataSet setIsFromCache(boolean bol) {
        this.isFromCache = bol;
        return this;
    }

    @Override
    public boolean isEmpty() {
        boolean result = true;
        if (null == this.rows) {
            result = true;
        } else if (this.rows instanceof Collection) {
            result = this.rows.isEmpty();
        }
        return result;
    }

    public DataRow getRow(int index) {
        DataRow row = null;
        if (null != this.rows && index < this.rows.size()) {
            row = this.rows.get(index);
        }
        if (null != row) {
            row.setContainer(this);
        }
        if (null == row && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            row = new DataRow();
        }
        return row;
    }

    public boolean exists(String ... params) {
        DataRow row = this.getRow(0, params);
        return row != null;
    }

    public DataRow getRow(Compare compare, String ... params) {
        return this.getRow(compare, 0, params);
    }

    public DataRow getRow(String ... params) {
        return this.getRow(null, 0, params);
    }

    public DataRow getRow(Compare compare, DataRow params) {
        return this.getRow(compare, 0, params);
    }

    public DataRow getRow(DataRow params) {
        return this.getRow(Compare.EQUAL, 0, params);
    }

    public DataRow getRow(Compare compare, List<String> params) {
        String[] kvs = BeanUtil.list2array(params);
        return this.getRow(compare, 0, kvs);
    }

    public DataRow getRow(List<String> params) {
        return this.getRow(Compare.EQUAL, params);
    }

    public DataRow getRow(Compare compare, int begin, String ... params) {
        DataSet set = this.getRows(compare, begin, 1, params);
        if (!set.isEmpty()) {
            return set.getRow(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    public DataSet getRows(Map<String, String> kvs) {
        return this.getRows(0, -1, kvs);
    }

    public DataSet getRows(Compare compare, Map<String, String> kvs) {
        return this.getRows(compare, 0, -1, kvs);
    }

    public DataRow getRow(int begin, String ... params) {
        return this.getRow(Compare.EQUAL, begin, params);
    }

    public DataRow getRow(Compare compare, int begin, DataRow params) {
        DataSet set = this.getRows(compare, begin, 1, params);
        if (!set.isEmpty()) {
            return set.getRow(0);
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    public DataRow getRow(int begin, DataRow params) {
        return this.getRow(Compare.EQUAL, begin, params);
    }

    public DataRow getRowById(String value) {
        return this.getRow("ID", value);
    }

    public DataRow getRowByPrimvaryValue(String value) {
        return this.getRow(DataRow.DEFAULT_PRIMARY_KEY, value);
    }

    public DataSet distinct(String ... keys) {
        DataSet result = new DataSet();
        HashMap<String, String> chks = new HashMap<String, String>();
        Object ks = "";
        for (String key : keys) {
            ks = (String)ks + "${" + key + "}";
        }
        if (null != this.rows) {
            for (DataRow row : this.rows) {
                String tag = row.getString((String)ks);
                if (chks.containsKey(tag)) continue;
                result.addRow(row.extract(keys));
                chks.put(tag, "0");
            }
        }
        result.copyProperty(this);
        return result;
    }

    public DataSet distinct(List<String> keys) {
        DataSet result = new DataSet();
        if (null != this.rows) {
            for (DataRow row : this.rows) {
                String[] params = this.packParam(row, keys);
                DataRow chk = result.getRow(params);
                if (chk != null && !chk.isEmpty()) continue;
                DataRow tmp = new DataRow();
                for (String key : keys) {
                    tmp.put(key, row.get(key));
                }
                result.addRow(tmp);
            }
        }
        result.copyProperty(this);
        return result;
    }

    public DataSet clone() {
        DataSet clone = null;
        try {
            clone = (DataSet)super.clone();
        }
        catch (Exception ignored) {
            clone = new DataSet();
        }
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this.rows) {
            rows.add(row.clone());
        }
        clone.setRows(rows);
        clone.copyProperty(this);
        return clone;
    }

    private DataSet copyProperty(DataSet from) {
        return DataSet.copyProperty(from, this);
    }

    public static DataSet copyProperty(DataSet from, DataSet to) {
        if (null != from && null != to) {
            to.exception = from.exception;
            to.message = from.message;
            to.navi = from.navi;
            to.head = from.head;
            to.primaryKeys = from.primaryKeys;
            to.dataSource = from.dataSource;
            to.datalink = from.datalink;
            to.schema = from.schema;
            to.tables = from.tables;
            to.metadatas = from.metadatas;
        }
        return to;
    }

    public DataSet convertNumber(String ... keys) {
        for (DataRow row : this.rows) {
            row.convertNumber(keys);
        }
        return this;
    }

    public DataSet convertString(String ... keys) {
        for (DataRow row : this.rows) {
            row.convertString(keys);
        }
        return this;
    }

    public DataSet convertInt(Integer def, String ... keys) {
        for (DataRow row : this.rows) {
            row.convertInt(def, keys);
        }
        return this;
    }

    public DataSet convertInt(String ... keys) {
        Integer def = null;
        return this.convertInt(def, keys);
    }

    public DataSet convertLong(String ... keys) {
        Long def = null;
        return this.convertLong(def, keys);
    }

    public DataSet convertLong(Long def, String ... keys) {
        for (DataRow row : this.rows) {
            row.convertLong(def, keys);
        }
        return this;
    }

    public DataSet convertDouble(String ... keys) {
        Double def = null;
        return this.convertDouble(def, keys);
    }

    public DataSet convertDouble(Double def, String ... keys) {
        for (DataRow row : this.rows) {
            row.convertDouble(def, keys);
        }
        return this;
    }

    public DataSet convertDecimal(String ... keys) {
        BigDecimal def = null;
        return this.convertDecimal(def, keys);
    }

    public DataSet convertDecimal(BigDecimal def, String ... keys) {
        for (DataRow row : this.rows) {
            row.convertDecimal(def, keys);
        }
        return this;
    }

    public DataSet skip(boolean skip) {
        for (DataRow row : this.rows) {
            row.skip = skip;
        }
        return this;
    }

    private Map<String, String> kvs(String ... params) {
        HashMap<String, String> kvs = new HashMap<String, String>();
        int len = params.length;
        boolean ignoreSplit = false;
        for (String param : params) {
            if (null != param && param.contains(":")) continue;
            ignoreSplit = true;
            break;
        }
        if (ignoreSplit) {
            for (int i = 0; i < len; i += 2) {
                String k = params[i];
                String v = params[i + 1];
                kvs.put(k, v);
            }
            return kvs;
        }
        int i = 0;
        String srcFlagTag = "srcFlag";
        while (i < len) {
            String p1 = params[i];
            if (BasicUtil.isEmpty((Object)p1)) {
                ++i;
                continue;
            }
            if (p1.contains(":")) {
                String[] ks = BeanUtil.parseKeyValue(p1);
                kvs.put(ks[0], ks[1]);
                ++i;
                continue;
            }
            if (i + 1 < len) {
                String p2 = params[i + 1];
                if (BasicUtil.isEmpty((Object)p2) || !p2.contains(":")) {
                    kvs.put(p1, p2);
                    i += 2;
                    continue;
                }
                if (BasicUtil.checkEl(p2)) {
                    p2 = p2.substring(2, p2.length() - 1);
                    kvs.put(p1, p2);
                    kvs.put(p1 + srcFlagTag, "true");
                    i += 2;
                    continue;
                }
                String[] ks = BeanUtil.parseKeyValue(p2);
                kvs.put(ks[0], ks[1]);
                i += 2;
                continue;
            }
            ++i;
        }
        return kvs;
    }

    public DataSet getRows(int begin, int qty, String ... params) {
        return this.getRows(begin, qty, this.kvs(params));
    }

    public DataSet getRows(PageNavi navi, String ... params) {
        return this.getRows((int)navi.getFirstRow(), (int)navi.getLastRow(), params);
    }

    public DataSet getRows(Compare compare, int begin, int qty, String ... params) {
        return this.getRows(compare, begin, qty, this.kvs(params));
    }

    public DataSet getRows(Compare compare, int begin, int qty, DataRow kvs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String k : kvs.keySet()) {
            map.put(k, kvs.getString(k));
        }
        return this.getRows(compare, begin, qty, map);
    }

    public DataSet getRows(int begin, int qty, DataRow kvs) {
        return this.getRows(Compare.EQUAL, begin, qty, kvs);
    }

    public DataSet getRows(int begin, int qty, Map<String, String> kvs) {
        return this.getRows(Compare.EQUAL, begin, qty, kvs);
    }

    public DataSet getRows(Compare compare, int begin, int qty, Map<String, String> kvs) {
        DataSet set = new DataSet();
        if (this.rows.isEmpty()) {
            return set;
        }
        String srcFlagTag = "srcFlag";
        HashMap<String, Compare> compares = new HashMap<String, Compare>();
        HashMap<String, String> compareKvs = new HashMap<String, String>();
        if (null == compare || compare == Compare.AUTO) {
            for (String k : kvs.keySet()) {
                String v = kvs.get(k);
                if (null == v) continue;
                Compare cmp = Compare.EQUAL;
                if (v.startsWith("=")) {
                    v = v.substring(1);
                    cmp = Compare.EQUAL;
                } else if (v.startsWith(">")) {
                    v = v.substring(1);
                    cmp = Compare.GREAT;
                } else if (v.startsWith(">=")) {
                    v = v.substring(2);
                    cmp = Compare.GREAT_EQUAL;
                } else if (v.startsWith("<")) {
                    v = v.substring(1);
                    cmp = Compare.LESS;
                } else if (v.startsWith("<=")) {
                    v = v.substring(2);
                    cmp = Compare.LESS_EQUAL;
                } else if (v.startsWith("%") && v.endsWith("%")) {
                    v = v.substring(1, v.length() - 1);
                    cmp = Compare.LIKE;
                } else if (v.endsWith("%")) {
                    v = v.substring(0, v.length() - 1);
                    cmp = Compare.LIKE_PREFIX;
                } else if (v.startsWith("%")) {
                    v = v.substring(1);
                    cmp = Compare.LIKE_SUFFIX;
                }
                compareKvs.put(k, v);
                compares.put(k, cmp);
            }
            kvs = compareKvs;
        }
        int size = this.rows.size();
        for (int i = begin; i < size; ++i) {
            DataRow row = this.rows.get(i);
            if (row.skip) continue;
            boolean chk = true;
            for (String k : kvs.keySet()) {
                boolean srcFlag = false;
                if (k.endsWith(srcFlagTag)) continue;
                String srcFlagValue = kvs.get(k + srcFlagTag);
                if (BasicUtil.isNotEmpty(srcFlagValue)) {
                    srcFlag = true;
                }
                Object value = row.get(k);
                Object v = kvs.get(k);
                if (!row.containsKey(k) && null == value) {
                    chk = false;
                    break;
                }
                if (null == v) {
                    if (null == value) continue;
                    chk = false;
                    break;
                }
                if (null == value) {
                    chk = false;
                    break;
                }
                Compare cmp = null;
                cmp = null != compare && Compare.AUTO != compare ? compare : (Compare)((Object)compares.get(k));
                if (null == cmp) continue;
                if (srcFlag) {
                    v = "${" + (String)v + "}";
                }
                if (cmp.compare(value, v)) continue;
                chk = false;
                break;
            }
            if (!chk) continue;
            set.add(row);
            if (qty > 0 && set.size() >= qty) break;
        }
        set.copyProperty(this);
        return set;
    }

    public DataSet getRows(Compare compare, int begin, String ... params) {
        return this.getRows(compare, begin, -1, params);
    }

    public DataSet getRows(int begin, String ... params) {
        return this.getRows(Compare.EQUAL, begin, -1, params);
    }

    public DataSet getRows(Compare compare, String ... params) {
        return this.getRows(compare, 0, params);
    }

    public DataSet getRows(String ... params) {
        return this.getRows(Compare.AUTO, 0, params);
    }

    public DataSet getRows(Compare compare, DataSet set, String key) {
        String[] kvs = new String[set.size()];
        int i = 0;
        for (DataRow row : set) {
            String value = row.getString(key);
            if (!BasicUtil.isNotEmpty(value)) continue;
            kvs[i++] = key + ":" + value;
        }
        return this.getRows(compare, kvs);
    }

    public DataSet getRows(DataSet set, String key) {
        return this.getRows(Compare.EQUAL, set, key);
    }

    public DataSet getRows(Compare compare, DataRow row, String ... keys) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        boolean i = false;
        for (String key : keys) {
            String value = row.getString(key);
            if (!BasicUtil.isNotEmpty(value)) continue;
            list.add((CallSite)((Object)(key + ":" + value)));
        }
        String[] kvs = (String[])BeanUtil.list2array(list);
        return this.getRows(compare, kvs);
    }

    public DataSet getRows(DataRow row, String ... keys) {
        return this.getRows(Compare.EQUAL, row, keys);
    }

    public DataSet filter(int begin, int end, String key, String value) {
        DataSet set = new DataSet();
        int size = this.size();
        if (begin < 0) {
            begin = 0;
        }
        for (int i = begin; i < size && i <= end; ++i) {
            String tmpValue = this.getString(i, key, "");
            if ((null != value || null != tmpValue) && (null == value || !value.equals(tmpValue))) continue;
            set.add(this.getRow(i));
        }
        set.copyProperty(this);
        return set;
    }

    public DataSet getRows(int fr, int to) {
        DataSet set = new DataSet();
        int size = this.size();
        if (fr < 0) {
            fr = 0;
        }
        for (int i = fr; i < size && i <= to; ++i) {
            set.addRow(this.getRow(i));
        }
        return set;
    }

    public BigDecimal sum(int begin, int end, String key) {
        BigDecimal result = BigDecimal.ZERO;
        int size = this.rows.size();
        if (begin <= 0) {
            begin = 0;
        }
        for (int i = begin; i < size && i <= end; ++i) {
            BigDecimal tmp = this.getDecimal(i, key, 0.0);
            if (null == tmp) continue;
            result = result.add(this.getDecimal(i, key, 0.0));
        }
        return result;
    }

    public BigDecimal sum(String key) {
        BigDecimal result = BigDecimal.ZERO;
        result = this.sum(0, this.size() - 1, key);
        return result;
    }

    public DataRow sums(DataRow result, List<String> keys) {
        if (null == result) {
            result = new DataRow();
        }
        if (this.size() > 0) {
            if (keys.isEmpty()) {
                keys = this.getRow(0).numberKeys();
            }
            for (String key : keys) {
                result.put(key, (Object)this.sum(key));
            }
        }
        return result;
    }

    public DataRow sums(DataRow result, String ... keys) {
        return this.sums(result, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataRow sums(String ... keys) {
        return this.sums(new DataRow(), BeanUtil.array2list(new String[][]{keys}));
    }

    public DataRow avgs(DataRow result, List<String> keys) {
        if (null == result) {
            result = new DataRow();
        }
        if (this.size() > 0) {
            if (keys.isEmpty()) {
                keys = this.getRow(0).numberKeys();
            }
            for (String key : keys) {
                result.put(key, (Object)this.avg(key));
            }
        }
        return result;
    }

    public DataRow avgs(DataRow result, String ... keys) {
        return this.avgs(result, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataRow avgs(String ... keys) {
        return this.avgs(new DataRow(), BeanUtil.array2list(new String[][]{keys}));
    }

    public DataRow avgs(DataRow result, boolean empty, int scale, int round, List<String> keys) {
        if (null == result) {
            result = new DataRow();
        }
        if (this.size() > 0) {
            if (keys.isEmpty()) {
                keys = this.getRow(0).numberKeys();
            }
            for (String key : keys) {
                result.put(key, (Object)this.avg(empty, scale, round, key));
            }
        }
        return result;
    }

    public DataRow avgs(DataRow result, boolean empty, int scale, int round, String ... keys) {
        return this.avgs(result, empty, scale, round, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataRow avgs(boolean empty, int scale, int round, String ... keys) {
        return this.avgs(new DataRow(), empty, scale, round, BeanUtil.array2list(new String[][]{keys}));
    }

    public BigDecimal maxDecimal(int top, String key) {
        BigDecimal result = null;
        int size = this.rows.size();
        if (size > top) {
            size = top;
        }
        for (int i = 0; i < size; ++i) {
            BigDecimal tmp = this.getDecimal(i, key, 0.0);
            if (null == tmp || null != result && tmp.compareTo(result) <= 0) continue;
            result = tmp;
        }
        return result;
    }

    public BigDecimal maxDecimal(String key) {
        return this.maxDecimal(this.size(), key);
    }

    public int maxInt(int top, String key) {
        BigDecimal result = this.maxDecimal(top, key);
        if (null == result) {
            return 0;
        }
        return result.intValue();
    }

    public int maxInt(String key) {
        return this.maxInt(this.size(), key);
    }

    public double maxDouble(int top, String key) {
        BigDecimal result = this.maxDecimal(top, key);
        if (null == result) {
            return 0.0;
        }
        return result.doubleValue();
    }

    public double maxDouble(String key) {
        return this.maxDouble(this.size(), key);
    }

    public long maxLong(int top, String key) {
        BigDecimal result = this.maxDecimal(top, key);
        if (null == result) {
            return 0L;
        }
        return result.longValue();
    }

    public long maxLong(String key) {
        return this.maxLong(this.size(), key);
    }

    public double maxFloat(int top, String key) {
        BigDecimal result = this.maxDecimal(top, key);
        if (null == result) {
            return 0.0;
        }
        return result.floatValue();
    }

    public double maxFloat(String key) {
        return this.maxFloat(this.size(), key);
    }

    public BigDecimal minDecimal(int top, String key) {
        BigDecimal result = null;
        int size = this.rows.size();
        if (size > top) {
            size = top;
        }
        for (int i = 0; i < size; ++i) {
            BigDecimal tmp = this.getDecimal(i, key, 0.0);
            if (null == tmp || null != result && tmp.compareTo(result) >= 0) continue;
            result = tmp;
        }
        return result;
    }

    public BigDecimal minDecimal(String key) {
        return this.minDecimal(this.size(), key);
    }

    public int minInt(int top, String key) {
        BigDecimal result = this.minDecimal(top, key);
        if (null == result) {
            return 0;
        }
        return result.intValue();
    }

    public int minInt(String key) {
        return this.minInt(this.size(), key);
    }

    public double minDouble(int top, String key) {
        BigDecimal result = this.minDecimal(top, key);
        if (null == result) {
            return 0.0;
        }
        return result.doubleValue();
    }

    public double minDouble(String key) {
        return this.minDouble(this.size(), key);
    }

    public double minFloat(int top, String key) {
        BigDecimal result = this.minDecimal(top, key);
        if (null == result) {
            return 0.0;
        }
        return result.floatValue();
    }

    public double minFloat(String key) {
        return this.minFloat(this.size(), key);
    }

    public DataRow max(String key) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        this.asc(key);
        return this.getRow(size - 1);
    }

    public DataRow min(String key) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        this.asc(key);
        return this.getRow(0);
    }

    public BigDecimal avg(boolean empty, int scale, int round, int top, String key) {
        BigDecimal result = BigDecimal.ZERO;
        int size = this.rows.size();
        if (size > top) {
            size = top;
        }
        int count = 0;
        for (int i = 0; i < size; ++i) {
            BigDecimal tmp = this.getDecimal(i, key, 0.0);
            if (null != tmp) {
                result = result.add(tmp);
            }
            if (null == tmp && !empty) continue;
            ++count;
        }
        if (count > 0) {
            result = result.divide(new BigDecimal(count), scale, round);
        }
        return result;
    }

    public BigDecimal avg(int scale, int round, String key) {
        return this.avg(true, scale, round, this.size(), key);
    }

    public BigDecimal avg(boolean empty, int scale, int round, String key) {
        return this.avg(empty, scale, round, this.size(), key);
    }

    public BigDecimal avg(boolean empty, String key) {
        return this.avg(empty, this.size(), 2, 4, key);
    }

    public BigDecimal avg(String key) {
        return this.avg(true, key);
    }

    public BigDecimal median(String key) {
        List<BigDecimal> numbers = this.getDecimals(key, BigDecimal.ZERO);
        Collections.sort(numbers);
        int size = numbers.size();
        int middle = size / 2;
        if (size > 0) {
            if (size % 2 == 1) {
                return numbers.get(middle);
            }
            return numbers.get(middle - 1).add(numbers.get(middle)).divide(new BigDecimal(2));
        }
        return null;
    }

    public Double median(String key, Double def) {
        BigDecimal median = this.median(key);
        if (null == median) {
            return def;
        }
        return median.doubleValue();
    }

    public Float median(String key, Float def) {
        BigDecimal median = this.median(key);
        if (null == median) {
            return def;
        }
        return Float.valueOf(median.floatValue());
    }

    public Long median(String key, Long def) {
        BigDecimal median = this.median(key);
        if (null == median) {
            return def;
        }
        return median.longValue();
    }

    public Integer median(String key, Integer def) {
        BigDecimal median = this.median(key);
        if (null == median) {
            return def;
        }
        return median.intValue();
    }

    public DataSet sum(String result, String items, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.sum(field));
        }
        return this;
    }

    public DataSet avg(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.avg(scale, round, field));
        }
        return this;
    }

    public DataSet var(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.var(scale, round, field));
        }
        return this;
    }

    public DataSet min(String result, String items, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.min(field));
        }
        return this;
    }

    public DataSet max(String result, String items, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.max(field));
        }
        return this;
    }

    public DataSet count(String result, String items, boolean empty, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.count(empty, field));
        }
        return this;
    }

    public DataSet vara(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.vara(scale, round, field));
        }
        return this;
    }

    public DataSet varp(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.varp(scale, round, field));
        }
        return this;
    }

    public DataSet varpa(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.varpa(scale, round, field));
        }
        return this;
    }

    public DataSet stdev(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.stdev(scale, round, field));
        }
        return this;
    }

    public DataSet stdeva(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.stdeva(scale, round, field));
        }
        return this;
    }

    public DataSet stdevp(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.stdevp(scale, round, field));
        }
        return this;
    }

    public DataSet stdevpa(String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, (Object)set.stdevpa(scale, round, field));
        }
        return this;
    }

    public DataSet agg(Aggregation agg, String result, String items, int scale, int round, String field, Compare compare, String ... conditions) {
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(items);
            if (null != conditions && conditions.length > 0) {
                set = set.getRows(compare, conditions);
            }
            row.put(result, set.agg(agg, scale, round, field));
        }
        return this;
    }

    public DataSet sum(String result, String items, String field, String ... conditions) {
        return this.sum(result, items, field, Compare.EQUAL, conditions);
    }

    public DataSet avg(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.avg(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet var(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.var(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet min(String result, String items, String field, String ... conditions) {
        return this.min(result, items, field, Compare.EQUAL, conditions);
    }

    public DataSet max(String result, String items, String field, String ... conditions) {
        return this.max(result, items, field, Compare.EQUAL, conditions);
    }

    public DataSet count(String result, String items, boolean empty, String field, String ... conditions) {
        return this.count(result, items, empty, field, Compare.EQUAL, conditions);
    }

    public DataSet vara(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.vara(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet varp(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.varp(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet varpa(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.varpa(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet stdev(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.stdev(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet stdeva(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.stdeva(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet stdevp(String result, String items, int scale, int round, String field, String ... conditions) {
        return this.stdevp(result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet agg(Aggregation agg, String result, String items, int scale, int round, String field, String ... conditions) {
        return this.agg(agg, result, items, scale, round, field, Compare.EQUAL, conditions);
    }

    public DataSet addRow(DataRow row) {
        if (null != row) {
            this.rows.add(row);
        }
        return this;
    }

    public DataSet addRow(int idx, DataRow row) {
        if (null != row) {
            this.rows.add(idx, row);
        }
        return this;
    }

    public String concat(String key, String connector) {
        return BasicUtil.concat(this.getStrings(key), connector);
    }

    public String concatNvl(String key, String connector) {
        return BasicUtil.concat(this.getNvlStrings(key), connector);
    }

    public String concatWithoutNull(String key, String connector) {
        return BasicUtil.concat(this.getStringsWithoutNull(key), connector);
    }

    public String concatWithoutEmpty(String key, String connector) {
        return BasicUtil.concat(this.getStringsWithoutEmpty(key), connector);
    }

    public String concatNvl(String key) {
        return BasicUtil.concat(this.getNvlStrings(key), ",");
    }

    public String concatWithoutNull(String key) {
        return BasicUtil.concat(this.getStringsWithoutNull(key), ",");
    }

    public String concatWithoutEmpty(String key) {
        return BasicUtil.concat(this.getStringsWithoutEmpty(key), ",");
    }

    public String concat(String key) {
        return BasicUtil.concat(this.getStrings(key), ",");
    }

    public List<Object> fetchValues(String key) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.get(i, key));
        }
        return result;
    }

    public List<String> fetchDistinctValue(String key) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            String value = this.getString(i, key, "");
            if (result.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    public List<String> fetchDistinctValues(String key) {
        return this.fetchDistinctValue(key);
    }

    public String displayNavi(String link) {
        String result = "";
        if (null != this.navi) {
            result = this.navi.getHtml();
        }
        return result;
    }

    public String navi(String link) {
        return this.displayNavi(link);
    }

    public String displayNavi() {
        return this.displayNavi(null);
    }

    public String navi() {
        return this.displayNavi(null);
    }

    public DataSet put(int idx, String key, Object value) {
        DataRow row = this.getRow(idx);
        if (null != row) {
            row.put(key, value);
        }
        return this;
    }

    public DataSet removes(String ... keys) {
        for (DataRow row : this.rows) {
            row.removes(keys);
        }
        return this;
    }

    public String getString(int index, String key) throws Exception {
        return this.getRow(index).getString(key);
    }

    public String getString(int index, String key, String def) {
        try {
            return this.getString(index, key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Point getPoint(int index, String key, Point def) {
        try {
            return this.getPoint(index, key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Point getPoint(int index, String key) throws Exception {
        return this.getRow(index).getPoint(key);
    }

    public String getString(String key) throws Exception {
        return this.getString(0, key);
    }

    public String getString(String key, String def) {
        return this.getString(0, key, def);
    }

    public Object get(int index, String key) {
        DataRow row = this.getRow(index);
        if (null != row) {
            return row.get(key);
        }
        return null;
    }

    public List<Object> gets(String key) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (DataRow row : this.rows) {
            list.add(row.get(key));
        }
        return list;
    }

    public List<DataSet> getSets(String key) {
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        for (DataRow row : this.rows) {
            DataSet set = row.getSet(key);
            if (null == set) continue;
            list.add(set);
        }
        return list;
    }

    public List<String> getStrings(String key) {
        ArrayList<String> result = new ArrayList<String>();
        for (DataRow row : this.rows) {
            result.add(row.getString(key));
        }
        return result;
    }

    public List<String> getStrings(String key, String ... defs) {
        ArrayList<String> result = new ArrayList<String>();
        for (DataRow row : this.rows) {
            result.add(row.getStringNvl(key, defs));
        }
        return result;
    }

    public List<String[]> getStringArrays(String ... keys) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (DataRow row : this.rows) {
            int len = keys.length;
            String[] item = new String[len];
            for (int i = 0; i < len; ++i) {
                String key = keys[i];
                item[i] = row.getString(key);
            }
            result.add(item);
        }
        return result;
    }

    public List<BigDecimal> getDecimals(String key, BigDecimal def) {
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
        for (DataRow row : this.rows) {
            result.add(row.getDecimal(key, def));
        }
        return result;
    }

    public List<Integer> getInts(String key) throws Exception {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (DataRow row : this.rows) {
            result.add(row.getInt(key));
        }
        return result;
    }

    public List<Integer> getDistinctInts(String key) throws Exception {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (DataRow row : this.rows) {
            int item = row.getInt(key);
            if (result.contains(row)) continue;
            result.add(item);
        }
        return result;
    }

    public List<Integer> getInts(String key, int def) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (DataRow row : this.rows) {
            result.add(row.getInt(key, (Integer)def));
        }
        return result;
    }

    public List<Integer[]> getIntArrays(String ... keys) throws Exception {
        ArrayList<Integer[]> result = new ArrayList<Integer[]>();
        for (DataRow row : this.rows) {
            int len = keys.length;
            Integer[] item = new Integer[len];
            for (int i = 0; i < len; ++i) {
                String key = keys[i];
                item[i] = row.getInt(key);
            }
            result.add(item);
        }
        return result;
    }

    public List<Integer[]> getIntArrays(Integer def, List<String> keys) {
        ArrayList<Integer[]> result = new ArrayList<Integer[]>();
        for (DataRow row : this.rows) {
            int len = keys.size();
            Integer[] item = new Integer[len];
            for (int i = 0; i < len; ++i) {
                String key = keys.get(i);
                item[i] = row.getInt(key, def);
            }
            result.add(item);
        }
        return result;
    }

    public List<Integer[]> getIntArrays(Integer def, String ... keys) {
        return this.getIntArrays(def, BeanUtil.array2list(new String[][]{keys}));
    }

    public List<Long> getLongs(String key) throws Exception {
        ArrayList<Long> result = new ArrayList<Long>();
        for (DataRow row : this.rows) {
            result.add(row.getLong(key));
        }
        return result;
    }

    public List<Long> getLongs(String key, Long def) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (DataRow row : this.rows) {
            result.add(row.getLong(key, def));
        }
        return result;
    }

    public List<Long> getDistinctLongs(String key, Long def) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (DataRow row : this.rows) {
            long item = row.getLong(key, def);
            if (result.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public List<Long[]> getLongArrays(String ... keys) throws Exception {
        ArrayList<Long[]> result = new ArrayList<Long[]>();
        for (DataRow row : this.rows) {
            int len = keys.length;
            Long[] item = new Long[len];
            for (int i = 0; i < len; ++i) {
                String key = keys[i];
                item[i] = row.getLong(key);
            }
            result.add(item);
        }
        return result;
    }

    public List<Long[]> getLongArrays(Long def, List<String> keys) {
        ArrayList<Long[]> result = new ArrayList<Long[]>();
        for (DataRow row : this.rows) {
            int len = keys.size();
            Long[] item = new Long[len];
            for (int i = 0; i < len; ++i) {
                String key = keys.get(i);
                item[i] = row.getLong(key, def);
            }
            result.add(item);
        }
        return result;
    }

    public List<Long[]> getLongArrays(Long def, String ... keys) {
        return this.getLongArrays(def, BeanUtil.array2list(new String[][]{keys}));
    }

    public List<Double> getDoubles(String key) throws Exception {
        ArrayList<Double> result = new ArrayList<Double>();
        for (DataRow row : this.rows) {
            result.add(row.getDouble(key));
        }
        return result;
    }

    public List<Double> getDistinctDoubles(String key) throws Exception {
        ArrayList<Double> result = new ArrayList<Double>();
        for (DataRow row : this.rows) {
            double item = row.getDouble(key);
            if (result.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public List<Double> getDoubles(String key, Double def) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (DataRow row : this.rows) {
            result.add(row.getDouble(key, def));
        }
        return result;
    }

    public List<Double[]> getDoubleArrays(String ... keys) throws Exception {
        ArrayList<Double[]> result = new ArrayList<Double[]>();
        for (DataRow row : this.rows) {
            int len = keys.length;
            Double[] item = new Double[len];
            for (int i = 0; i < len; ++i) {
                String key = keys[i];
                item[i] = row.getDouble(key);
            }
            result.add(item);
        }
        return result;
    }

    public List<Double[]> getDoubleArrays(Double def, List<String> keys) {
        ArrayList<Double[]> result = new ArrayList<Double[]>();
        for (DataRow row : this.rows) {
            int len = keys.size();
            Double[] item = new Double[len];
            for (int i = 0; i < len; ++i) {
                String key = keys.get(i);
                item[i] = row.getDouble(key, def);
            }
            result.add(item);
        }
        return result;
    }

    public List<Double[]> getDoubleArrays(Double def, String ... keys) {
        return this.getDoubleArrays(def, BeanUtil.array2list(new String[][]{keys}));
    }

    public List<Object> getObjects(String key) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (DataRow row : this.rows) {
            result.add(row.get(key));
        }
        return result;
    }

    public List<String> getDistinctStrings(String key) {
        return this.fetchDistinctValue(key);
    }

    public List<String> getNvlStrings(String key) {
        ArrayList<String> result = new ArrayList<String>();
        List<Object> list = this.fetchValues(key);
        for (Object val : list) {
            if (null != val) {
                result.add(val.toString());
                continue;
            }
            result.add("");
        }
        return result;
    }

    public List<String> getStringsWithoutEmpty(String key) {
        ArrayList<String> result = new ArrayList<String>();
        List<Object> list = this.fetchValues(key);
        for (Object val : list) {
            if (!BasicUtil.isNotEmpty(val)) continue;
            result.add(val.toString());
        }
        return result;
    }

    public List<String> getStringsWithoutNull(String key) {
        ArrayList<String> result = new ArrayList<String>();
        List<Object> list = this.fetchValues(key);
        for (Object val : list) {
            if (null == val) continue;
            result.add(val.toString());
        }
        return result;
    }

    public BigDecimal getDecimal(int idx, String key) throws Exception {
        return this.getRow(idx).getDecimal(key);
    }

    public BigDecimal getDecimal(int idx, String key, double def) {
        return this.getDecimal(idx, key, new BigDecimal(def));
    }

    public BigDecimal getDecimal(int idx, String key, BigDecimal def) {
        try {
            BigDecimal val = this.getDecimal(idx, key);
            if (null == val) {
                return def;
            }
            return val;
        }
        catch (Exception e) {
            return def;
        }
    }

    public DataSet extract(boolean regex, String ... keys) {
        return this.extract(regex, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet extract(boolean regex, List<String> keys) {
        DataSet result = new DataSet();
        for (DataRow row : this.rows) {
            DataRow item = row.extract(regex, keys);
            result.add(item);
        }
        result.navi = this.navi;
        return result;
    }

    public DataSet extract(String ... keys) {
        return this.extract(false, keys);
    }

    public String getEscapeString(int index, String key) throws Exception {
        return EscapeUtil.escape(this.getString(index, key)).toString();
    }

    public String getEscapeString(int index, String key, String def) {
        try {
            return this.getEscapeString(index, key);
        }
        catch (Exception e) {
            return EscapeUtil.escape(def).toString();
        }
    }

    public String getDoubleEscapeString(int index, String key) throws Exception {
        return EscapeUtil.escape2(this.getString(index, key));
    }

    public String getDoubleEscapeString(int index, String key, String def) {
        try {
            return this.getDoubleEscapeString(index, key);
        }
        catch (Exception e) {
            return EscapeUtil.escape2(def);
        }
    }

    public String getEscapeString(String key) throws Exception {
        return this.getEscapeString(0, key);
    }

    public String getDoubleEscapeString(String key) throws Exception {
        return this.getDoubleEscapeString(0, key);
    }

    public int getInt(int index, String key) throws Exception {
        return this.getRow(index).getInt(key);
    }

    public int getInt(int index, String key, int def) {
        try {
            return this.getInt(index, key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public int getInt(String key) throws Exception {
        return this.getInt(0, key);
    }

    public int getInt(String key, int def) {
        return this.getInt(0, key, def);
    }

    public double getDouble(int index, String key) throws Exception {
        return this.getRow(index).getDouble(key);
    }

    public double getDouble(int index, String key, double def) {
        try {
            return this.getDouble(index, key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public double getDouble(String key) throws Exception {
        return this.getDouble(0, key);
    }

    public double getDouble(String key, double def) {
        return this.getDouble(0, key, def);
    }

    public DataSet add(String target, String key, int value) {
        for (DataRow row : this.rows) {
            row.add(target, key, value);
        }
        return this;
    }

    public DataSet add(String target, String key, double value) {
        for (DataRow row : this.rows) {
            row.add(target, key, value);
        }
        return this;
    }

    public DataSet add(String target, String key, short value) {
        for (DataRow row : this.rows) {
            row.add(target, key, value);
        }
        return this;
    }

    public DataSet add(String target, String key, float value) {
        for (DataRow row : this.rows) {
            row.add(target, key, value);
        }
        return this;
    }

    public DataSet add(String target, String key, BigDecimal value) {
        for (DataRow row : this.rows) {
            row.add(target, key, value);
        }
        return this;
    }

    public DataSet add(String key, int value) {
        return this.add(key, key, value);
    }

    public DataSet add(String key, double value) {
        return this.add(key, key, value);
    }

    public DataSet add(String key, short value) {
        return this.add(key, key, value);
    }

    public DataSet add(String key, float value) {
        return this.add(key, key, value);
    }

    public DataSet add(String key, BigDecimal value) {
        return this.add(key, key, value);
    }

    public DataSet subtract(String target, String key, int value) {
        for (DataRow row : this.rows) {
            row.subtract(target, key, value);
        }
        return this;
    }

    public DataSet subtract(String target, String key, double value) {
        for (DataRow row : this.rows) {
            row.subtract(target, key, value);
        }
        return this;
    }

    public DataSet subtract(String target, String key, short value) {
        for (DataRow row : this.rows) {
            row.subtract(target, key, value);
        }
        return this;
    }

    public DataSet subtract(String target, String key, float value) {
        for (DataRow row : this.rows) {
            row.subtract(target, key, value);
        }
        return this;
    }

    public DataSet subtract(String target, String key, BigDecimal value) {
        for (DataRow row : this.rows) {
            row.subtract(target, key, value);
        }
        return this;
    }

    public DataSet subtract(String key, int value) {
        return this.subtract(key, key, value);
    }

    public DataSet subtract(String key, double value) {
        return this.subtract(key, key, value);
    }

    public DataSet subtract(String key, short value) {
        return this.subtract(key, key, value);
    }

    public DataSet subtract(String key, float value) {
        return this.subtract(key, key, value);
    }

    public DataSet subtract(String key, BigDecimal value) {
        return this.subtract(key, key, value);
    }

    public DataSet multiply(String target, String key, int value) {
        for (DataRow row : this.rows) {
            row.multiply(target, key, value);
        }
        return this;
    }

    public DataSet multiply(String target, String key, double value) {
        for (DataRow row : this.rows) {
            row.multiply(target, key, value);
        }
        return this;
    }

    public DataSet multiply(String target, String key, short value) {
        for (DataRow row : this.rows) {
            row.multiply(target, key, value);
        }
        return this;
    }

    public DataSet multiply(String target, String key, float value) {
        for (DataRow row : this.rows) {
            row.multiply(target, key, value);
        }
        return this;
    }

    public DataSet multiply(String target, String key, BigDecimal value) {
        for (DataRow row : this.rows) {
            row.multiply(target, key, value);
        }
        return this;
    }

    public DataSet multiply(String key, int value) {
        return this.multiply(key, key, value);
    }

    public DataSet multiply(String key, double value) {
        return this.multiply(key, key, value);
    }

    public DataSet multiply(String key, short value) {
        return this.multiply(key, key, value);
    }

    public DataSet multiply(String key, float value) {
        return this.multiply(key, key, value);
    }

    public DataSet multiply(String key, BigDecimal value) {
        return this.multiply(key, key, value);
    }

    public DataSet divide(String target, String key, int value) {
        for (DataRow row : this.rows) {
            row.divide(target, key, value);
        }
        return this;
    }

    public DataSet divide(String target, String key, double value) {
        for (DataRow row : this.rows) {
            row.divide(target, key, value);
        }
        return this;
    }

    public DataSet divide(String target, String key, short value) {
        for (DataRow row : this.rows) {
            row.divide(target, key, value);
        }
        return this;
    }

    public DataSet divide(String target, String key, float value) {
        for (DataRow row : this.rows) {
            row.divide(target, key, value);
        }
        return this;
    }

    public DataSet divide(String target, String key, BigDecimal value, int mode) {
        for (DataRow row : this.rows) {
            row.divide(target, key, value, mode);
        }
        return this;
    }

    public DataSet divide(String key, int value) {
        return this.divide(key, key, value);
    }

    public DataSet divide(String key, double value) {
        return this.divide(key, key, value);
    }

    public DataSet divide(String key, short value) {
        return this.divide(key, key, value);
    }

    public DataSet divide(String key, float value) {
        return this.divide(key, key, value);
    }

    public DataSet divide(String key, BigDecimal value, int mode) {
        return this.divide(key, key, value, mode);
    }

    public DataSet round(String target, String key, int scale, int mode) {
        for (DataRow row : this.rows) {
            row.round(target, key, scale, mode);
        }
        return this;
    }

    public DataSet round(String key, int scale, int mode) {
        return this.round(key, key, scale, mode);
    }

    public List<DataSet> split(int page) {
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        int size = this.size();
        if (page <= 0) {
            page = 1;
        }
        if (page > size) {
            page = size;
        }
        int vol = size / page;
        int dif = size - vol * page;
        int fr = 0;
        int to = 0;
        for (int i = 0; i < page; ++i) {
            to = fr + vol - 1;
            if (dif > 0) {
                ++to;
                --dif;
            }
            if (to >= size) {
                to = size - 1;
            }
            DataSet set = this.cuts(fr, to);
            list.add(set);
            fr = to + 1;
        }
        return list;
    }

    public List<DataSet> page(int vol) {
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        if (vol <= 0) {
            vol = 1;
        }
        int size = this.size();
        int page = (size - 1) / vol + 1;
        for (int i = 0; i < page; ++i) {
            int fr = i * vol;
            int to = (i + 1) * vol - 1;
            if (i == page - 1) {
                to = size - 1;
            }
            DataSet set = this.cuts(fr, to);
            list.add(set);
        }
        return list;
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "list");
        map.put("result", this.result);
        map.put("message", this.message);
        map.put("rows", this.rows);
        map.put("success", this.result);
        if (null != this.navi) {
            HashMap<String, Number> navi_ = new HashMap<String, Number>();
            navi_.put("page", this.navi.getCurPage());
            navi_.put("pages", this.navi.getTotalPage());
            navi_.put("rows", this.navi.getTotalRow());
            navi_.put("vol", this.navi.getPageRows());
            map.put("navi", navi_);
        }
        return BeanUtil.map2json(map);
    }

    public String toJson() {
        return BeanUtil.object2json(this);
    }

    public String getJson() {
        return this.toJSON();
    }

    @Override
    public String toJSON() {
        return this.toJson();
    }

    public String toJson(JsonInclude.Include include) {
        return BeanUtil.object2json(this, include);
    }

    public String getJson(JsonInclude.Include include) {
        return this.toJSON(include);
    }

    public String toJSON(JsonInclude.Include include) {
        return this.toJson(include);
    }

    public Map<String, DataRow> toMap(String key) {
        HashMap<String, DataRow> maps = new HashMap<String, DataRow>();
        for (DataRow row : this.rows) {
            maps.put(row.getString(key), row);
        }
        return maps;
    }

    public <T> T entity(int index, Class<T> clazz, String ... configs) {
        DataRow row = this.getRow(index);
        if (null != row) {
            return row.entity(clazz, configs);
        }
        return null;
    }

    public <T> List<T> entity(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        if (null != this.rows) {
            for (DataRow row : this.rows) {
                list.add(row.entity(clazz, new String[0]));
            }
        }
        return list;
    }

    public <T> T entity(Class<T> clazz, int idx) {
        DataRow row = this.getRow(idx);
        if (null != row) {
            return row.entity(clazz, new String[0]);
        }
        return null;
    }

    public <T> EntitySet<T> entitys(Class<T> clazz) {
        return EntityAdapterProxy.entitys(clazz, this, this.metadatas);
    }

    public DataSet setDest(String dest) {
        if (null == dest) {
            return this;
        }
        Catalog catalog = null;
        Schema schema = null;
        Table table = null;
        if (dest.contains(".") && !dest.contains(":")) {
            String[] tmps = dest.split("\\.");
            if (tmps.length == 2) {
                schema = new Schema(tmps[0]);
                table = new Table(tmps[1]);
                table.setSchema(schema);
            } else if (tmps.length == 3) {
                catalog = new Catalog(tmps[0]);
                schema = new Schema(tmps[1]);
                schema.setCatalog(catalog);
                table = new Table(tmps[2]);
                table.setSchema(schema);
                table.setCatalog(catalog);
            }
            this.setCatalog(catalog);
            this.setSchema(schema);
            this.setTable(table);
        } else {
            table = new Table(dest);
            this.setTable(table);
        }
        for (DataRow row : this.rows) {
            if (!BasicUtil.isEmpty((Object)row.getDest())) continue;
            row.setCatalog(catalog);
            row.setSchema(schema);
            row.setTable(table);
        }
        return this;
    }

    public DataSet union(DataSet set, List<String> keys) {
        int i;
        int size;
        DataSet result = new DataSet();
        if (null != this.rows) {
            size = this.rows.size();
            for (i = 0; i < size; ++i) {
                result.add(this.rows.get(i));
            }
        }
        if (keys.isEmpty()) {
            keys.add(ConfigTable.DEFAULT_PRIMARY_KEY);
        }
        size = set.size();
        for (i = 0; i < size; ++i) {
            DataRow item = set.getRow(i);
            if (result.contains(item, keys)) continue;
            result.add(item);
        }
        return result;
    }

    public DataSet union(DataSet set, String ... keys) {
        return this.union(set, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet unionAll(DataSet set) {
        int i;
        int size;
        DataSet result = new DataSet();
        if (null != this.rows) {
            size = this.rows.size();
            for (i = 0; i < size; ++i) {
                result.add(this.rows.get(i));
            }
        }
        size = set.size();
        for (i = 0; i < size; ++i) {
            DataRow item = set.getRow(i);
            result.add(item);
        }
        return result;
    }

    public boolean contains(DataRow row, List<String> keys) {
        if (null == this.rows || this.rows.isEmpty() || null == row) {
            return false;
        }
        if (keys.isEmpty()) {
            keys.add(ConfigTable.DEFAULT_PRIMARY_KEY);
        }
        String[] params = this.packParam(row, keys);
        return this.exists(params);
    }

    public boolean contains(DataRow row, String ... keys) {
        return this.contains(row, BeanUtil.array2list(new String[][]{keys}));
    }

    public String[] packParam(DataRow row, String ... keys) {
        return this.packParam(row, BeanUtil.array2list(new String[][]{keys}));
    }

    public String[] packParam(DataRow row, List<String> keys) {
        if (null == keys || null == row) {
            return null;
        }
        String[] params = new String[keys.size() * 2];
        int idx = 0;
        for (String key : keys) {
            if (null == key) continue;
            String[] ks = BeanUtil.parseKeyValue(key);
            params[idx++] = ks[0];
            params[idx++] = row.getString(ks[1]);
        }
        return params;
    }

    public DataSet setParent(String key, DataRow parent) {
        for (DataRow row : this.rows) {
            row.setParent(key, parent);
        }
        return this;
    }

    public DataSet dispatchs(Compare compare, String field, boolean unique, boolean recursion, DataSet items, List<String> keys) {
        if (null == items) {
            return this;
        }
        if (keys.isEmpty()) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u5bf9\u5e94\u5173\u7cfb");
        }
        if (BasicUtil.isEmpty((Object)field)) {
            field = "ITEMS";
        }
        for (DataRow row : this.rows) {
            if (null != row.get(field)) continue;
            String[] kvs = this.packParam(row, this.reverseKey(keys));
            DataSet set = items.getRows(compare, this.kvs(kvs));
            set.remove(row);
            DataSet parents = row.getAllParent(field);
            int size = set.size();
            block1: for (DataRow parent : parents) {
                for (int i = 0; i < size; ++i) {
                    DataRow chk = set.getRow(i);
                    if (parent != chk) continue;
                    DataRow copy = new DataRow();
                    copy.copy(chk, new String[0]);
                    copy.put(false, field, (Object)new DataSet());
                    set.set(i, copy);
                    continue block1;
                }
            }
            if (recursion) {
                set.dispatchs(compare, field, unique, recursion, items, keys);
            }
            if (unique) {
                set.skip(true);
            }
            row.put(false, field, (Object)set);
            set.setParent(field, row);
        }
        items.skip(false);
        return this;
    }

    public DataSet dispatchs(Compare compare, String field, boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatchs(compare, field, unique, recursion, items, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet dispatchs(Compare compare, boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatchs(compare, "ITEMS", unique, recursion, items, keys);
    }

    public DataSet dispatchs(Compare compare, String field, DataSet items, String ... keys) {
        return this.dispatchs(compare, field, false, false, items, keys);
    }

    public DataSet dispatchs(Compare compare, DataSet items, String ... keys) {
        return this.dispatchs(compare, "ITEMS", items, keys);
    }

    public DataSet dispatchs(Compare compare, boolean unique, boolean recursion, String ... keys) {
        return this.dispatchs(compare, "ITEMS", unique, recursion, this, keys);
    }

    public DataSet dispatchs(Compare compare, String field, boolean unique, boolean recursion, String ... keys) {
        return this.dispatchs(compare, field, unique, recursion, this, keys);
    }

    public DataSet dispatch(Compare compare, String field, boolean unique, boolean recursion, DataSet items, List<String> keys) {
        if (null == items) {
            return this;
        }
        if (keys.isEmpty()) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u5bf9\u5e94\u5173\u7cfb");
        }
        if (BasicUtil.isEmpty((Object)field)) {
            field = "ITEMS";
        }
        for (DataRow row : this.rows) {
            if (null != row.get(field)) continue;
            String[] params = this.packParam(row, this.reverseKey(keys));
            DataRow result = items.getRow(compare, params);
            if (null != result && !result.isEmpty() && unique) {
                result.skip = true;
            }
            row.put(field, (Object)result);
        }
        items.skip(false);
        return this;
    }

    public DataSet dispatch(Compare compare, String field, boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatch(compare, field, unique, recursion, items, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet dispatch(Compare compare, String field, DataSet items, String ... keys) {
        return this.dispatch(compare, field, false, false, items, keys);
    }

    public DataSet dispatch(Compare compare, DataSet items, String ... keys) {
        return this.dispatch(compare, "ITEM", false, false, items, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet dispatch(Compare compare, boolean unique, boolean recursion, String ... keys) {
        return this.dispatch(compare, "ITEM", unique, recursion, this, keys);
    }

    public DataSet dispatch(Compare compare, String field, boolean unique, boolean recursion, String ... keys) {
        return this.dispatch(compare, field, unique, recursion, this, keys);
    }

    public DataSet dispatchs(String field, boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatchs(Compare.EQUAL, field, unique, recursion, items, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet dispatchs(boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatchs(Compare.EQUAL, "ITEMS", unique, recursion, items, keys);
    }

    public DataSet dispatchs(String field, DataSet items, String ... keys) {
        return this.dispatchs(Compare.EQUAL, field, false, false, items, keys);
    }

    public DataSet dispatchs(DataSet items, String ... keys) {
        return this.dispatchs(Compare.EQUAL, "ITEMS", items, keys);
    }

    public DataSet dispatchs(boolean unique, boolean recursion, String ... keys) {
        return this.dispatchs(Compare.EQUAL, "ITEMS", unique, recursion, this, keys);
    }

    public DataSet dispatchs(String field, boolean unique, boolean recursion, String ... keys) {
        return this.dispatchs(Compare.EQUAL, field, unique, recursion, this, keys);
    }

    public DataSet dispatch(String field, boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatch(Compare.EQUAL, field, unique, recursion, items, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet dispatch(String field, DataSet items, String ... keys) {
        return this.dispatch(Compare.EQUAL, field, false, false, items, keys);
    }

    public DataSet dispatch(DataSet items, String ... keys) {
        return this.dispatch(Compare.EQUAL, "ITEM", false, false, items, BeanUtil.array2list(new String[][]{keys}));
    }

    public DataSet dispatch(boolean unique, boolean recursion, String ... keys) {
        return this.dispatch(Compare.EQUAL, "ITEM", unique, recursion, this, keys);
    }

    public DataSet dispatch(String field, boolean unique, boolean recursion, String ... keys) {
        return this.dispatch(Compare.EQUAL, field, unique, recursion, this, keys);
    }

    @Deprecated
    public DataSet dispatchItems(String field, boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatchs(field, unique, recursion, items, keys);
    }

    @Deprecated
    public DataSet dispatchItems(boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatchs(unique, recursion, items, keys);
    }

    @Deprecated
    public DataSet dispatchItems(String field, DataSet items, String ... keys) {
        return this.dispatchs(field, items, keys);
    }

    @Deprecated
    public DataSet dispatchItems(DataSet items, String ... keys) {
        return this.dispatchs(items, keys);
    }

    @Deprecated
    public DataSet dispatchItems(boolean unique, boolean recursion, String ... keys) {
        return this.dispatchs(unique, recursion, keys);
    }

    @Deprecated
    public DataSet dispatchItems(String field, boolean unique, boolean recursion, String ... keys) {
        return this.dispatchs(field, unique, recursion, keys);
    }

    @Deprecated
    public DataSet dispatchItem(String field, boolean unique, boolean recursion, DataSet items, String ... keys) {
        return this.dispatch(field, unique, recursion, items, keys);
    }

    @Deprecated
    public DataSet dispatchItem(String field, DataSet items, String ... keys) {
        return this.dispatch(field, items, keys);
    }

    @Deprecated
    public DataSet dispatchItem(DataSet items, String ... keys) {
        return this.dispatch(items, keys);
    }

    @Deprecated
    public DataSet dispatchItem(boolean unique, boolean recursion, String ... keys) {
        return this.dispatch(unique, recursion, keys);
    }

    @Deprecated
    public DataSet dispatchItem(String field, boolean unique, boolean recursion, String ... keys) {
        return this.dispatch(field, unique, recursion, keys);
    }

    public DataSet join(DataSet items, List<String> keys) {
        if (null == items || keys.isEmpty()) {
            return this;
        }
        for (DataRow row : this.rows) {
            String[] params = this.packParam(row, this.reverseKey(keys));
            DataRow result = items.getRow(params);
            if (null == result || result.isEmpty()) continue;
            row.copy(result, result.keys(), new String[0]);
        }
        return this;
    }

    public DataSet join(DataSet items, String ... keys) {
        return this.join(items, BeanUtil.array2list(new String[][]{keys}));
    }

    @Override
    public DataSet toLowerKey(boolean recursion, String ... keys) {
        for (DataRow row : this.rows) {
            row.toLowerKey(recursion, keys);
        }
        return this;
    }

    @Override
    public DataSet toUpperKey(boolean recursion, String ... keys) {
        for (DataRow row : this.rows) {
            row.toUpperKey(recursion, keys);
        }
        return this;
    }

    public DataSet toLowerValue() {
        for (DataRow row : this.rows) {
            row.toLowerValue(new String[0]);
        }
        return this;
    }

    public DataSet toUpperValue() {
        for (DataRow row : this.rows) {
            row.toUpperValue(new String[0]);
        }
        return this;
    }

    public DataSet setUpdateNullColumn(boolean updateNullColumn) {
        for (DataRow row : this.rows) {
            row.setUpdateNullColumn(updateNullColumn);
        }
        return this;
    }

    public DataSet setUpdateEmptyColumn(boolean updateEmptyColumn) {
        for (DataRow row : this.rows) {
            row.setUpdateEmptyColumn(updateEmptyColumn);
        }
        return this;
    }

    public DataSet group(String field, Compare compare, String ... keys) {
        DataSet groups = this.distinct(keys);
        groups.dispatchs(compare, field, true, false, this, keys);
        return groups;
    }

    public DataSet group(String ... keys) {
        return this.group("ITEMS", Compare.EQUAL, keys);
    }

    public DataSet group(String items, String field, String factor, Aggregation agg, int scale, int round, String ... keys) {
        String items_key = "ITEMS";
        if (BasicUtil.isNotEmpty(items)) {
            items_key = items;
        }
        DataSet groups = this.group(items_key, Compare.EQUAL, keys);
        for (DataRow group : groups) {
            group.put(field, group.getItems().agg(agg, scale, round, factor));
            if (!BasicUtil.isEmpty((Object)items)) continue;
            group.remove(items_key);
        }
        return groups;
    }

    public DataSet group(String items, List<AggregationConfig> aggs, String ... keys) {
        String items_key = "ITEMS";
        if (BasicUtil.isNotEmpty(items)) {
            items_key = items;
        }
        DataSet groups = this.group(items_key, Compare.EQUAL, keys);
        for (DataRow group : groups) {
            for (AggregationConfig config : aggs) {
                group.put(config.getField(), group.getItems().agg(config.getAggregation(), config.getScale(), config.getRound(), config.getFactor()));
            }
            if (!BasicUtil.isEmpty((Object)items)) continue;
            group.remove(items_key);
        }
        return groups;
    }

    public DataSet group(String factor, Aggregation agg, String ... keys) {
        Object field = agg.getCode();
        if (BasicUtil.isNotEmpty(factor)) {
            field = factor + "_" + (String)field;
        }
        return this.group(null, (String)field, factor, agg, 0, 0, keys);
    }

    public DataSet group(Aggregation agg, String ... keys) {
        return this.group(null, agg.getCode(), null, agg, 0, 0, keys);
    }

    public Object agg(String type, String key) {
        Aggregation agg = Aggregation.valueOf(type);
        return this.agg(agg, key);
    }

    public Object agg(Aggregation agg, String key) {
        return this.agg(agg, 2, 4, key);
    }

    public Object agg(Aggregation agg, int scale, int round, String key) {
        Serializable result = null;
        switch (agg) {
            case COUNT: {
                result = Integer.valueOf(this.count(false, key));
                break;
            }
            case SUM: {
                result = this.sum(key);
                break;
            }
            case AVG: {
                result = this.avg(false, scale, round, key);
                break;
            }
            case AVGA: {
                result = this.avg(true, scale, round, key);
                break;
            }
            case MEDIAN: {
                result = this.median(key);
                break;
            }
            case MAX: {
                result = this.max(key);
                break;
            }
            case MAX_DECIMAL: {
                result = this.maxDecimal(key);
                break;
            }
            case MAX_DOUBLE: {
                result = Double.valueOf(this.maxDouble(key));
                break;
            }
            case MAX_FLOAT: {
                result = Double.valueOf(this.maxFloat(key));
                break;
            }
            case MAX_INT: {
                result = Integer.valueOf(this.maxInt(key));
                break;
            }
            case MIN: {
                result = this.min(key);
                break;
            }
            case MIN_DECIMAL: {
                result = this.minDecimal(key);
                break;
            }
            case MIN_DOUBLE: {
                result = Double.valueOf(this.minDouble(key));
                break;
            }
            case MIN_FLOAT: {
                result = Double.valueOf(this.minFloat(key));
                break;
            }
            case MIN_INT: {
                result = Integer.valueOf(this.minInt(key));
                break;
            }
            case STDEV: {
                result = this.stdev(scale, round, key);
                break;
            }
            case STDEVP: {
                result = this.stdevp(scale, round, key);
                break;
            }
            case STDEVA: {
                result = this.stdeva(scale, round, key);
                break;
            }
            case STDEVPA: {
                result = this.stdevpa(scale, round, key);
                break;
            }
            case VAR: {
                result = this.var(scale, round, key);
                break;
            }
            case VARA: {
                result = this.vara(scale, round, key);
                break;
            }
            case VARP: {
                result = this.varp(scale, round, key);
                break;
            }
            case VARPA: {
                result = this.varpa(scale, round, key);
            }
        }
        return result;
    }

    public BigDecimal stdev(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.stdev(values, scale, round);
    }

    public BigDecimal stdeva(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.stdeva(values, scale, round);
    }

    public BigDecimal stdevp(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.stdevp(values, scale, round);
    }

    public BigDecimal stdevpa(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.stdevpa(values, scale, round);
    }

    public BigDecimal var(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.var(values, scale, round);
    }

    public BigDecimal vara(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.vara(values, scale, round);
    }

    public BigDecimal varp(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.varp(values, scale, round);
    }

    public BigDecimal varpa(int scale, int round, String key) {
        List<BigDecimal> values = this.getDecimals(key, null);
        return NumberUtil.varpa(values, scale, round);
    }

    public DataSet or(DataSet set, String ... keys) {
        return this.union(set, keys);
    }

    public static DataSet intersection(boolean distinct, List<DataSet> sets, String ... keys) {
        DataSet result = null;
        if (null != sets && !sets.isEmpty()) {
            for (DataSet set : sets) {
                if (null == result) {
                    result = set;
                    continue;
                }
                result = result.intersection(distinct, set, keys);
            }
        }
        if (null == result) {
            result = new DataSet();
        }
        return result;
    }

    public static DataSet intersection(List<DataSet> sets, String ... keys) {
        return DataSet.intersection(false, sets, keys);
    }

    public DataSet intersection(boolean distinct, DataSet set, String ... keys) {
        DataSet result = new DataSet();
        if (null == set) {
            return result;
        }
        for (DataRow row : this.rows) {
            String[] kv;
            if (!set.contains(row, kv = this.reverseKey(keys))) continue;
            if (!result.contains(row, kv)) {
                result.add(row.clone());
                continue;
            }
            if (distinct) continue;
            result.add(row.clone());
        }
        return result;
    }

    public DataSet intersection(DataSet set, String ... keys) {
        return this.intersection(false, set, keys);
    }

    public DataSet and(boolean distinct, DataSet set, String ... keys) {
        return this.intersection(distinct, set, keys);
    }

    public DataSet and(DataSet set, String ... keys) {
        return this.intersection(false, set, keys);
    }

    public DataSet complement(boolean distinct, DataSet set, String ... keys) {
        DataSet result = new DataSet();
        for (DataRow row : this.rows) {
            String[] kv = this.reverseKey(keys);
            if (null != set && set.contains(row, kv) || distinct && result.contains(row, kv)) continue;
            result.add(row.clone());
        }
        return result;
    }

    public DataSet complement(DataSet set, String ... keys) {
        return this.complement(false, set, keys);
    }

    public DataSet difference(boolean distinct, DataSet set, String ... keys) {
        DataSet result = new DataSet();
        for (DataRow row : this.rows) {
            String[] kv = this.reverseKey(keys);
            if (null != set && set.contains(row, kv) || distinct && result.contains(row, kv)) continue;
            result.add(row.clone());
        }
        return result;
    }

    public DataSet difference(DataSet set, String ... keys) {
        return this.difference(false, set, keys);
    }

    private String[] reverseKey(String[] keys) {
        return this.reverseKey(BeanUtil.array2list(new String[][]{keys}));
    }

    private String[] reverseKey(List<String> keys) {
        if (null == keys) {
            return new String[0];
        }
        int size = keys.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            Object key = keys.get(i);
            if (BasicUtil.isNotEmpty(key) && ((String)key).contains(":")) {
                String[] ks = BeanUtil.parseKeyValue((String)key);
                key = ks[1] + ":" + ks[0];
            }
            result[i] = key;
        }
        return result;
    }

    public DataSet removeEmptyRow(String ... keys) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            DataRow row = this.getRow(i);
            if (null == keys || keys.length == 0) {
                if (!row.isEmpty()) continue;
                this.remove(row);
                continue;
            }
            boolean isEmpty = true;
            for (String key : keys) {
                if (!row.isNotEmpty(key)) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) continue;
            this.remove(row);
        }
        return this;
    }

    public DataSet changeKey(String key, String target, boolean remove) {
        if (null == key || null == target) {
            return this;
        }
        if (key.equals(target)) {
            return this;
        }
        for (DataRow row : this.rows) {
            row.changeKey(key, target, remove);
        }
        return this;
    }

    public DataSet changeKey(String key, String target) {
        return this.changeKey(key, target, true);
    }

    public DataSet removeColumn(String ... columns) {
        if (null != columns) {
            for (String column : columns) {
                for (DataRow row : this.rows) {
                    row.remove(column);
                }
            }
        }
        return this;
    }

    public DataSet removeEmptyColumn(String ... columns) {
        for (DataRow row : this.rows) {
            row.removeEmpty(columns);
        }
        return this;
    }

    public DataSet nvl() {
        for (DataRow row : this.rows) {
            row.nvl(new String[0]);
        }
        return this;
    }

    public DataRow add(KeyAdapter.KEY_CASE cs) {
        DataRow row = new DataRow(cs);
        this.add(row);
        return row;
    }

    public DataRow add() {
        DataRow row = new DataRow();
        this.add(row);
        return row;
    }

    @Override
    public boolean add(DataRow e) {
        if (null != e && null == e.getContainer()) {
            e.setContainer(this);
        }
        return this.rows.add(e);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.rows.addAll(c);
    }

    @Override
    public void clear() {
        this.rows.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.rows.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rows.containsAll(c);
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        int size = this.rows.size();
        for (int i = size - 1; i >= 0; --i) {
            DataRow item = this.rows.get(i);
            if (item != o) continue;
            this.rows.remove(item);
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.rows.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.rows.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.rows.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.rows.toArray(a);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogName() {
        if (null != this.catalog) {
            return this.catalog.getName();
        }
        return null;
    }

    public DataSet setCatalog(Catalog catalog) {
        this.catalog = catalog;
        return this;
    }

    public DataSet setCatalog(String catalog) {
        this.catalog = BasicUtil.isNotEmpty(catalog) ? new Catalog(catalog) : null;
        return this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getSchemaName() {
        if (null != this.schema) {
            return this.schema.getName();
        }
        return null;
    }

    public DataSet setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public DataSet setSchema(String schema) {
        this.schema = BasicUtil.isNotEmpty(schema) ? new Schema(schema) : null;
        return this;
    }

    public Table getTable(boolean checkItem) {
        Table table = null;
        if (null != this.tables && !this.tables.isEmpty()) {
            table = this.tables.values().iterator().next();
        }
        if (null == table && checkItem && !this.rows.isEmpty()) {
            return this.rows.get(0).getTable(false);
        }
        return table;
    }

    public Table getTable() {
        return this.getTable(true);
    }

    public String getTableName() {
        Table tab = this.getTable();
        if (null != tab) {
            return tab.getName();
        }
        return null;
    }

    public String getTableFullName() {
        Table table = this.getTable();
        if (null != table) {
            return table.getFullName();
        }
        return null;
    }

    public LinkedHashMap<String, Table> getTables(boolean checkItem) {
        if (null != this.tables && !this.tables.isEmpty()) {
            return this.tables;
        }
        if (checkItem && !this.rows.isEmpty()) {
            return this.rows.get(0).getTables(false);
        }
        return this.tables;
    }

    public DataSet setTables(List<Table> tables) {
        this.tables = new LinkedHashMap();
        if (null != tables) {
            for (Table table : tables) {
                this.addTable(table);
            }
        }
        return this;
    }

    public DataSet setTables(LinkedHashMap<String, Table> tables) {
        this.tables = tables;
        return this;
    }

    public DataSet setTable(Table table) {
        this.tables = new LinkedHashMap();
        this.addTable(table);
        return this;
    }

    public DataSet addTable(Table table) {
        String name;
        if (null == this.tables) {
            this.tables = new LinkedHashMap();
        }
        if (null != table && null != (name = table.getName())) {
            this.tables.put(name.toUpperCase(), table);
        }
        return this;
    }

    public DataSet setTable(String table) {
        if (null != table) {
            if (table.contains(".")) {
                String[] tbs = table.split("\\.");
                if (tbs.length == 2) {
                    this.setTable(new Table(tbs[1]));
                    this.schema = new Schema(tbs[0]);
                } else if (tbs.length == 3) {
                    this.setTable(new Table(tbs[2]));
                    this.schema = new Schema(tbs[1]);
                    this.catalog = new Catalog(tbs[0]);
                }
            } else {
                this.setTable(new Table(table));
            }
        } else {
            this.tables = new LinkedHashMap();
        }
        return this;
    }

    public boolean isExpire(int millisecond) {
        return System.currentTimeMillis() - this.createTime > (long)millisecond;
    }

    public boolean isExpire(long millisecond) {
        return System.currentTimeMillis() - this.createTime > millisecond;
    }

    public boolean isExpire() {
        if (this.getExpires() == -1L) {
            return false;
        }
        return System.currentTimeMillis() - this.createTime > this.getExpires();
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public List<DataRow> getRows() {
        return this.rows;
    }

    public long getExpires() {
        return this.expires;
    }

    public DataSet setExpires(long millisecond) {
        this.expires = millisecond;
        return this;
    }

    public DataSet setExpires(int millisecond) {
        this.expires = millisecond;
        return this;
    }

    public boolean isResult() {
        return this.result;
    }

    public boolean isSuccess() {
        return this.result;
    }

    public DataSet setResult(boolean result) {
        this.result = result;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public DataSet setException(Exception exception) {
        this.exception = exception;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public DataSet setMessage(String message) {
        this.message = message;
        return this;
    }

    public PageNavi getNavi() {
        return this.navi;
    }

    public DataSet setNavi(PageNavi navi) {
        this.navi = navi;
        if (null != navi) {
            navi.setDataSize(this.size());
        }
        return this;
    }

    public DataSet setRows(List<DataRow> rows) {
        this.rows = rows;
        return this;
    }

    public String getDest() {
        Object dest = null;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        String tableName = this.getTableName();
        if (BasicUtil.isNotEmpty(catalogName)) {
            dest = catalogName;
        }
        if (BasicUtil.isNotEmpty(schemaName)) {
            dest = null == dest ? schemaName : (String)dest + "." + schemaName;
        }
        if (BasicUtil.isNotEmpty(tableName)) {
            dest = null == dest ? tableName : (String)dest + "." + tableName;
        }
        return dest;
    }

    public DataSet order(String ... keys) {
        return this.asc(keys);
    }

    public DataSet put(String key, Object value, boolean pk, boolean override) {
        for (DataRow row : this.rows) {
            row.put(key, value, pk, override);
        }
        return this;
    }

    public DataSet putWithoutNull(String key, Object value) {
        if (null != value) {
            this.put(key, value);
        }
        return this;
    }

    public DataSet putWithoutEmpty(String key, Object value) {
        if (BasicUtil.isNotEmpty(value)) {
            this.put(key, value);
        }
        return this;
    }

    public DataSet putIfNull(String key, Object value) {
        for (DataRow row : this.rows) {
            row.putIfNull(key, value);
        }
        return this;
    }

    public DataSet putIfEmpty(String key, Object value) {
        for (DataRow row : this.rows) {
            row.putIfEmpty(key, value);
        }
        return this;
    }

    public DataSet put(String key, Object value, boolean pk) {
        for (DataRow row : this.rows) {
            row.put(key, value, pk);
        }
        return this;
    }

    public DataSet put(String key, Object value) {
        for (DataRow row : this.rows) {
            row.put(key, value);
        }
        return this;
    }

    public DataSet derive(String key, Object origin) {
        return this.putVar(key, origin);
    }

    public DataSet putVar(String key, Object value) {
        block8: {
            int regex;
            block9: {
                block7: {
                    String str;
                    int idx;
                    regex = 0;
                    if (value instanceof String && (idx = (str = (String)value).indexOf("${")) != -1) {
                        if (str.startsWith("$") && str.endsWith("}")) {
                            regex = 1;
                            if (str.indexOf("${", idx + 2) > 0 && idx != -1) {
                                regex = 2;
                            }
                        } else {
                            regex = 2;
                        }
                    }
                    if (regex != 0) break block7;
                    for (DataRow row : this.rows) {
                        row.put(key, value);
                    }
                    break block8;
                }
                if (regex != true) break block9;
                for (DataRow row : this.rows) {
                    String k = (String)value;
                    k = k.substring(2, k.length() - 1);
                    row.put(key, row.get(k));
                }
                break block8;
            }
            if (regex != 2) break block8;
            for (DataRow row : this.rows) {
                row.put(key, (Object)row.getString((String)value));
            }
        }
        return this;
    }

    public DataSet pivot(List<String> pks, List<String> classKeys, List<String> valueKeys) {
        DataSet result = this.distinct(pks);
        DataSet classValues = this.distinct(classKeys);
        for (DataRow row : result) {
            for (DataRow classValue : classValues) {
                DataRow params = new DataRow();
                params.copy(row, pks, new String[0]).copy(classValue, new String[0]);
                DataRow valueRow = this.getRow(params);
                if (null != valueRow && !valueRow.isEmpty()) {
                    valueRow.skip = true;
                }
                String finalKey = this.concatValue(classValue, "-");
                if (null != valueKeys && !valueKeys.isEmpty()) {
                    if (valueKeys.size() == 1) {
                        if (null != valueRow) {
                            row.put(finalKey, valueRow.get(valueKeys.get(0)));
                            continue;
                        }
                        row.put(finalKey, (Object)null);
                        continue;
                    }
                    for (String valueKey : valueKeys) {
                        if (null != valueRow) {
                            row.put(finalKey + "-" + valueKey, valueRow.get(valueKey));
                            continue;
                        }
                        row.put(finalKey + "-" + valueKey, (Object)null);
                    }
                    continue;
                }
                if (null != valueRow) {
                    row.put(finalKey, (Object)valueRow);
                    continue;
                }
                row.put(finalKey, (Object)null);
            }
        }
        this.skip(false);
        return result;
    }

    public DataSet pivot(String[] pks, String[] classKeys, String[] valueKeys) {
        return this.pivot(BeanUtil.array2list(new String[][]{pks}), BeanUtil.array2list(new String[][]{classKeys}), BeanUtil.array2list(new String[][]{valueKeys}));
    }

    public DataSet pivot(String pk, String classKey, String valueKey) {
        List<String> pks = BeanUtil.array2list(new String[][]{pk.trim().split(",")});
        List<String> classKeys = BeanUtil.array2list(new String[][]{classKey.trim().split(",")});
        List<String> valueKeys = BeanUtil.array2list(new String[][]{valueKey.trim().split(",")});
        return this.pivot(pks, classKeys, valueKeys);
    }

    public DataSet pivot(String pk, String classKey) {
        List<String> pks = BeanUtil.array2list(new String[][]{pk.trim().split(",")});
        List<String> classKeys = BeanUtil.array2list(new String[][]{classKey.trim().split(",")});
        ArrayList<String> valueKeys = new ArrayList<String>();
        return this.pivot(pks, classKeys, valueKeys);
    }

    public DataSet pivot(List<String> pks, List<String> classKeys, String ... valueKeys) {
        ArrayList<String> list = new ArrayList<String>();
        if (null != valueKeys) {
            for (String item : valueKeys) {
                list.add(item);
            }
        }
        return this.pivot(pks, classKeys, valueKeys);
    }

    public Map map(String key, String value) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (DataRow row : this.rows) {
            map.put(row.get(key), row.get(value));
        }
        return map;
    }

    public Map map(String key) {
        LinkedHashMap<Object, DataRow> map = new LinkedHashMap<Object, DataRow>();
        for (DataRow row : this.rows) {
            map.put(row.get(key), row);
        }
        return map;
    }

    public Map map(int key) {
        LinkedHashMap<Object, DataRow> map = new LinkedHashMap<Object, DataRow>();
        if (null == this.rows || this.rows.isEmpty()) {
            return map;
        }
        String k = this.rows.get(0).keys().get(0);
        for (DataRow row : this.rows) {
            map.put(row.get(k), row);
        }
        return map;
    }

    public Map map(int key, int value) {
        List<String> keys;
        if (null != this.rows && !this.rows.isEmpty() && (keys = this.rows.get(0).keys()).size() > key && keys.size() > value) {
            return this.map(keys.get(key), keys.get(value));
        }
        return new LinkedHashMap();
    }

    public Map map() {
        List<String> keys;
        if (null != this.rows && this.rows.size() > 0 && (keys = this.rows.get(0).keys()).size() > 1) {
            return this.map(keys.get(0), keys.get(1));
        }
        return new LinkedHashMap();
    }

    public DataRow row(String key, String value) {
        DataRow result = new DataRow();
        for (DataRow row : this.rows) {
            result.put(row.getString(key), row.get(value));
        }
        return result;
    }

    public DataRow row(int key, int value) {
        List<String> keys;
        if (null != this.rows && this.rows.size() > 0 && (keys = this.rows.get(0).keys()).size() > key && keys.size() > value) {
            return this.row(keys.get(key), keys.get(value));
        }
        return new DataRow();
    }

    public DataRow row() {
        List<String> keys;
        if (null != this.rows && this.rows.size() > 0 && (keys = this.rows.get(0).keys()).size() > 1) {
            return this.row(keys.get(0), keys.get(1));
        }
        return new DataRow();
    }

    private String concatValue(DataRow row, String split) {
        StringBuilder builder = new StringBuilder();
        List<String> keys = row.keys();
        for (String key : keys) {
            if (builder.length() > 0) {
                builder.append(split);
            }
            builder.append(row.getString(key));
        }
        return builder.toString();
    }

    private String[] kvs(DataRow row) {
        List<String> keys = row.keys();
        int size = keys.size();
        String[] kvs = new String[size * 2];
        for (int i = 0; i < size; ++i) {
            String k = keys.get(i);
            String v = row.getStringNvl(k, new String[0]);
            kvs[i * 2] = k;
            kvs[i * 2 + 1] = v;
        }
        return kvs;
    }

    public DataSet asc(String ... keys) {
        this.sort(1, keys);
        return this;
    }

    public DataSet desc(String ... keys) {
        this.sort(-1, keys);
        return this;
    }

    public DataSet sort(final int factor, final String ... keys) {
        Collections.sort(this.rows, new Comparator<DataRow>(){

            @Override
            public int compare(DataRow r1, DataRow r2) {
                int result = 0;
                for (String key : keys) {
                    TypeMetadata.CATEGORY_GROUP type = null;
                    Column column = DataSet.this.getMetadata(key);
                    if (null != column) {
                        type = column.getTypeMetadata().getCategoryGroup();
                    }
                    Object v1 = r1.get(key);
                    Object v2 = r2.get(key);
                    if (null == v1) {
                        if (null == v2) continue;
                        return -factor;
                    }
                    if (null == v2) {
                        return factor;
                    }
                    if (type == TypeMetadata.CATEGORY_GROUP.NUMBER) {
                        BigDecimal num1 = new BigDecimal(v1.toString());
                        BigDecimal num2 = new BigDecimal(v2.toString());
                        result = num1.compareTo(num2);
                    } else if (type == TypeMetadata.CATEGORY_GROUP.DATETIME) {
                        Date date1 = DateUtil.parse(v1);
                        Date date2 = DateUtil.parse(v2);
                        result = date1.compareTo(date2);
                    } else {
                        result = v1.toString().compareTo(v2.toString());
                    }
                    if (result == 0) continue;
                    if (result > 0) {
                        return factor;
                    }
                    return -factor;
                }
                return result;
            }
        });
        return this;
    }

    public DataSet addAllUpdateColumns() {
        for (DataRow row : this.rows) {
            row.addAllUpdateColumns();
        }
        return this;
    }

    public DataSet clearUpdateColumns() {
        for (DataRow row : this.rows) {
            row.clearUpdateColumns();
        }
        return this;
    }

    public DataSet removeNull(String ... keys) {
        for (DataRow row : this.rows) {
            row.removeNull(keys);
        }
        return this;
    }

    private static String key(String key) {
        if (null != key && ConfigTable.IS_UPPER_KEY) {
            key = key.toUpperCase();
        }
        return key;
    }

    public DataSet replaceNull(String replace, String ... keys) {
        for (DataRow row : this.rows) {
            row.replaceNull(replace, keys);
        }
        return this;
    }

    public DataSet replaceEmpty(String replace, String ... keys) {
        for (DataRow row : this.rows) {
            row.replaceEmpty(replace, keys);
        }
        return this;
    }

    public DataSet replaces(String oldChar, String replace, String ... keys) {
        if (null == oldChar) {
            return this;
        }
        for (DataRow row : this.rows) {
            row.replaces(oldChar, replace, keys);
        }
        return this;
    }

    public DataSet replaces(boolean regex, String oldChar, String replace, String ... keys) {
        if (regex) {
            return this.replaceRegex(oldChar, replace, keys);
        }
        return this.replaces(oldChar, replace, keys);
    }

    public DataSet replaceRegex(String regex, String replace, String ... keys) {
        for (DataRow row : this.rows) {
            row.replaceRegex(regex, replace, keys);
        }
        return this;
    }

    public DataRow random() {
        DataRow row = null;
        int size = this.size();
        if (size > 0) {
            row = this.getRow(BasicUtil.getRandomNumber(0, size - 1));
        }
        return row;
    }

    public DataSet randoms(int qty) {
        DataSet set = new DataSet();
        int size = this.size();
        if (qty < 0) {
            qty = 0;
        }
        if (qty > size) {
            qty = size;
        }
        for (int i = 0; i < qty; ++i) {
            int idx;
            DataRow row;
            while (set.contains(row = this.getRow(idx = BasicUtil.getRandomNumber(0, size - 1)))) {
            }
            set.add(row);
        }
        set.copyProperty(this);
        return set;
    }

    public DataSet ognl(String key, String formula, Object values, int strategy, boolean exception) throws Exception {
        if (strategy == 0) {
            for (DataRow row : this.rows) {
                try {
                    row.ognl(key, formula, values);
                }
                catch (Exception e) {
                    if (!exception) continue;
                    throw e;
                }
            }
        } else {
            ArrayList<Object> results = new ArrayList<Object>();
            for (DataRow row : this.rows) {
                try {
                    results.add(row.ognl(formula, values));
                }
                catch (Exception e) {
                    results.add(null);
                    if (!exception) continue;
                    throw e;
                }
            }
            int size = results.size();
            for (int i = 0; i < size; ++i) {
                Object result = results.get(i);
                if (null == result) continue;
                this.rows.get(i).put(key, result);
            }
        }
        return this;
    }

    public DataSet ognl(String key, String formula, int strategy, boolean exception) throws Exception {
        return this.ognl(key, formula, null, strategy, exception);
    }

    public DataSet ognl(String key, String formula) throws Exception {
        return this.ognl(key, formula, null, 0, false);
    }

    public DataSet randoms(int min, int max) {
        int qty = BasicUtil.getRandomNumber(min, max);
        return this.randoms(qty);
    }

    public DataSet unique(String ... keys) {
        return this.distinct(keys);
    }

    public DataSet regex(String key, String regex, Regular.MATCH_MODE mode) {
        DataSet set = new DataSet();
        for (DataRow row : this) {
            String tmpValue = row.getString(key);
            if (!RegularUtil.match(tmpValue, regex, mode)) continue;
            set.add(row);
        }
        set.copyProperty(this);
        return set;
    }

    public DataSet regex(String key, String regex) {
        return this.regex(key, regex, Regular.MATCH_MODE.MATCH);
    }

    public boolean checkRequired(String ... keys) {
        for (DataRow row : this.rows) {
            if (row.checkRequired(keys)) continue;
            return false;
        }
        return true;
    }

    public String getDatalink() {
        return this.datalink;
    }

    public void setDatalink(String datalink) {
        this.datalink = datalink;
    }

    public DataSet copy(boolean regex, DataRow data, String ... keys) {
        if (null == data) {
            return this;
        }
        for (DataRow row : this.rows) {
            row.copy(regex, data, keys);
        }
        return this;
    }

    public DataSet copy(boolean regex, DataRow data, List<String> keys) {
        if (null == data || data.isEmpty()) {
            return this;
        }
        for (DataRow row : this.rows) {
            row.copy(regex, data, keys, new String[0]);
        }
        return this;
    }

    public DataSet copy(DataRow data, String ... keys) {
        return this.copy(false, data, keys);
    }

    public DataSet copyString(DataRow data, String ... keys) {
        for (DataRow row : this.rows) {
            row.copyString(data, keys);
        }
        return this;
    }

    private String string(Object object) {
        Object first = BeanUtil.first(object);
        if (null != first) {
            return first.toString();
        }
        return null;
    }

    public class Select
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean ignoreCase = true;
        private boolean ignoreNull = true;

        public DataSet setIgnoreCase(boolean bol) {
            this.ignoreCase = bol;
            return DataSet.this;
        }

        public DataSet setIgnoreNull(boolean bol) {
            this.ignoreNull = bol;
            return DataSet.this;
        }

        public DataSet equals(String key, Object value) {
            return this.equals(DataSet.this, key, value);
        }

        private DataSet equals(DataSet src, String key, Object value) {
            DataSet set = new DataSet();
            value = BeanUtil.first(value);
            for (DataRow row : src) {
                String tmpValue = row.getString(key);
                if (this.ignoreNull) {
                    if (null == tmpValue || null == value) {
                        continue;
                    }
                } else if (null == tmpValue && null == value) {
                    set.add(row);
                    continue;
                }
                if (null == tmpValue) continue;
                boolean chk = false;
                chk = this.ignoreCase ? (null == value ? false : tmpValue.equalsIgnoreCase(value.toString())) : tmpValue.equals(value);
                if (!chk) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public DataSet notEquals(String key, Object value) {
            return this.notEquals(DataSet.this, key, value);
        }

        private DataSet notEquals(DataSet src, String key, Object value) {
            DataSet set = new DataSet();
            value = BeanUtil.first(value);
            for (DataRow row : src) {
                String tmpValue = row.getString(key);
                if (this.ignoreNull) {
                    if (null == tmpValue || null == value) {
                        continue;
                    }
                } else if (null == tmpValue && null == value) {
                    set.add(row);
                    continue;
                }
                if (null == tmpValue) continue;
                boolean chk = false;
                if (this.ignoreCase) {
                    chk = null == value ? false : !tmpValue.equalsIgnoreCase(value.toString());
                } else {
                    boolean bl = chk = !tmpValue.equals(value);
                }
                if (!chk) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public DataSet contains(String key, Object value) {
            return this.contains(DataSet.this, key, value);
        }

        private DataSet contains(DataSet src, String key, Object value) {
            DataSet set = new DataSet();
            value = BeanUtil.first(value);
            for (DataRow row : src) {
                String tmpValue = row.getString(key);
                if (this.ignoreNull) {
                    if (null == tmpValue || null == value) {
                        continue;
                    }
                } else if (null == tmpValue && null == value) {
                    set.add(row);
                    continue;
                }
                if (null == tmpValue || null == value) continue;
                if (this.ignoreCase) {
                    tmpValue = tmpValue.toLowerCase();
                    value = value.toString().toLowerCase();
                }
                if (!tmpValue.contains(value.toString())) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public DataSet like(String key, String pattern) {
            return this.like(DataSet.this, key, pattern);
        }

        private DataSet like(DataSet src, String key, String pattern) {
            DataSet set = new DataSet();
            if (null != pattern) {
                pattern = ((String)pattern).replace("!", "^").replace("_", "\\s|\\S").replace("%", "(\\s|\\S)*");
            }
            for (DataRow row : src) {
                String tmpValue = row.getString(key);
                if (this.ignoreNull) {
                    if (null == tmpValue || null == pattern) {
                        continue;
                    }
                } else if (null == tmpValue && null == pattern) {
                    set.add(row);
                    continue;
                }
                if (null == tmpValue || null == pattern) continue;
                if (this.ignoreCase) {
                    pattern = "(?i)" + (String)pattern;
                }
                if (!RegularUtil.match(tmpValue, (String)pattern, Regular.MATCH_MODE.MATCH)) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public DataSet notLike(String key, String pattern) {
            return this.notLike(DataSet.this, key, pattern);
        }

        private DataSet notLike(DataSet src, String key, String pattern) {
            DataSet set = new DataSet();
            if (null == pattern) {
                return set;
            }
            pattern = ((String)pattern).replace("!", "^").replace("_", "\\s|\\S").replace("%", "(\\s|\\S)*");
            for (DataRow row : src) {
                String tmpValue = row.getString(key);
                if (this.ignoreNull) {
                    if (null == tmpValue || null == pattern) {
                        continue;
                    }
                } else if (null == tmpValue && null == pattern) {
                    set.add(row);
                    continue;
                }
                if (null == tmpValue || null == pattern) continue;
                if (this.ignoreCase) {
                    pattern = "(?i)" + (String)pattern;
                }
                if (RegularUtil.match(tmpValue, (String)pattern, Regular.MATCH_MODE.MATCH)) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public DataSet startWith(String key, String prefix) {
            return this.startWith(DataSet.this, key, prefix);
        }

        private DataSet startWith(DataSet src, String key, String prefix) {
            DataSet set = new DataSet();
            for (DataRow row : src) {
                String tmpValue = row.getString(key);
                if (this.ignoreNull) {
                    if (null == tmpValue || null == prefix) {
                        continue;
                    }
                } else if (null == tmpValue && null == prefix) {
                    set.add(row);
                    continue;
                }
                if (null == tmpValue || null == prefix) continue;
                if (this.ignoreCase) {
                    tmpValue = tmpValue.toLowerCase();
                    prefix = prefix.toLowerCase();
                }
                if (!tmpValue.startsWith(prefix)) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public DataSet endWith(String key, String suffix) {
            return this.endWith(DataSet.this, key, suffix);
        }

        private DataSet endWith(DataSet src, String key, String suffix) {
            DataSet set = new DataSet();
            for (DataRow row : src) {
                String tmpValue = row.getString(key);
                if (this.ignoreNull) {
                    if (null == tmpValue || null == suffix) {
                        continue;
                    }
                } else if (null == tmpValue && null == suffix) {
                    set.add(row);
                    continue;
                }
                if (null == tmpValue || null == suffix) continue;
                if (this.ignoreCase) {
                    tmpValue = tmpValue.toLowerCase();
                    suffix = suffix.toLowerCase();
                }
                if (!tmpValue.endsWith(suffix)) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public <T> DataSet in(String key, T ... values) {
            return this.in(DataSet.this, key, BeanUtil.array2list(new Object[][]{values}));
        }

        public <T> DataSet in(String key, Collection<T> values) {
            return this.in(DataSet.this, key, values);
        }

        private <T> DataSet in(DataSet src, String key, Collection<T> values) {
            DataSet set = new DataSet();
            for (DataRow row : src) {
                if (!BasicUtil.containsString(this.ignoreNull, this.ignoreCase, values, row.getString(key))) continue;
                set.add(row);
            }
            set.copyProperty(src);
            return set;
        }

        public <T> DataSet notIn(String key, T ... values) {
            return this.notIn(DataSet.this, key, BeanUtil.array2list(new Object[][]{values}));
        }

        public <T> DataSet notIn(String key, Collection<T> values) {
            return this.notIn(DataSet.this, key, values);
        }

        private <T> DataSet notIn(DataSet src, String key, Collection<T> values) {
            DataSet set = new DataSet();
            if (null != values) {
                String tmpValue = null;
                for (DataRow row : src) {
                    tmpValue = row.getString(key);
                    if (this.ignoreNull && null == tmpValue || BasicUtil.containsString(this.ignoreNull, this.ignoreCase, values, tmpValue)) continue;
                    set.add(row);
                }
            }
            set.copyProperty(src);
            return set;
        }

        public DataSet isNull(String ... keys) {
            return this.isNull(DataSet.this, keys);
        }

        private DataSet isNull(DataSet src, String ... keys) {
            DataSet set = src;
            if (null != keys) {
                for (String key : keys) {
                    set = this.isNull(set, key);
                }
            }
            return set;
        }

        private DataSet isNull(DataSet src, String key) {
            DataSet set = new DataSet();
            for (DataRow row : src) {
                if (null != row.get(key)) continue;
                set.add(row);
            }
            return set;
        }

        public DataSet isNotNull(String ... keys) {
            return this.isNotNull(DataSet.this, keys);
        }

        private DataSet isNotNull(DataSet src, String ... keys) {
            DataSet set = src;
            if (null != keys) {
                for (String key : keys) {
                    set = this.isNotNull(set, key);
                }
            }
            return set;
        }

        private DataSet isNotNull(DataSet src, String key) {
            DataSet set = new DataSet();
            for (DataRow row : src) {
                if (null == row.get(key)) continue;
                set.add(row);
            }
            return set;
        }

        public DataSet notNull(String ... keys) {
            return this.isNotNull(keys);
        }

        public DataSet empty(String ... keys) {
            return this.empty(DataSet.this, keys);
        }

        private DataSet empty(DataSet src, String ... keys) {
            DataSet set = src;
            if (null != keys) {
                for (String key : keys) {
                    set = this.empty(set, key);
                }
            }
            return set;
        }

        private DataSet empty(DataSet src, String key) {
            DataSet set = new DataSet();
            for (DataRow row : src) {
                if (!row.isEmpty(key)) continue;
                set.add(row);
            }
            return set;
        }

        public DataSet notEmpty(String ... keys) {
            return this.notEmpty(DataSet.this, keys);
        }

        private DataSet notEmpty(DataSet src, String ... keys) {
            DataSet set = src;
            if (null != keys) {
                for (String key : keys) {
                    set = this.notEmpty(set, key);
                }
            }
            return set;
        }

        private DataSet notEmpty(DataSet src, String key) {
            DataSet set = new DataSet();
            for (DataRow row : src) {
                if (!row.isNotEmpty(key)) continue;
                set.add(row);
            }
            return set;
        }

        public <T> DataSet less(String key, T value) {
            return this.less(DataSet.this, key, value);
        }

        private <T> DataSet less(DataSet src, String key, T value) {
            DataSet set = new DataSet();
            if (null == value) {
                return set;
            }
            Object first = BeanUtil.first(value);
            if (null == first) {
                return set;
            }
            if (BasicUtil.isNumber(first)) {
                BigDecimal number = new BigDecimal(first.toString());
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getDecimal(key, (Integer)0).compareTo(number) >= 0) continue;
                    set.add(row);
                }
            } else if (BasicUtil.isDate(first) || BasicUtil.isDateTime(first)) {
                try {
                    Date date = DateUtil.parse(first);
                    for (DataRow row : src) {
                        if (null == row.get(key) || !row.isNotEmpty(key) || DateUtil.diff(14, date, row.getDate(key, new Date())) >= 0L) continue;
                        set.add(row);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getString(key).compareTo(first.toString()) >= 0) continue;
                    set.add(row);
                }
            }
            set.copyProperty(src);
            return set;
        }

        public <T> DataSet lessEqual(String key, T value) {
            return this.lessEqual(DataSet.this, key, value);
        }

        private <T> DataSet lessEqual(DataSet src, String key, T value) {
            DataSet set = new DataSet();
            if (null == value) {
                return set;
            }
            Object first = BeanUtil.first(value);
            if (null == first) {
                return set;
            }
            if (BasicUtil.isNumber(first)) {
                BigDecimal number = new BigDecimal(first.toString());
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getDecimal(key, (Integer)0).compareTo(number) > 0) continue;
                    set.add(row);
                }
            } else if (BasicUtil.isDate(first) || BasicUtil.isDateTime(first)) {
                try {
                    Date date = DateUtil.parse(first.toString());
                    for (DataRow row : src) {
                        if (null == row.get(key) || !row.isNotEmpty(key) || DateUtil.diff(14, date, row.getDate(key, new Date())) > 0L) continue;
                        set.add(row);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getString(key).compareTo(first.toString()) < 0) continue;
                    set.add(row);
                }
            }
            set.copyProperty(src);
            return set;
        }

        public <T> DataSet greater(String key, T value) {
            return this.greater(DataSet.this, key, value);
        }

        private <T> DataSet greater(DataSet src, String key, T value) {
            DataSet set = new DataSet();
            if (null == value) {
                return set;
            }
            Object first = BeanUtil.first(value);
            if (null == first) {
                return set;
            }
            if (BasicUtil.isNumber(first)) {
                BigDecimal number = new BigDecimal(first.toString());
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getDecimal(key, (Integer)0).compareTo(number) <= 0) continue;
                    set.add(row);
                }
            } else if (BasicUtil.isDate(first) || BasicUtil.isDateTime(first)) {
                try {
                    Date date = DateUtil.parse(first.toString());
                    for (DataRow row : src) {
                        if (null == row.get(key) || !row.isNotEmpty(key) || DateUtil.diff(14, date, row.getDate(key, new Date())) <= 0L) continue;
                        set.add(row);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getString(key).compareTo(first.toString()) <= 0) continue;
                    set.add(row);
                }
            }
            set.copyProperty(src);
            return set;
        }

        public <T> DataSet greaterEqual(String key, T value) {
            return this.greaterEqual(DataSet.this, key, value);
        }

        private <T> DataSet greaterEqual(DataSet src, String key, T value) {
            DataSet set = new DataSet();
            if (null == value) {
                return set;
            }
            Object first = BeanUtil.first(value);
            if (null == first) {
                return set;
            }
            if (BasicUtil.isNumber(first)) {
                BigDecimal number = new BigDecimal(first.toString());
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getDecimal(key, (Integer)0).compareTo(number) < 0) continue;
                    set.add(row);
                }
            } else if (BasicUtil.isDate(first) || BasicUtil.isDateTime(first)) {
                try {
                    Date date = DateUtil.parse(first);
                    for (DataRow row : src) {
                        if (null == row.get(key) || !row.isNotEmpty(key) || DateUtil.diff(14, date, row.getDate(key, new Date())) < 0L) continue;
                        set.add(row);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                for (DataRow row : src) {
                    if (null == row.get(key) || row.getString(key).compareTo(first.toString()) < 0) continue;
                    set.add(row);
                }
            }
            set.copyProperty(src);
            return set;
        }

        public <T> DataSet between(String key, T min, T max) {
            return this.between(DataSet.this, key, min, max);
        }

        private <T> DataSet between(DataSet src, String key, T min, T max) {
            DataSet set = this.greaterEqual(src, key, min);
            set = this.lessEqual(set, key, max);
            return set;
        }

        public DataSet ognl(String formula) throws Exception {
            return this.ognl(DataSet.this, formula);
        }

        private DataSet ognl(DataSet src, String formula) throws Exception {
            DataSet set = new DataSet();
            Iterator<DataRow> iterator = src.iterator();
            while (iterator.hasNext()) {
                OgnlContext context = new OgnlContext(null, null, (MemberAccess)new DefaultOgnlMemberAccess(true));
                DataRow row = iterator.next();
                Object value = Ognl.getValue((String)formula, (Map)context, (Object)row);
                if (!BasicUtil.parseBoolean(value, false).booleanValue()) continue;
                set.add(row);
            }
            return set;
        }

        public DataSet filter(Compare compare, String key, Object values) {
            DataSet set = DataSet.this;
            if (compare == Compare.EQUAL) {
                set = this.equals(key, values);
            } else if (compare == Compare.NOT_EQUAL) {
                set = this.notEquals(key, values);
            } else if (compare == Compare.GREAT) {
                set = this.greater(key, values);
            } else if (compare == Compare.GREAT_EQUAL) {
                set = this.greaterEqual(key, values);
            } else if (compare == Compare.LESS) {
                set = this.less(key, values);
            } else if (compare == Compare.LESS_EQUAL) {
                set = this.lessEqual(key, values);
            } else if (compare == Compare.IN) {
                set = this.in(key, values);
            } else if (compare == Compare.NOT_IN) {
                set = this.notIn(key, values);
            } else if (compare == Compare.EMPTY) {
                set = this.empty(key);
            } else if (compare == Compare.NOT_EMPTY) {
                set = this.notEmpty(key);
            } else if (compare == Compare.NULL) {
                set = this.isNull(key);
            } else if (compare == Compare.NOT_NULL) {
                set = this.notNull(key);
            } else if (compare == Compare.LIKE) {
                set = this.like(key, DataSet.this.string(values));
            } else if (compare == Compare.NOT_LIKE) {
                set = this.notLike(key, DataSet.this.string(values));
            } else if (compare == Compare.START_WITH) {
                set = this.startWith(key, DataSet.this.string(values));
            } else if (compare == Compare.END_WITH) {
                set = this.endWith(key, DataSet.this.string(values));
            }
            return set;
        }
    }

    public class Format
    implements Serializable {
        public DataSet date(String format, String ... cols) {
            for (DataRow row : DataSet.this.rows) {
                row.format.date(format, cols);
            }
            return DataSet.this;
        }

        public DataSet date(String format, Class ... classes) {
            for (DataRow row : DataSet.this.rows) {
                row.format.date(format, classes);
            }
            return DataSet.this;
        }

        public DataSet date(boolean greedy, String format, String def) {
            for (DataRow row : DataSet.this.rows) {
                row.format.date(greedy, format, def);
            }
            return DataSet.this;
        }

        public DataSet date(boolean greedy, String format, Date def) {
            for (DataRow row : DataSet.this.rows) {
                row.format.date(greedy, format, def);
            }
            return DataSet.this;
        }

        public DataSet date(boolean greedy, String format) {
            for (DataRow row : DataSet.this.rows) {
                row.format.date(greedy, format);
            }
            return DataSet.this;
        }

        public DataSet number(String format, String ... cols) {
            for (DataRow row : DataSet.this.rows) {
                row.format.number(format, cols);
            }
            return DataSet.this;
        }

        public DataSet number(String format, Class ... classes) {
            for (DataRow row : DataSet.this.rows) {
                row.format.number(format, classes);
            }
            return DataSet.this;
        }

        public DataSet number(boolean greedy, String format, String def) {
            for (DataRow row : DataSet.this.rows) {
                row.format.number(greedy, format, def);
            }
            return DataSet.this;
        }

        public DataSet number(boolean greedy, String format) {
            return this.number(greedy, format, "");
        }
    }

    public class Parse
    implements Serializable {
        public DataSet date(String ... cols) {
            for (DataRow row : DataSet.this.rows) {
                row.parse.date(cols);
            }
            return DataSet.this;
        }

        public DataSet number(String ... cols) {
            for (DataRow row : DataSet.this.rows) {
                row.parse.number(cols);
            }
            return DataSet.this;
        }
    }
}

