/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.ColumnsDiffer;
import org.anyline.metadata.differ.IndexsDiffer;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.TriggersDiffer;

public class TableDiffer
implements MetadataDiffer {
    private Table origin;
    private Table dest;
    private ColumnsDiffer columnsDiffer;
    private IndexsDiffer indexsDiffer;
    private TriggersDiffer triggersDiffer;

    public TableDiffer() {
    }

    public TableDiffer(Table origin, Table dest) {
        this.origin = origin;
        this.dest = dest;
    }

    public boolean isEmpty() {
        if (null != this.columnsDiffer && !this.columnsDiffer.isEmpty()) {
            return false;
        }
        return null == this.indexsDiffer || this.indexsDiffer.isEmpty();
    }

    public static TableDiffer compare(Table origin, Table dest) {
        if (null == dest) {
            dest = new Table();
        }
        TableDiffer differ = new TableDiffer(origin, dest);
        LinkedHashMap<String, Column> originColumns = origin.getColumns();
        LinkedHashMap<String, Column> destColumns = dest.getColumns();
        differ.setColumnsDiffer(ColumnsDiffer.compare(originColumns, destColumns));
        differ.setIndexsDiffer(IndexsDiffer.compare(origin.getIndexes(), dest.getIndexes()));
        return differ;
    }

    public ColumnsDiffer getColumnsDiffer() {
        return this.columnsDiffer;
    }

    public void setColumnsDiffer(ColumnsDiffer columnsDiffer) {
        this.columnsDiffer = columnsDiffer;
    }

    public IndexsDiffer getIndexsDiffer() {
        return this.indexsDiffer;
    }

    public void setIndexsDiffer(IndexsDiffer indexsDiffer) {
        this.indexsDiffer = indexsDiffer;
    }

    public TriggersDiffer getTriggersDiffer() {
        return this.triggersDiffer;
    }

    public void setTriggersDiffer(TriggersDiffer triggersDiffer) {
        this.triggersDiffer = triggersDiffer;
    }

    public Table getOrigin() {
        return this.origin;
    }

    public void setOrigin(Table origin) {
        this.origin = origin;
    }

    public Table getDest() {
        return this.dest;
    }

    public void setDest(Table dest) {
        this.dest = dest;
    }
}

