/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.differ.MetadataDiffer;

public class ProceduresDiffer
implements MetadataDiffer {
    private LinkedHashMap<String, Procedure> adds = new LinkedHashMap();
    private LinkedHashMap<String, Procedure> drops = new LinkedHashMap();
    private LinkedHashMap<String, Procedure> updates = new LinkedHashMap();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static ProceduresDiffer compare(LinkedHashMap<String, Procedure> origins, LinkedHashMap<String, Procedure> dests) {
        ProceduresDiffer differ = new ProceduresDiffer();
        LinkedHashMap<String, Procedure> adds = new LinkedHashMap<String, Procedure>();
        LinkedHashMap<String, Procedure> drops = new LinkedHashMap<String, Procedure>();
        LinkedHashMap<String, Procedure> updates = new LinkedHashMap<String, Procedure>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Procedure origin = origins.get(key);
            Procedure dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.put(key, origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public LinkedHashMap<String, Procedure> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Procedure> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Procedure> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Procedure> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Procedure> getUpdates() {
        return this.updates;
    }

    public void setUpdates(LinkedHashMap<String, Procedure> updates) {
        this.updates = updates;
    }
}

