/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.geometry;

import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.Polygon;

public class MultiPolygon
extends Geometry {
    private List<Polygon> polygons = new ArrayList<Polygon>();

    public MultiPolygon() {
        this.type = 6;
    }

    public MultiPolygon(List<Polygon> polygons) {
        this();
        this.polygons = polygons;
    }

    public MultiPolygon add(Polygon polygon) {
        this.polygons.add(polygon);
        return this;
    }

    public MultiPolygon add(List<Polygon> polygons) {
        if (null != polygons) {
            polygons.addAll(polygons);
        }
        return this;
    }

    public MultiPolygon clear() {
        this.polygons = new ArrayList<Polygon>();
        return this;
    }

    public List<Polygon> polygons() {
        return this.polygons;
    }

    @Override
    public String toString(boolean tag) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        builder.append("(");
        boolean first = true;
        for (Polygon polygon : this.polygons) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(polygon.toString(false));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String sql() {
        return this.sql(true, true);
    }

    @Override
    public String sql(boolean tag, boolean bracket) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        if (bracket) {
            builder.append("(");
        }
        boolean first = true;
        for (Polygon polygon : this.polygons) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(polygon.sql(false, false));
        }
        if (bracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }
}

