/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.adapter.init;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.anyline.adapter.EnvironmentWorker;
import org.anyline.annotation.Autowired;
import org.anyline.annotation.Component;
import org.anyline.bean.BeanDefine;
import org.anyline.bean.LoadListener;
import org.anyline.bean.ValueReference;
import org.anyline.bean.init.DefaultBeanDefine;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.CharUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.anyline.util.ZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEnvironmentWorker
implements EnvironmentWorker {
    protected static Logger log = LoggerFactory.getLogger(DefaultEnvironmentWorker.class);
    private static DefaultEnvironmentWorker instance = null;
    private static final Map<String, Object> factory = new HashMap<String, Object>();

    public static EnvironmentWorker start(File config) {
        if (null == instance) {
            instance = new DefaultEnvironmentWorker();
        }
        ConfigTable.setWorker(instance);
        if (null != config) {
            ConfigTable.parseEnvironment(FileUtil.read(config, StandardCharsets.UTF_8).toString(), config.getName());
        }
        try {
            DefaultEnvironmentWorker.loadBean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, LoadListener> listeners = instance.getBeans(LoadListener.class);
        for (LoadListener listener : listeners.values()) {
            listener.load();
        }
        return instance;
    }

    public static EnvironmentWorker start() {
        return DefaultEnvironmentWorker.start(null);
    }

    public static void loadBean() throws Exception {
        String path = Objects.requireNonNull(ConfigTable.class.getResource("")).getPath();
        path = ConfigTable.path(path);
        DefaultEnvironmentWorker.loadBean(new JarFile(path));
        Enumeration<URL> urls = ConfigTable.class.getClassLoader().getResources("org/anyline/");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String protocol = url.getProtocol().toLowerCase();
            if ("file".equals(protocol)) {
                DefaultEnvironmentWorker.loadBean(new File(url.getFile()));
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            log.debug("[load bean form jar][path:{}]", (Object)jar.getName());
            DefaultEnvironmentWorker.loadBean(jar);
        }
        String type = ConfigTable.getProjectProtocol();
        if ("jar".equals(type)) {
            JarFile jFile = new JarFile(System.getProperty("java.class.path"));
            DefaultEnvironmentWorker.loadBean(jFile);
        } else {
            DefaultEnvironmentWorker.loadBean(new File(ConfigTable.getClassPath(), "bean.imports"));
        }
        File file = new File(FileUtil.merge(ConfigTable.getClassPath(), "config/bean.imports"));
        if (file.exists()) {
            DefaultEnvironmentWorker.loadBean(FileUtil.read(file, "UTF-8").toString());
        }
    }

    public static void loadBean(File file) {
        if (null != file && file.exists()) {
            if (file.isDirectory()) {
                List<File> files = FileUtil.getAllChildrenFile(file, "bean.imports", ".jar");
                for (File item : files) {
                    DefaultEnvironmentWorker.loadBean(item);
                }
            } else {
                String name = file.getName().toLowerCase();
                if (name.endsWith(".jar")) {
                    try {
                        DefaultEnvironmentWorker.loadBean(new JarFile(file));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    DefaultEnvironmentWorker.loadBean(FileUtil.read(file, "UTF-8").toString());
                }
            }
        }
    }

    public static void loadBean(JarFile jar) {
        Enumeration<JarEntry> jarEntrys = jar.entries();
        while (jarEntrys.hasMoreElements()) {
            JarEntry entry = jarEntrys.nextElement();
            String name = entry.getName();
            if (name.contains("bean.imports")) {
                try {
                    InputStream in = jar.getInputStream(entry);
                    String txt = FileUtil.read(in, StandardCharsets.UTF_8).toString();
                    DefaultEnvironmentWorker.loadBean(txt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!name.contains("jar")) continue;
        }
        List<String> classes = ZipUtil.classes(jar, "org.anyline", false);
        ClassLoader loader = ConfigTable.class.getClassLoader();
        Class<?> component = null;
        for (String clazz : classes) {
            try {
                Object annotation;
                if (clazz.contains(".web.") || clazz.contains(".net.")) continue;
                Class<?> c = loader.loadClass(clazz);
                if (null == component) {
                    component = loader.loadClass(Component.class.getName());
                }
                if (null == (annotation = c.getAnnotation(component))) continue;
                Method[] methods = annotation.annotationType().getMethods();
                String beanName = null;
                for (Method method : methods) {
                    Object value;
                    String name = method.getName();
                    if (!name.equalsIgnoreCase("value") && !name.equalsIgnoreCase("name") || null == (value = method.invoke(annotation, new Object[0]))) continue;
                    beanName = value.toString();
                }
                if (null == beanName) {
                    beanName = c.getName();
                }
                Object bean = c.newInstance();
                DefaultEnvironmentWorker.autowired(bean);
                instance.reg(beanName, bean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void autowired(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        List<Field> fields = ClassUtil.getFields(clazz, false, false);
        for (Field field : fields) {
            Object val;
            Autowired annotation = field.getAnnotation(Autowired.class);
            if (null == annotation || null != (val = BeanUtil.getFieldValue(object, field))) continue;
            Method[] methods = annotation.annotationType().getMethods();
            String beanName = null;
            Method[] methodArray = methods;
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Object value;
                Method method = methodArray[i];
                String name = method.getName();
                if (!name.equalsIgnoreCase("value") && !name.equalsIgnoreCase("name") || null == (value = method.invoke((Object)annotation, new Object[0]))) continue;
                beanName = value.toString();
            }
            if (BasicUtil.isNotEmpty(beanName)) {
                val = instance.getBean(beanName);
            } else {
                Class<?> beanClass = field.getType();
                val = instance.getBean(beanClass);
            }
            BeanUtil.setFieldValue(object, field, val);
        }
        List<Method> methods = ClassUtil.getMethods(clazz, true);
        for (Method method : methods) {
            Type[] types;
            Autowired annotation = method.getAnnotation(Autowired.class);
            if (null == annotation) continue;
            for (Type type : types = method.getGenericParameterTypes()) {
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)type;
                Type[] arguments = pt.getActualTypeArguments();
                Class<?> pclass = Class.forName(pt.getRawType().getTypeName());
                if (ClassUtil.isInSub(pclass, Map.class)) {
                    Type kt = arguments[0];
                    Type vt = arguments[1];
                    Class<?> kc = Class.forName(kt.getTypeName());
                    Class<?> vc = Class.forName(vt.getTypeName());
                    Map<String, ?> beans = ConfigTable.environment().getBeans(vc);
                    method.invoke(object, beans);
                    continue;
                }
                if (!ClassUtil.isInSub(pclass, Collection.class)) continue;
                Type ct = arguments[0];
                Class<?> cc = Class.forName(ct.getTypeName());
                Map<String, ?> beans = ConfigTable.environment().getBeans(cc);
                ArrayList values = new ArrayList();
                for (Object bean : beans.values()) {
                    values.add(bean);
                }
                method.invoke(object, values);
            }
        }
    }

    public static void loadBean(String config) {
        String[] lines;
        for (String line : lines = config.split("\n")) {
            String[] kv = line.split("=");
            if (kv.length != 2) continue;
            try {
                instance.reg(kv[0], new DefaultBeanDefine(kv[1], false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getBean(String name) {
        Object bean = factory.get(name);
        if (bean instanceof BeanDefine) {
            bean = this.instance(name, (BeanDefine)bean);
        }
        return bean;
    }

    @Override
    public <T> Map<String, T> getBeans(Class<T> clazz) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : factory.keySet()) {
            Object bean = factory.get(key);
            if (null == bean) continue;
            if (ClassUtil.isInSub(bean.getClass(), clazz)) {
                map.put(key, bean);
                continue;
            }
            if (!(bean instanceof BeanDefine)) continue;
            BeanDefine define = (BeanDefine)bean;
            if (!ClassUtil.isInSub(bean.getClass(), define.getType())) continue;
            map.put(key, this.instance(key, define));
        }
        return map;
    }

    @Override
    public Object instance(BeanDefine define) {
        Object bean = null;
        Class type = define.getType();
        try {
            bean = type.newInstance();
            LinkedHashMap<String, Object> values = define.getValues();
            for (String key : values.keySet()) {
                Object value = values.get(key);
                if (value instanceof ValueReference && (value = this.getBean(((ValueReference)value).getName())) instanceof BeanDefine) {
                    value = this.instance(key, (BeanDefine)value);
                }
                BeanUtil.setFieldValue(bean, key, value, true, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bean;
    }

    public Object instance(String name, BeanDefine define) {
        Object bean = instance.instance(define);
        if (null != name) {
            factory.put(name, bean);
        }
        return bean;
    }

    @Override
    public boolean regBean(String name, Object bean) {
        return this.reg(name, bean);
    }

    @Override
    public boolean regBean(String name, BeanDefine bean) {
        return this.reg(name, bean);
    }

    public boolean reg(String name, Object bean) {
        Object type = bean;
        if (bean instanceof BeanDefine) {
            BeanDefine define = (BeanDefine)bean;
            if (name.endsWith("default")) {
                define.setPrimary(true);
            }
            if (define.isLazy()) {
                factory.put(name, define);
                type = define.getTypeName();
            } else {
                Object insance = this.instance(name, define);
                factory.put(name, insance);
                type = insance;
            }
        } else if (bean instanceof Class) {
            Class clazz = (Class)bean;
            try {
                factory.put(name, clazz.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            factory.put(name, bean);
        }
        log.debug("[reg bean][name:{}][instance:{}]", (Object)name, type);
        return true;
    }

    @Override
    public boolean destroyBean(String bean) {
        return DefaultEnvironmentWorker.destroy(bean);
    }

    public static boolean destroy(String bean) {
        factory.remove(bean);
        return true;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        Map<String, T> beans = this.getBeans(clazz);
        Object bean = null;
        if (null != beans && !beans.isEmpty()) {
            bean = beans.values().iterator().next();
        }
        if (null != bean) {
            try {
                if (bean instanceof BeanDefine) {
                    bean = this.instance(null, (BeanDefine)bean);
                }
                DefaultEnvironmentWorker.autowired(bean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)bean;
    }

    @Override
    public <T> T getBean(String name, Class<T> clazz) {
        Object bean = factory.get(name);
        if (bean instanceof BeanDefine) {
            bean = this.instance(name, (BeanDefine)bean);
        }
        if (null != bean && ClassUtil.isInSub(bean.getClass(), clazz)) {
            try {
                DefaultEnvironmentWorker.autowired(bean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return (T)bean;
        }
        return null;
    }

    @Override
    public boolean containsBean(String name) {
        return factory.containsKey(name);
    }

    @Override
    public Object getSingletonBean(String name) {
        return factory.get(name);
    }

    @Override
    public boolean containsSingleton(String name) {
        return this.containsBean(name);
    }

    @Override
    public <T> T getSingletonBean(String name, Class<T> clazz) {
        return this.getBean(name, clazz);
    }

    @Override
    public Object get(String key) {
        return null;
    }

    @Override
    public String getString(String key) {
        return ConfigTable.getString(key);
    }

    @Override
    public String string(String prefixes, String keys) {
        String value = null;
        if (null == keys) {
            return value;
        }
        if (null == prefixes) {
            prefixes = "";
        }
        String[] ps = prefixes.split(",");
        String[] kss = keys.split(",");
        for (String p : ps) {
            for (String string : kss) {
                String string2 = p + string;
                value = this.getString(string2);
                if (null != value) {
                    return value;
                }
                String[] ks = string2.split("-");
                Object sKey = null;
                for (String k : ks) {
                    sKey = null == sKey ? k : (String)sKey + CharUtil.toUpperCaseHeader(k);
                }
                value = this.getString((String)sKey);
                if (null != value) {
                    return value;
                }
                ks = string2.split("_");
                sKey = null;
                for (String k : ks) {
                    sKey = null == sKey ? k : (String)sKey + CharUtil.toUpperCaseHeader(k);
                }
                value = this.getString((String)sKey);
                if (null != value) {
                    return value;
                }
                ks = string2.toLowerCase().split("_");
                sKey = null;
                for (String k : ks) {
                    sKey = null == sKey ? k : (String)sKey + CharUtil.toUpperCaseHeader(k);
                }
                value = this.getString((String)sKey);
                if (null != value) {
                    return value;
                }
                sKey = string2.replace("_", "-");
                value = this.getString((String)sKey);
                if (null != value) {
                    return value;
                }
                sKey = string2.toLowerCase().replace("_", "-");
                value = this.getString((String)sKey);
                if (null == value) continue;
                return value;
            }
        }
        return value;
    }

    @Override
    public Map<String, Object> inject(String id, String prefix, Map params, Map<String, HashSet<String>> alias, Class clazz) throws Exception {
        HashMap<String, Object> cache = new HashMap<String, Object>();
        DefaultBeanDefine define = new DefaultBeanDefine(clazz);
        List<Method> methods = ClassUtil.getMethods(clazz, true);
        for (Method method : methods) {
            Class<?> paramType;
            Object name;
            if (method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || !((String)(name = method.getName())).startsWith("set")) continue;
            Object value = BeanUtil.value(params, (String)(name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4)), alias, paramType = method.getParameters()[0].getType(), null);
            if (null == value) {
                value = this.value(prefix, (String)name, alias, paramType, null);
            }
            if (null == value) continue;
            cache.put((String)name, value);
            define.addValue((String)name, value);
        }
        for (Method key : params.keySet()) {
            define.addValue(((Object)key).toString(), params.get(key));
        }
        this.regBean(id, define);
        log.info("[inject bean][type:{}][bean:{}]", (Object)clazz, (Object)id);
        return cache;
    }

    @Override
    public Map<String, Object> inject(String id, Map params, Class clazz) throws Exception {
        HashMap<String, Object> cache = new HashMap<String, Object>();
        DefaultBeanDefine define = new DefaultBeanDefine(clazz);
        List<Method> methods = ClassUtil.getMethods(clazz, true);
        for (Method method : methods) {
            Class<?> tp;
            Object value;
            Object name;
            if (method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || !((String)(name = method.getName())).startsWith("set") || null == (value = BeanUtil.value(params, (String)(name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4)), null, Object.class, null)) || null == (value = ConvertProxy.convert(value, tp = method.getParameters()[0].getType(), false))) continue;
            cache.put((String)name, value);
            define.addValue((String)name, value);
        }
        for (Method key : params.keySet()) {
            define.addValue(((Object)key).toString(), params.get(key));
        }
        this.regBean(id, define);
        log.info("[inject bean][type:{}][bean:{}]", (Object)clazz, (Object)id);
        return cache;
    }
}

