/*
 * Copyright 2006-2023 www.anyline.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



package org.anyline.metadata.type;

import org.anyline.adapter.KeyAdapter.KEY_CASE;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public enum DatabaseType implements Serializable {
        NONE			        ("NONE"	                           , KEY_CASE.SRC, 0, null, "",""),
        COMMON                  ("COMMON"	                           , KEY_CASE.SRC, 0, null, "",""),
        Access              	("Microsoft Access"                 	, KEY_CASE.SRC	, 980	, "Microsoft Access"	, "sun.jdbc.odbc.JdbcOdbcDriver"	, "jdbc:odbc:driver={Microsoft Access Driver (*.mdb)};DBQ={database}"),
        Accumulo            	("Apache Accumulo"                  	, KEY_CASE.SRC	, 910	, null	, ""	, ""),
        Acebase             	("Acebase"                          	, KEY_CASE.SRC	, 624	, null	, ""	, ""),
        ActianFastObjects   	("Actian FastObjects"               	, KEY_CASE.SRC	, 710	, null	, ""	, ""),
        ActianNoSQL         	("Actian NoSQL Database"            	, KEY_CASE.SRC	, 838	, null	, ""	, ""),
        ActianPSQL          	("Actian PSQL"                      	, KEY_CASE.SRC	, 668	, null	, ""	, ""),
        ActianVector        	("Actian Vector"                    	, KEY_CASE.SRC	, 790	, null	, ""	, ""),
        ActorDB             	("ActorDB"                          	, KEY_CASE.SRC	, 602	, null	, ""	, ""),
        Adabas              	("Adabas"                           	, KEY_CASE.SRC	, 919	, null	, ""	, ""),
        Adaptive            	("SAP Adaptive Server"              	, KEY_CASE.SRC	, 974	, null	, "com.sybase.jdbc.SybDriver"	, "jdbc:sybase:Tds:{host}:{port}/{database}"),
        Aerospike           	("Aerospike"                        	, KEY_CASE.SRC	, 940	, null	, "com.aerospike.jdbc.AerospikeDriver"	, "jdbc:aerospike:{host}:{port}/{namespace}"),
        AgensGraph          	("AgensGraph"                       	, KEY_CASE.SRC	, 612	, null	, ""	, ""),
        AlaSQL              	("AlaSQL"                           	, KEY_CASE.SRC	, 765	, null	, ""	, ""),
        Algolia             	("Algolia"                          	, KEY_CASE.SRC	, 938	, null	, ""	, ""),
        AllegroGraph        	("AllegroGraph"                     	, KEY_CASE.SRC	, 807	, null	, ""	, ""),
        Altibase            	("Altibase"                         	, KEY_CASE.SRC	, 786	, null	, ""	, ""),
        AmazonAurora        	("Amazon Aurora"                    	, KEY_CASE.SRC	, 950	, null	, ""	, ""),
        AmazonCloudSearch   	("Amazon CloudSearch"               	, KEY_CASE.SRC	, 867	, null	, ""	, ""),
        AmazonDocumentDB    	("Amazon DocumentDB"                	, KEY_CASE.SRC	, 857	, null	, ""	, ""),
        AmazonDynamoDB      	("Amazon DynamoDB"                  	, KEY_CASE.SRC	, 983	, null	, ""	, ""),
        AmazonKeyspaces     	("Amazon Keyspaces"                 	, KEY_CASE.SRC	, 782	, null	, ""	, ""),
        AmazonNeptune       	("Amazon Neptune"                   	, KEY_CASE.SRC	, 872	, null	, ""	, ""),
        AmazonRedshift      	("Amazon Redshift"                  	, KEY_CASE.SRC	, 966	, null	, "com.amazon.redshift.jdbc4.Driver"	, "jdbc:redshift://{host}:{port}/{database}"),
        AmazonSimpleDB      	("Amazon SimpleDB"                  	, KEY_CASE.SRC	, 869	, null	, ""	, ""),
        AmazonTimestream    	("Amazon Timestream"                	, KEY_CASE.SRC	, 785	, null	, ""	, ""),
        AnalyticDBMySQL     	("Alibaba Cloud AnalyticDB for MySQL"	, KEY_CASE.SRC	, 759	, null	, "com.mysql.cj.jdbc.Driver"	, "jdbc:mysql://{host}:{port:3306}/{database}"),
        AnalyticDBPostgreSQL	("Alibaba Cloud AnalyticDB for PostgreSQL"	, KEY_CASE.SRC	, 734	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        AntDB               	("AntDB"                            	, KEY_CASE.SRC	, 696	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        Anywhere            	("SAP Anywhere"                     	, KEY_CASE.SRC	, 900	, null	, "com.sybase.jdbc4.jdbc.SybDriver"	, "jdbc:sybase:Tds:{host}:{port}/{database}"),
        AnzoGraph_DB        	("AnzoGraph DB"                     	, KEY_CASE.SRC	, 707	, null	, ""	, ""),
        ApsaraDBPolarDB     	("Alibaba Cloud ApsaraDB for PolarDB"	, KEY_CASE.SRC	, 720	, null	, "com.aliyun.polardb.Driver"	, "jdbc:polardb://{host}:{port:3306}/{database}"),
        ArangoDB            	("ArangoDB"                         	, KEY_CASE.SRC	, 916	, null	, ""	, ""),
        ArcadeDB            	("ArcadeDB"                         	, KEY_CASE.SRC	, 658	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        ArgoDB              	("Transwarp ArgoDB(星环)"             	, KEY_CASE.SRC	, 621	, null	, ""	, ""),
        atoti               	("atoti"                            	, KEY_CASE.SRC	, 743	, null	, ""	, ""),
        Axibase             	("Axibase"                          	, KEY_CASE.SRC	, 718	, null	, "com.axibase.tsd.driver.jdbc.AtsdDriver"	, "jdbc:atsd://{host}:{port}"),
        AzureCosmos         	("Microsoft Azure Cosmos DB"        	, KEY_CASE.SRC	, 972	, null	, ""	, ""),
        AzureDataExplorer   	("Microsoft Azure Data Explorer"    	, KEY_CASE.SRC	, 939	, null	, ""	, ""),
        AzureSearch         	("Microsoft Azure Search"           	, KEY_CASE.SRC	, 933	, null	, ""	, ""),
        AzureSQL            	("Microsoft Azure SQL Database"     	, KEY_CASE.SRC	, 984	, null	, ""	, ""),
        AzureSynapse        	("Microsoft Azure Synapse Analytics"	, KEY_CASE.SRC	, 969	, null	, ""	, ""),
        AzureTableStorage   	("Microsoft Azure Table Storage"    	, KEY_CASE.SRC	, 931	, null	, ""	, ""),
        Badger              	("Badger"                           	, KEY_CASE.SRC	, 661	, null	, ""	, ""),
        BadgerDB            	("BadgerDB"                         	, KEY_CASE.SRC	, 0	, null	, ""	, ""),
        Bangdb              	("Bangdb"                           	, KEY_CASE.SRC	, 674	, null	, ""	, ""),
        BaseX               	("BaseX"                            	, KEY_CASE.SRC	, 860	, null	, ""	, ""),
        BergDB              	("BergDB"                           	, KEY_CASE.SRC	, 594	, null	, ""	, ""),
        BigchainDB          	("BigchainDB"                       	, KEY_CASE.SRC	, 794	, null	, ""	, ""),
        BigObject           	("BigObject"                        	, KEY_CASE.SRC	, 654	, null	, ""	, ""),
        Blazegraph          	("Blazegraph"                       	, KEY_CASE.SRC	, 783	, null	, ""	, ""),
        Blueflood           	("Blueflood"                        	, KEY_CASE.SRC	, 644	, null	, ""	, ""),
        BoltDB              	("BoltDB"                           	, KEY_CASE.SRC	, 744	, null	, ""	, ""),
        BrightstarDB        	("BrightstarDB"                     	, KEY_CASE.SRC	, 628	, null	, ""	, ""),
        Brytlyt             	("Brytlyt"                          	, KEY_CASE.SRC	, 712	, null	, ""	, ""),
        Cache               	("InterSystems Cache"               	, KEY_CASE.SRC	, 900	, null	, "com.intersys.jdbc.CacheDriver"	, "jdbc:Cache://{host}:{port}/{database}"),
        Cachelot            	("Cachelot"                         	, KEY_CASE.SRC	, 610	, null	, ""	, ""),
        Cassandra           	("Cassandra"                        	, KEY_CASE.SRC	, 987	, null	, "org.apache.cassandra.cql.jdbc.CassandraDriver"	, "jdbc:cassandra://{host}:{port/{database}"),
        Cayley              	("Cayley"                           	, KEY_CASE.SRC	, 0	, null	, ""	, ""),
        ChinaMobileDB       	("磐维数据库"                            	, KEY_CASE.SRC	, 900	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        ChinaUnicomDB       	("中国联通"                             	, KEY_CASE.SRC	, 900	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        Chroma              	("Chroma"                           	, KEY_CASE.SRC	, 859	, null	, ""	, ""),
        CirroData           	("东方国信"                             	, KEY_CASE.SRC	, 900	, null	, "com.bonc.xcloud.jdbc.XCloudDriver"	, "jdbc:xcloud:@{host}:{port}/{database}"),
        Citus               	("Citus"                            	, KEY_CASE.SRC	, 878	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        ClickHouse          	("ClickHouse"                       	, KEY_CASE.SRC	, 960	, null	, "ru.yandex.clickhouse.ClickHouseDriver"	, "jdbc:clickhouse://{host}:{port:8123}/{database}"),
        Cloudant            	("IBM Cloudant"                     	, KEY_CASE.SRC	, 898	, null	, ""	, ""),
        Cloudera            	("Cloudera "                        	, KEY_CASE.SRC	, 962	, null	, "com.cloudera.impala.jdbc41.Driver"	, "jdbc:impala://{host}:{port}/{database}"),
        CloudKit            	("CloudKit"                         	, KEY_CASE.SRC	, 889	, null	, ""	, ""),
        CnosDB              	("CnosDB"                           	, KEY_CASE.SRC	, 729	, null	, ""	, ""),
        CockroachDB         	("CockroachDB"                      	, KEY_CASE.SRC	, 935	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        Comdb2              	("Comdb2"                           	, KEY_CASE.SRC	, 683	, null	, "com.bloomberg.comdb2.jdbc.Driver"	, "jdbc:comdb2://{host}:{port}/{database}"),
        ComputeDB           	("Tibco ComputeDB"                  	, KEY_CASE.SRC	, 678	, null	, ""	, ""),
        CortexDB            	("CortexDB"                         	, KEY_CASE.SRC	, 593	, null	, ""	, ""),
        Couchbase           	("Couchbase"                        	, KEY_CASE.SRC	, 967	, null	, ""	, "couchbases://{database}"),
        CouchDB             	("CouchDB"                          	, KEY_CASE.SRC	, 953	, null	, ""	, ""),
        CovenantSQL         	("CovenantSQL"                      	, KEY_CASE.SRC	, 592	, null	, ""	, ""),
        Coveo               	("Coveo"                            	, KEY_CASE.SRC	, 876	, null	, ""	, ""),
        Crase               	("Crase"                            	, KEY_CASE.SRC	, 0	, null	, ""	, ""),
        CrateDB             	("CrateDB"                          	, KEY_CASE.SRC	, 768	, null	, ""	, ""),
        CrispI              	("CrispI"                           	, KEY_CASE.SRC	, 0	, null	, ""	, ""),
        CubicWeb            	("CubicWeb"                         	, KEY_CASE.SRC	, 667	, null	, ""	, ""),
        Cubrid              	("Cubrid"                           	, KEY_CASE.SRC	, 826	, null	, ""	, ""),
        D3                  	("D3"                               	, KEY_CASE.SRC	, 825	, null	, ""	, ""),
        DaggerDB            	("DaggerDB"                         	, KEY_CASE.SRC	, 591	, null	, ""	, ""),
        Databend            	("Databend"                         	, KEY_CASE.SRC	, 739	, null	, ""	, ""),
        Databricks          	("Databricks"                       	, KEY_CASE.SRC	, 982	, null	, ""	, "jdbc:databricks://{host}:{port};HttpPath={path}"),
        DatacomDB           	("Datacom/DB"                       	, KEY_CASE.SRC	, 772	, null	, ""	, ""),
        DataEase            	("DataEase"                         	, KEY_CASE.SRC	, 827	, null	, ""	, ""),
        DataFS              	("DataFS"                           	, KEY_CASE.SRC	, 615	, null	, ""	, ""),
        Datameer            	("Datameer"                         	, KEY_CASE.SRC	, 840	, null	, ""	, ""),
        Datastax            	("Datastax Enterprise"              	, KEY_CASE.SRC	, 941	, null	, ""	, ""),
        Datomic             	("Datomic"                          	, KEY_CASE.SRC	, 864	, null	, ""	, ""),
        DB2                 	("IBM Db2"                          	, KEY_CASE.SRC	, 990	, null	, "com.ibm.db2.jcc.DB2Driver"	, "jdbc:db2://{host}:{port:50000}/{database}"),
        Db2Warehouse        	("IBM Db2 warehouse"                	, KEY_CASE.SRC	, 833	, null	, "com.ibm.db2.jcc.DB2Driver"	, "jdbc:db2://{host}:{port:50000}/{database}"),
        Db4o                	("Db4o"                             	, KEY_CASE.SRC	, 850	, null	, ""	, ""),
        dbase               	("dBASE"                            	, KEY_CASE.SRC	, 957	, null	, ""	, ""),
        DBISAM              	("DBISAM"                           	, KEY_CASE.SRC	, 791	, null	, ""	, ""),
        DeepLake            	("Deep Lake"                        	, KEY_CASE.SRC	, 697	, null	, ""	, ""),
        Derby               	("Derby"                            	, KEY_CASE.SRC	, 936	, null	, "org.apache.derby.jdbc.EmbeddedDriver"	, "jdbc:derby:{database}"),
        Dgraph              	("Dgraph"                           	, KEY_CASE.SRC	, 846	, null	, ""	, ""),
        DM                  	("达梦"                               	, KEY_CASE.SRC	, 990	, null	, "dm.jdbc.driver.DmDriver"	, "jdbc:dm://{host}:{port:5236}/{database}"),
        DolphinDB           	("DolphinDB"                        	, KEY_CASE.SRC	, 905	, null	, "com.dolphindb.jdbc.Driver"	, "jdbc:dolphindb://{host}:{port}"),
        Dolt                	("Dolt"                             	, KEY_CASE.SRC	, 788	, null	, ""	, ""),
        Doris               	("Apache Doris"                     	, KEY_CASE.SRC	, 756	, null	, "com.mysql.cj.jdbc.Driver"	, "jdbc:mysql://{host}:{port:3306}/{database}"),
        Dragonfly           	("Dragonfly"                        	, KEY_CASE.SRC	, 651	, null	, ""	, ""),
        Drill               	("Apache Drill"                     	, KEY_CASE.SRC	, 886	, null	, ""	, ""),
        DuckDB              	("DuckDB"                           	, KEY_CASE.SRC	, 906	, null	, "org.duckdb.DuckDBDriver"	, "jdbc:duckdb:{database}"),
        Dydra               	("Dydra"                            	, KEY_CASE.SRC	, 673	, null	, ""	, ""),
        EDB                 	("EDB"                              	, KEY_CASE.SRC	, 883	, null	, "org.postgresql.Driver"	, "jdbc:edb://{host}:{port:5444}/{database}"),
        EdgelessDB          	("EdgelessDB"                       	, KEY_CASE.SRC	, 590	, null	, ""	, ""),
        Ehcache             	("Ehcache"                          	, KEY_CASE.SRC	, 937	, null	, ""	, ""),
        EJDB                	("EJDB"                             	, KEY_CASE.SRC	, 699	, null	, ""	, ""),
        Elassandra          	("Elassandra"                       	, KEY_CASE.SRC	, 726	, null	, ""	, ""),
        ElasticSearch       	("Elasticsearch"                    	, KEY_CASE.SRC	, 991	, null	, ""	, ""),
        ElevateDB           	("ElevateDB"                        	, KEY_CASE.SRC	, 688	, null	, ""	, ""),
        Elliptics           	("Elliptics"                        	, KEY_CASE.SRC	, 727	, null	, ""	, ""),
        Eloquera            	("Eloquera"                         	, KEY_CASE.SRC	, 647	, null	, ""	, ""),
        Empress             	("Empress"                          	, KEY_CASE.SRC	, 858	, null	, ""	, ""),
        EsgynDB             	("EsgynDB"                          	, KEY_CASE.SRC	, 679	, null	, "org.trafodion.jdbc.t4.T4Driver"	, "jdbc:t4jdbc://{host}:{port}/"),
        etcd                	("etcd"                             	, KEY_CASE.SRC	, 947	, null	, ""	, ""),
        EventStore          	("IBM Db2 Event Store"              	, KEY_CASE.SRC	, 671	, null	, "com.ibm.db2.jcc.DB2Driver"	, "jdbc:db2://{host}:{port:50000}/{database}"),
        EXASOL              	("EXASOL"                           	, KEY_CASE.SRC	, 887	, null	, "com.exasol.jdbc.EXADriver"	, "jdbc:exa:{host}:{port}"),
        eXistdb             	("eXist-db"                         	, KEY_CASE.SRC	, 777	, null	, ""	, ""),
        Exorbyte            	("Exorbyte"                         	, KEY_CASE.SRC	, 666	, null	, ""	, ""),
        eXtreme             	("eXtremeDB"                        	, KEY_CASE.SRC	, 767	, null	, "com.mcobject.jdbc.McoDriver"	, "jdbc:extremedb:{host}:{port}"),
        eXtremeScale        	("WebSphere eXtreme Scale"          	, KEY_CASE.SRC	, 776	, null	, ""	, ""),
        Ezmeral             	("HPE Ezmeral Data Fabric"          	, KEY_CASE.SRC	, 808	, null	, ""	, ""),
        FaircomDB           	("Faircom DB"                       	, KEY_CASE.SRC	, 685	, null	, "ctree.jdbc.ctreeDriver"	, "jdbc:ctree://{host}:{port}/{database}"),
        FaircomEDGE         	("Faircom EDGE"                     	, KEY_CASE.SRC	, 611	, null	, "ctree.jdbc.ctreeDriver"	, "jdbc:ctree://{host}:{port}/{database}"),
        Fauna               	("Fauna"                            	, KEY_CASE.SRC	, 841	, null	, ""	, ""),
        FeatureBase         	("FeatureBase"                      	, KEY_CASE.SRC	, 715	, null	, ""	, ""),
        FileMaker           	("FileMaker"                        	, KEY_CASE.SRC	, 978	, null	, "com.filemaker.jdbc.Driver"	, "jdbc:filemaker://{host}:{port};{database}"),
        Firebase            	("Firebase Realtime Database"       	, KEY_CASE.SRC	, 961	, null	, ""	, ""),
        Firebird            	("Firebird"                         	, KEY_CASE.SRC	, 968	, null	, "org.firebirdsql.jdbc.FBDriver"	, "jdbc:firebirdsql://{host}:{port:3050}/{database}"),
        Firebolt            	("Firebolt"                         	, KEY_CASE.SRC	, 865	, null	, ""	, "jdbc:firebolt:{database}"),
        Flink               	("Apache Flink"                     	, KEY_CASE.SRC	, 954	, null	, ""	, ""),
        FlockDB             	("FlockDB"                          	, KEY_CASE.SRC	, 692	, null	, ""	, ""),
        Fluree              	("Fluree"                           	, KEY_CASE.SRC	, 706	, null	, ""	, ""),
        FoundationDB        	("FoundationDB"                     	, KEY_CASE.SRC	, 835	, null	, ""	, ""),
        FrontBase           	("FrontBase"                        	, KEY_CASE.SRC	, 753	, null	, "com.frontbase.jdbc.FBJDriver"	, "jdbc:FrontBase://{host}:{port}{database}"),
        Fujitsu             	("Fujitsu Enterprise Postgres"      	, KEY_CASE.SRC	, 693	, null	, ""	, ""),
        FusionInsight       	("FusionInsight"                    	, KEY_CASE.SRC	, 900	, null	, "org.apache.hive.jdbc.HiveDriver"	, "jdbc:hive2://{host}:{port}/{database}"),
        GaiaDB              	("百度GaiaDB-X"                       	, KEY_CASE.SRC	, 900	, null	, "com.mysql.cj.jdbc.Driver"	, "jdbc:mysql://{host}:{port:3306}/{database}"),
        Galaxybase          	("Galaxybase"                       	, KEY_CASE.SRC	, 616	, null	, ""	, ""),
        GaussDB200         	    ("GaussDB 200"                      	, KEY_CASE.SRC	, 900	, null	, "com.huawei.gauss200.jdbc.Driver"	, "jdbc:gaussdb://{host}:{port:25308}/{database}"),
        GaussDB100          	("GaussDB 100"                      	, KEY_CASE.SRC	, 900	, null	, "com.huawei.gauss.jdbc.ZenithDriver"	, "jdbc:zenith:@{host}:{port}"),
        GBase8A             	("南大通用8A"                           	, KEY_CASE.SRC	, 990	, null	, "com.gbase.jdbc.Driver"	, "jdbc:gbase://{host}:{port:5258}/{database}"),
        GBase8C             	("南大通用8C"                           	, KEY_CASE.SRC	, 990	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:15432}/{database}"),
        GBase8S             	("南大通用8S"                          	, KEY_CASE.SRC	, 990	, null	, "com.gbasedbt.jdbc.Driver"	, "jdbc:gbasedbt-sqli://{host}:{port:1533}/{database}:GBASEDBTSERVER={server};user={user};password={password}"),
        GemFire             	("GemFire"                          	, KEY_CASE.SRC	, 904	, null	, ""	, ""),
        GemStoneS           	("GemStone/S"                       	, KEY_CASE.SRC	, 758	, null	, ""	, ""),
        Geode               	("Geode"                            	, KEY_CASE.SRC	, 870	, null	, ""	, ""),
        GeoMesa             	("GeoMesa"                          	, KEY_CASE.SRC	, 778	, null	, ""	, ""),
        GigaSpaces          	("GigaSpaces"                       	, KEY_CASE.SRC	, 813	, null	, "com.j_spaces.jdbc.driver.GDriver"	, "jdbc:gigaspaces:url:jini://{host}"),
        Giraph              	("Giraph"                           	, KEY_CASE.SRC	, 822	, null	, ""	, ""),
        GoldenDB            	("中兴GoldenDB"                       	, KEY_CASE.SRC	, 900	, null	, "com.mysql.cj.jdbc.Driver"	, "jdbc:mysql://{host}:{port:3306}/{database}"),
        GoogleBigQuery      	("Google BigQuery"                  	, KEY_CASE.SRC	, 980	, null	, ""	, ""),
        GoogleBigtable      	("Google Cloud Bigtable"            	, KEY_CASE.SRC	, 912	, null	, ""	, ""),
        GoogleDatastore     	("Google Cloud Datastore"           	, KEY_CASE.SRC	, 922	, null	, ""	, ""),
        GoogleFirestore     	("Google Cloud Firestore"           	, KEY_CASE.SRC	, 952	, null	, ""	, ""),
        GoogleSpanner       	("Google Cloud Spanner"             	, KEY_CASE.SRC	, 902	, null	, ""	, ""),
        GraphBase           	("GraphBase"                        	, KEY_CASE.SRC	, 665	, null	, ""	, ""),
        GraphDB             	("GraphDB"                          	, KEY_CASE.SRC	, 879	, null	, ""	, ""),
        GraphEngine         	("Graph Engine"                     	, KEY_CASE.SRC	, 745	, null	, ""	, ""),
        Graphite            	("Graphite"                         	, KEY_CASE.SRC	, 921	, null	, ""	, ""),
        GraphPortal         	("Graph Portal"                     	, KEY_CASE.SRC	, 0	, null	, ""	, ""),
        GreatDB             	("万里数据库"                            	, KEY_CASE.SRC	, 900	, null	, "com.mysql.cj.jdbc.Driver"	, "jdbc:mysql://{host}:{port:3306}/{database}"),
        Greenplum           	("Greenplum"                        	, KEY_CASE.SRC	, 951	, null	, "com.pivotal.jdbc.GreenplumDriver"	, "jdbc:pivotal:greenplum://{host}:{port};DatabaseName={database}"),
        GreptimeDB          	("GreptimeDB"                       	, KEY_CASE.SRC	, 660	, null	, ""	, ""),
        GridDB              	("GridDB"                           	, KEY_CASE.SRC	, 852	, null	, "com.toshiba.mwcloud.gs.sql.Driver"	, "jdbc:gs://{host}:{port}/{cluster}/{database}"),
        GridGain            	("GridGain"                         	, KEY_CASE.SRC	, 847	, null	, "org.apache.ignite.IgniteJdbcThinDriver"	, "jdbc:ignite:thin://{host}:{port}"),
        Grinn               	("Grinn"                            	, KEY_CASE.SRC	, 0	, null	, ""	, ""),
        gStore              	("gStore"                           	, KEY_CASE.SRC	, 631	, null	, ""	, ""),
        GTM                 	("GT.M"                             	, KEY_CASE.SRC	, 821	, null	, ""	, ""),
        H2                  	("H2"                               	, KEY_CASE.SRC	, 949	, null	, "org.h2.Driver"	, "jdbc:h2:{database}"),
        H2GIS               	("H2GIS"                            	, KEY_CASE.SRC	, 649	, null	, ""	, ""),
        HANA                	("SAP HANA"                         	, KEY_CASE.SRC	, 976	, null	, "com.sap.db.jdbc.Driver"	, "jdbc:sap://{host}:{port}[?{param}]"),
        HarperDB            	("HarperDB"                         	, KEY_CASE.SRC	, 736	, null	, "cdata.jdbc.harperdb.HarperDBDriver"	, "jdbc:harperdb:Server={host};User={user};Password={password};"),
        HashData            	("酷克数据"                             	, KEY_CASE.SRC	, 900	, null	, "org.postgresql.Driver"	, "jdbc:postgresql://{host}:{port:5432}/{database}}"),
        Hawkular            	("Hawkular Metrics"                 	, KEY_CASE.SRC	, 613	, null	, ""	, ""),
        HAWQ                	("Apache HAWQ"                      	, KEY_CASE.SRC	, 805	, null	, ""	, ""),
        Hazelcast           	("Hazelcast"                        	, KEY_CASE.SRC	, 944	, null	, ""	, ""),
        Hbase               	("HBase"                            	, KEY_CASE.SRC	, 973	, null	, "org.apache.phoenix.jdbc.PhoenixDriver"	, " jdbc:phoenix:{host}:{port}/{database}"),
        HEAVYAI             	("HEAVY.AI"                         	, KEY_CASE.SRC	, 893	, null	, "ai.heavy.jdbc.HeavyAIDriver"	, "jdbc:heavyai:{host}:{port}:{database}"),
        Helium              	("Helium"                           	, KEY_CASE.SRC	, 589	, null	, ""	, ""),
        Heroic              	("Heroic"                           	, KEY_CASE.SRC	, 750	, null	, ""	, ""),
        HFSQL               	("HFSQL"                            	, KEY_CASE.SRC	, 819	, null	, ""	, ""),
        HGraphDB            	("HGraphDB"                         	, KEY_CASE.SRC	, 588	, null	, ""	, ""),
        Hibari              	("Hibari"                           	, KEY_CASE.SRC	, 789	, null	, ""	, ""),
        HighGo              	("瀚高"                               	, KEY_CASE.SRC	, 980	, null	, "com.highgo.jdbc.Driver"	, "jdbc:highgo://{host}:{port:5866}/{database}"),
        Hippo               	("Transwarp Hippo"                  	, KEY_CASE.SRC	, 625	, null	, ""	, ""),
        Hive                	("Hive"                             	, KEY_CASE.SRC	, 981	, null	, "org.apache.hive.jdbc.HiveDriver"	, "jdbc:hive2://{host}:{port}/{database}"),
        HotDB               	("热璞"                               	, KEY_CASE.SRC	, 900	, null	, "com.mysql.cj.jdbc.Driver"	, "jdbc:mysql://{host}:{port:3306}/{database}"),
        HugeGraph           	("HugeGraph"                        	, KEY_CASE.SRC	, 677	, null	, ""	, ""),
        HyperGraphDB        	("HyperGraphDB"                     	, KEY_CASE.SRC	, 701	, null	, ""	, ""),
        HyperLevelDB        	("HyperLevelDB"                     	, KEY_CASE.SRC	, 646	, null	, ""	, ""),
        HyperSQL            	("HyperSQL(HSQLDB)"                 	, KEY_CASE.SRC	, 920	, null	, "org.hsqldb.jdbcDriver"	, " jdbc:hsqldb:file:{database}"),
        iBoxDB              	("iBoxDB"                           	, KEY_CASE.SRC	, 609	, null	, ""	, ""),
        IDMS                	("IDMS"                             	, KEY_CASE.SRC	, 780	, null	, ""	, ""),
        Ignite              	("Ignite"                           	, KEY_CASE.SRC	, 913	, null	, "org.apache.ignite.IgniteJdbcThinDriver"	, ""),
        Immudb              	("Immudb"                           	, KEY_CASE.SRC	, 705	, null	, ""	, ""),
        IMS                 	("IMS"                              	, KEY_CASE.SRC	, 875	, null	, ""	, ""),
        Indica              	("Indica"                           	, KEY_CASE.SRC	, 629	, null	, ""	, ""),
        Infinispan          	("Infinispan"                       	, KEY_CASE.SRC	, 900	, null	, ""	, ""),
        InfiniteGraph       	("InfiniteGraph"                    	, KEY_CASE.SRC	, 722	, null	, ""	, ""),
        InfinityDB          	("InfinityDB"                       	, KEY_CASE.SRC	, 627	, null	, ""	, ""),
        InfluxDB            	("InfluxDB"                         	, KEY_CASE.SRC	, 971	, null	, ""	, "jdbc:influxdb://{host}:{port}/{database}"),
        Infobright          	("Infobright"                       	, KEY_CASE.SRC	, 834	, null	, ""	, ""),
        Informix            	("Informix"                         	, KEY_CASE.SRC	, 965	, null	, "com.informix.jdbc.IfxDriver"	, "jdbc:informix-sqli://{host}:{port}/{database}:INFORMIXSERVER={server}"),
        Ingres              	("Ingres"                           	, KEY_CASE.SRC	, 926	, null	, ""	, ""),
        Intelligence        	("Edge Intelligence"                	, KEY_CASE.SRC	, 601	, null	, ""	, ""),
        Interbase           	("Interbase"                        	, KEY_CASE.SRC	, 932	, null	, "interbase.interclient.Driver"	, "jdbc:interbase://{host}/{database}"),
        IoTDB               	("Apache IoTDB"                     	, KEY_CASE.SRC	, 798	, null	, "org.apache.iotdb.jdbc.IoTDBDriver"	, ""),
        IRIS                	("InterSystems IRIS"                	, KEY_CASE.SRC	, 881	, null	, "com.intersystems.jdbc.IRISDriver"	, "jdbc:IRIS://{host}:{port}/{database}"),
        ITTIA               	("ITTIA"                            	, KEY_CASE.SRC	, 728	, null	, ""	, ""),
        Jackrabbit          	("Jackrabbit"                       	, KEY_CASE.SRC	, 929	, null	, ""	, ""),
        Jade                	("Jade"                             	, KEY_CASE.SRC	, 731	, null	, ""	, ""),
        JaguarDB            	("JaguarDB"                         	, KEY_CASE.SRC	, 619	, null	, "com.jaguar.jdbc.JaguarDriver"	, " new JaguarDataSource( {host}, {port}, {database})"),
        JanusGraph          	("JanusGraph"                       	, KEY_CASE.SRC	, 856	, null	, ""	, ""),
        JasDB               	("JasDB"                            	, KEY_CASE.SRC	, 587	, null	, ""	, ""),
        jBASE               	("jBASE"                            	, KEY_CASE.SRC	, 861	, null	, ""	, ""),
        Jena                	("Apache Jena - TDB"                	, KEY_CASE.SRC	, 915	, null	, ""	, ""),
        JethroData          	("JethroData"                       	, KEY_CASE.SRC	, 595	, null	, ""	, ""),
        KairosDB            	("KairosDB"                         	, KEY_CASE.SRC	, 764	, null	, ""	, ""),
        Kdb                 	("Kdb"                              	, KEY_CASE.SRC	, 948	, null	, ""	, ""),
        KeyDB               	("KeyDB"                            	, KEY_CASE.SRC	, 761	, null	, ""	, ""),
        Kinetica            	("Kinetica"                         	, KEY_CASE.SRC	, 763	, null	, ""	, ""),
        KingBase            	("人大金仓"                             	, KEY_CASE.UPPER	, 724	, null	, "com.kingbase8.Driver"	,"jdbc:kingbase8://{host}:{port:54321}/{database}"),
        KunDB               	("星环"                               	,KEY_CASE.SRC	,657	,null	,"com.mysql.cj.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        Kyligence           	("Kyligence Enterprise"             	,KEY_CASE.SRC	,716	,null	,"org.apache.kylin.jdbc.Driver"	,"jdbc:kylin://{host}:{port}/{project}"),
        kylin               	("Apache Kylin"                     	,KEY_CASE.SRC	,823	,null	,"org.apache.kylin.jdbc.Driver"	," jdbc:kylin://{host}:{port:7070}/{database}"),
        LeanXcale           	("LeanXcale"                        	,KEY_CASE.SRC	,695	,null	,"com.leanxcale.client.Driver"	,"jdbc:leanxcale://{host}:{port:1522}/{database}"),
        LedisDB             	("LedisDB"                          	,KEY_CASE.SRC	,605	,null	,""	,""),
        LevelDB             	("LevelDB"                          	,KEY_CASE.SRC	,895	,null	,""	,""),
        LightDB             	("恒生电子"                             	,KEY_CASE.SRC	,900	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        Linter              	("Linter"                           	,KEY_CASE.SRC	,653	,null	,""	,""),
        LiteDB              	("LiteDB"                           	,KEY_CASE.SRC	,829	,null	,""	,""),
        LMDB                	("LMDB"                             	,KEY_CASE.SRC	,874	,null	,""	,""),
        LokiJS              	("LokiJS"                           	,KEY_CASE.SRC	,741	,null	,""	,""),
        Lovefield           	("Lovefield"                        	,KEY_CASE.SRC	,714	,null	,""	,""),
        M3DB                	("M3DB"                             	,KEY_CASE.SRC	,806	,null	,""	,""),
        MachbaseNeo         	("Machbase Neo"                     	,KEY_CASE.SRC	,711	,null	,"com.machbase.jdbc.MachDriver"	,"jdbc:machbase://{host}:{port:5656}/{database}"),
        ManticoreSearch     	("Manticore Search"                 	,KEY_CASE.SRC	,652	,null	,""	,""),
        MapDB               	("MapDB"                            	,KEY_CASE.SRC	,770	,null	,""	,""),
        MariaDB             	("MariaDB"                          	,KEY_CASE.SRC	,986	,null	,"org.mariadb.jdbc.Driver"	,"jdbc:mysql://{host}:{port}/{database}"),
        MarkLogic           	("MarkLogic"                        	,KEY_CASE.SRC	,945	,null	,""	,""),
        Marqo               	("Marqo"                            	,KEY_CASE.SRC	,700	,null	,""	,""),
        MatrixOne           	("MatrixOne"                        	,KEY_CASE.SRC	,817	,null	,""	,""),
        MaxCompute          	("Alibaba Cloud MaxCompute"         	,KEY_CASE.SRC	,762	,null	,"com.aliyun.odps.jdbc.OdpsDriver"	,"jdbc:odps:{host}?project={database}"),
        MaxDB               	("MaxDB"                            	,KEY_CASE.SRC	,899	,null	,"com.sap.dbtech.jdbc.DriverSapDB"	,"jdbc:sapdb://{host}:{port}/{database}"),
        Meilisearch         	("Meilisearch"                      	,KEY_CASE.SRC	,818	,null	,""	,""),
        Memcached           	("Memcached"                        	,KEY_CASE.SRC	,964	,null	,""	,""),
        Memgraph            	("Memgraph"                         	,KEY_CASE.SRC	,892	,null	,""	,""),
        Milvus              	("Milvus"                           	,KEY_CASE.SRC	,828	,null	,""	,""),
        Mimer_SQL           	("Mimer SQL"                        	,KEY_CASE.SRC	,704	,null	,""	,""),
        Mnesia              	("Mnesia"                           	,KEY_CASE.SRC	,855	,null	,""	,""),
        Model204            	("Model 204"                        	,KEY_CASE.SRC	,796	,null	,""	,""),
        ModeShape           	("ModeShape"                        	,KEY_CASE.SRC	,733	,null	,""	,""),
        MogDB               	("云和恩墨"                             	,KEY_CASE.SRC	,900	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        MonetDB             	("MonetDB"                          	,KEY_CASE.SRC	,862	,null	,"org.monetdb.jdbc.MonetDriver"	,"jdbc:monetdb://{host}:{port}/{database}"),
        MongoDB             	("MongoDB"                          	,KEY_CASE.SRC	,993	,"mongodb:"	,""	,"mongodb://[{user}:{password}@]{host}:{port:27017}/{database}"),
        mSQL                	("mSQL"                             	,KEY_CASE.SRC	,830	,null	,""	,""),
        MSSQL               	("SQL Server 2005+"                 	,KEY_CASE.SRC	,996	,""	,"com.microsoft.sqlserver.jdbc.SQLServerDriver"	,"jdbc:sqlserver://{host}:{port:1433};databaseName={database}"),
        MSSQL2000           	("SQL Server 2000"                  	,KEY_CASE.SRC	,980	,":microsoft:sqlserver:"	,"com.microsoft.jdbc.sqlserver.SQLServerDriver"	,"jdbc:microsoft:sqlserver://{host}:{port:1433};databaseName={database}"),
        MuDB                	("沐融信息科技"                           	,KEY_CASE.SRC	,900	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        Mulgara             	("Mulgara"                          	,KEY_CASE.SRC	,694	,null	,""	,""),
        MyScale             	("MyScale"                          	,KEY_CASE.SRC	,655	,null	,""	,""),
        MySQL               	("MySQL"                            	,KEY_CASE.SRC	,999	,null	,"com.mysql.cj.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        NCache              	("NCache"                           	,KEY_CASE.SRC	,801	,null	,""	,""),
        Nebula         	        ("Nebula"                      	     ,KEY_CASE.SRC	,873	,null	,"NebulaDriver"	,"jdbc:nebula://{host}"),
        Neo4j               	("Neo4j"                            	,KEY_CASE.SRC	,980	,null	,"org.neo4j.jdbc.Driver"	,"jdbc:neo4j:http://{host}:{port:7474}"),
        Netezza             	("Netezza"                          	,KEY_CASE.SRC	,956	,null	,"org.netezza.Driver"	,"j dbc:netezza://{host}:{port}/{database}"),
        NEventStore         	("NEventStore"                      	,KEY_CASE.SRC	,684	,null	,""	,""),
        Newts               	("Newts"                            	,KEY_CASE.SRC	,603	,null	,""	,""),
        NexusDB             	("NexusDB"                          	,KEY_CASE.SRC	,747	,null	,""	,""),
        NonStopSQL          	("NonStop SQL"                      	,KEY_CASE.SRC	,832	,null	,""	,""),
        NosDB               	("NosDB"                            	,KEY_CASE.SRC	,626	,null	,""	,""),
        NSDb                	("NSDb"                             	,KEY_CASE.SRC	,620	,null	,""	,""),
        NuoDB               	("NuoDB"                            	,KEY_CASE.SRC	,802	,null	,"com.nuodb.jdbc.Driver"	,"jdbc:com.nuodb://{host}:{port}/{database}"),
        ObjectBox           	("ObjectBox"                        	,KEY_CASE.SRC	,820	,null	,""	,""),
        ObjectDB            	("ObjectDB"                         	,KEY_CASE.SRC	,784	,null	,""	,""),
        ObjectivityDB       	("Objectivity/DB"                   	,KEY_CASE.SRC	,769	,null	,""	,""),
        ObjectStore         	("ObjectStore"                      	,KEY_CASE.SRC	,831	,null	,""	,""),
        OceanBase           	("OceanBase"                        	,KEY_CASE.SRC	,842	,null	,"com.oceanbase.jdbc.Driver"	,"jdbc:oceanbase://{host}:{port}/{database}"),
        ODABA               	("ODABA"                            	,KEY_CASE.SRC	,0	,null	,""	,""),
        OpenEdge            	("OpenEdge"                         	,KEY_CASE.SRC	,907	,null	,"com.ddtek.jdbc.openedge.OpenEdgeDriver"	,"jdbc:datadirect:openedge://{host}:{port};databaseName={database};user={user};password={password}"),
        OpenGauss           	("openGauss"                        	,KEY_CASE.SRC	,800	,null	,"org.opengauss.Driver"	,"jdbc:opengauss://{host}:{port:5432}/{database}"),
        openGemini          	("openGemini"                       	,KEY_CASE.SRC	,634	,null	,""	,""),
        OpenInsight         	("OpenInsight"                      	,KEY_CASE.SRC	,760	,null	,""	,""),
        OpenQM              	("OpenQM"                           	,KEY_CASE.SRC	,709	,null	,""	,""),
        OpenSearch          	("OpenSearch"                       	,KEY_CASE.SRC	,955	,null	,""	,""),
        OpenTSDB            	("OpenTSDB"                         	,KEY_CASE.SRC	,844	,null	,""	,""),
        ORACLE              	("Oracle"                           	,KEY_CASE.SRC	,997	,null	,"oracle.jdbc.OracleDriver"	,"jdbc:oracle:thin:@{host}:{port:1521}/{database}"),
        OracleBerkeley      	("Oracle Berkeley DB"               	,KEY_CASE.SRC	,897	,null	,""	,""),
        OracleCoherence     	("Oracle Coherence"                 	,KEY_CASE.SRC	,871	,null	,""	,""),
        OracleEssbase       	("Oracle Essbase"                   	,KEY_CASE.SRC	,942	,null	,""	,""),
        OracleNoSQL         	("Oracle NoSQL"                     	,KEY_CASE.SRC	,908	,null	,""	,""),
        OracleRdb           	("Oracle Rdb"                       	,KEY_CASE.SRC	,814	,null	,""	,""),
        OrientDB            	("OrientDB"                         	,KEY_CASE.SRC	,903	,null	,""	,""),
        OrigoDB             	("OrigoDB"                          	,KEY_CASE.SRC	,640	,null	,""	,""),
        oscar               	("神舟通用"                             	,KEY_CASE.SRC	,990	,null	,"com.oscar.Driver"	,"jdbc:oscar://{host}:{port:2003}/{database}"),
        OushuDB             	("OushuDB"                          	,KEY_CASE.SRC	,630	,null	,""	,""),
        OWASP               	("OWASP"                            	,KEY_CASE.SRC	,0	,null	,""	,""),
        PerconaMongoDB      	("Percona Server for MongoDB"       	,KEY_CASE.SRC	,746	,null	,""	,""),
        PerconaMySQL        	("Percona Server for MySQL"         	,KEY_CASE.SRC	,868	,null	,""	,""),
        Perst               	("Perst"                            	,KEY_CASE.SRC	,816	,null	,""	,""),
        Phoenix             	("Apache Phoenix"                   	,KEY_CASE.SRC	,884	,null	,"org.apache.phoenix.jdbc.PhoenixDriver"	,"jdbc:phoenix:{host}:{port:2181}/{database}"),
        PieCloudDB          	("PieCloudDB"                       	,KEY_CASE.SRC	,690	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        Pinecone            	("Pinecone"                         	,KEY_CASE.SRC	,894	,null	,""	,""),
        Pinot               	("Apache Pinot"                     	,KEY_CASE.SRC	,751	,null	,"PinotDriver"	,"jdbc:pinot://{host}:{port}"),
        PipelineDB          	("PipelineDB"                       	,KEY_CASE.SRC	,675	,null	,""	,""),
        PlanetScale         	("PlanetScale"                      	,KEY_CASE.SRC	,839	,null	,""	,""),
        PolarDB             	("PolarDB"                          	,KEY_CASE.SRC	,980	,null	,"com.aliyun.polardb.Driver"	,"jdbc:polardb://{host}:{port:5432}/{database}"),
        PostGIS             	("PostGIS"                          	,KEY_CASE.SRC	,970	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        PostgreSQL          	("PostgreSQL"                       	,KEY_CASE.SRC	,998	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        PostgresXL          	("Postgres-XL"                      	,KEY_CASE.SRC	,752	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}}"),
        PouchDB             	("PouchDB"                          	,KEY_CASE.SRC	,885	,null	,""	,""),
        Presto              	("Presto"                           	,KEY_CASE.SRC	,959	,null	,"com.facebook.presto.jdbc.PrestoDriver"	,"jdbc:presto://{host}:{port}/{database}"),
        Prometheus          	("Prometheus"                       	,KEY_CASE.SRC	,943	,null	,""	,""),
        Qdrant              	("Qdrant"                           	,KEY_CASE.SRC	,797	,null	,""	,""),
        Quasardb            	("Quasardb"                         	,KEY_CASE.SRC	,681	,null	,""	,""),
        QuestDB             	("QuestDB"                          	,KEY_CASE.SRC	,853	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        Raima               	("Raima Database Manager"           	,KEY_CASE.SRC	,740	,null	,"RDMDriver"	,"jdbc:raima:rdm://{host}:{port:21553}"),
        RapidsDB            	("柏睿数据"                             	,KEY_CASE.SRC	,900	,null	,"com.boraydata.jdbc.Driver"	,"jdbc:rpdsql://{host}:{port}/{database}"),
        RaptorDB            	("RaptorDB"                         	,KEY_CASE.SRC	,585	,null	,""	,""),
        Rasdaman            	("Rasdaman"                         	,KEY_CASE.SRC	,725	,null	,""	,""),
        RavenDB             	("RavenDB"                          	,KEY_CASE.SRC	,901	,null	,""	,""),
        RBASE               	("R:BASE"                           	,KEY_CASE.SRC	,738	,null	,""	,""),
        RDF4J               	("RDF4J"                            	,KEY_CASE.SRC	,779	,null	,""	,""),
        RDFox               	("RDFox"                            	,KEY_CASE.SRC	,708	,null	,""	,""),
        Reality             	("Northgate Reality"                	,KEY_CASE.SRC	,811	,null	,""	,""),
        Realm               	("Realm"                            	,KEY_CASE.SRC	,946	,null	,""	,""),
        Redis               	("Redis"                            	,KEY_CASE.SRC	,992	,null	,""	,""),
        Redland             	("Redland"                          	,KEY_CASE.SRC	,737	,null	,""	,""),
        RedStore            	("RedStore"                         	,KEY_CASE.SRC	,702	,null	,""	,""),
        reldb               	("reldb"                            	,KEY_CASE.SRC	,0	,null	,""	,""),
        ResinCache          	("Resin Cache"                      	,KEY_CASE.SRC	,596	,null	,""	,""),
        RethinkDB           	("RethinkDB"                        	,KEY_CASE.SRC	,888	,null	,""	,""),
        RiakKV              	("Riak KV"                          	,KEY_CASE.SRC	,918	,null	,""	,""),
        RiakTS              	("Riak TS"                          	,KEY_CASE.SRC	,687	,null	,""	,""),
        RisingWave          	("RisingWave"                       	,KEY_CASE.SRC	,754	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}}"),
        Rizhiyi             	("Rizhiyi"                          	,KEY_CASE.SRC	,584	,null	,""	,""),
        RocksDB             	("RocksDB"                          	,KEY_CASE.SRC	,909	,null	,""	,""),
        Rockset             	("Rockset"                          	,KEY_CASE.SRC	,775	,null	,""	,""),
        RRDtool             	("RRDtool"                          	,KEY_CASE.SRC	,880	,null	,""	,""),
        SadasEngine         	("Sadas Engine"                     	,KEY_CASE.SRC	,614	,null	,""	,""),
        SAPIQ               	("SAP IQ"                           	,KEY_CASE.SRC	,917	,null	,"com.sybase.jdbc4.jdbc.SybDriver"	,"jdbc:sybase:Tds:{host}:{port}/{database}"),
        Scalaris            	("Scalaris"                         	,KEY_CASE.SRC	,748	,null	,""	,""),
        ScaleArc            	("ScaleArc"                         	,KEY_CASE.SRC	,755	,null	,""	,""),
        SciDB               	("SciDB"                            	,KEY_CASE.SRC	,766	,null	,""	,""),
        ScyllaDB            	("ScyllaDB"                         	,KEY_CASE.SRC	,934	,null	,""	,""),
        SearchBlox          	("SearchBlox"                       	,KEY_CASE.SRC	,723	,null	,""	,""),
        searchxml           	("searchxml"                        	,KEY_CASE.SRC	,583	,null	,""	,""),
        Sedna               	("Sedna"                            	,KEY_CASE.SRC	,843	,null	,""	,""),
        SelectDB            	("SelectDB"                         	,KEY_CASE.SRC	,900	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        SenseiDB            	("SenseiDB"                         	,KEY_CASE.SRC	,643	,null	,""	,""),
        Sequoiadb           	("Sequoiadb(巨杉数据库)"                 	,KEY_CASE.SRC	,730	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        Siaqodb             	("Siaqodb"                          	,KEY_CASE.SRC	,637	,null	,""	,""),
        SingleStore         	("SingleStore"                      	,KEY_CASE.SRC	,927	,null	,"com.singlestore.jdbc.Driver"	,"jdbc:singlestore://{host}:{port}/{database}"),
        SinoDB              	("星瑞格"                              	,KEY_CASE.SRC	,900	,null	,"com.sinodbms.jdbc.IfxDriver"	,"jdbc:sinodbms-sqli://{host}:{port}/{database}:SINODBMSSERVER={server}"),
        SiriDB              	("SiriDB"                           	,KEY_CASE.SRC	,623	,null	,""	,""),
        SiteWhere           	("SiteWhere"                        	,KEY_CASE.SRC	,622	,null	,""	,""),
        Skytable            	("Skytable"                         	,KEY_CASE.SRC	,663	,null	,""	,""),
        SmallSQL            	("SmallSQL"                         	,KEY_CASE.SRC	,599	,null	,""	,""),
        Snowflake           	("Snowflake"                        	,KEY_CASE.SRC	,988	,null	," net.snowflake.client.jdbc.SnowflakeDriver"	,"jdbc:snowflake://{host}"),
        solidDB             	("solidDB"                          	,KEY_CASE.SRC	,803	,null	,""	,""),
        Solr                	("Solr"                             	,KEY_CASE.SRC	,975	,null	,""	,""),
        SpaceTime           	("SpaceTime"                        	,KEY_CASE.SRC	,598	,null	,""	,""),
        Spark               	("Spark SQL"                        	,KEY_CASE.SRC	,963	,null	,"org.apache.hive.jdbc.HiveDriver"	,"jdbc:hive2://{host}:{port}/{database}"),
        SparkleDB           	("SparkleDB"                        	,KEY_CASE.SRC	,597	,null	,""	,""),
        Sparksee            	("Sparksee"                         	,KEY_CASE.SRC	,656	,null	,""	,""),
        SpatiaLite          	("SpatiaLite"                       	,KEY_CASE.SRC	,863	,null	,""	,""),
        Speedb              	("Speedb"                           	,KEY_CASE.SRC	,680	,null	,""	,""),
        Sphinx              	("Sphinx"                           	,KEY_CASE.SRC	,930	,null	,""	,""),
        SpliceMachine       	("Splice Machine"                   	,KEY_CASE.SRC	,735	,null	,""	,""),
        Splunk              	("Splunk"                           	,KEY_CASE.SRC	,985	,null	,""	,""),
        SQLBase             	("SQLBase"                          	,KEY_CASE.SRC	,845	,null	,""	,""),
        SQLite              	("SQLite"                           	,KEY_CASE.SRC	,989	,null	,"org.sqlite.JDBC"	,"jdbc:sqlite:{database}"),
        SQLJS               	("SQL.JS"                           	,KEY_CASE.SRC	,810	,null	,""	,""),
        SQream              	("SQream DB"                        	,KEY_CASE.SRC	,773	,null	,"com.sqream.jdbc.SQDriver"	,"jdbc:Sqream://{host}:{port}/{database}"),
        Starcounter         	("Starcounter"                      	,KEY_CASE.SRC	,719	,null	,""	,""),
        StarDB              	("京东StarDB"                         	,KEY_CASE.SRC	,900	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        Stardog             	("Stardog"                          	,KEY_CASE.SRC	,866	,null	,""	,""),
        StarRocks           	("StarRocks"                        	,KEY_CASE.SRC	,804	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        StateServer         	("ScaleOut StateServer"             	,KEY_CASE.SRC	,608	,null	,""	,""),
        StellarDB           	("Transwarp StellarDB"              	,KEY_CASE.SRC	,617	,null	,""	,""),
        Strabon             	("Strabon"                          	,KEY_CASE.SRC	,732	,null	,""	,""),
        STSdb               	("STSdb"                            	,KEY_CASE.SRC	,691	,null	,""	,""),
        SurrealDB           	("SurrealDB"                        	,KEY_CASE.SRC	,0	,null	,"com.surrealdb.driver.SyncSurrealDriver"	,""),
        SwayDB              	("SwayDB"                           	,KEY_CASE.SRC	,604	,null	,""	,""),
        SWCDB               	("SWC-DB"                           	,KEY_CASE.SRC	,606	,null	,""	,""),
        Sybase              	("Sybase"                           	,KEY_CASE.SRC	,980	,null	,"com.sybase.jdbc4.jdbc.SybDriver"	,"jdbc:sybase:Tds:{host}:{port}/{database}"),
        Table_Store         	("Alibaba Cloud Table Store"        	,KEY_CASE.SRC	,669	,null	,""	,""),
        Tajo                	("Tajo"                             	,KEY_CASE.SRC	,698	,null	,""	,""),
        Tarantool           	("Tarantool"                        	,KEY_CASE.SRC	,848	,null	,""	,""),
        TDengine            	("TDengine"                         	,KEY_CASE.SRC	,882	,null	,"com.taosdata.jdbc.TSDBDriver"	,"jdbc:TAOS://{host}:{port:6030}/{database}"),
        TDSQL               	("TDSQL for MySQL"                  	,KEY_CASE.SRC	,781	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        TeraData            	("Teradata"                         	,KEY_CASE.SRC	,979	,null	,"com.ncr.teradata.TeraDriver"	,"jdbc:teradata://{host}/DATABASE={database},DBS_PORT={port:1025}"),
        TerarkDB            	("TerarkDB"                         	,KEY_CASE.SRC	,641	,null	,""	,""),
        TerminusDB          	("TerminusDB"                       	,KEY_CASE.SRC	,662	,null	,""	,""),
        Tibero              	("Tibero"                           	,KEY_CASE.SRC	,854	,null	,"com.tmax.tibero.jdbc.TbDriver"	,"jdbc:tibero:thin:@{host}:{port}:{database}"),
        TiDB                	("TiDB"                             	,KEY_CASE.SRC	,911	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        TigerGraph          	("TigerGraph"                       	,KEY_CASE.SRC	,851	,null	,"com.tigergraph.jdbc.Driver"	,"jdbc:tg:http://{host}:{port}"),
        Tigris              	("Tigris"                           	,KEY_CASE.SRC	,650	,null	,""	,""),
        Timescale           	("TimescaleDB"                      	,KEY_CASE.SRC	,924	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        TimesTen            	("TimesTen"                         	,KEY_CASE.SRC	,837	,null	,"com.timesten.jdbc.TimesTenClientDriver"	,"jdbc:timesten:client:dsn={database}"),
        TinkerGraph         	("TinkerGraph"                      	,KEY_CASE.SRC	,672	,null	,""	,""),
        Tkrzw               	("Tkrzw"                            	,KEY_CASE.SRC	,607	,null	,""	,""),
        TokyoTyrant         	("Tokyo Tyrant"                     	,KEY_CASE.SRC	,664	,null	,""	,""),
        TomP2P              	("TomP2P"                           	,KEY_CASE.SRC	,639	,null	,""	,""),
        Transbase           	("Transbase"                        	,KEY_CASE.SRC	,689	,null	,"transbase.jdbc.Driver"	,"jdbc:transbase://{host}:{port:4444}/{database}"),
        TransLattice        	("TransLattice"                     	,KEY_CASE.SRC	,659	,null	,""	,""),
        Trino               	("Trino"                            	,KEY_CASE.SRC	,928	,null	,"io.trino.jdbc.TrinoDriver"	,"jdbc:trino://{host}:{port}/{database}"),
        TSDB                	("Alibaba Cloud TSDB"               	,KEY_CASE.SRC	,642	,null	,""	,""),
        TypeDB              	("TypeDB"                           	,KEY_CASE.SRC	,787	,null	,""	,""),
        Typesense           	("Typesense"                        	,KEY_CASE.SRC	,771	,null	,""	,""),
        UbiSQL              	("平安科技"                             	,KEY_CASE.SRC	,900	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        Ultipa              	("Ultipa"                           	,KEY_CASE.SRC	,670	,null	,""	,""),
        Upscaledb           	("Upscaledb"                        	,KEY_CASE.SRC	,633	,null	,""	,""),
        UXDB                	("优炫数据库"                            	,KEY_CASE.SRC	,900	,null	,"com.uxsino.uxdb.Driver"	,"jdbc:uxdb://{host}:{port:5432}/{database}"),
        Vald                	("Vald"                             	,KEY_CASE.SRC	,757	,null	,""	,""),
        Valentina           	("Valentina Server"                 	,KEY_CASE.SRC	,676	,null	,""	,""),
        Vastbase            	("海量数据"                             	,KEY_CASE.SRC	,900	,null	,"org.postgresql.Driver"	,"jdbc:postgresql://{host}:{port:5432}/{database}"),
        VelocityDB          	("VelocityDB"                       	,KEY_CASE.SRC	,648	,null	,""	,""),
        Vertica             	("Vertica"                          	,KEY_CASE.SRC	,958	,null	,"com.vertica.jdbc.Driver"	,"jdbc:vertica://{host}:{port:5433}/{database}"),
        Vespa               	("Vespa"                            	,KEY_CASE.SRC	,742	,null	,""	,""),
        VictoriaMetrics     	("VictoriaMetrics"                  	,KEY_CASE.SRC	,824	,null	,""	,""),
        Virtuoso            	("Virtuoso"                         	,KEY_CASE.SRC	,925	,null	,""	,""),
        VistaDB             	("VistaDB"                          	,KEY_CASE.SRC	,749	,null	,""	,""),
        Vitess              	("Vitess"                           	,KEY_CASE.SRC	,812	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        Voldemort           	("Project Voldemort"                	,KEY_CASE.SRC	,713	,null	,""	,""),
        VoltDB              	("VoltDB"                           	,KEY_CASE.SRC	,836	,null	,"org.voltdb.jdbc.Driver"	,"jdbc:voltdb://{host}:{port:21212}"),
        Voracity            	("Voracity"                         	,KEY_CASE.SRC	,0	,null	,""	,""),
        WakandaDB           	("WakandaDB"                        	,KEY_CASE.SRC	,618	,null	,""	,""),
        Warp                	("Warp 10"                          	,KEY_CASE.SRC	,635	,null	,""	,""),
        Weaviate            	("Weaviate"                         	,KEY_CASE.SRC	,849	,null	,""	,""),
        Xapian              	("Xapian"                           	,KEY_CASE.SRC	,792	,null	,""	,""),
        xigemaDB            	("华胜信泰"                             	,KEY_CASE.SRC	,900	,null	,"com.informix.jdbc.IfxDriver"	,"jdbc:informix-sqli://{host}:{port}/{database}:INFORMIXSERVER={server}"),
        XuGu                	("XuGu"                             	,KEY_CASE.SRC	,645	,null	,"com.xugu.cloudjdbc.Driver"	,"jdbc:xugu://{host}:{port:5138}/database"),
        XTDB                	("XTDB"                             	,KEY_CASE.SRC	,645	,null	,""	,""),
        XtremeData          	("XtremeData"                       	,KEY_CASE.SRC	,638	,null	,""	,""),
        YDB                 	("YDB"                              	,KEY_CASE.SRC	,703	,null	,""	,""),
        Yellowbrick         	("Yellowbrick"                      	,KEY_CASE.SRC	,774	,null	,""	,""),
        YiDB                	("天翼数智"                             	,KEY_CASE.SRC	,900	,null	,"com.mysql.jdbc.Driver"	,"jdbc:mysql://{host}:{port:3306}/{database}"),
        YottaDB             	("YottaDB"                          	,KEY_CASE.SRC	,682	,null	,""	,""),
        YTsaurus            	("YTsaurus"                         	,KEY_CASE.SRC	,636	,null	,""	,""),
        YugabyteDB          	("YugabyteDB"                       	,KEY_CASE.SRC	,896	,null	,"com.yugabyte.Driver"	,"jdbc:yugabytedb://{host}:{port}/{database}"),
        ZeroMQ              	("ZeroMQ"                           	,KEY_CASE.SRC	,0	,null	,""	,""),
        ZODB                	("ZODB"                             	,KEY_CASE.SRC	,795	,null	,""	,""),
        ;
        DatabaseType(String title, KEY_CASE objectNameCase, int boost, String keywords, String driver, String url) {
                this.title = title;
                this.driver = driver;
                this.objectNameCase = objectNameCase;
                this.url = url;
                this.boost = boost;
                if(null != keywords) {
                        String[] ks = keywords.toLowerCase().split(",");
                        for(String k:ks) {
                                this.keywords.add(k.toLowerCase());
                        }
                }
                if(null != url) {
                        //   jdbc:mysql://host:3306/db
                        int idx = url.indexOf(":", 6);
                        if(idx > 0) {
                                this.keywords.add(url.substring(0,idx+1).toLowerCase());
                        }
                }
                if(null != driver) {
                        this.keywords.add(driver.toLowerCase());
                }
        }
        //时查询系统表时对象名(表名、列表)是否大写
        private final List<String> keywords = new ArrayList<>();
        private final KEY_CASE objectNameCase;
        private final int boost;
        private final String title;
        private final String driver;
        private final String url;
        public int boost() {
                return boost;
        }
        public List<String> keywords() {
                return keywords;
        }
        public String driver() {
                return driver;
        }
        public String url() {
                return url;
        }
        public String title() {
                return title;
        }
        public KEY_CASE nameCase() {
                return objectNameCase;
        }

}
