/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.anyline.entity.Coordinate;
import org.anyline.entity.SRS;
import org.anyline.entity.geometry.Point;
import org.anyline.entity.geometry.Ring;
import org.anyline.util.BasicUtil;
import org.anyline.util.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GISUtil {
    private static final Logger log = LoggerFactory.getLogger(GISUtil.class);
    private static Double EARTH_RADIUS = 6378.137;
    private static final Double RADIUS = 6378245.0;
    private static final Double EE = 0.006693421622965943;
    private static final Double PI = Math.PI;
    private static final Double X_PI = 52.35987755982988;

    private static Double rad(Double d) {
        return d * Math.PI / 180.0;
    }

    public static Double distance(Double lng1, Double lat1, Double lng2, Double lat2) {
        try {
            Double radLat1 = GISUtil.rad(lat1);
            Double radLat2 = GISUtil.rad(lat2);
            Double a = radLat1 - radLat2;
            Double b = GISUtil.rad(lng1) - GISUtil.rad(lng2);
            Double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
            s = s * EARTH_RADIUS;
            s = (double)Math.round(s * 10000.0) / 10000.0;
            s = s * 1000.0;
            BigDecimal decimal = new BigDecimal(s);
            s = decimal.setScale(2, 4).doubleValue();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String distanceFormat(Double lng1, Double lat1, Double lng2, Double lat2) {
        Double distance = GISUtil.distance(lng1, lat1, lng2, lat2);
        return GISUtil.distanceFormat(distance);
    }

    public static String distanceFormatCn(Double lng1, Double lat1, Double lng2, Double lat2) {
        Double distance = GISUtil.distance(lng1, lat1, lng2, lat2);
        return GISUtil.distanceFormatCn(distance);
    }

    public static Double distance(String lng1, String lat1, String lng2, String lat2) {
        Double distance = null;
        try {
            distance = GISUtil.distance(BasicUtil.parseDouble(lng1, null), BasicUtil.parseDouble(lat1, null), BasicUtil.parseDouble(lng2, null), BasicUtil.parseDouble(lat2, null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return distance;
    }

    public static String distanceFormat(String lng1, String lat1, String lng2, String lat2) {
        Double distance = GISUtil.distance(lng1, lat1, lng2, lat2);
        return GISUtil.distanceFormat(distance);
    }

    public static String distanceFormatCn(String lng1, String lat1, String lng2, String lat2) {
        Double distance = GISUtil.distance(lng1, lat1, lng2, lat2);
        return GISUtil.distanceFormatCn(distance);
    }

    public static Double distance(Coordinate loc1, Coordinate loc2) {
        Double distance = null;
        try {
            distance = GISUtil.distance(BasicUtil.parseDouble(loc1.getLng(), null), BasicUtil.parseDouble(loc1.getLat(), null), BasicUtil.parseDouble(loc2.getLng(), null), BasicUtil.parseDouble(loc2.getLat(), null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return distance;
    }

    public static String distanceFormat(Coordinate loc1, Coordinate loc2) {
        Double distance = GISUtil.distance(loc1.getLng(), loc1.getLat(), loc2.getLng(), loc2.getLat());
        return GISUtil.distanceFormat(distance);
    }

    public static String distanceFormatCn(Coordinate loc1, Coordinate loc2) {
        Double distance = GISUtil.distance(loc1.getLng(), loc1.getLat(), loc2.getLng(), loc2.getLat());
        return GISUtil.distanceFormatCn(distance);
    }

    public static String distanceFormat(Double distance) {
        String result = distance + "m";
        if (distance > 1000.0) {
            result = NumberUtil.format(distance / 1000.0, "0.00") + "km";
        }
        return result;
    }

    public static String distanceFormatCn(Double distance) {
        String result = distance + "\u7c73";
        if (distance > 1000.0) {
            result = NumberUtil.format(distance / 1000.0, "0.00") + "\u5343\u7c73";
        }
        return result;
    }

    public static String parseGPS(String gps) {
        String result = null;
        if (null == gps) {
            return null;
        }
        gps = gps.replaceAll("[^0-9.]", "");
        String d = gps.substring(0, gps.indexOf("."));
        String m = "";
        int idx = d.length() - 2;
        d = gps.substring(0, idx);
        m = gps.substring(idx);
        BigDecimal dd = BasicUtil.parseDecimal((Object)d, 0.0);
        BigDecimal dm = BasicUtil.parseDecimal((Object)m, 0.0).divide(new BigDecimal(60), 7, 0);
        result = dd.add(dm).toString();
        return result;
    }

    public static Double[] convert(SRS src, Double lng, Double lat, SRS tar) {
        Double[] location = new Double[2];
        if (src == tar) {
            location[0] = lng;
            location[1] = lat;
            return location;
        }
        if (tar == SRS.GCJ02LL) {
            if (src == SRS.WGS84LL) {
                location = GISUtil.wgs2gcj(lng, lat);
            } else if (src == SRS.BD09LL) {
                location = GISUtil.bd2gcj(lng, lat);
            }
        } else if (tar == SRS.WGS84LL) {
            if (src == SRS.GCJ02LL) {
                location = GISUtil.gcj2wgs(lng, lat);
            } else if (src == SRS.BD09LL) {
                location = GISUtil.bd2wgs(lng, lat);
            }
        } else if (tar == SRS.BD09LL) {
            if (src == SRS.GCJ02LL) {
                location = GISUtil.gcj2bd(lng, lat);
            } else if (src == SRS.WGS84LL) {
                location = GISUtil.wgs2bd(lng, lat);
            }
        }
        return location;
    }

    public static Double[] convert(SRS src, String lng, String lat, SRS tar) {
        return GISUtil.convert(src, BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null), tar);
    }

    public static Double[] convert(SRS src, String[] location, SRS tar) {
        return GISUtil.convert(src, location[0], location[1], tar);
    }

    public static Double[] convert(SRS src, Double[] location, SRS tar) {
        return GISUtil.convert(src, location[0], location[1], tar);
    }

    public static Double[] bd2gcj(Double[] location) {
        return GISUtil.bd2gcj(location[0], location[1]);
    }

    public static Double[] bd2gcj(String[] location) {
        return GISUtil.bd2gcj(location[0], location[1]);
    }

    public static Double[] bd2gcj(String lng, String lat) {
        return GISUtil.bd2gcj(BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    public static Double[] bd2gcj(Double lng, Double lat) {
        Double x = lng - 0.0065;
        Double y = lat - 0.006;
        Double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * X_PI);
        Double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * X_PI);
        Double gg_lng = z * Math.cos(theta);
        Double gg_lat = z * Math.sin(theta);
        return new Double[]{gg_lng, gg_lat};
    }

    public static Double[] bd2wgs(Double[] location) {
        return GISUtil.bd2wgs(location[0], location[1]);
    }

    public static Double[] bd2wgs(String[] location) {
        return GISUtil.bd2wgs(location[0], location[1]);
    }

    public static Double[] bd2wgs(String lng, String lat) {
        return GISUtil.bd2wgs(BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    public static Double[] bd2wgs(Double lng, Double lat) {
        return GISUtil.gcj2wgs(GISUtil.bd2gcj(lng, lat));
    }

    public static Double[] gcj2bd(Double[] location) {
        return GISUtil.gcj2bd(location[0], location[1]);
    }

    public static Double[] gcj2bd(String[] location) {
        return GISUtil.gcj2bd(location[0], location[1]);
    }

    public static Double[] gcj2bd(String lng, String lat) {
        return GISUtil.gcj2bd(BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    public static Double[] gcj2bd(Double lng, Double lat) {
        Double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * X_PI);
        Double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * X_PI);
        Double bd_lng = z * Math.cos(theta) + 0.0065;
        Double bd_lat = z * Math.sin(theta) + 0.006;
        return new Double[]{bd_lng, bd_lat};
    }

    public static Double[] wgs2bd(Double[] location) {
        return GISUtil.wgs2bd(location[0], location[1]);
    }

    public static Double[] wgs2bd(String[] location) {
        return GISUtil.wgs2bd(location[0], location[1]);
    }

    public static Double[] wgs2bd(String lng, String lat) {
        return GISUtil.gcj2bd(GISUtil.wgs2gcj(lng, lat));
    }

    public static Double[] wgs2bd(Double lng, Double lat) {
        return GISUtil.gcj2bd(GISUtil.wgs2gcj(lng, lat));
    }

    public static Double[] wgs2gcj(Double[] location) {
        return GISUtil.wgs2gcj(location[0], location[1]);
    }

    public static Double[] wgs2gcj(String[] location) {
        return GISUtil.wgs2gcj(location[0], location[1]);
    }

    public static Double[] wgs2gcj(String lng, String lat) {
        return GISUtil.wgs2gcj(BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    public static Double[] wgs2gcj(Double lng, Double lat) {
        if (GISUtil.inChina(lng, lat)) {
            Double dlat = GISUtil.lat(lng - 105.0, lat - 35.0);
            Double dlng = GISUtil.lng(lng - 105.0, lat - 35.0);
            Double radlat = lat / 180.0 * PI;
            Double magic = Math.sin(radlat);
            magic = 1.0 - EE * magic * magic;
            Double sqrtmagic = Math.sqrt(magic);
            dlat = dlat * 180.0 / (RADIUS * (1.0 - EE) / (magic * sqrtmagic) * PI);
            dlng = dlng * 180.0 / (RADIUS / sqrtmagic * Math.cos(radlat) * PI);
            Double mglat = lat + dlat;
            Double mglng = lng + dlng;
            return new Double[]{mglng, mglat};
        }
        return new Double[]{lng, lat};
    }

    public static Double[] gcj2wgs(Double[] location) {
        return GISUtil.gcj2wgs(location[0], location[1]);
    }

    public static Double[] gcj2wgs(String[] location) {
        return GISUtil.gcj2wgs(location[0], location[1]);
    }

    public static Double[] gcj2wgs(String lng, String lat) {
        return GISUtil.gcj2wgs(BasicUtil.parseDouble(lng, 0.0), BasicUtil.parseDouble(lat, 0.0));
    }

    public static Double[] gcj2wgs(Double lng, Double lat) {
        if (GISUtil.inChina(lng, lat)) {
            Double dlat = GISUtil.lat(lng - 105.0, lat - 35.0);
            Double dlng = GISUtil.lng(lng - 105.0, lat - 35.0);
            Double radlat = lat / 180.0 * PI;
            Double magic = Math.sin(radlat);
            magic = 1.0 - EE * magic * magic;
            Double sqrtmagic = Math.sqrt(magic);
            dlat = dlat * 180.0 / (RADIUS * (1.0 - EE) / (magic * sqrtmagic) * PI);
            dlng = dlng * 180.0 / (RADIUS / sqrtmagic * Math.cos(radlat) * PI);
            Double mglat = lat + dlat;
            Double mglng = lng + dlng;
            return new Double[]{lng * 2.0 - mglng, lat * 2.0 - mglat};
        }
        return new Double[]{lng, lat};
    }

    private static Double lat(Double lng, Double lat) {
        Double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret = ret + (20.0 * Math.sin(6.0 * lng * PI) + 20.0 * Math.sin(2.0 * lng * PI)) * 2.0 / 3.0;
        ret = ret + (20.0 * Math.sin(lat * PI) + 40.0 * Math.sin(lat / 3.0 * PI)) * 2.0 / 3.0;
        ret = ret + (160.0 * Math.sin(lat / 12.0 * PI) + 320.0 * Math.sin(lat * PI / 30.0)) * 2.0 / 3.0;
        return ret;
    }

    private static Double lng(Double lng, Double lat) {
        Double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret = ret + (20.0 * Math.sin(6.0 * lng * PI) + 20.0 * Math.sin(2.0 * lng * PI)) * 2.0 / 3.0;
        ret = ret + (20.0 * Math.sin(lng * PI) + 40.0 * Math.sin(lng / 3.0 * PI)) * 2.0 / 3.0;
        ret = ret + (150.0 * Math.sin(lng / 12.0 * PI) + 300.0 * Math.sin(lng / 30.0 * PI)) * 2.0 / 3.0;
        return ret;
    }

    public static boolean inChina(Double lng, Double lat) {
        return lng > 73.66 && lng < 135.05 && lat > 3.86 && lat < 53.55;
    }

    public static boolean pnpoly(Point point, Ring ring) {
        ArrayList<Double> lngs = new ArrayList<Double>();
        ArrayList<Double> lats = new ArrayList<Double>();
        for (Point p : ring.getPoints()) {
            lngs.add(p.x());
            lats.add(p.y());
        }
        return GISUtil.pnpoly(point.x(), point.y(), lngs, lats);
    }

    public static boolean pnpoly(Point point, Point ... points) {
        ArrayList<Double> lngs = new ArrayList<Double>();
        ArrayList<Double> lats = new ArrayList<Double>();
        for (Point p : points) {
            lngs.add(p.x());
            lats.add(p.y());
        }
        return GISUtil.pnpoly(point.x(), point.y(), lngs, lats);
    }

    public static boolean pnpoly(Point point, List<Point> points) {
        ArrayList<Double> lngs = new ArrayList<Double>();
        ArrayList<Double> lats = new ArrayList<Double>();
        for (Point p : points) {
            lngs.add(p.x());
            lats.add(p.y());
        }
        return GISUtil.pnpoly(point.x(), point.y(), lngs, lats);
    }

    public static boolean pnpoly(Double lng, Double lat, List<Double[]> points) {
        ArrayList<Double> lngs = new ArrayList<Double>();
        ArrayList<Double> lats = new ArrayList<Double>();
        for (Double[] point : points) {
            lngs.add(point[0]);
            lats.add(point[1]);
        }
        return GISUtil.pnpoly(lng, lat, lngs, lats);
    }

    public static boolean pnpoly(Double x, Double y, List<Double> xs, List<Double> ys) {
        if (null == xs || xs.isEmpty() || null == ys || ys.isEmpty()) {
            return false;
        }
        Double maxX = xs.stream().max(Comparator.comparingDouble(Double::doubleValue)).get();
        Double maxY = ys.stream().max(Comparator.comparingDouble(Double::doubleValue)).get();
        Double minX = xs.stream().min(Comparator.comparingDouble(Double::doubleValue)).get();
        Double minY = ys.stream().min(Comparator.comparingDouble(Double::doubleValue)).get();
        if (x < minX || x > maxX || y < minY || y > maxY) {
            return false;
        }
        boolean result = false;
        int n = xs.size();
        Double[] vertx = xs.toArray(new Double[0]);
        Double[] verty = ys.toArray(new Double[0]);
        int i = 0;
        int j = n - 1;
        while (i < n) {
            if (verty[i] > y != verty[j] > y && x < (vertx[j] - vertx[i]) * (y - verty[i]) / (verty[j] - verty[i]) + vertx[i]) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }
}

