/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.ColumnsDiffer;
import org.anyline.metadata.differ.IndexsDiffer;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.TriggersDiffer;

public class TableDiffer
implements MetadataDiffer {
    private ColumnsDiffer columnsDiffer;
    private IndexsDiffer indexsDiffer;
    private TriggersDiffer triggersDiffer;

    public boolean isEmpty() {
        if (null != this.columnsDiffer && !this.columnsDiffer.isEmpty()) {
            return false;
        }
        return null == this.indexsDiffer || this.indexsDiffer.isEmpty();
    }

    public static TableDiffer compare(Table origin, Table dest) {
        TableDiffer differ = new TableDiffer();
        if (null == dest) {
            dest = new Table();
        }
        LinkedHashMap<String, Column> originColumns = origin.getColumns();
        LinkedHashMap<String, Column> destColumns = dest.getColumns();
        differ.setColumnsDiffer(ColumnsDiffer.compare(origin.getColumns(), dest.getColumns()));
        differ.setIndexsDiffer(IndexsDiffer.compare(origin.getIndexes(), dest.getIndexes()));
        return differ;
    }

    public ColumnsDiffer getColumnsDiffer() {
        return this.columnsDiffer;
    }

    public void setColumnsDiffer(ColumnsDiffer columnsDiffer) {
        this.columnsDiffer = columnsDiffer;
    }

    public IndexsDiffer getIndexsDiffer() {
        return this.indexsDiffer;
    }

    public void setIndexsDiffer(IndexsDiffer indexsDiffer) {
        this.indexsDiffer = indexsDiffer;
    }

    public TriggersDiffer getTriggersDiffer() {
        return this.triggersDiffer;
    }

    public void setTriggersDiffer(TriggersDiffer triggersDiffer) {
        this.triggersDiffer = triggersDiffer;
    }
}

