/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.geometry;

import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.Point;

public class MultiPoint
extends Geometry {
    private List<Point> points = new ArrayList<Point>();

    public MultiPoint() {
        this.type = 4;
    }

    public MultiPoint(List<Point> points) {
        this();
        this.points = points;
    }

    public MultiPoint add(Point point) {
        this.points.add(point);
        return this;
    }

    public MultiPoint add(List<Point> points) {
        if (null != points) {
            points.addAll(points);
        }
        return this;
    }

    public MultiPoint add(double x, double y) {
        Point point = new Point(x, y);
        point.srid(this.srid);
        return this.add(point);
    }

    public MultiPoint add(int x, int y) {
        return this.add(new Point(x, y));
    }

    public MultiPoint clear() {
        this.points = new ArrayList<Point>();
        return this;
    }

    public List<Point> points() {
        return this.points;
    }

    @Override
    public String toString(boolean tag) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        builder.append("(");
        boolean first = true;
        for (Point point : this.points) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(point.toString(false));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String sql(boolean tag, boolean bracket) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        if (bracket) {
            builder.append("(");
        }
        boolean first = true;
        for (Point point : this.points) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(point.sql(false, false));
        }
        if (bracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String sql() {
        return this.sql(true, true);
    }

    public List<Point> getPoints() {
        return this.points;
    }
}

