/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.differ.MetadataDiffer;

public class TriggersDiffer
implements MetadataDiffer {
    private LinkedHashMap<String, Trigger> adds = new LinkedHashMap();
    private LinkedHashMap<String, Trigger> drops = new LinkedHashMap();
    private LinkedHashMap<String, Trigger> updates = new LinkedHashMap();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static TriggersDiffer compare(LinkedHashMap<String, Trigger> origins, LinkedHashMap<String, Trigger> dests) {
        TriggersDiffer differ = new TriggersDiffer();
        LinkedHashMap<String, Trigger> adds = new LinkedHashMap<String, Trigger>();
        LinkedHashMap<String, Trigger> drops = new LinkedHashMap<String, Trigger>();
        LinkedHashMap<String, Trigger> updates = new LinkedHashMap<String, Trigger>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Trigger origin = origins.get(key);
            Trigger dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.put(key, origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public LinkedHashMap<String, Trigger> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Trigger> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Trigger> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Trigger> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Trigger> getUpdates() {
        return this.updates;
    }

    public void setUpdates(LinkedHashMap<String, Trigger> updates) {
        this.updates = updates;
    }
}

