/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.TableDiffer;

public class TablesDiffer
implements MetadataDiffer {
    private LinkedHashMap<String, Table> adds = new LinkedHashMap();
    private LinkedHashMap<String, Table> drops = new LinkedHashMap();
    private LinkedHashMap<String, Table> updates = new LinkedHashMap();
    private LinkedHashMap<String, TableDiffer> differs = new LinkedHashMap();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static TablesDiffer compare(LinkedHashMap<String, Table> origins, LinkedHashMap<String, Table> dests) {
        return TablesDiffer.compare(origins, dests, true);
    }

    public static TablesDiffer compare(LinkedHashMap<String, Table> origins, LinkedHashMap<String, Table> dests, boolean ignoreSchema) {
        TablesDiffer differ = new TablesDiffer();
        LinkedHashMap<String, Table> adds = new LinkedHashMap<String, Table>();
        LinkedHashMap<String, Table> drops = new LinkedHashMap<String, Table>();
        LinkedHashMap<String, Table> updates = new LinkedHashMap<String, Table>();
        LinkedHashMap<String, TableDiffer> differs = new LinkedHashMap<String, TableDiffer>();
        if (null == origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Table<Object> origin = origins.get(key);
            Table<Object> dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origin);
                continue;
            }
            TableDiffer dif = origin.compare(dest);
            if (dif.isEmpty()) continue;
            origin.setUpdate(dest, false, false);
            updates.put(key, origin);
            differs.put(key, dif);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        differ.setDiffers(differs);
        return differ;
    }

    public LinkedHashMap<String, Table> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Table> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Table> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Table> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Table> getUpdates() {
        return this.updates;
    }

    public void setUpdates(LinkedHashMap<String, Table> updates) {
        this.updates = updates;
    }

    public LinkedHashMap<String, TableDiffer> getDiffers() {
        return this.differs;
    }

    public void setDiffers(LinkedHashMap<String, TableDiffer> differs) {
        this.differs = differs;
    }
}

