/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Column;
import org.anyline.metadata.differ.MetadataDiffer;

public class ColumnsDiffer
implements MetadataDiffer {
    private LinkedHashMap<String, Column> adds = new LinkedHashMap();
    private LinkedHashMap<String, Column> drops = new LinkedHashMap();
    private LinkedHashMap<String, Column> updates = new LinkedHashMap();

    public static ColumnsDiffer compare(LinkedHashMap<String, Column> origins, LinkedHashMap<String, Column> dests) {
        ColumnsDiffer differ = new ColumnsDiffer();
        LinkedHashMap<String, Column> adds = new LinkedHashMap<String, Column>();
        LinkedHashMap<String, Column> drops = new LinkedHashMap<String, Column>();
        LinkedHashMap<String, Column> updates = new LinkedHashMap<String, Column>();
        if (null == origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Column origin = origins.get(key);
            Column dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origin);
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.put(key, origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public LinkedHashMap<String, Column> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Column> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Column> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Column> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Column> getUpdates() {
        return this.updates;
    }

    public void setUpdates(LinkedHashMap<String, Column> updates) {
        this.updates = updates;
    }
}

