/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.client.map;

import org.anyline.client.map.MapClient;
import org.anyline.entity.Coordinate;
import org.anyline.entity.SRS;
import org.anyline.util.BasicUtil;
import org.anyline.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapClient
implements MapClient {
    private static Logger log = LoggerFactory.getLogger(AbstractMapClient.class);

    @Override
    public Coordinate regeo(Coordinate coordinate) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format("\u5b50\u7c7b(" + this.getClass().getName() + ")\u672a\u5b9e\u73b0 public Coordinate regeo(Coordinate coordinate)", 37));
        }
        return null;
    }

    @Override
    public Coordinate geo(String address, String city) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format("\u5b50\u7c7b(" + this.getClass().getName() + ")\u672a\u5b9e\u73b0 Coordinate geo(String address, String city)", 37));
        }
        return null;
    }

    @Override
    public Coordinate geo(String address) {
        return this.geo(address, null);
    }

    @Override
    public Coordinate regeo(SRS srs, Double lng, Double lat) {
        Coordinate coordinate = new Coordinate(srs, lng, lat);
        return this.regeo(coordinate);
    }

    @Override
    public Coordinate regeo(SRS srs, String lng, String lat) {
        return this.regeo(srs, BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    @Override
    public Coordinate regeo(SRS srs, String point) {
        String[] points = point.split(",");
        return this.regeo(srs, BasicUtil.parseDouble(points[0], null), BasicUtil.parseDouble(points[1], null));
    }

    @Override
    public Coordinate regeo(String point) {
        return this.regeo(SRS.GCJ02LL, point);
    }

    @Override
    public Coordinate regeo(String lng, String lat) {
        return this.regeo(BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    @Override
    public Coordinate regeo(Double lng, Double lat) {
        return this.regeo(SRS.GCJ02LL, lng, lat);
    }

    @Override
    public Coordinate regeo(SRS srs, String[] point) {
        return this.regeo(srs, point[0], point[1]);
    }

    @Override
    public Coordinate regeo(String[] point) {
        return this.regeo(point[0], point[1]);
    }

    @Override
    public Coordinate regeo(SRS srs, Double[] point) {
        return this.regeo(srs, point[0], point[1]);
    }

    @Override
    public Coordinate regeo(Double[] point) {
        return this.regeo(point[0], point[1]);
    }
}

