/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;

public class TextUtil {
    public static double similarity(String doc1, String doc2) {
        if (doc1 != null && doc1.trim().length() > 0 && doc2 != null && doc2.trim().length() > 0) {
            int[] fq;
            short charIndex;
            int i;
            HashMap<Integer, int[]> AlgorithmMap = new HashMap<Integer, int[]>();
            for (i = 0; i < doc1.length(); ++i) {
                char d1 = doc1.charAt(i);
                if (!TextUtil.isHanZi(d1) || (charIndex = TextUtil.getGB2312Id(d1)) == -1) continue;
                fq = (int[])AlgorithmMap.get(charIndex);
                if (fq != null && fq.length == 2) {
                    fq[0] = fq[0] + 1;
                    continue;
                }
                fq = new int[]{1, 0};
                AlgorithmMap.put(Integer.valueOf(charIndex), fq);
            }
            for (i = 0; i < doc2.length(); ++i) {
                char d2 = doc2.charAt(i);
                if (!TextUtil.isHanZi(d2) || (charIndex = TextUtil.getGB2312Id(d2)) == -1) continue;
                fq = (int[])AlgorithmMap.get(charIndex);
                if (fq != null && fq.length == 2) {
                    fq[1] = fq[1] + 1;
                    continue;
                }
                fq = new int[]{0, 1};
                AlgorithmMap.put(Integer.valueOf(charIndex), fq);
            }
            Iterator iterator = AlgorithmMap.keySet().iterator();
            double sqdoc1 = 0.0;
            double sqdoc2 = 0.0;
            double denominator = 0.0;
            while (iterator.hasNext()) {
                int[] c = (int[])AlgorithmMap.get(iterator.next());
                denominator += (double)(c[0] * c[1]);
                sqdoc1 += (double)(c[0] * c[0]);
                sqdoc2 += (double)(c[1] * c[1]);
            }
            return denominator / Math.sqrt(sqdoc1 * sqdoc2);
        }
        throw new NullPointerException(" the Document is null or have not cahrs!!");
    }

    public static boolean isHanZi(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fa5';
    }

    public static short getGB2312Id(char ch) {
        try {
            byte[] buffer = Character.toString(ch).getBytes("GB2312");
            if (buffer.length != 2) {
                return -1;
            }
            int b0 = (buffer[0] & 0xFF) - 161;
            int b1 = (buffer[1] & 0xFF) - 161;
            return (short)(b0 * 94 + b1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

