/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.Date;
import org.anyline.util.DateUtil;

public class DateBuilder {
    private Date date = new Date();

    public DateBuilder(Date date) {
        this.date = date;
    }

    public DateBuilder(String date) {
        try {
            this.date = DateUtil.parse(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DateBuilder(String date, String format) {
        try {
            this.date = DateUtil.parse(date, format);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DateBuilder() {
    }

    public static DateBuilder init() {
        return new DateBuilder();
    }

    public static DateBuilder init(String date) {
        return new DateBuilder(date);
    }

    public static DateBuilder init(String date, String format) {
        return new DateBuilder(date, format);
    }

    public static DateBuilder init(Date date) {
        return new DateBuilder(date);
    }

    public Date getDate() {
        return this.date;
    }

    public Date date() {
        return this.date;
    }

    public DateBuilder addYear(int qty) {
        this.date = DateUtil.addYear(this.date, qty);
        return this;
    }

    public DateBuilder addMonth(int qty) {
        this.date = DateUtil.addMonth(this.date, qty);
        return this;
    }

    public DateBuilder addDay(int qty) {
        this.date = DateUtil.addDay(this.date, qty);
        return this;
    }

    public DateBuilder addHour(int qty) {
        this.date = DateUtil.addHour(this.date, qty);
        return this;
    }

    public DateBuilder addMinute(int qty) {
        this.date = DateUtil.addMinute(this.date, qty);
        return this;
    }

    public DateBuilder addSecond(int qty) {
        this.date = DateUtil.addSecond(this.date, qty);
        return this;
    }

    public boolean before(String date) throws Exception {
        return this.before(DateUtil.parse(date));
    }

    public boolean before(Date date) {
        return this.date.getTime() < date.getTime();
    }

    public boolean before() {
        return this.date.getTime() < new Date().getTime();
    }

    public boolean after(Date date) {
        return this.date.getTime() > date.getTime();
    }

    public boolean after() {
        return this.date.getTime() > new Date().getTime();
    }

    public boolean equal(Date date) {
        return this.date.getTime() == date.getTime();
    }

    public boolean between(Date min, Date max) {
        Long time = this.date.getTime();
        return time > min.getTime() && time < max.getTime();
    }

    public boolean between(String min, String max) throws Exception {
        return this.between(DateUtil.parse(min), DateUtil.parse(max));
    }

    public boolean expire() {
        return this.before();
    }

    public String format(String format) {
        return DateUtil.format(this.date, format);
    }

    public String format() {
        return this.format("yyyy-MM-dd HH:mm:ss");
    }

    public String week() {
        return DateUtil.getWeek(this.date);
    }

    public int year() {
        return DateUtil.year(this.date);
    }

    public int month() {
        return DateUtil.month(this.date);
    }

    public DateBuilder firstDayOfWeek() {
        this.date = DateUtil.getFirstDayOfWeek(this.date);
        return this;
    }

    public DateBuilder firstDayOfNextWeek() {
        this.date = DateUtil.getFirstDayOfNextWeek(this.date);
        return this;
    }

    public DateBuilder firstDayOfPreviousWeek() {
        this.date = DateUtil.getFirstDayOfPreviousWeek(this.date);
        return this;
    }

    public DateBuilder lastDayOfWeek() {
        this.date = DateUtil.getLastDayOfWeek(this.date);
        return this;
    }

    public DateBuilder lastDayOfNextWeek() {
        this.date = DateUtil.getLastDayOfNextWeek(this.date);
        return this;
    }

    public DateBuilder lastDayOfPreviousWeek() {
        this.date = DateUtil.getLastDayOfPreviousWeek(this.date);
        return this;
    }

    public DateBuilder firstDayOfMonth() {
        this.date = DateUtil.getFirstDayOfMonth(this.date);
        return this;
    }

    public DateBuilder firstDayOfNextMonth() {
        this.date = DateUtil.getFirstDayOfNextMonth(this.date);
        return this;
    }

    public DateBuilder firstDayOfPreviousMonth() {
        this.date = DateUtil.getFirstDayOfPreviousMonth(this.date);
        return this;
    }

    public DateBuilder lastDayOfMonth() {
        this.date = DateUtil.getLastDayOfMonth(this.date);
        return this;
    }

    public DateBuilder lastDayOfPreviousMonth() {
        this.date = DateUtil.getLastDayOfPreviousMonth(this.date);
        return this;
    }

    public DateBuilder lastDayOfNextMonth() {
        this.date = DateUtil.getLastDayOfNextMonth(this.date);
        return this;
    }

    public DateBuilder currentWeekday() {
        this.date = DateUtil.getCurrentWeekday(this.date);
        return this;
    }

    public DateBuilder mondayOFWeek() {
        this.date = DateUtil.getMondayOFWeek(this.date);
        return this;
    }

    public DateBuilder nextMonday() {
        this.date = DateUtil.getNextMonday(this.date);
        return this;
    }

    public DateBuilder nextSunday() {
        this.date = DateUtil.getNextSunday(this.date);
        return this;
    }

    public DateBuilder nextYearEnd() {
        this.date = DateUtil.getNextYearEnd(this.date);
        return this;
    }

    public DateBuilder nextYearFirst() {
        this.date = DateUtil.getNextYearFirst(this.date);
        return this;
    }
}

