/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.bean.init;

import java.util.LinkedHashMap;
import org.anyline.bean.BeanDefine;
import org.anyline.bean.init.DefaultValueReference;

public class DefaultBeanDefine
implements BeanDefine {
    private String typeName;
    private Class type;
    private boolean lazy = true;
    private boolean primary = false;
    private LinkedHashMap<String, Object> values = new LinkedHashMap();

    public DefaultBeanDefine() {
    }

    public DefaultBeanDefine(Class type) {
        this.type = type;
    }

    public DefaultBeanDefine(String type) {
        this.typeName = type;
    }

    public DefaultBeanDefine(Class type, boolean lazy) {
        this.type = type;
        this.lazy = lazy;
    }

    public DefaultBeanDefine(String type, boolean lazy) {
        this.typeName = type.trim();
        this.lazy = lazy;
    }

    @Override
    public String getTypeName() {
        if (null == this.typeName && null != this.type) {
            this.typeName = this.type.getName();
        }
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName.trim();
    }

    @Override
    public Class getType() {
        if (null == this.type && null != this.typeName) {
            try {
                this.type = Class.forName(this.typeName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.type;
    }

    @Override
    public BeanDefine setType(Class type) {
        this.type = type;
        return this;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public BeanDefine setPrimary(boolean primary) {
        this.primary = primary;
        return this;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public BeanDefine setLazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    @Override
    public LinkedHashMap<String, Object> getValues() {
        return this.values;
    }

    @Override
    public BeanDefine setValues(LinkedHashMap<String, Object> values) {
        this.values = values;
        return this;
    }

    @Override
    public BeanDefine addValue(String name, Object value) {
        this.values.put(name, value);
        return this;
    }

    @Override
    public BeanDefine addReferenceValue(String name, String value) {
        this.values.put(name, new DefaultValueReference(value));
        return this;
    }
}

