/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.encrypt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA1Util {
    private static final Logger log = LoggerFactory.getLogger(SHA1Util.class);
    private static MessageDigest digest = null;

    public static String sign(String src) {
        String result = "";
        try {
            if (null == digest) {
                digest = MessageDigest.getInstance("SHA-1");
            }
            digest.update(src.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            result = hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.debug("[SHA1 SIGN][src:{}][sign:{}]", (Object)src, (Object)result);
        }
        return result;
    }
}

