/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgUtil {
    private static final Logger log = LoggerFactory.getLogger(ImgUtil.class);

    public static void scale(File src, File tar, float scale) {
        try {
            BufferedImage img = ImageIO.read(src);
            int width = img.getWidth();
            int height = img.getHeight();
            width = (int)((float)width * scale);
            height = (int)((float)height * scale);
            Image image = img.getScaledInstance(width, height, 1);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            File dir = tar.getParentFile();
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            ImageIO.write((RenderedImage)tag, "JPEG", tar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scale(File src, File tar, String format, int width, int height, boolean fill) {
        long fr = System.currentTimeMillis();
        try {
            File dir;
            double ratio = 0.0;
            BufferedImage bi = ImageIO.read(src);
            Image itemp = bi.getScaledInstance(width, height, 4);
            ratio = bi.getHeight() > bi.getWidth() ? Integer.valueOf(height).doubleValue() / (double)bi.getHeight() : Integer.valueOf(width).doubleValue() / (double)bi.getWidth();
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
            itemp = op.filter(bi, null);
            if (fill) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            if (null != (dir = tar.getParentFile()) && !dir.exists()) {
                dir.mkdirs();
            }
            ImageIO.write((RenderedImage)((BufferedImage)itemp), format, tar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("[\u538b\u7f29\u56fe\u7247][\u8017\u65f6:{}][source:{}][target:{}]", new Object[]{System.currentTimeMillis() - fr, src, tar});
    }

    public static void scale(File src, File tar, String format, int width, int height) {
        ImgUtil.scale(src, tar, format, width, height, false);
    }

    public static void scale(File src, File tar, int width, int height, boolean fill) {
        ImgUtil.scale(src, tar, "jpeg", width, height, fill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cut(File src, File tar, int x, int y, int w, int h) {
        ImageReader reader = null;
        ImageInputStream iis = null;
        try {
            String format = "JPEG";
            if (src.getName().toLowerCase().endsWith("png")) {
                format = "PNG";
            }
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(format);
            reader = iterator.next();
            iis = ImageIO.createImageInputStream(src);
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rectangle = new Rectangle(x, y, w, h);
            param.setSourceRegion(rectangle);
            BufferedImage bi = reader.read(0, param);
            format = "JPEG";
            if (tar.getName().toLowerCase().endsWith("png")) {
                format = "PNG";
            }
            ImageIO.write((RenderedImage)bi, format, tar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                iis.close();
                reader.dispose();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void cut(File src, File dir, int rows, int cols) {
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageIO.read(src);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int destWidth = srcWidth;
                int destHeight = srcHeight;
                destWidth = srcWidth % cols == 0 ? srcWidth / cols : (int)Math.floor(srcWidth / cols) + 1;
                destHeight = srcHeight % rows == 0 ? srcHeight / rows : (int)Math.floor(srcWidth / rows) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        if (null != dir && !dir.exists()) {
                            dir.mkdirs();
                        }
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(dir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static float getSizeScale(File file) {
        float scale = 0.0f;
        try {
            BufferedImage bi = ImageIO.read(file);
            float w = bi.getHeight();
            float h = bi.getWidth();
            scale = w / h;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return scale;
    }

    public static final void cut3(File src, File dir, int width, int height) {
        try {
            if (width <= 0) {
                width = 200;
            }
            if (height <= 0) {
                height = 150;
            }
            BufferedImage bi = ImageIO.read(src);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > width && srcHeight > height) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int cols = 0;
                int rows = 0;
                cols = srcWidth % width == 0 ? srcWidth / width : (int)Math.floor(srcWidth / width) + 1;
                rows = srcHeight % height == 0 ? srcHeight / height : (int)Math.floor(srcHeight / height) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * width, i * height, width, height);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(width, height, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        if (null != dir && !dir.exists()) {
                            dir.mkdirs();
                        }
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(dir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void convert(File src, String format, String dest) {
        try {
            src.canRead();
            src.canWrite();
            BufferedImage img = ImageIO.read(src);
            ImageIO.write((RenderedImage)img, format, new File(dest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void gray(File src, File tar) {
        try {
            BufferedImage img = ImageIO.read(src);
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(cs, null);
            img = op.filter(img, null);
            ImageIO.write((RenderedImage)img, "JPEG", tar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String base64Img(File img) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(img);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new String(Base64.getEncoder().encode(data));
    }

    public static String base64(File img) {
        return ImgUtil.base64Img(img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String base64Img(URL url) {
        byte[] data = null;
        HttpURLConnection conn = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = null;
        try {
            int c;
            conn = (HttpURLConnection)url.openConnection();
            is = conn.getInputStream();
            bis = new BufferedInputStream(is);
            baos = new ByteArrayOutputStream();
            int BUFFER_SIZE = 81920;
            int EOF = -1;
            byte[] buf = new byte[81920];
            while ((c = bis.read(buf)) != -1) {
                baos.write(buf, 0, c);
            }
            data = baos.toByteArray();
            baos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.disconnect();
                is.close();
                bis.close();
                baos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Base64.getEncoder().encodeToString(data);
    }

    public static String base64(URL url) {
        return ImgUtil.base64Img(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean base64Img(File file, String str) {
        if (null == str || null == file) {
            return false;
        }
        File dir = file.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
        str = str.replace("data:image/jpeg;base64, ", "").replace("data:image/png;base64, ", "");
        OutputStream out = null;
        try {
            boolean i;
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] b = decoder.decode(str);
            for (i = false; i < b.length; i += 1) {
                if (b[i] >= 0) continue;
                boolean bl = i;
                b[bl] = (byte)(b[bl] + 256);
            }
            out = new FileOutputStream(file);
            out.write(b);
            out.flush();
            out.close();
            i = true;
            return i;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean base64(File file, String str) {
        return ImgUtil.base64Img(file, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] size(File img) {
        int width = -1;
        int height = -1;
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(img);
            width = bi.getWidth();
            height = bi.getHeight();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bi.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int[] result = new int[]{width, height};
        return result;
    }

    public static int width(File img) {
        return ImgUtil.size(img)[0];
    }

    public static int height(File img) {
        return ImgUtil.size(img)[1];
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IMAGE_TYPE {
        GIF{

            @Override
            public String getName() {
                return "\u56fe\u5f62\u4ea4\u6362\u683c\u5f0f";
            }

            @Override
            public String getCode() {
                return "gif";
            }
        }
        ,
        JPG{

            @Override
            public String getName() {
                return "\u8054\u5408\u7167\u7247\u4e13\u5bb6\u7ec4";
            }

            @Override
            public String getCode() {
                return "jpg";
            }
        }
        ,
        JPEG{

            @Override
            public String getName() {
                return "\u8054\u5408\u7167\u7247\u4e13\u5bb6\u7ec4";
            }

            @Override
            public String getCode() {
                return "jpeg";
            }
        }
        ,
        BMP{

            @Override
            public String getName() {
                return "\u4f4d\u56fe, Windows\u64cd\u4f5c\u7cfb\u7edf\u4e2d\u7684\u6807\u51c6\u56fe\u50cf\u6587\u4ef6\u683c\u5f0f";
            }

            @Override
            public String getCode() {
                return "bmp";
            }
        }
        ,
        PNG{

            @Override
            public String getName() {
                return "\u53ef\u79fb\u690d\u7f51\u7edc\u56fe\u5f62";
            }

            @Override
            public String getCode() {
                return "png";
            }
        }
        ,
        PSD{

            @Override
            public String getName() {
                return "Photoshop\u7684\u4e13\u7528\u683c\u5f0fPhotoshop";
            }

            @Override
            public String getCode() {
                return "psd";
            }
        };


        public abstract String getName();

        public abstract String getCode();
    }
}

