/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.adapter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.KeyAdapter;
import org.anyline.adapter.PersistenceAdapter;
import org.anyline.entity.DataRow;
import org.anyline.entity.generator.GeneratorConfig;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.metadata.persistence.ManyToMany;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.CharUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

public interface EntityAdapter {
    public static void sort(List<? extends EntityAdapter> interceptors) {
        Collections.sort(interceptors, new Comparator<EntityAdapter>(){

            @Override
            public int compare(EntityAdapter r1, EntityAdapter r2) {
                int ordre2;
                int order1 = r1.order();
                if (order1 > (ordre2 = r2.order())) {
                    return 1;
                }
                if (order1 < ordre2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    default public int order() {
        return 10;
    }

    default public Class type() {
        return Object.class;
    }

    default public List<Class> types() {
        return new ArrayList<Class>();
    }

    default public Table table(Class clazz) {
        String name;
        Table table;
        String key;
        block3: {
            key = clazz.getName();
            table = EntityAdapterProxy.class2table.get(key.toUpperCase());
            if (null != table) {
                return table;
            }
            Class parent = clazz;
            name = null;
            while (BasicUtil.isEmpty((Object)(name = ClassUtil.parseAnnotationFieldValue(parent, "table.name", "table.value", "tableName.name", "tableName.value")))) {
                if (null != (parent = parent.getSuperclass())) continue;
                break block3;
            }
            table = new Table(name);
            EntityAdapterProxy.class2table.put(key.toUpperCase(), table);
            return table;
        }
        if ("Camel_".equalsIgnoreCase(ConfigTable.ENTITY_CLASS_TABLE_MAP)) {
            name = BeanUtil.camel_(clazz.getSimpleName());
            table = new Table(name);
            EntityAdapterProxy.class2table.put(key.toUpperCase(), table);
            return table;
        }
        name = clazz.getSimpleName();
        table = new Table(name);
        EntityAdapterProxy.class2table.put(key.toUpperCase(), table);
        return table;
    }

    default public LinkedHashMap<String, Column> columns(Class clazz) {
        return this.columns(clazz, MODE.DDL);
    }

    default public LinkedHashMap<String, Column> columns(Class clazz, MODE mode) {
        LinkedHashMap<String, Column> columns = null;
        if (MODE.INSERT == mode) {
            columns = EntityAdapterProxy.insert_columns.get(clazz.getName().toUpperCase());
        } else if (MODE.UPDATE == mode) {
            columns = EntityAdapterProxy.update_columns.get(clazz.getName().toUpperCase());
        } else if (MODE.DDL == mode) {
            // empty if block
        }
        if (null == columns) {
            columns = new LinkedHashMap();
            List<Field> fields = ClassUtil.getFields(clazz, false, false);
            List<Field> ignores = ClassUtil.getFieldsByAnnotation(clazz, "Transient", "OneToMany", "ManyToMany");
            fields.removeAll(ignores);
            for (Field field : fields) {
                Column column = this.column(clazz, field, new String[0]);
                if (MODE.INSERT == mode) {
                    String insertable = ClassUtil.parseAnnotationFieldValue(field, "column.insertable");
                    if ("false".equalsIgnoreCase(insertable)) {
                        continue;
                    }
                } else if (MODE.UPDATE == mode) {
                    String updatable = ClassUtil.parseAnnotationFieldValue(field, "column.updatable");
                    if ("false".equalsIgnoreCase(updatable)) {
                        continue;
                    }
                } else if (MODE.DDL == mode) {
                    // empty if block
                }
                if (!BasicUtil.isNotEmpty(column)) continue;
                columns.put(column.getName().toUpperCase(), column);
            }
            if (MODE.INSERT == mode) {
                EntityAdapterProxy.insert_columns.put(clazz.getName().toUpperCase(), columns);
            } else if (MODE.UPDATE == mode) {
                EntityAdapterProxy.update_columns.put(clazz.getName().toUpperCase(), columns);
            } else if (MODE.DDL == mode) {
                EntityAdapterProxy.ddl_columns.put(clazz.getName().toUpperCase(), columns);
            }
        }
        LinkedHashMap<String, Column> list = new LinkedHashMap<String, Column>();
        list.putAll(columns);
        return list;
    }

    default public Column column(Class clazz, Field field, String ... annotations) {
        Class<?> c;
        String key = clazz.getName() + ":" + field.getName().toUpperCase();
        Column column = EntityAdapterProxy.field2column.get(key.toUpperCase());
        if (null != column) {
            return column;
        }
        String name = null;
        if (null == annotations || annotations.length == 0) {
            annotations = BasicUtil.isNotEmpty(ConfigTable.ENTITY_COLUMN_ANNOTATION) ? ConfigTable.ENTITY_COLUMN_ANNOTATION.split(",") : "column.name, column.value, TableField.name, TableField.value, tableId.name, tableId.value, Id.name, Id.value".split(",");
        }
        if (BasicUtil.isEmpty((Object)(name = ClassUtil.parseAnnotationFieldValue(field, annotations))) && "camel_".equals(ConfigTable.ENTITY_FIELD_COLUMN_MAP)) {
            name = BeanUtil.camel_(field.getName());
        }
        if (BasicUtil.isEmpty((Object)name) && ((c = field.getType()) == String.class || c == Date.class || ClassUtil.isPrimitiveClass(c))) {
            name = field.getName();
        }
        if (BasicUtil.isNotEmpty(name)) {
            column = new Column(name);
            EntityAdapterProxy.field2column.put(key.toUpperCase(), column);
            EntityAdapterProxy.column2field.put(clazz.getName().toUpperCase() + ":" + name.toUpperCase(), field);
            String type = ClassUtil.parseAnnotationFieldValue(field, "column.columnDefinition");
            if (BasicUtil.isNotEmpty(type)) {
                if (type.contains("[]")) {
                    type = type.replace("[]", "");
                    column.setArray(true);
                }
                column.setType(type);
            }
            return column;
        }
        return null;
    }

    default public Field field(Class clazz, Column column) {
        return this.field(clazz, column.getName());
    }

    default public Field field(Class clazz, String column) {
        Field field = EntityAdapterProxy.column2field.get(clazz.getName().toUpperCase() + ":" + column.toUpperCase());
        if (null == field) {
            this.fields(clazz);
            field = EntityAdapterProxy.column2field.get(clazz.getName().toUpperCase() + ":" + column.toUpperCase());
        }
        if (null == field || field.getDeclaringClass() != clazz) {
            List<Field> fields = ClassUtil.getFields(clazz, false, false);
            for (Field f : fields) {
                if (!f.getName().equalsIgnoreCase(column) || f.getDeclaringClass() != clazz) continue;
                field = f;
                EntityAdapterProxy.column2field.put(clazz.getName().toUpperCase() + ":" + column.toUpperCase(), field);
                break;
            }
        }
        return field;
    }

    default public void fields(Class clazz) {
        List<Field> fields = ClassUtil.getFields(clazz, false, false);
        for (Field field : fields) {
            this.column(clazz, field, new String[0]);
        }
    }

    default public Column primaryKey(Class clazz) {
        LinkedHashMap<String, Column> list = this.primaryKeys(clazz);
        Iterator<Column> iterator = list.values().iterator();
        if (iterator.hasNext()) {
            Column column = iterator.next();
            return column;
        }
        return new Column(DataRow.DEFAULT_PRIMARY_KEY);
    }

    default public PrimaryGenerator generator(String table, Field field) {
        PrimaryGenerator.GENERATOR generator = null;
        if (null == GeneratorConfig.get(table = table.toUpperCase())) {
            Object generatorName = ClassUtil.parseAnnotationFieldValue(field, "GeneratedValue", "generator");
            if (null != generatorName) {
                String name = generatorName.toString();
                for (PrimaryGenerator.GENERATOR item : PrimaryGenerator.GENERATOR.values()) {
                    if (!item.name().equalsIgnoreCase(name)) continue;
                    generator = item;
                    break;
                }
            }
            if (null == generator) {
                generator = PrimaryGenerator.GENERATOR.AUTO;
            }
            GeneratorConfig.put(table, generator);
        }
        return generator;
    }

    default public PrimaryGenerator generator(Class clazz, Field field) {
        String table = this.table(clazz).getName().toUpperCase();
        return this.generator(table, field);
    }

    default public void generator(Class clazz) {
        List<Field> fields = ClassUtil.getFieldsByAnnotation(clazz, "GeneratedValue");
        for (Field field : fields) {
            String table = null;
            try {
                ManyToMany manyToMany = PersistenceAdapter.manyToMany(field);
                if (null != manyToMany) {
                    table = manyToMany.joinTable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == table) {
                table = this.table(clazz).getName();
            }
            this.generator(table, field);
        }
    }

    default public LinkedHashMap<String, Column> primaryKeys(Class clazz) {
        LinkedHashMap<String, Column> list = EntityAdapterProxy.primarys.get(clazz.getName().toUpperCase());
        if (null == list) {
            Column column;
            Field field;
            list = new LinkedHashMap();
            String annotations = ConfigTable.ENTITY_PRIMARY_KEY_ANNOTATION;
            if (BasicUtil.isEmpty((Object)annotations)) {
                annotations = "tableId, Id";
            }
            List<Field> fields = ClassUtil.getFieldsByAnnotation(clazz, annotations.split(","));
            for (Field field2 : fields) {
                Column column2 = this.column(clazz, field2, annotations.split(","));
                if (null == column2) continue;
                list.put(column2.getName().toUpperCase(), column2);
            }
            if (list.isEmpty() && null != (field = ClassUtil.getField(fields = ClassUtil.getFields(clazz, false, false), DataRow.DEFAULT_PRIMARY_KEY, true, true)) && null != (column = this.column(clazz, field, annotations.split(",")))) {
                list.put(column.getName().toUpperCase(), column);
            }
            if (list.size() == 0) {
                list.put(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase(), new Column(DataRow.DEFAULT_PRIMARY_KEY));
            }
            EntityAdapterProxy.primarys.put(clazz.getName().toUpperCase(), list);
        }
        this.generator(clazz);
        return list;
    }

    default public Map<String, Object> primaryValue(Object obj) {
        Column primary = this.primaryKey(obj.getClass());
        Field field = EntityAdapterProxy.column2field.get(obj.getClass().getName().toUpperCase() + ":" + primary.getName().toUpperCase());
        Object value = BeanUtil.getFieldValue(obj, field);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(primary.getName().toUpperCase(), value);
        return map;
    }

    default public boolean createPrimaryValue(Object obj, List<String> inserts) {
        return false;
    }

    default public boolean createPrimaryValue(Object obj, LinkedHashMap<String, Column> inserts) {
        return false;
    }

    default public Map<String, Object> primaryValues(Object obj) {
        LinkedHashMap<String, Column> primarys = this.primaryKeys(obj.getClass());
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String primary : primarys.keySet()) {
            Field field = EntityAdapterProxy.column2field.get(obj.getClass().getName().toUpperCase() + ":" + primary.toUpperCase());
            Object value = BeanUtil.getFieldValue(obj, field);
            map.put(primary.toUpperCase(), value);
        }
        return map;
    }

    default public <T> T entity(Class<T> clazz, Map<String, Object> map, Map columns) {
        return this.entity(null, clazz, map, columns);
    }

    default public <T> T entity(T entity, Class<T> clazz, Map<String, Object> map, Map metadatas) {
        List<Field> fields = ClassUtil.getFields(clazz, false, false);
        HashMap fk = new HashMap();
        if (null == entity) {
            try {
                entity = clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DataRow row = null;
        if (map instanceof DataRow) {
            row = (DataRow)map;
        }
        for (Field field : fields) {
            Object value = null;
            String columnName = field.getName();
            if (null != row) {
                value = row.get(columnName);
            } else {
                value = map.get(columnName);
                if (null == value) {
                    value = map.get(columnName.toUpperCase());
                }
            }
            if (null == value) {
                Column column = this.column(clazz, field, new String[0]);
                columnName = column.getName();
                if (null != row) {
                    value = row.get(columnName);
                } else {
                    value = map.get(columnName);
                    if (null == value) {
                        value = map.get(columnName.toUpperCase());
                    }
                }
            }
            if (null == value) continue;
            Column metadata = null;
            if (map instanceof DataRow) {
                metadata = ((DataRow)map).getMetadata(columnName);
            }
            if (null == metadata && null != metadatas) {
                metadata = (Column)metadatas.get(columnName.toUpperCase());
            }
            BeanUtil.setFieldValue(entity, field, metadata, value);
        }
        return entity;
    }

    default public DataRow row(Object obj, String ... keys) {
        return this.row(null, obj, keys);
    }

    default public DataRow row(DataRow row, Object obj, String ... keys) {
        return DataRow.parse(row, KeyAdapter.KEY_CASE.CONFIG, obj, keys);
    }

    default public List<String> column2param(List<String> metadatas) {
        ArrayList<String> params = new ArrayList<String>();
        for (String metadata : metadatas) {
            params.add(this.column2param(metadata));
        }
        return params;
    }

    default public String column2param(String metadata) {
        String param = null;
        String keyCase = ConfigTable.HTTP_PARAM_KEY_CASE;
        if ("camel".equals(keyCase)) {
            param = metadata + ":" + BeanUtil.camel(metadata.toLowerCase());
        } else if ("Camel".equals(keyCase)) {
            String key = CharUtil.toUpperCaseHeader(metadata.toLowerCase());
            param = metadata + ":" + BeanUtil.Camel(key);
        } else {
            param = "lower".equalsIgnoreCase(keyCase) ? metadata + ":" + metadata.toLowerCase() : ("upper".equalsIgnoreCase(keyCase) ? metadata + ":" + metadata.toUpperCase() : metadata + ":" + metadata);
        }
        return param;
    }

    public static Object getPrimaryValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryValue();
        }
        if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            return EntityAdapterProxy.primaryValue(obj);
        }
        return BeanUtil.getFieldValue(obj, ConfigTable.DEFAULT_PRIMARY_KEY);
    }

    public static void setPrimaryValue(Object obj, Object value) {
        if (null == obj) {
            return;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            row.setPrimaryValue(value);
        } else {
            Column key = EntityAdapterProxy.primaryKey(obj.getClass());
            Field field = EntityAdapterProxy.field(obj.getClass(), key);
            BeanUtil.setFieldValue(obj, field, value);
        }
    }

    public static enum MODE {
        INSERT,
        UPDATE,
        DDL;

    }
}

