/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.encrypt;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.NumberUtil;
import org.anyline.util.XssUtil;
import org.anyline.util.encrypt.DESKey;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DESUtil {
    private static final Logger log = LoggerFactory.getLogger(DESUtil.class);
    public static final String DEFAULT_SECRET_KEY = "L~@L$^N*)E+";
    public static final String DEFAULT_SALT = "!@)A(#$N%^&Y*(";
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;
    private String salt = "!@)A(#$N%^&Y*(";
    private static Map<String, DESUtil> instances = new Hashtable<String, DESUtil>();
    private static Map<String, DESKey> deskeys = null;
    private static DESKey defaultDesKey = null;
    private static final int MAX_DES_VERSION_INDEX = 12;
    private static final int DES_VERSION_LENGTH = 3;
    private static final String ENCRYPT_TYPE_PARAM = "param";
    private static final String ENCRYPT_TYPE_KEY = "name";
    private static final String ENCRYPT_TYPE_VALUE = "value";
    public static List<String> ignores = new ArrayList<String>();

    public static DESUtil getInstance() {
        DESUtil instance = instances.get(DEFAULT_SECRET_KEY);
        try {
            instance = new DESUtil();
            instances.put(DEFAULT_SECRET_KEY, instance);
        }
        catch (Exception e) {
            log.warn("[des insance][result:fail][msg:{}]", (Object)e.toString());
        }
        return instance;
    }

    public static DESUtil getInstance(String key) {
        DESUtil instance;
        if (null == key || key.trim().equals("")) {
            key = DEFAULT_SECRET_KEY;
        }
        if (null == (instance = instances.get(key))) {
            try {
                instance = new DESUtil(key);
                instances.put(key, instance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    protected DESUtil() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        this(DEFAULT_SECRET_KEY);
    }

    protected DESUtil(String key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Security.getProvider("SunJCE");
        Key _key = this.getKey(key.getBytes());
        this.encryptCipher = Cipher.getInstance("DES");
        this.encryptCipher.init(1, _key);
        this.decryptCipher = Cipher.getInstance("DES");
        this.decryptCipher.init(2, _key);
    }

    private byte[] encrypt(byte[] bytes) throws BadPaddingException, IllegalBlockSizeException {
        return this.encryptCipher.doFinal(bytes);
    }

    public String encrypt(String str) throws BadPaddingException, IllegalBlockSizeException {
        if (null == str || ignores.contains(str)) {
            return str;
        }
        str = this.salt + (String)str;
        return NumberUtil.byte2hex(this.encrypt(((String)str).getBytes()));
    }

    private byte[] decrypt(byte[] bytes) throws BadPaddingException, IllegalBlockSizeException {
        return this.decryptCipher.doFinal(bytes);
    }

    private Key getKey(byte[] bytes) {
        byte[] arrB = new byte[8];
        for (int i = 0; i < bytes.length && i < arrB.length; ++i) {
            arrB[i] = bytes[i];
        }
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }

    public String decrypt(String str) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (null == str || ignores.contains(str)) {
            return str;
        }
        String result = "";
        result = new String(this.decrypt(NumberUtil.hex2bytes(str)), ConfigTable.getString("DES_ENCODE", "UTF-8"));
        result = result.substring(this.salt.length());
        return result;
    }

    public static void encrypt(Collection<?> list, String ... keys) throws BadPaddingException, IllegalBlockSizeException {
        if (null == keys || null == list) {
            return;
        }
        for (Object obj : list) {
            DESUtil.encrypt(obj, keys);
        }
    }

    public static void encrypt(Object obj, String ... keys) throws BadPaddingException, IllegalBlockSizeException {
        if (null == keys || null == obj) {
            return;
        }
        for (String key : keys) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                Object value = map.get(key);
                if (null == value) continue;
                map.put(key, DESUtil.getInstance().encrypt(value.toString()));
                continue;
            }
            Object value = BeanUtil.getFieldValue(obj, key);
            if (null == value) continue;
            value = DESUtil.getInstance().encrypt(value.toString());
            BeanUtil.setFieldValue(obj, key, value);
        }
    }

    public static String filterIllegalChar(String src) {
        if (null == src) {
            return src;
        }
        src = XssUtil.strip(src);
        return src;
    }

    public static String encryptParam(String param) {
        if (null == param || param.trim().isEmpty()) {
            return "";
        }
        return DESUtil.encryptByType(param, ENCRYPT_TYPE_PARAM);
    }

    public static String decryptParam(String param) {
        if (null == param) {
            return null;
        }
        return DESUtil.decrypt(param, ENCRYPT_TYPE_PARAM);
    }

    public static String encryptParamKey(String key) {
        if (null == key || key.trim().isEmpty()) {
            return "";
        }
        return DESUtil.encryptKey(key);
    }

    public static String decryptParamKey(String key) {
        if (null == key) {
            return null;
        }
        return DESUtil.decrypt(key, ENCRYPT_TYPE_KEY);
    }

    public static String encryptParamValue(String value) {
        if (null == value || value.trim().isEmpty()) {
            return "";
        }
        return DESUtil.encryptValue(value);
    }

    public static String decryptParamValue(String value) {
        if (null == value) {
            return null;
        }
        return DESUtil.decrypt(value.trim(), ENCRYPT_TYPE_VALUE);
    }

    private static String encryptByType(String src, String type, boolean mix) {
        Object result = null;
        if (null == src || ignores.contains(src)) {
            return src;
        }
        if (DESUtil.isEncrypt(src, type)) {
            return src;
        }
        DESUtil des = DESUtil.getInstance(defaultDesKey.getKey(type));
        try {
            result = des.encrypt(src);
            result = DESUtil.insertDESVersion((String)result);
            Object pre = defaultDesKey.getPrefix(type);
            if (mix && ENCRYPT_TYPE_VALUE.equals(type)) {
                String rand = "v" + BasicUtil.getRandomNumberString(5) + "v";
                pre = rand + (String)pre;
            }
            result = (String)pre + (String)result;
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String encryptByType(String src, String type) {
        return DESUtil.encryptByType(src, type, false);
    }

    public static String encryptKey(String src) {
        if (null == src) {
            return src;
        }
        return DESUtil.encryptByType(src, ENCRYPT_TYPE_KEY);
    }

    public static String encryptValue(String src, boolean mix) {
        if (null == src) {
            return src;
        }
        return DESUtil.encryptByType(src, ENCRYPT_TYPE_VALUE, mix);
    }

    public static String encryptValue(String src) {
        return DESUtil.encryptValue(src, false);
    }

    public static boolean isEncrypt(String src, String type) {
        if (null == src) {
            return false;
        }
        try {
            String value = DESUtil.decrypt(src, type);
            return null != value;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String decrypt(String src, String type) {
        String result;
        block2: {
            DESKey key;
            if (null == src || null == type || ignores.contains(src)) {
                return null;
            }
            result = null;
            result = DESUtil.decrypt(src, defaultDesKey, type);
            if (null != result) break block2;
            Iterator<String> versions = deskeys.keySet().iterator();
            while (versions.hasNext() && null == (result = DESUtil.decrypt(src, key = deskeys.get(versions.next()), type))) {
            }
        }
        return result;
    }

    private static String decrypt(String src, DESKey key, String type) {
        if (ConfigTable.getBoolean("IS_DECRYPT_LOG")) {
            log.warn("[decrypt][start][src:{}][type:{}]", (Object)src, (Object)type);
        }
        String result = src;
        if (null == src || ignores.contains(src)) {
            return null;
        }
        if (ENCRYPT_TYPE_VALUE.equals(type) && RegularUtil.match(result, "v\\d{5}v", Regular.MATCH_MODE.PREFIX)) {
            result = result.substring(7);
            if (ConfigTable.getBoolean("IS_DECRYPT_LOG")) {
                log.warn("[decrypt][\u5220\u9664\u6df7\u6dc6\u7801][result:{}]", (Object)result);
            }
        }
        try {
            DESUtil des;
            String[] tmp;
            String prefix = key.getPrefix(type);
            int sub = -1;
            if (null != prefix) {
                sub = prefix.length();
            }
            if (sub > result.length() || sub == -1) {
                return null;
            }
            if (result.startsWith(prefix)) {
                result = result.substring(sub);
                if (ConfigTable.getBoolean("IS_DECRYPT_LOG")) {
                    log.warn("[decrypt][\u5220\u9664\u524d\u7f00][result:{}]", (Object)result);
                }
            }
            if (null != (tmp = DESUtil.parseDESVersion(result)) && tmp.length == 2 && key.getVersion().equals(tmp[0])) {
                result = tmp[1];
            }
            if (null != (des = DESUtil.getInstance(key.getKey(type)))) {
                try {
                    result = des.decrypt(result);
                }
                catch (Exception e) {
                    result = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (ConfigTable.getBoolean("IS_DECRYPT_LOG")) {
            log.warn("[decrypt][end][result:{}]", (Object)result);
        }
        return result;
    }

    public static String encryptUrl(String url) {
        if (null == url || !((String)url).contains("?")) {
            return url;
        }
        String param = ((String)url).substring(((String)url).indexOf("?") + 1);
        try {
            param = DESUtil.encryptParam(param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        url = ((String)url).substring(0, ((String)url).indexOf("?") + 1) + param;
        return url;
    }

    public static String encryptUrl(String url, boolean union, boolean encryptKey, boolean encryptValue) {
        if (null == url || !((String)url).contains("?")) {
            return url;
        }
        Object param = ((String)url).substring(((String)url).indexOf("?") + 1);
        try {
            if (union) {
                param = DESUtil.encryptParam((String)param);
            } else {
                String[] params = ((String)param).split("&");
                param = "";
                for (String p : params) {
                    String[] kv = p.split("=");
                    if (kv.length != 2) continue;
                    String k = kv[0];
                    if (encryptKey) {
                        k = DESUtil.encryptKey(k);
                    }
                    String v = kv[1];
                    if (encryptValue) {
                        v = DESUtil.encryptValue(v);
                    }
                    if (!"".equals(params)) {
                        param = (String)param + "&";
                    }
                    param = (String)param + k + "=" + v;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        url = ((String)url).substring(0, ((String)url).indexOf("?") + 1) + (String)param;
        return url;
    }

    public static String encryptHtmlTagA(String tag) {
        try {
            String url = RegularUtil.fetchUrl(tag);
            tag = tag.replace(url, DESUtil.encryptUrl(url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tag;
    }

    private static String[] parseDESVersion(String src) {
        String[] result = null;
        if (null != src && src.length() > 3) {
            try {
                result = new String[2];
                String tmp = src.substring(3);
                int idx = DESUtil.getDESVersionIndex(tmp);
                if (idx >= 0) {
                    result[0] = src.substring(idx, idx + 3);
                    result[1] = src.substring(0, idx) + src.substring(idx + 3);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static int getDESVersionIndex(String src) {
        int idx = -1;
        if (null != src && src.length() > 12) {
            String tmp = src.substring(12);
            int len = tmp.length();
            String chr = src.substring(len / 2, len / 2 + 1);
            idx = chr.toCharArray()[0];
            idx = Math.abs(idx % 12);
        }
        return idx;
    }

    private static String insertDESVersion(String src, String version) {
        int idx = DESUtil.getDESVersionIndex(src);
        if (idx >= 0) {
            src = BasicUtil.insert(src, idx, version);
        }
        return src;
    }

    private static String insertDESVersion(String src) {
        return DESUtil.insertDESVersion(src, defaultDesKey.getVersion());
    }

    private static Map<String, Object> encryptKey(Map<String, Object> map, boolean mix, String ... keys) {
        if (null == map) {
            return map;
        }
        List<String> ks = BeanUtil.getMapKeys(map);
        for (String k : ks) {
            Object v = map.get(k);
            if (null == v || v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Date) {
                if (null != keys && keys.length != 0 && !BasicUtil.contains(keys, k)) continue;
                String key = DESUtil.encryptByType(k, ENCRYPT_TYPE_KEY, mix);
                map.remove(k);
                map.put(key, v);
                continue;
            }
            v = DESUtil.encryptKey(v, mix, keys);
        }
        return map;
    }

    private static Collection<Object> encryptKey(Collection<Object> list, boolean mix, String ... keys) {
        if (null == list) {
            return list;
        }
        for (Object obj : list) {
            obj = DESUtil.encryptKey(obj, mix, keys);
        }
        return list;
    }

    public static Collection<Object> encryptKey(Collection<Object> list, String ... keys) {
        return DESUtil.encryptKey(list, false, keys);
    }

    public static Object encryptKey(Object obj, boolean mix, String ... keys) {
        if (null == obj) {
            return obj;
        }
        if (obj instanceof Map) {
            obj = DESUtil.encryptKey((Map)obj, mix, keys);
        } else if (obj instanceof Collection) {
            obj = DESUtil.encryptKey((Collection<Object>)((Collection)obj), mix, keys);
        }
        return obj;
    }

    public static Object encryptKey(Object obj, String ... keys) {
        return DESUtil.encryptKey(obj, false, keys);
    }

    static {
        deskeys = new HashMap<String, DESKey>();
        try {
            Object keyPath;
            String ignoreList = ConfigTable.getString("DES_IGNORE");
            if (null != ignoreList) {
                String[] tmps;
                for (String tmp : tmps = ignoreList.split(",")) {
                    ignores.add(tmp);
                }
            }
            if (BasicUtil.isNotEmpty(keyPath = ConfigTable.getString("DES_KEY_FILE"))) {
                if (((String)keyPath).contains("${classpath}")) {
                    keyPath = ((String)keyPath).replace("${classpath}", ConfigTable.getClassPath());
                } else if (((String)keyPath).startsWith("/")) {
                    keyPath = ConfigTable.getWebRoot() + (String)keyPath;
                }
                File keyFile = new File((String)keyPath);
                if (keyFile.exists()) {
                    SAXReader reader = new SAXReader();
                    Document document = reader.read(keyFile);
                    Element root = document.getRootElement();
                    Iterator itrKey = root.elementIterator();
                    while (itrKey.hasNext()) {
                        Element element = (Element)itrKey.next();
                        DESKey key = new DESKey();
                        String version = element.attributeValue("version");
                        key.setVersion(version);
                        key.setKey(element.elementTextTrim("des-key"));
                        key.setKeyParam(element.elementTextTrim("des-key-param"));
                        key.setKeyParamName(element.elementTextTrim("des-key-param-name"));
                        key.setKeyParamValue(element.elementTextTrim("des-key-param-value"));
                        key.setPrefix(element.elementTextTrim("des-prefix"));
                        key.setPrefixParam(element.elementTextTrim("des-prefix-param"));
                        key.setPrefixParamName(element.elementTextTrim("des-prefix-param-name"));
                        key.setPrefixParamValue(element.elementTextTrim("des-prefix-param-value"));
                        if (null == defaultDesKey) {
                            defaultDesKey = key;
                            continue;
                        }
                        deskeys.put(version, key);
                    }
                }
            }
            if (null == defaultDesKey) {
                defaultDesKey = new DESKey();
                String version = "vic";
                defaultDesKey.setVersion(version);
                defaultDesKey.setKey("5*(YHU*6d9");
                defaultDesKey.setKeyParam("@#$%0(*7#");
                defaultDesKey.setKeyParamName("@#$%#");
                defaultDesKey.setKeyParamValue("@#23$%097#");
                defaultDesKey.setPrefix("");
                defaultDesKey.setPrefixParam("als7n6e9o1r5gv78ac1vice624c623f");
                defaultDesKey.setPrefixParamName("l80j0sa9n2y1l4i7n6e9o1r5gk");
                defaultDesKey.setPrefixParamValue("p298pn6e9o1r5gv");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

