/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.MetadataDiffer;

public class TablesDiffer
implements MetadataDiffer {
    private List<Table> adds = new ArrayList<Table>();
    private List<Table> drops = new ArrayList<Table>();
    private List<Table> updates = new ArrayList<Table>();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static TablesDiffer compare(LinkedHashMap<String, Table> origins, LinkedHashMap<String, Table> dests) {
        TablesDiffer differ = new TablesDiffer();
        ArrayList<Table> adds = new ArrayList<Table>();
        ArrayList<Table> drops = new ArrayList<Table>();
        ArrayList<Table> updates = new ArrayList<Table>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Table<Object> origin = origins.get(key);
            Table<Object> dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public List<Table> getAdds() {
        return this.adds;
    }

    public void setAdds(List<Table> adds) {
        this.adds = adds;
    }

    public List<Table> getDrops() {
        return this.drops;
    }

    public void setDrops(List<Table> drops) {
        this.drops = drops;
    }

    public List<Table> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<Table> updates) {
        this.updates = updates;
    }
}

