/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public abstract class NumberTextUtil {
    private static final Map<Lang, NumberTextUtil> _InstancePool = new EnumMap<Lang, NumberTextUtil>(Lang.class);

    protected NumberTextUtil() {
    }

    public abstract String getText(long var1);

    public abstract String getOrdinalText(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberTextUtil getInstance(Lang lang) {
        if (lang == null) {
            throw new NullPointerException();
        }
        NumberTextUtil result = null;
        Map<Lang, NumberTextUtil> map = _InstancePool;
        synchronized (map) {
            result = _InstancePool.get((Object)lang);
            if (result == null) {
                switch (lang.ordinal()) {
                    case 0: {
                        result = new NumberTextEnglish();
                        break;
                    }
                    case 1: {
                        result = new NumberTextEnglishCleanSpaceOnly();
                        break;
                    }
                    case 2: {
                        result = new NumberTextChinese(NumberTextChinese.Type.Simplified);
                        break;
                    }
                    case 3: {
                        result = new NumberTextChinese(NumberTextChinese.Type.Traditional);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Language not supported yet : " + String.valueOf((Object)lang));
                    }
                }
                _InstancePool.put(lang, result);
            }
        }
        return result;
    }

    private static boolean checkNumber(String number) {
        return number != null && number.matches("[0-9]+");
    }

    public static enum Lang {
        English,
        EnglishWithCleanSpaceOnly,
        ChineseSimplified,
        ChineseTraditional;

    }

    private static class NumberTextEnglish
    extends NumberTextUtil {
        private static final Map<String, String> _Ordinals = new HashMap<String, String>();

        private NumberTextEnglish() {
        }

        @Override
        public String getText(long number) {
            StringBuilder builder = new StringBuilder();
            this.buildText(builder, number);
            return builder.toString();
        }

        @Override
        public String getOrdinalText(long number) {
            StringBuilder builder = new StringBuilder();
            this.buildText(builder, number);
            this.replaceLastTokenWithOrdinal(builder);
            return builder.toString();
        }

        private void buildText(StringBuilder builder, long number) {
            assert (builder != null);
            if (number < 0L) {
                builder.append(this.getConnectDisplay(Connect.Minus)).append(this.getConnectDisplay(Connect.AfterMinus));
                number = -number;
            }
            String numString = Long.toString(number);
            int power = 0;
            while (numString.length() > (power + 1) * 3) {
                ++power;
            }
            while (power > 0) {
                boolean modified = this.extendToken(builder, numString, power * 3);
                if (modified) {
                    builder.append(this.getConnectDisplay(Connect.AfterNumber)).append(this.getPowerDisplay(Power.values()[power - 1]));
                }
                --power;
            }
            this.extendToken(builder, Long.toString(number), 0);
        }

        private boolean extendToken(StringBuilder builder, String number, int suffix) {
            assert (builder != null && NumberTextUtil.checkNumber(number) && suffix < number.length());
            int len = number.length() - suffix;
            int hundreds = len > 2 ? number.charAt(len - 3) - 48 : -1;
            int tens = len > 1 ? number.charAt(len - 2) - 48 : -1;
            int inds = number.charAt(len - 1) - 48;
            if (hundreds <= 0 && tens <= 0 && inds <= 0 && suffix > 0) {
                return false;
            }
            if (len > 3) {
                builder.append(this.getConnectDisplay(Connect.AfterPower));
            }
            if (hundreds == 0) {
                if (len > 3 && (tens > 0 || inds > 0)) {
                    builder.append(this.getConnectDisplay(Connect.And)).append(this.getConnectDisplay(Connect.AfterAnd));
                }
            } else if (hundreds > 0) {
                builder.append(this.getDigitName(Digit.values()[hundreds])).append(this.getConnectDisplay(Connect.AfterNumber)).append(this.getConnectDisplay(Connect.Hundred));
                if (tens > 0 || inds > 0) {
                    builder.append(this.getConnectDisplay(Connect.AfterHundred)).append(this.getConnectDisplay(Connect.And)).append(this.getConnectDisplay(Connect.AfterAnd));
                }
            }
            if (tens > 1) {
                builder.append(this.getDigitMultiTen(Digit.values()[tens]));
                if (inds > 0) {
                    builder.append(this.getConnectDisplay(Connect.AfterTen));
                }
            }
            if (tens == 1) {
                builder.append(this.getDigitPlusTen(Digit.values()[inds]));
            } else if (inds > 0 || number.length() == 1) {
                builder.append(this.getDigitName(Digit.values()[inds]));
            }
            return true;
        }

        private void replaceLastTokenWithOrdinal(StringBuilder builder) {
            int suffix;
            assert (builder != null && builder.length() > 0);
            for (suffix = builder.length() - 1; suffix >= 0 && !this.isConnect(builder.charAt(suffix)); --suffix) {
            }
            String lastToken = builder.substring(suffix + 1);
            builder.delete(suffix + 1, builder.length()).append(this.toOrdinal(lastToken));
        }

        String getPowerDisplay(Power power) {
            assert (power != null);
            return power.display;
        }

        String getConnectDisplay(Connect connect) {
            assert (connect != null);
            return connect.display;
        }

        String getDigitName(Digit digit) {
            assert (digit != null);
            return digit.display;
        }

        String toOrdinal(String name) {
            assert (name != null && !name.isEmpty());
            Object result = _Ordinals.get(name);
            if (result == null) {
                result = name.charAt(name.length() - 1) == 'y' ? name.substring(0, name.length() - 1) + "ieth" : name + "th";
            }
            return result;
        }

        String getDigitPlusTen(Digit digit) {
            assert (digit != null);
            return digit.plusTen;
        }

        String getDigitMultiTen(Digit digit) {
            assert (digit != null);
            return digit.multiTen;
        }

        boolean isConnect(char c) {
            return Connect.isConnect(c);
        }

        static {
            for (Digit d : Digit.values()) {
                _Ordinals.put(d.display, d.displayOrdinal);
            }
        }

        static enum Connect {
            Minus("minus"),
            Hundred("hundred"),
            And("and"),
            AfterMinus(" "),
            AfterNumber(" "),
            AfterPower(" "),
            AfterHundred(" "),
            AfterAnd(" "),
            AfterTen("-");

            final String display;

            private Connect(String display) {
                this.display = display;
            }

            private static boolean isConnect(char c) {
                return c == ' ' || c == '-';
            }
        }

        static enum Power {
            Thousand("thousand"),
            Million("million"),
            Billion("billion"),
            Trillion("trillion"),
            Quadrillion("quadrillion"),
            Quintillion("quintillion"),
            Sextillion("sextillion"),
            Septillion("septillion"),
            Octillion("octillion"),
            Nonillion("nonillion"),
            Decillion("decillion"),
            Undecillion("undecillion"),
            Duodecillion("duodecillion"),
            Tredecillion("tredecillion"),
            Quattuordecillion("quattuordecillion"),
            Quindecillion("quindecillion"),
            Sexdecillion("sexdecillion"),
            Septendecillion("septendecillion"),
            Octodecillion("octodecillion"),
            Novemdecillion("novemdecillion"),
            Vigintillion("vigintillion");

            final String display;

            private Power(String display) {
                this.display = display;
            }
        }

        static enum Digit {
            Zero("zero", "zeroth", "ten", ""),
            One("one", "first", "eleven", "ten"),
            Two("two", "second", "twelve", "twenty"),
            Three("three", "third", "thirteen", "thirty"),
            Four("four", "fourth", "fourteen", "fourty"),
            Five("five", "fifth", "fifteen", "fifty"),
            Six("six", "sixth", "sixteen", "sixty"),
            Seven("seven", "seventh", "seventeen", "seventy"),
            Eight("eight", "eighth", "eighteen", "eighty"),
            Nine("nine", "nineth", "nineteen", "ninety");

            final String display;
            final String displayOrdinal;
            final String plusTen;
            final String multiTen;

            private Digit(String display, String displayOrdinal, String plusTen, String multiTen) {
                this.display = display;
                this.displayOrdinal = displayOrdinal;
                this.plusTen = plusTen;
                this.multiTen = multiTen;
            }
        }
    }

    private static class NumberTextEnglishCleanSpaceOnly
    extends NumberTextEnglish {
        private NumberTextEnglishCleanSpaceOnly() {
        }

        @Override
        String getConnectDisplay(NumberTextEnglish.Connect connect) {
            return connect == NumberTextEnglish.Connect.AfterTen ? " " : super.getConnectDisplay(connect);
        }
    }

    private static class NumberTextChinese
    extends NumberTextUtil {
        private final Type type;

        private NumberTextChinese(Type type) {
            assert (type != null);
            this.type = type;
        }

        @Override
        public String getText(long number) {
            StringBuilder builder = new StringBuilder();
            this.buildText(builder, number);
            return builder.toString();
        }

        @Override
        public String getOrdinalText(long number) {
            StringBuilder builder = new StringBuilder().append("Di");
            this.buildText(builder, number);
            return builder.toString();
        }

        private void buildText(StringBuilder builder, long number) {
            assert (builder != null);
            if (number < 0L) {
                builder.append(this.getConnectDisplay(Connect.Fu));
                number = -number;
            }
            String numString = Long.toString(number);
            int power = 0;
            while (numString.length() > (power + 1) * 4) {
                ++power;
            }
            while (power > 0) {
                if (this.extendToken(builder, numString, power * 4)) {
                    builder.append(this.getPowerDisplay(Power.values()[power - 1]));
                }
                --power;
            }
            this.extendToken(builder, numString, 0);
        }

        private boolean extendToken(StringBuilder builder, String number, int suffix) {
            assert (builder != null && NumberTextUtil.checkNumber(number) && number.length() > suffix);
            int len = number.length() - suffix;
            int qian = len > 3 ? number.charAt(len - 4) - 48 : -1;
            int bai = len > 2 ? number.charAt(len - 3) - 48 : -1;
            int shi = len > 1 ? number.charAt(len - 2) - 48 : -1;
            int ind = number.charAt(len - 1) - 48;
            boolean nonZero = false;
            if (qian == 0) {
                if (bai > 0 || shi > 0 || ind > 0) {
                    builder.append(this.getConnectDisplay(Connect.Ling));
                }
            } else if (qian > 0) {
                builder.append(this.getDigitDisplay(Digit.values()[qian])).append(this.getConnectDisplay(Connect.Qian));
                nonZero = true;
            }
            if (bai == 0) {
                if (qian > 0 && (shi > 0 || ind > 0)) {
                    builder.append(this.getConnectDisplay(Connect.Ling));
                }
            } else if (bai > 0) {
                builder.append(this.getDigitDisplay(Digit.values()[bai])).append(this.getConnectDisplay(Connect.Bai));
                nonZero = true;
            }
            if (shi == 0) {
                if (bai > 0 && ind > 0) {
                    builder.append(this.getConnectDisplay(Connect.Ling));
                }
            } else if (shi > 0) {
                if (number.length() > 2 || shi != 1) {
                    builder.append(this.getDigitDisplay(Digit.values()[shi]));
                }
                builder.append(this.getConnectDisplay(Connect.Shi));
                nonZero = true;
            }
            if (ind == 0) {
                boolean addZero = len == 1;
                for (int i = 1; addZero && i <= suffix; ++i) {
                    if (number.charAt(i) == '0') continue;
                    addZero = false;
                }
                if (addZero) {
                    builder.append(this.getConnectDisplay(Connect.Ling));
                }
            } else {
                builder.append(this.getDigitDisplay(Digit.values()[ind]));
                nonZero = true;
            }
            return nonZero;
        }

        String getConnectDisplay(Connect connect) {
            assert (connect != null);
            return this.type == Type.Simplified ? connect.display : connect.displayTraditional;
        }

        String getPowerDisplay(Power power) {
            assert (power != null);
            return this.type == Type.Simplified ? power.display : power.displayTraditional;
        }

        String getDigitDisplay(Digit digit) {
            assert (digit != null);
            return this.type == Type.Simplified ? digit.display : digit.displayTraditional;
        }

        static enum Type {
            Simplified,
            Traditional;

        }

        static enum Connect {
            Di("\u7b2c", "\u7b2c"),
            Fu("\u8d1f", "\u8ca0"),
            Ling("\u96f6", "\u96f6"),
            Shi("\u5341", "\u62fe"),
            Bai("\u767e", "\u4f70"),
            Qian("\u5343", "\u4edf");

            final String display;
            final String displayTraditional;

            private Connect(String display, String displayTraditional) {
                this.display = display;
                this.displayTraditional = displayTraditional;
            }
        }

        static enum Power {
            Wan("\u4e07", "\u842c"),
            Yi("\u4ebf", "\u5104"),
            Zhao("\u5146", "\u5146"),
            Jing("\u4eac", "\u4eac"),
            Gai("\u5793", "\u5793"),
            Zi("\u79ed", "\u79ed"),
            Rang("\u7a70", "\u7a70"),
            Gou("\u6c9f", "\u6e9d"),
            Jian("\u6da7", "\u6f97"),
            Zheng("\u6b63", "\u6b63"),
            Zai("\u8f7d", "\u8f09");

            final String display;
            final String displayTraditional;

            private Power(String display, String displayTraditional) {
                this.display = display;
                this.displayTraditional = displayTraditional;
            }
        }

        static enum Digit {
            Ling("\u96f6", "\u96f6"),
            Yi("\u4e00", "\u58f9"),
            Er("\u4e8c", "\u8d30"),
            San("\u4e09", "\u53c1"),
            Si("\u56db", "\u8086"),
            Wu("\u4e94", "\u4f0d"),
            Liu("\u516d", "\u9646"),
            Qi("\u4e03", "\u67d2"),
            Ba("\u516b", "\u634c"),
            Jiu("\u4e5d", "\u7396");

            final String display;
            final String displayTraditional;

            private Digit(String display, String displayTraditional) {
                this.display = display;
                this.displayTraditional = displayTraditional;
            }
        }
    }
}

