/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;

public class BaseMetadata<T extends BaseMetadata> {
    private static Map<Integer, Type> types = new HashMap<Integer, Type>();
    protected DatabaseType database = DatabaseType.NONE;
    protected String datasource;
    protected Catalog catalog;
    protected Schema schema;
    protected String name;
    protected String alias;
    protected String comment;
    protected boolean execute = true;
    protected String text;
    protected String id;
    protected String user;
    protected Long objectId;
    protected Table<?> table;
    protected String definition;
    protected T origin;
    protected T update;
    protected boolean setmap = false;
    protected boolean getmap = false;
    protected boolean drop = false;
    protected ACTION.DDL action = null;
    protected List<String> ddls;
    protected String identity;
    protected Object extend;
    protected Date checkSchemaTime;
    protected LinkedHashMap<String, Object> property;
    protected DataRow metadata = new DataRow();

    public static boolean check(int strut, Type type) {
        int tp = type.value();
        return (strut & tp) == tp;
    }

    public static Map<Integer, Type> types() {
        return types;
    }

    public static Type type(int type) {
        return BaseMetadata.types().get(type);
    }

    public static List<Type> types(int types) {
        ArrayList<Type> list = new ArrayList<Type>();
        int count = 0;
        while (types >= 1) {
            int temp = types % 2;
            types = (types - temp) / 2;
            if (temp == 1) {
                Type t = null;
                t = count == 0 ? BaseMetadata.type(1) : BaseMetadata.type(2 << count - 1);
                if (null != t) {
                    list.add(t);
                }
            }
            ++count;
        }
        return list;
    }

    public String getIdentity() {
        if (null == this.identity) {
            this.identity = BasicUtil.nvl(this.getCatalogName(), "") + "_" + BasicUtil.nvl(this.getSchemaName(), "") + "_" + BasicUtil.nvl(this.getTableName(false), "") + "_" + BasicUtil.nvl(this.getName(), "");
            this.identity = this.identity.toUpperCase();
        }
        return this.identity;
    }

    public static <T extends BaseMetadata> List<String> names(LinkedHashMap<String, T> columns) {
        return BaseMetadata.names(columns, false);
    }

    public static <T extends BaseMetadata> List<String> names(LinkedHashMap<String, T> columns, boolean upper) {
        ArrayList<String> names = new ArrayList<String>();
        if (null != columns) {
            for (BaseMetadata column : columns.values()) {
                String name = column.getName();
                if (upper && null != name) {
                    name = name.toUpperCase();
                }
                names.add(name);
            }
        }
        return names;
    }

    public static <T extends BaseMetadata> void sort(final LinkedHashMap<String, Integer> positions, LinkedHashMap<String, T> columns) {
        if (null == positions || positions.isEmpty()) {
            return;
        }
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(columns.values());
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Integer p2;
                Integer p1 = (Integer)positions.get(((BaseMetadata)o1).getName().toUpperCase());
                if (p1 == (p2 = (Integer)positions.get(((BaseMetadata)o2).getName().toUpperCase()))) {
                    return 0;
                }
                if (null == p1) {
                    return 1;
                }
                if (null == p2) {
                    return -1;
                }
                return p1 > p2 ? 1 : -1;
            }
        });
        columns.clear();
        for (BaseMetadata column : list) {
            columns.put(column.getName().toUpperCase(), column);
        }
    }

    public DatabaseType getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseType database) {
        this.database = database;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogName() {
        if (null == this.catalog) {
            return null;
        }
        return this.catalog.getName();
    }

    public DataRow getMetadata() {
        return this.metadata;
    }

    public void setMetadata(DataRow metadata) {
        this.metadata = metadata;
    }

    public T setCatalog(String catalog) {
        this.catalog = BasicUtil.isEmpty((Object)catalog) ? null : new Catalog(catalog);
        return (T)this;
    }

    public T setCatalog(Catalog catalog) {
        this.catalog = catalog;
        return (T)this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getSchemaName() {
        if (null == this.schema) {
            return null;
        }
        return this.schema.getName();
    }

    public T setSchema(String schema) {
        this.schema = null == schema ? null : new Schema(schema);
        return (T)this;
    }

    public T setSchema(Schema schema) {
        this.schema = schema;
        return (T)this;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getCheckSchemaTime() {
        return this.checkSchemaTime;
    }

    public T setCheckSchemaTime(Date checkSchemaTime) {
        if (this.setmap && null != this.update) {
            ((BaseMetadata)this.update).setCheckSchemaTime(checkSchemaTime);
            return (T)this;
        }
        this.checkSchemaTime = checkSchemaTime;
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        Object dest = null;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        String tableName = this.name;
        if (BasicUtil.isNotEmpty(catalogName)) {
            dest = catalogName;
        }
        if (BasicUtil.isNotEmpty(schemaName)) {
            dest = null == dest ? schemaName : (String)dest + "." + schemaName;
        }
        if (BasicUtil.isNotEmpty(tableName)) {
            dest = null == dest ? tableName : (String)dest + "." + tableName;
        }
        return dest;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public String getAlias() {
        return this.alias;
    }

    public T setAlias(String alias) {
        this.alias = alias;
        return (T)this;
    }

    public T setComment(String comment) {
        if (this.setmap && null != this.update) {
            ((BaseMetadata)this.update).comment = comment;
            return (T)this;
        }
        this.comment = comment;
        return (T)this;
    }

    public String getComment() {
        if (this.getmap && null != this.update) {
            return ((BaseMetadata)this.update).comment;
        }
        return this.comment;
    }

    public T delete() {
        return this.drop();
    }

    public boolean isDelete() {
        return this.drop;
    }

    public T setDelete(boolean drop) {
        this.drop = drop;
        return (T)this;
    }

    public ACTION.DDL getAction() {
        return this.action;
    }

    public T setAction(ACTION.DDL action) {
        this.action = action;
        return (T)this;
    }

    public T drop() {
        this.drop = true;
        return (T)this;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public T setDrop(boolean drop) {
        this.drop = drop;
        return (T)this;
    }

    public T setNewName(String newName) {
        return this.setNewName(newName, true, true);
    }

    public T setNewName(String newName, boolean setmap, boolean getmap) {
        if (null == this.update) {
            this.update(setmap, getmap);
        }
        ((BaseMetadata)this.update).setName(newName);
        return this.update;
    }

    public Table getTable(boolean update) {
        if (update && null != this.table && null != this.table.getUpdate()) {
            return (Table)this.table.getUpdate();
        }
        return this.table;
    }

    public Table getTable() {
        return this.getTable(false);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getTableName(boolean update) {
        Table table = this.getTable(update);
        if (null != table) {
            return table.getName();
        }
        return null;
    }

    public String getTableName() {
        return this.getTableName(false);
    }

    public T setTable(String table) {
        this.table = new Table(table);
        return (T)this;
    }

    public LinkedHashMap<String, Object> getProperty() {
        if (this.getmap && null != this.update) {
            return ((BaseMetadata)this.update).getProperty();
        }
        return this.property;
    }

    public T setProperty(String key, Object value) {
        if (this.getmap && null != this.update) {
            return ((BaseMetadata)this.update).setProperty(key, value);
        }
        if (null == this.property) {
            this.property = new LinkedHashMap();
        }
        this.property.put(key, value);
        return (T)this;
    }

    public T setProperty(LinkedHashMap<String, Object> property) {
        if (this.getmap && null != this.update) {
            return ((BaseMetadata)this.update).setProperty(property);
        }
        this.property = property;
        return (T)this;
    }

    public String getDefinition() {
        if (this.getmap && null != this.update) {
            return ((BaseMetadata)this.update).definition;
        }
        return this.definition;
    }

    public T setDefinition(String definition) {
        if (this.setmap && null != this.update) {
            ((Trigger)this.update).definition = definition;
            return (T)this;
        }
        this.definition = definition;
        return (T)this;
    }

    public boolean isRename() {
        if (null != this.update) {
            return !BasicUtil.equalsIgnoreCase(this.name, ((BaseMetadata)this.update).getName());
        }
        return false;
    }

    public String getDdl() {
        if (null != this.ddls && this.ddls.size() > 0) {
            return this.ddls.get(0);
        }
        return null;
    }

    public List<String> getDdls() {
        return this.ddls;
    }

    public void setDdls(List<String> ddl) {
        this.ddls = ddl;
    }

    public void addDdl(String ddl) {
        if (this.ddls == null) {
            this.ddls = new ArrayList<String>();
        }
        this.ddls.add(ddl);
    }

    public List<String> ddls() {
        return this.ddls;
    }

    public List<String> ddls(boolean init) {
        return this.ddls;
    }

    public List<String> getDdls(boolean init) {
        return this.ddls;
    }

    public String ddl() {
        if (null != this.ddls && this.ddls.size() > 0) {
            return this.ddls.get(0);
        }
        return null;
    }

    public String ddl(boolean init) {
        if (null != this.ddls && this.ddls.size() > 0) {
            return this.ddls.get(0);
        }
        return null;
    }

    public String getDdl(boolean init) {
        if (null != this.ddls && this.ddls.size() > 0) {
            return this.ddls.get(0);
        }
        return null;
    }

    public Object getExtend() {
        return this.extend;
    }

    public void setExtend(Object extend) {
        this.extend = extend;
    }

    public boolean execute() {
        return this.execute;
    }

    public void execute(boolean execute) {
        this.execute = execute;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public T getUpdate() {
        return this.update;
    }

    public T setUpdate(T update, boolean setmap, boolean getmap) {
        this.update = update;
        this.setmap = setmap;
        this.getmap = getmap;
        if (null != update) {
            ((BaseMetadata)update).update = null;
        }
        return (T)this;
    }

    public T update() {
        return this.update(true, true);
    }

    public T update(boolean setmap, boolean getmap) {
        this.setmap = setmap;
        this.getmap = getmap;
        this.update = this.clone();
        ((BaseMetadata)this.update).update = null;
        ((BaseMetadata)this.update).origin = this;
        return this.update;
    }

    public T clone() {
        BaseMetadata copy = null;
        try {
            copy = (BaseMetadata)this.getClass().newInstance();
            BeanUtil.copyFieldValue(copy, this);
            copy.update = null;
            copy.setmap = false;
            copy.getmap = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)copy;
    }

    public static <T extends BaseMetadata> T search(List<T> list, String catalog, String schema, String name) {
        for (BaseMetadata item : list) {
            if (!BasicUtil.equalsIgnoreCase(item.getCatalogName(), catalog) || !BasicUtil.equalsIgnoreCase(item.getSchemaName(), schema) || !BasicUtil.equalsIgnoreCase(item.getName(), name)) continue;
            return (T)item;
        }
        return null;
    }

    public static <T extends BaseMetadata> T search(List<T> list, String catalog, String name) {
        for (BaseMetadata item : list) {
            if (!BasicUtil.equalsIgnoreCase(item.getName(), name) || !BasicUtil.equalsIgnoreCase(item.getCatalogName(), catalog)) continue;
            return (T)item;
        }
        return null;
    }

    public static <T extends BaseMetadata> T search(List<T> list, String name) {
        for (BaseMetadata item : list) {
            if (!BasicUtil.equalsIgnoreCase(item.getName(), name)) continue;
            return (T)item;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getKeyword() {
        return "object";
    }

    public String toString() {
        return this.getKeyword() + ":" + this.getName();
    }

    static {
        for (TYPE type : TYPE.values()) {
            types.put(type.value, type);
        }
    }

    public static enum TYPE implements Type
    {
        TABLE(1),
        VIEW(2),
        COLUMN(4),
        PRIMARY(8),
        FOREIGN(16),
        INDEX(32),
        CONSTRAINT(64),
        SCHEMA(128),
        CATALOG(256),
        FUNCTION(512),
        PROCEDURE(1024),
        TRIGGER(2048),
        SEQUENCE(4096),
        SYNONYM(8192),
        DDL(16384);

        public final int value;

        private TYPE(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }
    }
}

