/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.differ.MetadataDiffer;

public class TriggersDiffer
implements MetadataDiffer {
    private List<Trigger> adds = new ArrayList<Trigger>();
    private List<Trigger> drops = new ArrayList<Trigger>();
    private List<Trigger> updates = new ArrayList<Trigger>();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static TriggersDiffer compare(LinkedHashMap<String, Trigger> origins, LinkedHashMap<String, Trigger> dests) {
        TriggersDiffer differ = new TriggersDiffer();
        ArrayList<Trigger> adds = new ArrayList<Trigger>();
        ArrayList<Trigger> drops = new ArrayList<Trigger>();
        ArrayList<Trigger> updates = new ArrayList<Trigger>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Trigger origin = origins.get(key);
            Trigger dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public List<Trigger> getAdds() {
        return this.adds;
    }

    public void setAdds(List<Trigger> adds) {
        this.adds = adds;
    }

    public List<Trigger> getDrops() {
        return this.drops;
    }

    public void setDrops(List<Trigger> drops) {
        this.drops = drops;
    }

    public List<Trigger> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<Trigger> updates) {
        this.updates = updates;
    }
}

