/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.Column;
import org.anyline.metadata.differ.MetadataDiffer;

public class ColumnsDiffer
implements MetadataDiffer {
    private List<Column> adds = new ArrayList<Column>();
    private List<Column> drops = new ArrayList<Column>();
    private List<Column> updates = new ArrayList<Column>();

    public static ColumnsDiffer compare(LinkedHashMap<String, Column> origins, LinkedHashMap<String, Column> dests) {
        ColumnsDiffer differ = new ColumnsDiffer();
        ArrayList<Column> adds = new ArrayList<Column>();
        ArrayList<Column> drops = new ArrayList<Column>();
        ArrayList<Column> updates = new ArrayList<Column>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Column origin = origins.get(key);
            Column dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public List<Column> getAdds() {
        return this.adds;
    }

    public void setAdds(List<Column> adds) {
        this.adds = adds;
    }

    public List<Column> getDrops() {
        return this.drops;
    }

    public void setDrops(List<Column> drops) {
        this.drops = drops;
    }

    public List<Column> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<Column> updates) {
        this.updates = updates;
    }
}

