/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.DefaultOrder;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class DefaultOrderStore
implements OrderStore {
    private static final long serialVersionUID = -2129393152486629564L;
    private List<Order> orders = new ArrayList<Order>();

    @Override
    public void order(Order order, boolean override) {
        if (null == order) {
            return;
        }
        Order tmp = this.getOrder(order.getColumn());
        if (null != tmp) {
            if (override) {
                tmp.setType(order.getType());
            }
        } else {
            this.orders.add(order);
        }
    }

    @Override
    public void order(Order order) {
        this.order(order, true);
    }

    @Override
    public void order(String col, Order.TYPE type, boolean override) {
        this.order(new DefaultOrder(col, type), override);
    }

    @Override
    public void order(String col, Order.TYPE type) {
        this.order(col, type, true);
    }

    @Override
    public void order(String col, String type, boolean override) {
        this.order(new DefaultOrder(col, type), override);
    }

    @Override
    public void order(String col, String type) {
        this.order(col, type, true);
    }

    @Override
    public void order(String str, boolean override) {
        String[] tmps;
        if (BasicUtil.isEmpty((Object)str)) {
            return;
        }
        String up = (str = str.trim()).toUpperCase().replaceAll("\\s+", " ").trim();
        if (up.startsWith("ORDER BY")) {
            str = str.substring(up.indexOf("ORDER BY") + "ORDER BY".length()).trim();
        }
        for (String tmp : tmps = str.split(",")) {
            this.order(new DefaultOrder(tmp), override);
        }
    }

    @Override
    public void order(String str) {
        this.order(str, true);
    }

    @Override
    public Order getOrder(String order) {
        if (null == order) {
            return null;
        }
        if (null != this.orders) {
            for (Order o : this.orders) {
                if (null == o || !order.equalsIgnoreCase(o.getColumn())) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public String getRunText(String delimiter) {
        StringBuilder builder = new StringBuilder();
        if (null != this.orders && !this.orders.isEmpty()) {
            builder.append("\nORDER BY ");
            for (int i = 0; i < this.orders.size(); ++i) {
                Order order = this.orders.get(i);
                if (null == order) continue;
                SQLUtil.delimiter(builder, order.getColumn(), delimiter).append(" ").append((Object)order.getType());
                if (i >= this.orders.size() - 1) continue;
                builder.append(",");
            }
        }
        return builder.toString();
    }

    @Override
    public void clear() {
        this.orders.clear();
    }

    @Override
    public List<Order> getOrders() {
        return this.orders;
    }

    @Override
    public boolean isEmpty() {
        if (null != this.orders) {
            return this.orders.isEmpty();
        }
        return true;
    }
}

