/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.Map;
import org.anyline.util.ConfigTable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="anyline.util.spring.context")
public class SpringContextUtil
implements ApplicationContextAware {
    public static ApplicationContext applicationContext;

    public static void init(ApplicationContext applicationContext) {
        SpringContextUtil.applicationContext = applicationContext;
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        applicationContext = ac;
        ConfigTable.setEnvironment(ac.getEnvironment());
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) throws BeansException {
        if (applicationContext.containsBean(name)) {
            return applicationContext.getBean(name);
        }
        return null;
    }

    public static <T> Map<String, T> getBeans(Class<T> clazz) throws BeansException {
        return applicationContext.getBeansOfType(clazz);
    }

    public static <T> T getBean(Class<T> clazz) throws BeansException {
        Map<String, T> beans = SpringContextUtil.getBeans(clazz);
        if (null != beans && !beans.isEmpty()) {
            for (Map.Entry<String, T> set : beans.entrySet()) {
                T bean = set.getValue();
                if (null == bean) continue;
                return bean;
            }
        }
        return null;
    }
}

