/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.View;
import org.anyline.metadata.differ.MetadataDiffer;

public class ViewsDiffer
implements MetadataDiffer {
    private List<View> adds = new ArrayList<View>();
    private List<View> drops = new ArrayList<View>();
    private List<View> updates = new ArrayList<View>();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static ViewsDiffer compare(LinkedHashMap<String, View> origins, LinkedHashMap<String, View> dests) {
        ViewsDiffer differ = new ViewsDiffer();
        ArrayList<View> adds = new ArrayList<View>();
        ArrayList<View> drops = new ArrayList<View>();
        ArrayList<View> updates = new ArrayList<View>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            View origin = origins.get(key);
            View dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public List<View> getAdds() {
        return this.adds;
    }

    public void setAdds(List<View> adds) {
        this.adds = adds;
    }

    public List<View> getDrops() {
        return this.drops;
    }

    public void setDrops(List<View> drops) {
        this.drops = drops;
    }

    public List<View> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<View> updates) {
        this.updates = updates;
    }
}

