/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.differ.MetadataDiffer;

public class ProceduresDiffer
implements MetadataDiffer {
    private List<Procedure> adds = new ArrayList<Procedure>();
    private List<Procedure> drops = new ArrayList<Procedure>();
    private List<Procedure> updates = new ArrayList<Procedure>();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public static ProceduresDiffer compare(LinkedHashMap<String, Procedure> origins, LinkedHashMap<String, Procedure> dests) {
        ProceduresDiffer differ = new ProceduresDiffer();
        ArrayList<Procedure> adds = new ArrayList<Procedure>();
        ArrayList<Procedure> drops = new ArrayList<Procedure>();
        ArrayList<Procedure> updates = new ArrayList<Procedure>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Procedure origin = origins.get(key);
            Procedure dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public List<Procedure> getAdds() {
        return this.adds;
    }

    public void setAdds(List<Procedure> adds) {
        this.adds = adds;
    }

    public List<Procedure> getDrops() {
        return this.drops;
    }

    public void setDrops(List<Procedure> drops) {
        this.drops = drops;
    }

    public List<Procedure> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<Procedure> updates) {
        this.updates = updates;
    }
}

