/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.HashMap;
import java.util.Map;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.regular.RegularUtil;

public class StyleParser {
    public static Map<String, Map<String, String>> load(String html) {
        String style = html;
        if (html.contains("<style")) {
            style = RegularUtil.cut(html, "<style", ">", "</style>");
        }
        HashMap<String, Map<String, String>> styles = new HashMap<String, Map<String, String>>();
        if (null != style) {
            String item;
            while (style.contains("}") && null != (item = RegularUtil.cut(style, "${begin}", "}"))) {
                String[] keys;
                style = style.substring(item.length() + 1);
                item = item.trim();
                String key = RegularUtil.cut(item, "${begin}", "{");
                String value = RegularUtil.cut(item, "{", "${end}");
                if (null == key || null == value) continue;
                key = key.trim();
                value = value.trim();
                for (String k : keys = key.split(",")) {
                    k = k.trim();
                    Map<String, String> tmps = StyleParser.parse(value);
                    tmps = StyleParser.join((Map)styles.get(k), tmps, true);
                    styles.put(k, tmps);
                }
            }
        }
        return styles;
    }

    public static Map<String, String> parse(String txt) {
        HashMap<String, String> styles = new HashMap<String, String>();
        if (null != txt) {
            String[] items;
            txt = BasicUtil.compress(txt);
            for (String item : items = txt.split(";")) {
                String[] vs;
                String[] kv;
                if (!item.contains(":") || (kv = item.split(":")).length != 2) continue;
                String k = kv[0].trim();
                String v = kv[1].trim();
                styles.put(k, v);
                if ("border".equalsIgnoreCase(k)) {
                    vs = (v = v.replace("solid", "single")).split(" ");
                    if (vs.length != 3) continue;
                    styles.put("border-top-width", vs[0]);
                    styles.put("border-top-style", vs[1]);
                    styles.put("border-top-color", vs[2]);
                    styles.put("border-right-width", vs[0]);
                    styles.put("border-right-style", vs[1]);
                    styles.put("border-right-color", vs[2]);
                    styles.put("border-bottom-width", vs[0]);
                    styles.put("border-bottom-style", vs[1]);
                    styles.put("border-bottom-color", vs[2]);
                    styles.put("border-left-width", vs[0]);
                    styles.put("border-left-style", vs[1]);
                    styles.put("border-left-color", vs[2]);
                    styles.put("border-insideV-width", vs[0]);
                    styles.put("border-insideV-style", vs[1]);
                    styles.put("border-insideV-color", vs[2]);
                    styles.put("border-insideH-width", vs[0]);
                    styles.put("border-insideH-style", vs[1]);
                    styles.put("border-insideH-color", vs[2]);
                    continue;
                }
                if ("border-top".equalsIgnoreCase(k) || "border-bottom".equalsIgnoreCase(k) || "border-left".equalsIgnoreCase(k) || "border-right".equalsIgnoreCase(k) || "border-insideV".equalsIgnoreCase(k) || "border-insideH".equalsIgnoreCase(k) || "border-tl2br".equalsIgnoreCase(k) || "border-tr2bl".equalsIgnoreCase(k)) {
                    if ("none".equalsIgnoreCase(v = v.replace("solid", "single"))) {
                        styles.put(k, v);
                        StyleParser.removeBorder(k, styles);
                        continue;
                    }
                    vs = v.split(" ");
                    if (vs.length != 3) continue;
                    styles.put(k + "-width", vs[0]);
                    styles.put(k + "-style", vs[1]);
                    styles.put(k + "-color", vs[2]);
                    continue;
                }
                if ("border-width".equalsIgnoreCase(k)) {
                    vs = v.split(" ");
                    if (vs.length != 2) continue;
                    styles.put("border-top-width", vs[0]);
                    styles.put("border-bottom-width", vs[0]);
                    styles.put("border-insideH-width", vs[0]);
                    styles.put("border-left-width", vs[1]);
                    styles.put("border-right-width", vs[1]);
                    styles.put("border-insideV-width", vs[1]);
                    continue;
                }
                if ("border-style".equalsIgnoreCase(k)) {
                    vs = (v = v.replace("solid", "single")).split(" ");
                    if (vs.length != 2) continue;
                    styles.put("border-top-style", vs[0]);
                    styles.put("border-bottom-style", vs[0]);
                    styles.put("border-insideH-style", vs[0]);
                    styles.put("border-left-style", vs[1]);
                    styles.put("border-right-style", vs[1]);
                    styles.put("border-insideV-style", vs[1]);
                    continue;
                }
                if ("border-color".equalsIgnoreCase(k)) {
                    vs = v.split(" ");
                    if (vs.length != 2) continue;
                    styles.put("border-top-color", vs[0]);
                    styles.put("border-bottom-color", vs[0]);
                    styles.put("border-insideH-color", vs[0]);
                    styles.put("border-left-color", vs[1]);
                    styles.put("border-right-color", vs[1]);
                    styles.put("border-insideV-color", vs[0]);
                    continue;
                }
                if ("font".equalsIgnoreCase(k)) {
                    if (!"bold".equalsIgnoreCase(v)) continue;
                    styles.put("font-weight", "700");
                    continue;
                }
                if ("font-weight".equalsIgnoreCase(k)) {
                    if (!"bold".equalsIgnoreCase(v)) continue;
                    styles.put("font-weight", "700");
                    continue;
                }
                if ("font-style".equalsIgnoreCase(k)) {
                    if (!"italic".equalsIgnoreCase(v)) continue;
                    styles.put("italic", "true");
                    continue;
                }
                if (!"text-decoration".equalsIgnoreCase(k) || !"underline".equalsIgnoreCase(v)) continue;
                styles.put("underline", "true");
            }
        }
        return styles;
    }

    public static Map<String, String> inherit(Map<String, String> src, Map<String, String> parent) {
        if (null == src) {
            src = new HashMap<String, String>();
        }
        if (null != parent) {
            for (String k : parent.keySet()) {
                if (src.containsKey(k) || !k.contains("font") && !k.contains("align") && !k.contains("list-style") && !k.contains("speak") && !k.equalsIgnoreCase("line-height") && !k.equalsIgnoreCase("word-spacing") && !k.equalsIgnoreCase("border-collapse") && !k.equalsIgnoreCase("border-spacing") && !k.equalsIgnoreCase("azimuth") && !k.equalsIgnoreCase("color") && !k.equalsIgnoreCase("caption-side") && !k.equalsIgnoreCase("cursor") && !k.equalsIgnoreCase("direction") && !k.equalsIgnoreCase("elevation") && !k.equalsIgnoreCase("empty-cells") && !k.equalsIgnoreCase("letter-spacing") && !k.equalsIgnoreCase("orphans") && !k.equalsIgnoreCase("pitch-range") && !k.equalsIgnoreCase("pitch") && !k.equalsIgnoreCase("quotes") && !k.equalsIgnoreCase("richness") && !k.equalsIgnoreCase("speaknumeral") && !k.equalsIgnoreCase("speechrate") && !k.equalsIgnoreCase("stress") && !k.equalsIgnoreCase("texttransform") && !k.equalsIgnoreCase("text-indent") && !k.equalsIgnoreCase("visibility") && !k.equalsIgnoreCase("voice-family") && !k.equalsIgnoreCase("volume") && !k.equalsIgnoreCase("word-spacing") && !k.equalsIgnoreCase("whitespace")) continue;
                src.put(k, parent.get(k));
            }
        }
        return src;
    }

    public static Map<String, String> removeBorder(String side, Map<String, String> styles) {
        side = side.replace("border-", "");
        styles.remove("border-" + side + "-width");
        styles.remove("border-" + side + "-style");
        styles.remove("border-" + side + "-color");
        styles.put("border-" + side, "none");
        return styles;
    }

    public static Map<String, String> removeBorder(Map<String, String> styles) {
        StyleParser.removeBorder("top", styles);
        StyleParser.removeBorder("right", styles);
        StyleParser.removeBorder("bottom", styles);
        StyleParser.removeBorder("left", styles);
        StyleParser.removeBorder("insideV", styles);
        StyleParser.removeBorder("insideH", styles);
        return styles;
    }

    public static Map<String, String> join(Map<String, String> src, Map<String, String> copy) {
        return StyleParser.join(src, copy, false);
    }

    public static Map<String, String> join(Map<String, String> src, Map<String, String> copy, boolean over) {
        if (null == src) {
            src = new HashMap<String, String>();
        }
        if (null == copy) {
            copy = new HashMap<String, String>();
        }
        if ("none".equalsIgnoreCase(copy.get("border"))) {
            StyleParser.removeBorder(src);
        }
        if ("none".equalsIgnoreCase(copy.get("border-left"))) {
            StyleParser.removeBorder("left", src);
        }
        if ("none".equalsIgnoreCase(copy.get("border-right"))) {
            StyleParser.removeBorder("right", src);
        }
        if ("none".equalsIgnoreCase(copy.get("border-top"))) {
            StyleParser.removeBorder("top", src);
        }
        if ("none".equalsIgnoreCase(copy.get("border-bottom"))) {
            StyleParser.removeBorder("bottom", src);
        }
        if ("none".equalsIgnoreCase(copy.get("border-insideV"))) {
            StyleParser.removeBorder("insideV", src);
        }
        if ("none".equalsIgnoreCase(copy.get("border-insideH"))) {
            StyleParser.removeBorder("insideH", src);
        }
        BeanUtil.join(src, copy, over);
        return src;
    }

    public static Map<String, String> parse(Map<String, String> src, String txt, boolean over) {
        Map<String, String> copy = StyleParser.parse(txt);
        return StyleParser.join(src, copy, over);
    }

    public static Map<String, String> parse(Map<String, String> src, String txt) {
        return StyleParser.parse(src, txt, false);
    }
}

