/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.type.init;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;

public class AbstractTypeMetadata
implements TypeMetadata {
    private boolean array;
    private List<DatabaseType> dbs = new ArrayList<DatabaseType>();
    private String name;
    private TypeMetadata.CATEGORY category;
    private Class transfer;
    private Class compatible;
    private int ignoreLength;
    private int ignorePrecision;
    private int ignoreScale;
    private TypeMetadata.Config config;

    public AbstractTypeMetadata(TypeMetadata.CATEGORY category, String name, Class transfer, Class compatible, int ignoreLength, int ignorePrecision, int ignoreScale, DatabaseType ... dbs) {
        this.category = category;
        this.name = name;
        if (null != dbs) {
            for (DatabaseType db : dbs) {
                this.dbs.add(db);
            }
        }
        this.transfer = transfer;
        this.compatible = compatible;
        this.ignoreLength = ignoreLength;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
    }

    public AbstractTypeMetadata(TypeMetadata.CATEGORY category, String name, Class compatible, int ignoreLength, int ignorePrecision, int ignoreScale, DatabaseType ... dbs) {
        this.category = category;
        this.name = name;
        if (null != dbs) {
            for (DatabaseType db : dbs) {
                this.dbs.add(db);
            }
        }
        this.compatible = compatible;
        this.ignoreLength = ignoreLength;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
    }

    @Override
    public Object convert(Object value, Object def) {
        return this.convert(value, null, def);
    }

    @Override
    public Object convert(Object value, Class target) {
        Object def = null;
        return this.convert(value, target, def);
    }

    @Override
    public Object convert(Object value, Class target, boolean array) {
        Object def = null;
        return this.convert(value, target, array, def);
    }

    @Override
    public Object convert(Object value, Class target, boolean array, Object def) {
        if (null == target) {
            target = this.compatible;
        }
        if (null != value) {
            if (value.getClass() == target) {
                return value;
            }
            if (null != this.transfer) {
                value = ConvertAdapter.convert(value, this.transfer, array, def);
            }
            value = ConvertAdapter.convert(value, target, array, def);
        }
        return value;
    }

    @Override
    public Object convert(Object value, Object obj, Field field) {
        return this.convert(value, field.getType());
    }

    @Override
    public Object read(Object value, Object def, Class clazz) {
        return this.read(value, def, clazz, false);
    }

    @Override
    public Object read(Object value, Object def, Class clazz, boolean array) {
        if (null == clazz) {
            clazz = this.transfer;
        }
        if (null == clazz) {
            clazz = this.compatible;
        }
        value = ConvertAdapter.convert(value, clazz, array, def);
        return value;
    }

    @Override
    public Object write(Object value, Object def, boolean placeholder) {
        return this.write(value, def, false, placeholder);
    }

    @Override
    public Object write(Object value, Object def, boolean array, boolean placeholder) {
        if (null != value && value.getClass() != this.compatible) {
            if (null != this.transfer) {
                value = ConvertAdapter.convert(value, this.transfer, array, def);
            }
            value = ConvertAdapter.convert(value, this.compatible, array, def);
        }
        if (null != value && !BasicUtil.isNumber(value)) {
            value = "'" + value + "'";
        }
        return value;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public void setArray(boolean array) {
        this.array = array;
    }

    @Override
    public TypeMetadata.CATEGORY getCategory() {
        return this.category;
    }

    @Override
    public TypeMetadata.CATEGORY_GROUP getCategoryGroup() {
        if (null != this.category) {
            return this.category.group();
        }
        return TypeMetadata.CATEGORY_GROUP.NONE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int ignoreLength() {
        return this.ignoreLength;
    }

    @Override
    public int ignorePrecision() {
        return this.ignorePrecision;
    }

    @Override
    public int ignoreScale() {
        return this.ignoreScale;
    }

    @Override
    public boolean support() {
        return true;
    }

    @Override
    public Class compatible() {
        return this.compatible;
    }

    @Override
    public Class transfer() {
        return this.transfer;
    }

    @Override
    public List<DatabaseType> databaseTypes() {
        return this.dbs;
    }

    @Override
    public TypeMetadata.Config config() {
        if (null == this.config) {
            this.config = new TypeMetadata.Config();
            this.config.setIgnoreLength(this.ignoreLength).setIgnorePrecision(this.ignorePrecision).setIgnoreScale(this.ignoreScale);
        }
        return this.config;
    }
}

