/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.Index;
import org.anyline.metadata.differ.MetadataDiffer;

public class IndexsDiffer
implements MetadataDiffer {
    private List<Index> adds = new ArrayList<Index>();
    private List<Index> drops = new ArrayList<Index>();
    private List<Index> updates = new ArrayList<Index>();

    public static IndexsDiffer compare(LinkedHashMap<String, Index> origins, LinkedHashMap<String, Index> dests) {
        IndexsDiffer differ = new IndexsDiffer();
        ArrayList<Index> adds = new ArrayList<Index>();
        ArrayList<Index> drops = new ArrayList<Index>();
        ArrayList<Index> updates = new ArrayList<Index>();
        if (null != origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Index<Object> origin = origins.get(key);
            Index<Object> dest = dests.get(key);
            if (null == dest) {
                drops.add(origins.get(origin));
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            updates.add(origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.add(dests.get(key));
        }
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setUpdates(updates);
        return differ;
    }

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.updates.isEmpty();
    }

    public List<Index> getAdds() {
        return this.adds;
    }

    public void setAdds(List<Index> adds) {
        this.adds = adds;
    }

    public List<Index> getDrops() {
        return this.drops;
    }

    public void setDrops(List<Index> drops) {
        this.drops = drops;
    }

    public List<Index> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<Index> updates) {
        this.updates = updates;
    }
}

