/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.geometry;

import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.Point;

public class Ring
extends Geometry {
    private Boolean clockwise = false;
    private List<Point> points = new ArrayList<Point>();

    public Ring add(Point point) {
        this.points.add(point);
        return this;
    }

    public Ring add(double x, double y) {
        return this.add(new Point(x, y));
    }

    public Ring add(int x, int y) {
        return this.add(new Point(x, y));
    }

    public List<Point> points() {
        return this.points;
    }

    public Ring() {
    }

    public Ring(List<Point> points) {
        this.points = points;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public Boolean clockwise() {
        return this.clockwise;
    }

    public void clockwise(Boolean clockwise) {
        this.clockwise = clockwise;
    }

    public void points(List<Point> points) {
        this.points = points;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean tag) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        builder.append("(");
        boolean first = true;
        for (Point point : this.points) {
            if (!first) {
                builder.append(",");
            }
            builder.append(point.toString(false));
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String sql(boolean tag, boolean bracket) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        if (bracket) {
            builder.append("(");
        }
        boolean first = true;
        for (Point point : this.points) {
            if (!first) {
                builder.append(",");
            }
            builder.append(point.sql(false, false));
            first = false;
        }
        if (bracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String sql() {
        return this.sql(true, true);
    }
}

