/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import org.anyline.adapter.KeyAdapter;
import org.anyline.adapter.init.LowerKeyAdapter;
import org.anyline.adapter.init.SrcKeyAdapter;
import org.anyline.adapter.init.UpperKeyAdapter;
import org.anyline.entity.AnyData;
import org.anyline.entity.DataSet;
import org.anyline.entity.geometry.Point;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.CharUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.DefaultOgnlMemberAccess;
import org.anyline.util.NumberUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRow
extends LinkedHashMap<String, Object>
implements Serializable,
AnyData {
    private static final long serialVersionUID = -2098827041540802313L;
    private static final Logger log = LoggerFactory.getLogger(DataRow.class);
    public static String KEY_CHILDREN = "CHILDREN";
    public static String KEY_ALL_CHILDREN = "ALL_CHILDREN";
    public static String KEY_ITEMS = "ITEMS";
    public static KeyAdapter.KEY_CASE DEFAULT_KEY_CASE = KeyAdapter.KEY_CASE.CONFIG;
    public static String DEFAULT_PRIMARY_KEY = ConfigTable.DEFAULT_PRIMARY_KEY;
    protected Boolean override = null;
    protected boolean updateNullColumn = ConfigTable.IS_UPDATE_NULL_COLUMN;
    protected boolean updateEmptyColumn = ConfigTable.IS_UPDATE_EMPTY_COLUMN;
    protected boolean insertNullColumn = ConfigTable.IS_INSERT_NULL_COLUMN;
    protected boolean insertEmptyColumn = ConfigTable.IS_INSERT_EMPTY_COLUMN;
    protected boolean replaceEmptyNull = ConfigTable.IS_REPLACE_EMPTY_NULL;
    protected String category = null;
    protected LinkedHashMap<String, Column> metadatas = null;
    protected transient DataSet container = null;
    protected transient Map<String, DataSet> containers = new HashMap<String, DataSet>();
    protected transient Map<String, DataRow> parents = new Hashtable<String, DataRow>();
    protected List<String> primaryKeys = new ArrayList<String>();
    protected List<String> updateColumns = new ArrayList<String>();
    protected List<String> ignoreUpdateColumns = new ArrayList<String>();
    protected String datalink = null;
    protected String dataSource = null;
    protected Catalog catalog = null;
    protected Schema schema = null;
    protected LinkedHashMap<String, Table> tables = new LinkedHashMap();
    protected DataRow attributes = null;
    protected DataRow tags = null;
    protected DataRow relations = null;
    protected long createTime = 0L;
    protected long nanoTime = 0L;
    protected long expires = -1L;
    protected Boolean isNew = false;
    protected boolean isFromCache = false;
    protected Map<String, String> keymap = new HashMap<String, String>();
    protected boolean isUpperKey = false;
    protected Map<String, String> converts = new HashMap<String, String>();
    public boolean skip = false;
    protected KeyAdapter keyAdapter = null;
    protected KeyAdapter.KEY_CASE keyCase = DEFAULT_KEY_CASE;
    public Format format = new Format();
    public Parse parse = new Parse();

    public DataRow() {
        this.parseKeycase(null);
        String pk = this.keyAdapter.key(DEFAULT_PRIMARY_KEY);
        if (null != pk) {
            this.primaryKeys.add(DEFAULT_PRIMARY_KEY);
        }
        this.createTime = System.currentTimeMillis();
        this.nanoTime = System.currentTimeMillis();
    }

    protected void parseKeycase(KeyAdapter.KEY_CASE keyCase) {
        if (null == keyCase) {
            keyCase = this.keyCase;
        } else {
            this.keyCase = keyCase;
        }
        if (null != keyCase) {
            this.keyAdapter = KeyAdapter.parse(keyCase);
            if (keyCase == KeyAdapter.KEY_CASE.CONFIG) {
                if (ConfigTable.IS_UPPER_KEY) {
                    this.keyAdapter = UpperKeyAdapter.getInstance();
                } else if (ConfigTable.IS_LOWER_KEY) {
                    this.keyAdapter = LowerKeyAdapter.getInstance();
                }
            }
        } else {
            this.keyAdapter = SrcKeyAdapter.getInstance();
        }
    }

    public DataRow(KeyAdapter.KEY_CASE keyCase) {
        this();
        this.parseKeycase(keyCase);
    }

    public DataRow(String table) {
        this();
        this.setTable(table);
    }

    public DataRow(Map<String, Object> map) {
        this();
        this.parseMap(null, map);
    }

    public DataRow(KeyAdapter.KEY_CASE keyCase, Map<String, Object> map) {
        this(keyCase);
        this.parseMap(null, map);
    }

    public DataRow(LinkedHashMap columns, Map<String, Object> map) {
        this();
        this.parseMap(columns, map);
    }

    public DataRow parseMap(LinkedHashMap columns, Map<String, Object> map) {
        this.setMetadata(columns);
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entity : set) {
            Object value = entity.getValue();
            if (null != value) {
                String type;
                if (value instanceof Map) {
                    value = new DataRow((Map)value);
                }
                if (null != (type = this.getMetadataTypeName(entity.getKey())) && type.toUpperCase().contains("JSON")) {
                    String str = value.toString().trim();
                    if (str.startsWith("{")) {
                        value = DataRow.parseJson(str);
                    } else if (str.startsWith("[")) {
                        value = DataSet.parseJson(str);
                    }
                }
            }
            this.put(this.keyAdapter.key(entity.getKey()), value);
        }
        return this;
    }

    public DataRow serCreateTime(Long time) {
        this.createTime = time;
        return this;
    }

    public DataRow serCreateTime(java.util.Date time) {
        this.createTime = time.getTime();
        return this;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public void setNanoTime(long nanoTime) {
        this.nanoTime = nanoTime;
    }

    public static DataRow parseList(DataRow row, Collection<?> list, String ... fields) {
        block6: {
            if (null == row) {
                row = new DataRow();
            }
            if (null == list) break block6;
            if (null == fields || fields.length == 0) {
                int i = 0;
                for (Object obj : list) {
                    row.put("" + i++, obj);
                }
            } else {
                Object[] items = list.toArray();
                int len = fields.length;
                for (int i = 0; i < len; ++i) {
                    String field = fields[i];
                    Object value = null;
                    if (i < items.length - 1) {
                        value = items[i];
                    }
                    row.put(field, value);
                }
            }
        }
        return row;
    }

    public static DataRow parseList(Collection<?> list, String ... fields) {
        return DataRow.parseList(null, list, fields);
    }

    public DataRow setKeyCase(KeyAdapter.KEY_CASE keyCase) {
        this.parseKeycase(keyCase);
        return this;
    }

    public static DataRow parse(DataRow row, Object obj, String ... keys) {
        if (EntityAdapterProxy.hasAdapter(obj.getClass()) && null != (row = EntityAdapterProxy.row(row, obj, keys))) {
            return row;
        }
        return DataRow.parse(row, KeyAdapter.KEY_CASE.CONFIG, obj, keys);
    }

    public static DataRow parse(Object obj, String ... keys) {
        return DataRow.parse((DataRow)null, obj, keys);
    }

    public static DataRow parse(KeyAdapter.KEY_CASE keyCase, String txt, String ... keys) {
        return DataRow.parse((DataRow)null, keyCase, (Object)txt, keys);
    }

    public static DataRow build(DataRow row, Object obj, String ... keys) {
        return DataRow.parse(row, obj, keys);
    }

    public static DataRow build(Object obj, String ... keys) {
        return DataRow.parse((DataRow)null, obj, keys);
    }

    public static DataRow parse(DataRow row, KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        block14: {
            if (null != obj && obj instanceof String) {
                return DataRow.parseJson(row, keyCase, (String)obj);
            }
            if (null == row) {
                row = new DataRow(keyCase);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            if (null != keys) {
                for (String key : keys) {
                    String[] tmp = key.split(":");
                    if (null == tmp || tmp.length <= 1) continue;
                    map.put(DataRow.putKeyCase(tmp[1].trim()), DataRow.putKeyCase(tmp[0].trim()));
                }
            }
            if (null == obj) break block14;
            if (obj instanceof JsonNode) {
                row = DataRow.parseJson(keyCase, (JsonNode)obj);
            } else if (obj instanceof DataRow) {
                row = (DataRow)obj;
            } else if (obj instanceof Map) {
                Map mp = (Map)obj;
                List<String> ks = BeanUtil.getMapKeys(mp);
                for (String k : ks) {
                    Object value = mp.get(k);
                    if (value instanceof Map) {
                        value = DataRow.parse(value, new String[0]);
                    }
                    row.put(k, value);
                }
            } else {
                List<Field> fields = ClassUtil.getFields(obj.getClass(), false, false);
                for (Field field : fields) {
                    String fieldName = field.getName();
                    String col = (String)map.get(fieldName);
                    if (null == col) {
                        col = fieldName;
                    }
                    row.put(keyCase, col, BeanUtil.getFieldValue(obj, field));
                }
            }
        }
        return row;
    }

    public static DataRow parse(KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        return DataRow.parse(null, keyCase, obj, keys);
    }

    public static DataRow build(DataRow row, KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        return DataRow.parse(row, keyCase, obj, keys);
    }

    public static DataRow build(KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        return DataRow.parse(null, keyCase, obj, keys);
    }

    public static DataRow parseJson(DataRow row, KeyAdapter.KEY_CASE keyCase, String json) {
        if (null != json) {
            try {
                return DataRow.parseJson(row, keyCase, BeanUtil.JSON_MAPPER.readTree(json));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static DataRow parseJson(KeyAdapter.KEY_CASE keyCase, String json) {
        return DataRow.parseJson(null, keyCase, json);
    }

    public static DataRow parseJson(DataRow row, String json) {
        return DataRow.parseJson(row, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static DataRow parseJson(String json) {
        return DataRow.parseJson(null, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static DataRow parseJson(DataRow row, KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        return (DataRow)DataRow.parseJsonObject(row, keyCase, json);
    }

    public static DataRow parseJson(KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        return (DataRow)DataRow.parseJsonObject(null, keyCase, json);
    }

    public static DataRow parseJson(DataRow row, JsonNode json) {
        return DataRow.parseJson(row, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static DataRow parseJson(JsonNode json) {
        return DataRow.parseJson(null, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static Object parseJsonObject(Object obj, KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        if (null == json) {
            return obj;
        }
        if (json.isValueNode()) {
            return BeanUtil.value(json);
        }
        if (json.isArray()) {
            Collection list = null;
            list = null != obj && obj instanceof Collection ? (Collection)obj : new ArrayList();
            Iterator items = json.iterator();
            boolean isDataRow = true;
            while (items.hasNext()) {
                JsonNode item = (JsonNode)items.next();
                Object row = DataRow.parseJsonObject(obj, keyCase, item);
                if (!(row instanceof DataRow)) {
                    isDataRow = false;
                }
                list.add(row);
            }
            if (isDataRow) {
                return DataSet.parse(list, new String[0]);
            }
            return list;
        }
        if (json.isObject()) {
            DataRow row = null;
            row = null != obj && obj instanceof DataRow ? (DataRow)obj : new DataRow(keyCase);
            Iterator fields = json.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode value = (JsonNode)field.getValue();
                String key = (String)field.getKey();
                if (null != value) {
                    if (value.isValueNode()) {
                        row.put(key, BeanUtil.value(value));
                        continue;
                    }
                    row.put(key, DataRow.parseJsonObject(keyCase, value));
                    continue;
                }
                row.put(key, (Object)null);
            }
            return row;
        }
        return null;
    }

    public static Object parseJsonObject(KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        return DataRow.parseJsonObject(null, keyCase, json);
    }

    public static DataRow parseXml(DataRow row, KeyAdapter.KEY_CASE keyCase, String xml) {
        if (null != xml) {
            try {
                Document doc = DocumentHelper.parseText((String)xml);
                return DataRow.parseXml(row, keyCase, doc.getRootElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static DataRow parseXml(DataRow row, String xml) {
        return DataRow.parseXml(row, KeyAdapter.KEY_CASE.CONFIG, xml);
    }

    public static DataRow parseXml(String xml) {
        return DataRow.parseXml(null, KeyAdapter.KEY_CASE.CONFIG, xml);
    }

    public static DataRow parseXml(DataRow row, KeyAdapter.KEY_CASE keyCase, Element element) {
        if (null == row) {
            row = new DataRow(keyCase);
        }
        if (null == element) {
            return row;
        }
        Iterator childs = element.elementIterator();
        Object key = element.getName();
        String namespace = element.getNamespacePrefix();
        if (BasicUtil.isNotEmpty(namespace)) {
            key = namespace + ":" + (String)key;
        }
        if (element.isTextOnly() || !childs.hasNext()) {
            row.put((String)key, (Object)element.getTextTrim());
        } else {
            while (childs.hasNext()) {
                Element child = (Element)childs.next();
                Object childKey = child.getName();
                String childNamespace = child.getNamespacePrefix();
                if (BasicUtil.isNotEmpty(childNamespace)) {
                    childKey = childNamespace + ":" + (String)childKey;
                }
                if (child.isTextOnly() || !child.elementIterator().hasNext()) {
                    row.put((String)childKey, (Object)child.getTextTrim());
                    continue;
                }
                DataRow childRow = DataRow.parseXml(row, keyCase, child);
                Object childStore = row.get((String)childKey);
                if (null == childStore) {
                    row.put((String)childKey, (Object)childRow);
                    continue;
                }
                if (childStore instanceof DataRow) {
                    DataSet childSet = new DataSet();
                    childSet.add((DataRow)childStore);
                    childSet.add(childRow);
                    row.put((String)childKey, (Object)childSet);
                    continue;
                }
                if (!(childStore instanceof DataSet)) continue;
                ((DataSet)childStore).add(childRow);
            }
        }
        Iterator attrs = element.attributeIterator();
        while (attrs.hasNext()) {
            Attribute attr = (Attribute)attrs.next();
            row.attr(attr.getName(), attr.getValue());
        }
        return row;
    }

    public static DataRow parseXml(KeyAdapter.KEY_CASE keyCase, Element element) {
        return DataRow.parseXml(null, keyCase, element);
    }

    public static DataRow parseArray(DataRow row, String ... kvs) {
        if (null == row) {
            row = new DataRow();
        }
        int len = kvs.length;
        int i = 0;
        while (i < len) {
            String p1 = kvs[i];
            if (BasicUtil.isEmpty((Object)p1)) {
                ++i;
                continue;
            }
            if (p1.contains(":")) {
                String[] ks = BeanUtil.parseKeyValue(p1);
                row.put(ks[0], (Object)ks[1]);
                ++i;
                continue;
            }
            if (i + 1 < len) {
                String p2 = kvs[i + 1];
                if (BasicUtil.isEmpty((Object)p2) || !p2.contains(":")) {
                    row.put(p1, (Object)p2);
                    i += 2;
                    continue;
                }
                String[] ks = BeanUtil.parseKeyValue(p2);
                row.put(ks[0], (Object)ks[1]);
                i += 2;
                continue;
            }
            ++i;
        }
        return row;
    }

    public static DataRow parseArray(String ... kvs) {
        return DataRow.parseArray((DataRow)null, kvs);
    }

    public DataRow setContainer(String key, DataSet container) {
        this.containers.put(key, container);
        return this;
    }

    public DataSet getContainer(String key) {
        return this.containers.get(key);
    }

    public DataRow setParent(String key, DataRow parent) {
        this.parents.put(key, parent);
        return this;
    }

    public DataRow getParent(String key) {
        return this.parents.get(key);
    }

    public DataSet getAllParent(String key) {
        DataSet set = new DataSet();
        for (DataRow parent = this.getParent(key); null != parent; parent = parent.getParent(key)) {
            set.add(parent);
        }
        return set;
    }

    public Boolean getOverride() {
        return this.override;
    }

    public void setOverride(Boolean override) {
        this.override = override;
    }

    public DataRow setMetadata(LinkedHashMap<String, Column> metadatas) {
        this.metadatas = metadatas;
        return this;
    }

    public DataRow setMetadata(String name, Column column) {
        if (null == this.metadatas) {
            this.metadatas = new LinkedHashMap();
        }
        this.metadatas.put(name.toUpperCase(), column);
        return this;
    }

    public DataRow setMetadata(Column column) {
        if (null != column) {
            return this.setMetadata(column.getName(), column);
        }
        return this;
    }

    public LinkedHashMap<String, Column> getMetadatas() {
        return this.getMetadatas(false);
    }

    public LinkedHashMap<String, Column> getMetadatas(boolean create) {
        LinkedHashMap<String, Column> result = this.metadatas;
        if ((null == result || result.isEmpty()) && null != this.container) {
            result = this.container.getMetadatas();
        }
        if ((null == result || result.isEmpty()) && create) {
            result = new LinkedHashMap();
            for (String key : this.keySet()) {
                result.put(key.toUpperCase(), new Column(key));
            }
        }
        return result;
    }

    public Column getMetadata(String column) {
        LinkedHashMap<String, Column> metadatas = this.getMetadatas();
        if (null == metadatas) {
            return null;
        }
        Column metadata = metadatas.get(column.toUpperCase());
        if (null == metadata && null != this.container) {
            metadata = this.container.getMetadata(column);
        }
        return metadata;
    }

    public String getMetadataTypeName(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getTypeName();
        }
        return null;
    }

    public Integer getMetadataType(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getType();
        }
        return null;
    }

    public String getMetadataFullType(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getFullType();
        }
        return null;
    }

    public String getMetadataClassName(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getClassName();
        }
        return null;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public DataRow setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public long getExpires() {
        return this.expires;
    }

    public DataRow setExpires(long millisecond) {
        this.expires = millisecond;
        return this;
    }

    public DataRow setExpires(int millisecond) {
        this.expires = millisecond;
        return this;
    }

    public DataRow merge(DataRow row, boolean over) {
        List<String> keys = row.keys();
        for (String key : keys) {
            if (!over && null != this.get(key)) continue;
            this.put(key, row.get(KeyAdapter.KEY_CASE.SRC, key));
        }
        return this;
    }

    public Object ognl(String formula, Object values) throws Exception {
        if (null == values) {
            values = this;
        }
        formula = BeanUtil.parseRuntimeValue(values, formula);
        OgnlContext context = new OgnlContext(null, null, (MemberAccess)new DefaultOgnlMemberAccess(true));
        Object value = Ognl.getValue((String)formula, (Map)context, (Object)values);
        return value;
    }

    public Object ognl(String formula) throws Exception {
        return this.ognl(formula, this);
    }

    public DataRow ognl(String key, String formula, Object values) throws Exception {
        this.put(key, this.ognl(formula, values));
        return this;
    }

    public DataRow ognl(String key, String formula) throws Exception {
        return this.ognl(key, formula, this);
    }

    public DataRow merge(DataRow row) {
        return this.merge(row, false);
    }

    public Boolean isNew() {
        if (null != this.isNew && this.isNew.booleanValue()) {
            return true;
        }
        boolean fullPv = true;
        List<String> ks = this.getPrimaryKeys();
        for (String k : ks) {
            Object v = this.get(k);
            if (!BasicUtil.isEmpty(v)) continue;
            fullPv = false;
            break;
        }
        return !fullPv;
    }

    public boolean isFromCache() {
        return this.isFromCache;
    }

    public DataRow setIsFromCache(boolean bol) {
        this.isFromCache = bol;
        return this;
    }

    public String getCd() {
        return this.getString("cd");
    }

    public String getId() {
        return this.getString("id");
    }

    public String getCode() {
        return this.getString("code");
    }

    public String getNm() {
        return this.getString("nm");
    }

    public String getName() {
        return this.getString("name");
    }

    public String getTitle() {
        return this.getString("title");
    }

    public DataSet getItems() {
        Object items = this.get(KEY_ITEMS);
        if (items instanceof DataSet) {
            return (DataSet)items;
        }
        return null;
    }

    public DataRow putItems(Object obj) {
        this.put(KEY_ITEMS, obj);
        return this;
    }

    public DataRow toLowerKey(boolean recursion, String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                Object value = this.get(key);
                if (recursion && value instanceof DataRow) {
                    ((DataRow)value).toLowerKey(true, keys);
                }
                this.remove(this.keyAdapter.key(key));
                key = key.toLowerCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        } else {
            for (String key : this.keys()) {
                Object value = this.get(key);
                if (recursion && value instanceof DataRow) {
                    ((DataRow)value).toLowerKey(true, keys);
                }
                this.remove(this.keyAdapter.key(key));
                key = key.toLowerCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        }
        this.parseKeycase(KeyAdapter.KEY_CASE.LOWER);
        return this;
    }

    public DataRow toLowerKey(String ... keys) {
        return this.toLowerKey(true, keys);
    }

    public DataRow toUpperKey(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                Object value = this.get(key);
                this.remove(this.keyAdapter.key(key));
                key = key.toUpperCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        } else {
            for (String key : this.keys()) {
                Object value = this.get(key);
                this.remove(this.keyAdapter.key(key));
                key = key.toUpperCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        }
        this.parseKeycase(KeyAdapter.KEY_CASE.UPPER);
        return this;
    }

    public DataRow toLowerValue(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                Object value = this.get(key);
                if (!(value instanceof String)) continue;
                this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)((String)value).toLowerCase());
            }
        } else {
            for (String key : this.keys()) {
                Object value = this.get(key);
                if (!(value instanceof String)) continue;
                this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)((String)value).toLowerCase());
            }
        }
        return this;
    }

    public DataRow toUpperValue(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                Object value = this.get(key);
                if (!(value instanceof String)) continue;
                this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)((String)value).toUpperCase());
            }
        } else {
            for (String key : this.keys()) {
                Object value = this.get(key);
                if (!(value instanceof String)) continue;
                this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)((String)value).toUpperCase());
            }
        }
        return this;
    }

    public boolean isNull(String key) {
        Object obj = this.get(key);
        return obj == null;
    }

    public boolean isNotNull(String key) {
        return !this.isNull(key);
    }

    public boolean isEmpty(boolean recursion, String key) {
        Object obj = this.get(key);
        return BasicUtil.isEmpty(recursion, obj);
    }

    public boolean isEmpty(String key) {
        Object obj = this.get(key);
        return BasicUtil.isEmpty(obj);
    }

    public boolean isNotEmpty(String key) {
        return !this.isEmpty(key);
    }

    public DataRow addPrimaryKey(boolean applyContainer, String ... pks) {
        if (null != pks) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : pks) {
                list.add(pk);
            }
            return this.addPrimaryKey(applyContainer, list);
        }
        return this;
    }

    public DataRow addPrimaryKey(String ... pks) {
        return this.addPrimaryKey(false, pks);
    }

    public DataRow addPrimaryKey(boolean applyContainer, Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        for (String item : pks) {
            if (BasicUtil.isEmpty((Object)item) || this.primaryKeys.contains(item = this.keyAdapter.key(item))) continue;
            this.primaryKeys.add(item);
        }
        if (this.hasContainer() && applyContainer) {
            this.getContainer().setPrimaryKey(false, this.primaryKeys);
        }
        return this;
    }

    public DataRow setPrimaryKey(boolean applyContainer, String ... pks) {
        if (null != pks) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : pks) {
                list.add(pk);
            }
            return this.setPrimaryKey(applyContainer, list);
        }
        return this;
    }

    public DataRow setPrimaryKey(String ... pks) {
        return this.setPrimaryKey(false, pks);
    }

    public DataRow setPrimaryKey(boolean applyContainer, Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (this.hasContainer() && applyContainer) {
            this.getContainer().setPrimaryKey(pks);
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        } else {
            this.primaryKeys.clear();
        }
        return this.addPrimaryKey(applyContainer, pks);
    }

    public DataRow setPrimaryKey(Collection<String> pks) {
        return this.setPrimaryKey(false, pks);
    }

    public Column getPrimaryColumn() {
        LinkedHashMap<String, Column> columns = this.getPrimaryColumns();
        if (!columns.isEmpty()) {
            return columns.values().iterator().next();
        }
        String pk = this.getPrimaryKey();
        if (null == pk) {
            pk = DEFAULT_PRIMARY_KEY;
        }
        Column column = null;
        column = null != this.metadatas ? this.metadatas.get(pk.toUpperCase()) : new Column(pk);
        return column;
    }

    public LinkedHashMap<String, Column> getPrimaryColumns() {
        List<String> pks;
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        if (null != this.metadatas) {
            for (Column column : this.metadatas.values()) {
                if (column.isPrimaryKey() != 1) continue;
                columns.put(column.getName().toUpperCase(), column);
            }
        }
        if (columns.isEmpty() && null != (pks = this.getPrimaryKeys())) {
            for (String pk : pks) {
                Column column = null;
                if (null != this.metadatas) {
                    column = this.metadatas.get(pk.toUpperCase());
                }
                if (null == column) {
                    column = new Column(pk);
                }
                columns.put(pk.toUpperCase(), column);
            }
        }
        return columns;
    }

    public List<String> getPrimaryKeys() {
        if (this.hasSelfPrimaryKeys()) {
            return this.primaryKeys;
        }
        if (this.hasContainer() && this.getContainer().hasPrimaryKeys()) {
            return this.getContainer().getPrimaryKeys();
        }
        return null;
    }

    public String getPrimaryKey() {
        List<String> keys = this.getPrimaryKeys();
        if (null != keys && !keys.isEmpty()) {
            return keys.get(0);
        }
        return null;
    }

    public List<Object> getPrimaryValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        List<String> keys = this.getPrimaryKeys();
        if (null != keys) {
            for (String key : keys) {
                values.add(this.get(key));
            }
        }
        return values;
    }

    public Object getPrimaryValue() {
        String key = this.getPrimaryKey();
        if (null != key) {
            return this.get(key);
        }
        return null;
    }

    public DataRow setPrimaryValue(Object value) {
        String key = this.getPrimaryKey();
        if (null != key) {
            this.put(key, value);
        }
        return this;
    }

    public boolean hasPrimaryKeys() {
        if (this.hasSelfPrimaryKeys()) {
            return true;
        }
        if (null != this.getContainer()) {
            return this.getContainer().hasPrimaryKeys();
        }
        return this.keys().contains(ConfigTable.DEFAULT_PRIMARY_KEY);
    }

    public boolean hasSelfPrimaryKeys() {
        return null != this.primaryKeys && !this.primaryKeys.isEmpty();
    }

    public String getCategory() {
        return this.category;
    }

    public DataRow setCategory(String category) {
        this.category = category;
        return this;
    }

    public DataRow getRelations() {
        return this.relations;
    }

    public DataRow setRelations(DataRow relations) {
        this.relations = relations;
        return this;
    }

    public DataRow addRelation(DataRow relation) {
        if (null == this.relations) {
            this.relations = new DataRow();
        }
        this.relations.put(relation.getCategory(), (Object)relation);
        return this;
    }

    public DataRow addRelation(String relation) {
        if (null == this.relations) {
            this.relations = new DataRow();
        }
        DataRow row = new DataRow();
        row.setCategory(relation);
        this.relations.put(relation, (Object)row);
        return this;
    }

    public DataRow getRelation(String key) {
        if (null == this.relations) {
            this.relations = new DataRow();
        }
        return (DataRow)this.relations.get(key);
    }

    public String getDataLink() {
        if (BasicUtil.isEmpty((Object)this.datalink) && null != this.getContainer()) {
            return this.getContainer().getDatalink();
        }
        return this.datalink;
    }

    public DataRow setDest(String dest) {
        if (null == dest) {
            return this;
        }
        if (dest.contains(".") && !dest.contains(":")) {
            String[] tmps = dest.split("\\.");
            Catalog catalog = null;
            Schema schema = null;
            Table table = null;
            if (tmps.length == 2) {
                schema = new Schema(tmps[0]);
                table = new Table(tmps[1]);
                table.setSchema(schema);
            } else if (tmps.length == 3) {
                catalog = new Catalog(tmps[0]);
                schema = new Schema(tmps[1]);
                schema.setCatalog(catalog);
                table = new Table(tmps[2]);
                table.setSchema(schema);
                table.setCatalog(catalog);
            }
            this.setCatalog(catalog);
            this.setSchema(schema);
            this.setTable(table);
        } else {
            Table table = new Table(dest);
            this.setTable(table);
        }
        return this;
    }

    public Object getChildren() {
        return this.get(KEY_CHILDREN);
    }

    public DataRow setChildren(Object children) {
        this.put(KEY_CHILDREN, children);
        return this;
    }

    public DataSet getAllChild(String key) {
        Object obj = this.get(KEY_ALL_CHILDREN);
        if (null != obj) {
            return (DataSet)obj;
        }
        DataSet set = new DataSet();
        DataSet childs = this.getSet(key);
        for (DataRow child : childs) {
            set.add(child);
            set.addAll((Collection)child.getAllChild(key));
        }
        this.put(KEY_ALL_CHILDREN, (Object)set);
        return set;
    }

    public <T> T entity(Class<T> clazz, String ... configs) {
        T entity = null;
        if (null == clazz) {
            return entity;
        }
        if (EntityAdapterProxy.hasAdapter(clazz) && null != (entity = (T)EntityAdapterProxy.entity(clazz, this, this.metadatas))) {
            return entity;
        }
        try {
            entity = clazz.newInstance();
            List<Field> fields = ClassUtil.getFields(clazz, false, false);
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                Object value = this.get(field.getName());
                BeanUtil.setFieldValue(entity, field, value);
            }
            if (null != configs) {
                String[] stringArray = configs;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String[] tmps;
                    String config;
                    String field = config = stringArray[i];
                    String column = config;
                    if (config.contains(":") && (tmps = config.split(":")).length >= 2) {
                        field = tmps[0];
                        column = tmps[1];
                    }
                    Object value = this.get(column);
                    BeanUtil.setFieldValue(entity, field, value);
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public boolean hasValue(String key) {
        return this.get(key) != null;
    }

    public boolean hasKey(String key) {
        return this.keySet().contains(this.keyAdapter.key(key));
    }

    public boolean containsKey(String key) {
        return this.keySet().contains(this.keyAdapter.key(key));
    }

    public List<String> keys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (String string : map.keySet()) {
            this.put(string, map.get(string));
        }
    }

    public DataRow put(KeyAdapter.KEY_CASE keyCase, String key, Object value) {
        return this.put(true, keyCase, key, value);
    }

    public DataRow put(boolean checkUpdate, String key, Object value) {
        return this.put(checkUpdate, null, key, value);
    }

    public DataRow put(boolean checkUpdate, KeyAdapter.KEY_CASE keyCase, String key, Object value) {
        KeyAdapter keyAdapter = this.keyAdapter;
        if (null != keyCase) {
            keyAdapter = KeyAdapter.parse(keyCase);
        }
        if (null != key) {
            if (keyAdapter.getKeyCase() != KeyAdapter.KEY_CASE.SRC) {
                key = keyAdapter.key(key);
            }
            boolean ignore = false;
            if (checkUpdate) {
                if (key.startsWith("+")) {
                    key = key.substring(1);
                    this.addUpdateColumns(key);
                } else if (key.startsWith("-")) {
                    key = key.substring(1);
                    this.addIgnoreColumns(key);
                    ignore = true;
                }
                Object oldValue = this.get(keyCase, key);
                if (null == oldValue || !oldValue.equals(value)) {
                    super.put(key, value);
                }
                if (null == value) {
                    if (this.isInsertNullColumn() || this.isUpdateNullColumn()) {
                        this.addUpdateColumns(key);
                    }
                } else if (BasicUtil.isEmpty(true, value)) {
                    if (this.isInsertEmptyColumn() || this.isUpdateEmptyColumn()) {
                        this.addUpdateColumns(key);
                    }
                } else if (!ignore && !BasicUtil.equals(oldValue, value)) {
                    this.addUpdateColumns(key);
                }
            } else {
                super.put(key, value);
            }
            if (ConfigTable.IS_KEY_IGNORE_CASE) {
                String ignoreKey = key.replace("_", "").replace("-", "").toUpperCase();
                this.keymap.put(ignoreKey, key);
            }
        }
        return this;
    }

    public DataRow put(boolean checkUpdate, KeyAdapter.KEY_CASE keyCase, String key, Object value, boolean pk, boolean override) {
        if (pk) {
            if (override) {
                this.primaryKeys.clear();
            }
            this.addPrimaryKey(key);
        }
        this.put(checkUpdate, keyCase, key, value);
        return this;
    }

    public DataRow put(KeyAdapter.KEY_CASE keyCase, String key, Object value, boolean pk, boolean override) {
        return this.put(true, keyCase, key, value, pk, override);
    }

    public DataRow put(String key, Object value, boolean pk, boolean override) {
        return this.put(null, key, value, pk, override);
    }

    public DataRow put(KeyAdapter.KEY_CASE keyCase, String key, Object value, boolean pk) {
        this.put(keyCase, key, value, pk, true);
        return this;
    }

    public DataRow put(String key, Object value, boolean pk) {
        this.put(null, key, value, pk, true);
        return this;
    }

    public DataRow put(String key) {
        DataRow row = new DataRow(this.keyCase);
        this.put(key, (Object)row);
        return row;
    }

    public DataSet puts(String key) {
        DataSet set = new DataSet();
        this.put(key, (Object)set);
        return set;
    }

    @Override
    public Object put(String key, Object value) {
        this.put(null, key, value, false, true);
        return this;
    }

    public DataRow set(String key, Object value) {
        this.put(null, key, value, false, true);
        return this;
    }

    public DataRow putWithoutNull(String key, Object value) {
        if (null != value) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow putWithoutEmpty(String key, Object value) {
        if (BasicUtil.isNotEmpty(value)) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow putIfEmpty(String key, Object value) {
        if (this.isEmpty(key)) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow putIfNull(String key, Object value) {
        if (this.isNull(key)) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow attr(String key, Object value) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        this.attributes.put(key, value);
        return this;
    }

    public DataRow setAttribute(String key, Object value) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        this.attributes.put(key, value);
        return this;
    }

    public Object attr(String key) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        return this.attributes.get(key);
    }

    public Object getAttribute(String key) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        return this.attributes.get(key);
    }

    public DataRow tag(String key, Object value) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        this.tags.put(key, value);
        return this;
    }

    public DataRow setTag(String key, Object value) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        this.tags.put(key, value);
        return this;
    }

    public Object tag(String key) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        return this.tags.get(key);
    }

    public Object getTag(String key) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        return this.tags.get(key);
    }

    public Map<String, Object> getTags() {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        return this.tags;
    }

    public DataRow getRow(String key) {
        if (null == key) {
            if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
                return new DataRow();
            }
            return null;
        }
        Object obj = this.get(key);
        if (null != obj) {
            if (obj instanceof DataRow) {
                return (DataRow)obj;
            }
            if (obj instanceof String) {
                try {
                    return DataRow.parseJson(obj.toString());
                }
                catch (Exception e) {
                    log.warn("{}>{}\u8f6c\u6362\u6210DataRow\u5931\u8d25", (Object)key, obj);
                }
            } else if (obj instanceof Map) {
                return new DataRow((Map)obj);
            }
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    public Point getPoint(String key) {
        if (null == key) {
            if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
                return new Point();
            }
            return null;
        }
        Object obj = this.get(key);
        if (null != obj && obj instanceof Point) {
            return (Point)obj;
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new Point();
        }
        return null;
    }

    public DataRow getRow(String ... keys) {
        if (null == keys || keys.length == 0) {
            if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
                return new DataRow();
            }
            return null;
        }
        DataRow result = this;
        for (String key : keys) {
            if (null == result) {
                if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
                    return new DataRow();
                }
                return null;
            }
            result = result.getRow(key);
        }
        if (null == result && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return result;
    }

    public DataSet getSet(String key) {
        Object obj;
        DataSet set = null;
        if (null != key && null != (obj = this.get(key))) {
            if (obj instanceof DataSet) {
                set = (DataSet)obj;
            } else if (obj instanceof List) {
                List list = (List)obj;
                set = new DataSet();
                for (Object item : list) {
                    set.add(DataRow.parse(item, new String[0]));
                }
            } else if (obj instanceof String) {
                set = DataSet.parseJson((String)obj);
            }
        }
        if (null == set && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            set = new DataSet();
        }
        return set;
    }

    public List<?> getList(String key) {
        if (null == key) {
            return null;
        }
        Object obj = this.get(key);
        if (null != obj) {
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj instanceof DataSet) {
                return ((DataSet)obj).getRows();
            }
        }
        return null;
    }

    public String getStringNvl(String key, String ... defs) {
        String result = this.getString(key);
        if (null == result) {
            result = null == defs || defs.length == 0 ? "" : BasicUtil.nvl(defs).toString();
        }
        return result;
    }

    public String getStringEvl(String key, String ... defs) {
        String result = this.getString(key);
        if (BasicUtil.isEmpty((Object)result)) {
            result = null == defs || defs.length == 0 ? "" : BasicUtil.evl(defs).toString();
        }
        return result;
    }

    public String getStringWithoutEmpty(String ... keys) {
        if (null == keys) {
            return null;
        }
        String result = null;
        for (String key : keys) {
            if (null == key) continue;
            if (key.contains("${") && key.contains("}")) {
                result = BeanUtil.parseFinalValue(this, key);
            } else {
                if (!this.contains(key)) continue;
                Object value = this.get(key);
                if (null != value) {
                    result = value instanceof byte[] ? new String((byte[])value) : value.toString();
                }
            }
            if (BasicUtil.isNotEmpty(result)) break;
        }
        return result;
    }

    public String getStringWithoutNull(String ... keys) {
        if (null == keys) {
            return null;
        }
        String result = null;
        for (String key : keys) {
            if (null == key) continue;
            if (key.contains("${") && key.contains("}")) {
                result = BeanUtil.parseFinalValue(this, key);
            } else {
                if (!this.contains(key)) continue;
                Object value = this.get(key);
                if (null != value) {
                    result = value instanceof byte[] ? new String((byte[])value) : value.toString();
                }
            }
            if (null != result) break;
        }
        return result;
    }

    public String getString(String ... keys) {
        if (null == keys) {
            return null;
        }
        String result = null;
        for (String key : keys) {
            if (null == key) continue;
            if (key.contains("${") && key.contains("}")) {
                result = BeanUtil.parseFinalValue(this, key);
                break;
            }
            if (!this.contains(key)) continue;
            Object value = this.get(key);
            if (null == value) break;
            if (value instanceof byte[]) {
                result = new String((byte[])value);
                break;
            }
            result = value.toString();
            break;
        }
        return result;
    }

    public String key(int index) {
        List<String> keys = this.keys();
        if (index < keys.size()) {
            return keys.get(index);
        }
        return null;
    }

    public String getString(int index) {
        return this.getString(this.key(index));
    }

    public String getString(String key) {
        Object value;
        if (null == key) {
            return null;
        }
        String result = null;
        if (key.contains("${") && key.contains("}")) {
            result = BeanUtil.parseFinalValue(this, key);
        } else if (this.contains(key) && null != (value = this.get(key))) {
            result = value instanceof byte[] ? new String((byte[])value) : value.toString();
        }
        if (null == result && ConfigTable.IS_RETURN_EMPTY_STRING_REPLACE_NULL) {
            result = "";
        }
        return result;
    }

    public Integer getInt(String ... keys) throws Exception {
        Object val = this.get(keys);
        if (val instanceof Boolean) {
            boolean bol = (Boolean)val;
            if (bol) {
                return 1;
            }
            return 0;
        }
        Double dbl = this.getDouble(keys);
        if (null != dbl) {
            return dbl.intValue();
        }
        return null;
    }

    public Integer getInt(int index) throws Exception {
        return this.getInt(this.key(index));
    }

    public Integer getInt(String key) throws Exception {
        Object val = this.get(key);
        if (val instanceof Boolean) {
            boolean bol = (Boolean)val;
            if (bol) {
                return 1;
            }
            return 0;
        }
        Double dbl = this.getDouble(key);
        if (null != dbl) {
            return dbl.intValue();
        }
        return null;
    }

    public Integer getInt(int index, Integer def) {
        return this.getInt(this.key(index), def);
    }

    public Integer getInt(String key, Integer def) {
        try {
            Integer result = this.getInt(key);
            if (null == result) {
                result = def;
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Integer getInt(Integer def, String ... keys) {
        Integer result = null;
        for (String key : keys) {
            result = this.getInt(key, (Integer)null);
            if (null == result) continue;
            return result;
        }
        return def;
    }

    public Double getDouble(String ... keys) throws Exception {
        Object value = this.get(keys);
        if (null != value) {
            return Double.parseDouble(value.toString());
        }
        return null;
    }

    public Double getDouble(int index) throws Exception {
        return this.getDouble(this.key(index));
    }

    public Double getDouble(String key) throws Exception {
        Object value = this.get(key);
        if (null != value) {
            return Double.parseDouble(value.toString());
        }
        return null;
    }

    public Double getDouble(int index, Double def) {
        return this.getDouble(this.key(index), def);
    }

    public Double getDouble(String key, Double def) {
        try {
            Double dbl = this.getDouble(key);
            if (null == dbl) {
                return def;
            }
            return dbl;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Double getDouble(int index, Integer def) {
        return this.getDouble(this.key(index), def);
    }

    public Double getDouble(String key, Integer def) {
        if (null == def) {
            return this.getDouble(key, (Double)null);
        }
        return this.getDouble(key, (Double)def.doubleValue());
    }

    public Long getLong(String ... keys) throws Exception {
        Object value = this.get(keys);
        return BasicUtil.parseLong(value);
    }

    public Long getLong(int index) throws Exception {
        return this.getLong(this.key(index));
    }

    public Long getLong(String key) throws Exception {
        Object value = this.get(key);
        return BasicUtil.parseLong(value);
    }

    public Long getLong(int index, Long def) {
        return this.getLong(this.key(index), def);
    }

    public Long getLong(String key, Long def) {
        try {
            Long result = this.getLong(key);
            if (null == result) {
                result = def;
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Long getLong(int index, Integer def) {
        return this.getLong(this.key(index), def);
    }

    public Long getLong(String key, Integer def) {
        if (null == def) {
            return this.getLong(key, (Long)null);
        }
        return this.getLong(key, (Long)def.longValue());
    }

    public Float getFloat(String ... keys) throws Exception {
        Object value = this.get(keys);
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    public Float getFloat(int index) throws Exception {
        return this.getFloat(this.key(index));
    }

    public Float getFloat(String key) throws Exception {
        Object value = this.get(key);
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    public Float getFloat(int index, Float def) {
        return this.getFloat(this.key(index), def);
    }

    public Float getFloat(String key, Float def) {
        try {
            Float result = this.getFloat(key);
            if (null == result) {
                result = def;
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Float getFloat(int index, Integer def) {
        return this.getFloat(this.key(index), def);
    }

    public Float getFloat(String key, Integer def) {
        if (null == def) {
            return this.getFloat(key, (Float)null);
        }
        return this.getFloat(key, Float.valueOf(def.floatValue()));
    }

    public Boolean getBoolean(int index, Boolean def) {
        return this.getBoolean(this.key(index), def);
    }

    public Boolean getBoolean(String key, Boolean def) {
        return BasicUtil.parseBoolean(this.getString(key), def);
    }

    public Boolean getBoolean(String ... keys) throws Exception {
        return BasicUtil.parseBoolean(this.getString(keys));
    }

    public Boolean getBoolean(int index) throws Exception {
        return this.getBoolean(this.key(index));
    }

    public Boolean getBoolean(String key) throws Exception {
        return BasicUtil.parseBoolean(this.getString(key));
    }

    public BigDecimal getDecimal(String ... keys) throws Exception {
        return new BigDecimal(this.getString(keys));
    }

    public BigDecimal getDecimal(int index) throws Exception {
        return this.getDecimal(this.key(index));
    }

    public BigDecimal getDecimal(String key) throws Exception {
        return new BigDecimal(this.getString(key));
    }

    public BigDecimal getDecimal(int index, Double def) {
        return this.getDecimal(this.key(index), def);
    }

    public BigDecimal getDecimal(String key, Double def) {
        return this.getDecimal(key, new BigDecimal(def));
    }

    public BigDecimal getDecimal(int index, Integer def) {
        return this.getDecimal(this.key(index), def);
    }

    public BigDecimal getDecimal(String key, Integer def) {
        return this.getDecimal(key, new BigDecimal(def));
    }

    public BigDecimal getDecimal(int index, BigDecimal def) {
        return this.getDecimal(this.key(index), def);
    }

    public BigDecimal getDecimal(String key, BigDecimal def) {
        try {
            BigDecimal result = this.getDecimal(key);
            if (null == result) {
                return def;
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public String getDecimal(String key, String format) throws Exception {
        BigDecimal result = this.getDecimal(key);
        return NumberUtil.format(result, format);
    }

    public String getDecimal(int index, String format) throws Exception {
        return this.getDecimal(this.key(index), format);
    }

    public String getDecimal(String key, double def, String format) {
        return this.getDecimal(key, new BigDecimal(def), format);
    }

    public String getDecimal(int index, double def, String format) {
        return this.getDecimal(this.key(index), def, format);
    }

    public String getDecimal(int index, BigDecimal def, String format) {
        return this.getDecimal(this.key(index), def, format);
    }

    public String getDecimal(String key, BigDecimal def, String format) {
        BigDecimal result = null;
        try {
            result = this.getDecimal(key);
            if (null == result) {
                result = def;
            }
        }
        catch (Exception e) {
            result = def;
        }
        return NumberUtil.format(result, format);
    }

    public java.util.Date getDate(int index, java.util.Date def) {
        return this.getDate(this.key(index), def);
    }

    public java.util.Date getDate(String key, java.util.Date def) {
        java.util.Date result = def;
        Object date = this.get(key);
        if (null == date) {
            return result;
        }
        result = date instanceof java.util.Date ? (java.util.Date)date : DateUtil.parse(date, def);
        if (null == result) {
            result = def;
        }
        return result;
    }

    public java.util.Date getDate(int index, String def) throws Exception {
        return this.getDate(this.key(index), def);
    }

    public java.util.Date getDate(String key, String def) throws Exception {
        try {
            return this.getDate(key);
        }
        catch (Exception e) {
            return DateUtil.parse(def);
        }
    }

    public java.util.Date getDate(String ... keys) throws Exception {
        return DateUtil.parse(this.get(keys));
    }

    public java.util.Date getDate(int index) throws Exception {
        return this.getDate(this.key(index));
    }

    public java.util.Date getDate(String key) throws Exception {
        return DateUtil.parse(this.get(key));
    }

    public byte[] getBytes(int index) {
        return this.getBytes(this.key(index));
    }

    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    public DataRow ellipsis(int length, String ... columns) {
        for (String column : columns) {
            String value = this.getString(column);
            if (null == value) continue;
            value = BasicUtil.ellipsis(length, value);
            this.put(column, (Object)value);
        }
        return this;
    }

    public DataSet toSet(String key, String value) {
        DataSet set = new DataSet();
        for (String k : this.keySet()) {
            DataRow row = new DataRow();
            row.put(key, (Object)k);
            row.put(value, this.get(k));
            set.add(row);
        }
        return set;
    }

    @Override
    public String toJSON() {
        return BeanUtil.map2json(this);
    }

    public String toJson() {
        return this.toJSON();
    }

    public String getJson() {
        return BeanUtil.map2json(this);
    }

    public String toJSON(JsonInclude.Include include) {
        return BeanUtil.map2json(this, include);
    }

    public String toJson(JsonInclude.Include include) {
        return this.toJSON(include);
    }

    public String getJson(JsonInclude.Include include) {
        return BeanUtil.map2json(this, include);
    }

    public DataRow removeEmpty(String ... keys) {
        return this.removeEmpty(false, keys);
    }

    public DataRow removeEmpty(boolean recursion, String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                if (!this.isEmpty(recursion, key)) continue;
                this.remove(key);
            }
        } else {
            List<String> cols = this.keys();
            for (String key : cols) {
                if (!this.isEmpty(recursion, key)) continue;
                this.remove(key);
            }
        }
        return this;
    }

    public DataRow removeNull(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                if (null != this.get(key)) continue;
                this.remove(key);
            }
        }
        List<String> cols = this.keys();
        for (String key : cols) {
            if (null != this.get(key)) continue;
            this.remove(key);
        }
        return this;
    }

    public boolean equals(DataRow row, String ... columns) {
        if (null == row || null == columns || columns.length == 0) {
            return false;
        }
        for (String column : columns) {
            String v2;
            String v1 = this.getString(column);
            if (BasicUtil.equals(v1, v2 = row.getString(column))) continue;
            return false;
        }
        return true;
    }

    public String toXML() {
        return BeanUtil.map2xml(this);
    }

    public String toXML(boolean border, boolean order) {
        return BeanUtil.map2xml(this, border, order);
    }

    public boolean hasContainer() {
        return null != this.getContainer();
    }

    public DataSet getContainer() {
        return this.container;
    }

    public DataRow setContainer(DataSet container) {
        this.container = container;
        return this;
    }

    public Catalog getCatalog() {
        if (null != this.catalog) {
            return this.catalog;
        }
        DataSet container = this.getContainer();
        if (null != container) {
            return container.getCatalog();
        }
        return null;
    }

    public String getCatalogName() {
        if (null != this.catalog) {
            return this.catalog.getName();
        }
        DataSet container = this.getContainer();
        if (null != container) {
            return container.getCatalogName();
        }
        return null;
    }

    public DataRow setCatalog(String catalog) {
        this.catalog = BasicUtil.isNotEmpty(catalog) ? new Catalog(catalog) : null;
        return this;
    }

    public DataRow setCatalog(Catalog catalog) {
        this.catalog = catalog;
        return this;
    }

    public Schema getSchema() {
        if (null != this.schema) {
            return this.schema;
        }
        DataSet container = this.getContainer();
        if (null != container) {
            return container.getSchema();
        }
        return null;
    }

    public String getSchemaName() {
        if (null != this.schema) {
            return this.schema.getName();
        }
        DataSet container = this.getContainer();
        if (null != container) {
            return container.getSchemaName();
        }
        return null;
    }

    public DataRow setSchema(String schema) {
        this.schema = BasicUtil.isNotEmpty(schema) ? new Schema(schema) : null;
        return this;
    }

    public DataRow setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Table getTable() {
        return this.getTable(true);
    }

    public Table getTable(boolean checkContainer) {
        if (null != this.tables && !this.tables.isEmpty()) {
            return this.tables.values().iterator().next();
        }
        if (checkContainer) {
            DataSet container = this.getContainer();
            if (null != container) {
                return container.getTable(false);
            }
            return null;
        }
        return null;
    }

    public String getTableName() {
        Table table = this.getTable();
        if (null != table) {
            return table.getName();
        }
        return null;
    }

    public String getDest() {
        Object dest = null;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        String tableName = this.getTableName();
        if (BasicUtil.isNotEmpty(catalogName)) {
            dest = catalogName;
        }
        if (BasicUtil.isNotEmpty(schemaName)) {
            dest = null == dest ? schemaName : (String)dest + "." + schemaName;
        }
        if (BasicUtil.isNotEmpty(tableName)) {
            dest = null == dest ? tableName : (String)dest + "." + tableName;
        }
        if (null == dest && null != this.container) {
            dest = this.container.getDest();
        }
        return dest;
    }

    public DataRow setTable(Table table) {
        this.tables = new LinkedHashMap();
        this.addTable(table);
        return this;
    }

    public LinkedHashMap<String, Table> getTables() {
        return this.getTables(true);
    }

    public LinkedHashMap<String, Table> getTables(boolean checkContainer) {
        if (null != this.tables && !this.tables.isEmpty()) {
            return this.tables;
        }
        if (checkContainer) {
            DataSet container = this.getContainer();
            if (null != container) {
                return container.getTables(false);
            }
            return this.tables;
        }
        return this.tables;
    }

    public DataRow setTables(List<Table> tables) {
        this.tables = new LinkedHashMap();
        for (Table table : tables) {
            this.addTable(table);
        }
        return this;
    }

    public DataRow setTables(LinkedHashMap<String, Table> tables) {
        this.tables = tables;
        return this;
    }

    public DataRow addTable(Table table) {
        String name;
        if (null == this.tables) {
            this.tables = new LinkedHashMap();
        }
        if (null != table && null != (name = table.getName())) {
            this.tables.put(name.toUpperCase(), table);
        }
        return this;
    }

    public DataRow setTable(String table) {
        this.setDest(table);
        return this;
    }

    public boolean isExpire(int millisecond) {
        return System.currentTimeMillis() - this.createTime > (long)millisecond;
    }

    public boolean isExpire(long millisecond) {
        return System.currentTimeMillis() - this.createTime > millisecond;
    }

    public boolean isExpire() {
        if (this.getExpires() == -1L) {
            return false;
        }
        return System.currentTimeMillis() - this.createTime > this.getExpires();
    }

    @Override
    public Object clone() {
        DataRow row = (DataRow)super.clone();
        row.container = this.container;
        row.primaryKeys = this.primaryKeys;
        row.dataSource = this.dataSource;
        row.schema = this.schema;
        row.tables = this.tables;
        row.createTime = this.createTime;
        row.nanoTime = this.nanoTime;
        row.isNew = this.isNew;
        return row;
    }

    public Boolean getIsNew() {
        return this.isNew;
    }

    public DataRow setIsNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public List<String> getUpdateColumns() {
        return this.updateColumns;
    }

    public LinkedHashMap<String, Column> getUpdateColumns(boolean metadata) {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        if (null != this.updateColumns) {
            for (String column : this.updateColumns) {
                Column col = null;
                if (null != this.metadatas) {
                    col = this.metadatas.get(column.toUpperCase());
                }
                if (null == col) {
                    col = new Column(column);
                }
                columns.put(column.toUpperCase(), col);
            }
        }
        return columns;
    }

    public LinkedHashMap<String, Column> getColumns() {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        for (String key : this.keySet()) {
            Column column = null;
            if (null != this.metadatas) {
                column = this.metadatas.get(key.toUpperCase());
            }
            if (null == column) {
                column = new Column(key);
            }
            columns.put(key.toUpperCase(), column);
        }
        return columns;
    }

    public List<String> getIgnoreUpdateColumns() {
        return this.ignoreUpdateColumns;
    }

    public DataRow removes(String ... keys) {
        if (null != keys) {
            for (String key : keys) {
                if (null == key) continue;
                key = this.keyAdapter.key(key);
                super.remove(key);
                this.updateColumns.remove(key);
            }
        }
        return this;
    }

    public DataRow removes(List<String> keys) {
        if (null != keys) {
            for (String key : keys) {
                if (null == key) continue;
                key = this.keyAdapter.key(key);
                super.remove(key);
                this.updateColumns.remove(key);
            }
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        if (null == key) {
            return null;
        }
        this.updateColumns.remove(this.keyAdapter.key(key.toString()));
        return super.remove(this.keyAdapter.key(key.toString()));
    }

    public DataRow clearUpdateColumns() {
        this.updateColumns.clear();
        return this;
    }

    public DataRow clearIgnoreUpdateColumns() {
        this.ignoreUpdateColumns.clear();
        return this;
    }

    public DataRow removeUpdateColumns(String ... cols) {
        if (null != cols) {
            for (String col : cols) {
                String key = this.keyAdapter.key(col);
                this.updateColumns.remove(key);
                this.ignoreUpdateColumns.add(key);
            }
        }
        return this;
    }

    public DataRow addUpdateColumns(String ... cols) {
        if (null != cols) {
            for (String col : cols) {
                String key = this.keyAdapter.key(col);
                if (this.updateColumns.contains(key)) continue;
                this.updateColumns.add(key);
                this.ignoreUpdateColumns.remove(key);
            }
        }
        return this;
    }

    public DataRow addIgnoreColumns(String ... cols) {
        if (null != cols) {
            for (String col : cols) {
                String key = this.keyAdapter.key(col);
                if (this.ignoreUpdateColumns.contains(key)) continue;
                this.ignoreUpdateColumns.add(key);
                this.updateColumns.remove(key);
            }
        }
        return this;
    }

    public DataRow addAllUpdateColumns() {
        this.updateColumns.clear();
        this.updateColumns.addAll(this.keys());
        this.ignoreUpdateColumns.clear();
        return this;
    }

    public DataRow copy(boolean regex, DataRow data, String[] fixs, String ... keys) {
        return this.copy(data, BeanUtil.array2list(fixs, keys), new String[0]);
    }

    public DataRow copy(boolean regex, DataRow data, String ... keys) {
        if (null == data) {
            return this;
        }
        if (null == keys || keys.length == 0) {
            return this.copy(data, data.keys(), new String[0]);
        }
        return this.copy(data, BeanUtil.array2list(new String[][]{keys}), new String[0]);
    }

    public DataRow copy(boolean regex, DataRow data, List<String> fixs, String ... keys) {
        if (null == data || data.isEmpty()) {
            return this;
        }
        List<String> list = BeanUtil.merge(fixs, keys);
        for (String key : list) {
            String[] ks = BeanUtil.parseKeyValue(key);
            if (null != ks && ks.length > 1) {
                this.put(ks[0], data.get(ks[1]));
                continue;
            }
            this.put(key, data.get(key));
        }
        return this;
    }

    public DataRow copy(DataRow data, String[] fixs, String ... keys) {
        return this.copy(false, data, fixs, keys);
    }

    public DataRow copy(DataRow data, String ... keys) {
        return this.copy(false, data, keys);
    }

    public DataRow copy(DataRow data, List<String> fixs, String ... keys) {
        return this.copy(false, data, fixs, keys);
    }

    public DataRow extract(boolean regex, String ... keys) {
        DataRow result = new DataRow();
        result.copy(regex, this, keys);
        return result;
    }

    public DataRow extract(boolean regex, List<String> keys) {
        DataRow result = new DataRow();
        result.copy(regex, this, keys, new String[0]);
        return result;
    }

    public DataRow extract(String ... keys) {
        return this.extract(false, keys);
    }

    public DataRow extract(List<String> keys) {
        return this.extract(false, keys);
    }

    public DataRow copyString(DataRow data, String ... keys) {
        if (null == data || null == keys) {
            return this;
        }
        for (String key : keys) {
            String[] ks = BeanUtil.parseKeyValue(key);
            Object obj = data.get(ks[1]);
            if (BasicUtil.isNotEmpty(obj)) {
                this.put(ks[0], (Object)obj.toString());
                continue;
            }
            this.put(ks[0], (Object)null);
        }
        return this;
    }

    public List<String> numberKeys() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> keys = this.keys();
        for (String key : keys) {
            if (!(this.get(key) instanceof Number)) continue;
            result.add(key);
        }
        return result;
    }

    public boolean checkRequired(String ... keys) {
        ArrayList<String> ks = new ArrayList<String>();
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                ks.add(key);
            }
        }
        return this.checkRequired(ks);
    }

    public boolean checkRequired(List<String> keys) {
        if (null != keys) {
            for (String key : keys) {
                if (!this.isEmpty(key)) continue;
                return false;
            }
        }
        return true;
    }

    public DataRow camel_() {
        List<String> keys = this.keys();
        for (String key : keys) {
            Object value = this.get(key);
            String camel_ = BeanUtil.camel_(key);
            this.updateColumns.remove(key);
            super.remove(key);
            this.put(KeyAdapter.KEY_CASE.SRC, camel_, value);
        }
        this.setKeyCase(KeyAdapter.KEY_CASE.SRC);
        return this;
    }

    public DataRow camel() {
        return this.camel(false);
    }

    public DataRow camel(boolean lower) {
        if (lower) {
            this.toLowerKey(new String[0]);
        }
        List<String> keys = this.keys();
        for (String key : keys) {
            Object value = this.get(key);
            String camel = BeanUtil.camel(key);
            this.updateColumns.remove(key);
            super.remove(key);
            this.put(KeyAdapter.KEY_CASE.SRC, camel, value);
        }
        this.setKeyCase(KeyAdapter.KEY_CASE.camel);
        return this;
    }

    public DataRow Camel() {
        List<String> keys = this.keys();
        for (String key : keys) {
            Object value = this.get(key);
            String Camel = BeanUtil.Camel(key);
            this.updateColumns.remove(key);
            super.remove(key);
            this.put(KeyAdapter.KEY_CASE.SRC, Camel, value);
        }
        this.setKeyCase(KeyAdapter.KEY_CASE.Camel);
        return this;
    }

    protected static String getKeyCase(KeyAdapter.KEY_CASE keyCase, String key) {
        if (null == key || keyCase == KeyAdapter.KEY_CASE.SRC) {
            return key;
        }
        if (keyCase == KeyAdapter.KEY_CASE.LOWER) {
            key = key.toLowerCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.UPPER) {
            key = key.toUpperCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.Camel) {
            key = BeanUtil.Camel(key);
        } else if (keyCase == KeyAdapter.KEY_CASE.camel) {
            key = BeanUtil.camel(key);
        }
        return key;
    }

    public static String getKeyCase(String key) {
        return DataRow.getKeyCase(KeyAdapter.KEY_CASE.CONFIG, key);
    }

    protected static String putKeyCase(KeyAdapter.KEY_CASE keyCase, String key) {
        if (null == key || keyCase == KeyAdapter.KEY_CASE.SRC) {
            return key;
        }
        if (keyCase == KeyAdapter.KEY_CASE.UPPER) {
            key = key.toUpperCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.LOWER) {
            key = key.toLowerCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.Camel) {
            key = BeanUtil.Camel(key);
        } else if (keyCase == KeyAdapter.KEY_CASE.camel) {
            key = BeanUtil.camel(key);
        } else if (keyCase.getCode().contains("_")) {
            key = BeanUtil.camel_(key);
            if (keyCase == KeyAdapter.KEY_CASE.CAMEL_CONFIG) {
                if (ConfigTable.IS_UPPER_KEY) {
                    key = key.toUpperCase();
                }
                if (ConfigTable.IS_LOWER_KEY) {
                    key = key.toLowerCase();
                }
            } else if (keyCase == KeyAdapter.KEY_CASE.CAMEL_LOWER) {
                key = key.toLowerCase();
            } else if (keyCase == KeyAdapter.KEY_CASE.CAMEL_UPPER) {
                key = key.toUpperCase();
            }
        }
        return key;
    }

    public static String putKeyCase(String key) {
        return DataRow.putKeyCase(KeyAdapter.KEY_CASE.CONFIG, key);
    }

    public boolean isUpdateNullColumn() {
        return this.updateNullColumn;
    }

    public DataRow setUpdateNullColumn(boolean updateNullColumn) {
        this.updateNullColumn = updateNullColumn;
        return this;
    }

    public boolean isUpdateEmptyColumn() {
        return this.updateEmptyColumn;
    }

    public DataRow setUpdateEmptyColumn(boolean updateEmptyColumn) {
        this.updateEmptyColumn = updateEmptyColumn;
        return this;
    }

    public boolean isInsertNullColumn() {
        return this.insertNullColumn;
    }

    public void setInsertNullColumn(boolean insertNullColumn) {
        this.insertNullColumn = insertNullColumn;
    }

    public boolean isInsertEmptyColumn() {
        return this.insertEmptyColumn;
    }

    public boolean isReplaceEmptyNull() {
        return this.replaceEmptyNull;
    }

    public void setInsertEmptyColumn(boolean insertEmptyColumn) {
        this.insertEmptyColumn = insertEmptyColumn;
    }

    public DataRow changeKey(String key, String target, boolean remove) {
        if (null == key || null == target) {
            return this;
        }
        if (this.keyAdapter.key(key).equals(this.keyAdapter.key(target))) {
            return this;
        }
        this.put(target, this.get(key));
        if (remove && !target.equalsIgnoreCase(key)) {
            this.remove(this.keyAdapter.key(key));
        }
        return this;
    }

    public DataRow changeKey(String key, String target) {
        return this.changeKey(key, target, true);
    }

    public DataRow replaceEmpty(String value) {
        List<String> keys = this.keys();
        for (String key : keys) {
            if (!this.isEmpty(key)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)value);
        }
        return this;
    }

    public DataRow trim() {
        List<String> keys = this.keys();
        for (String key : keys) {
            Object value = this.get(key);
            if (!(value instanceof String)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)((String)value).trim());
        }
        return this;
    }

    public DataRow trim(String ... keys) {
        for (String key : keys) {
            Object value = this.get(key);
            if (!(value instanceof String)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)((String)value).trim());
        }
        return this;
    }

    public DataRow compress() {
        for (String key : this.keySet()) {
            Object value = this.get(key);
            if (!(value instanceof String)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)BasicUtil.compress((String)value));
        }
        return this;
    }

    public DataRow compress(String ... keys) {
        for (String key : keys) {
            Object value = this.get(key);
            if (!(value instanceof String)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)BasicUtil.compress((String)value));
        }
        return this;
    }

    public DataRow sbc2dbc() {
        for (String key : this.keySet()) {
            Object value = this.get(key);
            if (!(value instanceof String)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)CharUtil.sbc2dbc((String)value));
        }
        return this;
    }

    public DataRow sbc2dbc(String ... keys) {
        for (String key : keys) {
            Object value = this.get(key);
            if (!(value instanceof String)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)CharUtil.sbc2dbc((String)value));
        }
        return this;
    }

    public DataRow replaceEmpty(String replace, String ... keys) {
        List<String> ks = null;
        ks = null == keys || keys.length == 0 ? this.keys() : BeanUtil.array2list(new String[][]{keys});
        for (String key : ks) {
            if (!this.isEmpty(key)) continue;
            this.put(key, (Object)replace);
        }
        return this;
    }

    public DataRow replaceNull(String replace, String ... keys) {
        List<String> ks = null;
        ks = null == keys || keys.length == 0 ? this.keys() : BeanUtil.array2list(new String[][]{keys});
        for (String key : ks) {
            if (null != this.get(key)) continue;
            this.put(key, (Object)replace);
        }
        return this;
    }

    public DataRow replaces(String oldChar, String replace, String ... keys) {
        List<String> ks = null;
        ks = null == keys || keys.length == 0 ? this.keys() : BeanUtil.array2list(new String[][]{keys});
        if (null == replace) {
            replace = "";
        }
        for (String key : ks) {
            Object value = this.get(key);
            if (value == null || !(value instanceof String)) continue;
            this.put(key, (Object)((String)value).replace(oldChar, replace));
        }
        return this;
    }

    public DataRow replaces(boolean regex, String oldChar, String replace, String ... keys) {
        if (regex) {
            return this.replaceRegex(oldChar, replace, keys);
        }
        return this.replaces(oldChar, replace, keys);
    }

    public DataRow replaceRegex(String regex, String replace, String ... keys) {
        List<String> ks = null;
        ks = null == keys || keys.length == 0 ? this.keys() : BeanUtil.array2list(new String[][]{keys});
        if (null == replace) {
            replace = "";
        }
        for (String key : ks) {
            Object value = this.get(key);
            if (value == null || !(value instanceof String)) continue;
            this.put(key, (Object)((String)value).replaceAll(regex, replace));
        }
        return this;
    }

    public String join(String ... keys) {
        Object result = "";
        if (null != keys) {
            for (String key : keys) {
                String val = this.getString(key);
                if (!BasicUtil.isNotEmpty(val)) continue;
                result = ((String)result).isEmpty() ? val : (String)result + "," + val;
            }
        }
        return result;
    }

    public DataRow convertDate(String ... keys) {
        java.util.Date def = null;
        return this.convertDate(def, keys);
    }

    public DataRow convertDate(java.util.Date def, String ... keys) {
        if (null == keys || keys.length == 0) {
            keys = BeanUtil.list2array(this.keys());
        }
        for (String key : keys) {
            Object v = this.get(key);
            this.remove(this.keyAdapter.key(key));
            java.util.Date result = DateUtil.parse(v, def);
            this.put(key, (Object)result);
        }
        return this;
    }

    public DataRow convertInt(String ... keys) {
        Integer def = null;
        return this.convertInt(def, keys);
    }

    public DataRow convertInt(Integer def, String ... keys) {
        if (null == keys || keys.length == 0) {
            keys = BeanUtil.list2array(this.keys());
        }
        for (String key : keys) {
            Object v = this.get(key);
            this.remove(this.keyAdapter.key(key));
            Integer result = BasicUtil.parseInt(v, def);
            this.put(key, (Object)result);
        }
        return this;
    }

    public DataRow convertLong(String ... keys) {
        Long def = null;
        return this.convertLong(def, keys);
    }

    public DataRow convertLong(Long def, String ... keys) {
        if (null == keys || keys.length == 0) {
            keys = BeanUtil.list2array(this.keys());
        }
        for (String key : keys) {
            Object v = this.get(key);
            this.remove(this.keyAdapter.key(key));
            Long result = BasicUtil.parseLong(v, def);
            this.put(key, (Object)result);
        }
        return this;
    }

    public DataRow convertDouble(String ... keys) {
        Double def = null;
        return this.convertDouble(def, keys);
    }

    public DataRow convertDouble(Double def, String ... keys) {
        if (null == keys || keys.length == 0) {
            keys = BeanUtil.list2array(this.keys());
        }
        for (String key : keys) {
            Object v = this.get(key);
            this.remove(this.keyAdapter.key(key));
            Double result = BasicUtil.parseDouble(v, def);
            this.put(key, (Object)result);
        }
        return this;
    }

    public DataRow convertNumber(String ... keys) {
        if (null == keys || keys.length == 0) {
            keys = BeanUtil.list2array(this.keys());
        }
        for (String key : keys) {
            Object v = this.get(key);
            Number result = null;
            if (null == v || v instanceof Integer || v instanceof Long || v instanceof Short || v instanceof Double || v instanceof Float || v instanceof Byte || v instanceof BigDecimal) continue;
            if (v instanceof java.util.Date) {
                date = (java.util.Date)v;
                result = date.getTime();
            } else if (v instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)v;
                result = timestamp.getTime();
            } else if (v instanceof Date) {
                date = (Date)v;
                result = date.getTime();
            } else if (v instanceof LocalDateTime) {
                result = DateUtil.parse((LocalDateTime)v).getTime();
            } else if (v instanceof LocalDate) {
                result = DateUtil.parse((LocalDate)v).getTime();
            }
            if (null == result) {
                result = new BigDecimal(v.toString());
            }
            this.remove(this.keyAdapter.key(key));
            this.put(key, (Object)result);
        }
        return this;
    }

    public DataRow convertDecimal(BigDecimal def, String ... keys) {
        if (null == keys || keys.length == 0) {
            keys = BeanUtil.list2array(this.keys());
        }
        for (String key : keys) {
            Object v = this.get(key);
            BigDecimal result = null;
            if (null != v) {
                result = BasicUtil.parseDecimal(v, def);
            }
            if (null == result) {
                result = def;
            }
            this.remove(this.keyAdapter.key(key));
            this.put(key, (Object)result);
        }
        return this;
    }

    public DataRow convertString(String ... keys) {
        List<String> list = null;
        list = null == keys || keys.length == 0 ? this.keys() : BeanUtil.array2list(new String[][]{keys});
        for (String key : list) {
            String v = this.getString(key);
            if (null == v) continue;
            this.put(key, (Object)v.toString());
        }
        return this;
    }

    public boolean contains(String key) {
        boolean result = false;
        if (null != key) {
            String ignoreKey;
            String tmp;
            key = this.keyAdapter.key(key);
            if (ConfigTable.IS_KEY_IGNORE_CASE && null != (tmp = this.keymap.get(ignoreKey = key.replace("_", "").replace("-", "").toUpperCase()))) {
                key = tmp;
            }
            result = super.containsKey(key);
        }
        return result;
    }

    public Object get(String ... keys) {
        Object result = null;
        if (null == keys) {
            return result;
        }
        for (String key : keys) {
            if (null == key) continue;
            if (this.keyAdapter.getKeyCase() != KeyAdapter.KEY_CASE.SRC) {
                String ignoreKey;
                String tmp;
                key = this.keyAdapter.key(key);
                if (ConfigTable.IS_KEY_IGNORE_CASE && null != (tmp = this.keymap.get(ignoreKey = key.replace("_", "").replace("-", "").toUpperCase()))) {
                    key = tmp;
                }
            }
            if (!super.containsKey(key)) continue;
            return super.get(key);
        }
        return result;
    }

    public Object get(String key) {
        if (this.keyAdapter.getKeyCase() == KeyAdapter.KEY_CASE.SRC && !ConfigTable.IS_KEY_IGNORE_CASE) {
            return super.get(key);
        }
        Object result = null;
        if (null != key) {
            String ignoreKey;
            String tmp;
            key = this.keyAdapter.key(key);
            if (ConfigTable.IS_KEY_IGNORE_CASE && null != (tmp = this.keymap.get(ignoreKey = key.replace("_", "").replace("-", "").toUpperCase()))) {
                key = tmp;
            }
            result = super.get(key);
        }
        return result;
    }

    public Object get(KeyAdapter.KEY_CASE keyCase, String key) {
        KeyAdapter keyAdapter = this.keyAdapter;
        if (null != keyCase) {
            keyAdapter = KeyAdapter.parse(keyCase);
        }
        Object result = null;
        if (null != key) {
            result = super.get(keyAdapter.key(key));
        }
        return result;
    }

    public Object recursion(boolean strict, String ... keys) {
        if (null == keys || keys.length == 0) {
            return null;
        }
        Object result = this;
        int size = keys.length;
        for (int i = 0; i < size; ++i) {
            Collection list;
            String key = keys[i];
            if (null == result) continue;
            if (result instanceof Collection && (list = (Collection)result).size() > 0) {
                result = list.iterator().next();
            }
            if (ClassUtil.isWrapClass(result) && !(result instanceof String)) {
                result = BeanUtil.getFieldValue(result, key);
                continue;
            }
            if (!strict) {
                return result;
            }
            if (i == size - 1) {
                return result;
            }
            return null;
        }
        return result;
    }

    public Object recursion(String ... keys) {
        return this.recursion(true, keys);
    }

    public Object nvl(String ... keys) {
        return BeanUtil.nvl(this, keys);
    }

    public Object evl(String ... keys) {
        return BeanUtil.evl(this, keys);
    }

    public DataRow add(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) + value));
        return this;
    }

    public DataRow add(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, (Double)0.0) + value));
        return this;
    }

    public DataRow add(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) + value));
        return this;
    }

    public DataRow add(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() + value));
        return this;
    }

    public DataRow add(String target, String key, BigDecimal value) {
        this.put(target, (Object)this.getDecimal(key, (Integer)0).add(value));
        return this;
    }

    public DataRow add(String key, int value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, double value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, short value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, float value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, BigDecimal value) {
        return this.add(key, key, value);
    }

    public DataRow subtract(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) - value));
        return this;
    }

    public DataRow subtract(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, (Double)0.0) - value));
        return this;
    }

    public DataRow subtract(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) - value));
        return this;
    }

    public DataRow subtract(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() - value));
        return this;
    }

    public DataRow subtract(String target, String key, BigDecimal value) {
        this.put(target, (Object)this.getDecimal(key, (Integer)0).subtract(value));
        return this;
    }

    public DataRow subtract(String key, int value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, double value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, short value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, float value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, BigDecimal value) {
        return this.subtract(key, key, value);
    }

    public DataRow multiply(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) * value));
        return this;
    }

    public DataRow multiply(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, (Double)0.0) * value));
        return this;
    }

    public DataRow multiply(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) * value));
        return this;
    }

    public DataRow multiply(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() * value));
        return this;
    }

    public DataRow multiply(String target, String key, BigDecimal value) {
        this.put(target, (Object)this.getDecimal(key, (Integer)0).multiply(value));
        return this;
    }

    public DataRow multiply(String key, int value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, double value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, short value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, float value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, BigDecimal value) {
        return this.multiply(key, key, value);
    }

    public DataRow divide(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) / value));
        return this;
    }

    public DataRow divide(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, (Double)0.0) / value));
        return this;
    }

    public DataRow divide(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, (Integer)0) / value));
        return this;
    }

    public DataRow divide(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() / value));
        return this;
    }

    public DataRow divide(String target, String key, BigDecimal value, int scale, int round) {
        this.put(target, (Object)this.getDecimal(key, (Integer)0).divide(value, scale, round));
        return this;
    }

    public DataRow divide(String target, String key, BigDecimal value, int mode) {
        this.put(target, (Object)this.getDecimal(key, (Integer)0).divide(value, mode));
        return this;
    }

    public DataRow divide(String key, int value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, double value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, short value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, float value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, BigDecimal value, int mode) {
        return this.divide(key, key, value, mode);
    }

    public DataRow round(String target, String key, int scale, int mode) {
        BigDecimal value = this.getDecimal(key, (Integer)0);
        value.setScale(scale, mode);
        this.put(target, (Object)value);
        return this;
    }

    public DataRow round(String key, int scale, int mode) {
        return this.round(key, key, scale, mode);
    }

    @Override
    public String toString() {
        Object result = this.getClass().getSimpleName();
        Object pv = this.getPrimaryValue();
        if (null != pv) {
            result = (String)result + "(" + pv + ")";
        }
        result = (String)result + ":" + this.toJSON();
        return result;
    }

    protected DataRow numberFormat(String src, String tar, String format, String def) {
        if (null == tar || null == src || this.isEmpty(src) || null == format) {
            return this;
        }
        try {
            this.put(tar, (Object)NumberUtil.format(this.getString(src), format));
        }
        catch (Exception e) {
            this.put(tar, (Object)def);
        }
        return this;
    }

    protected DataRow dateFormat(String src, String tar, String format, java.util.Date def) {
        if (null == tar || null == src || this.isEmpty(src) || null == format) {
            return this;
        }
        this.put(tar, (Object)DateUtil.format(this.getDate(src, def), format));
        return this;
    }

    protected DataRow dateFormat(String src, String tar, String format, String def) {
        if (null == tar || null == src || this.isEmpty(src) || null == format) {
            return this;
        }
        try {
            this.put(tar, (Object)DateUtil.format(this.getDate(src), format));
        }
        catch (Exception e) {
            this.put(tar, (Object)def);
        }
        return this;
    }

    protected DataRow dateParse(String src, String tar, String format, java.util.Date def) {
        if (null == tar || null == src || this.isEmpty(src) || null == format) {
            return this;
        }
        Object value = this.get(src);
        java.util.Date date = null;
        date = value instanceof String && null != format ? DateUtil.parse((String)value, format) : DateUtil.parse(value);
        this.put(tar, (Object)date);
        return this;
    }

    protected DataRow numberParse(String src, String tar, String def) {
        BigDecimal result;
        block7: {
            if (null == tar || null == src || this.isEmpty(src)) {
                return this;
            }
            Object value = this.get(src);
            if (null == value) {
                value = def;
            }
            result = null;
            if (null != value) {
                try {
                    if (value instanceof String) {
                        String str = ((String)value).replace(",", "");
                        result = new BigDecimal(str);
                    } else {
                        result = BasicUtil.parseDecimal(value, null);
                    }
                }
                catch (Exception e) {
                    if (null == def) break block7;
                    result = new BigDecimal(def);
                }
            }
        }
        this.put(tar, (Object)result);
        return this;
    }

    public class Format
    implements Serializable {
        public DataRow date(String format, String ... cols) {
            if (null == cols || BasicUtil.isEmpty((Object)format)) {
                return DataRow.this;
            }
            String[] stringArray = cols;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String col;
                String src = col = stringArray[i];
                String tar = col;
                String def = "";
                if (col.contains(":")) {
                    String[] tmps = col.split(":");
                    if (tmps.length >= 2) {
                        src = tmps[0];
                        tar = tmps[1];
                    }
                    if (tmps.length > 2) {
                        def = tmps[2];
                    }
                }
                DataRow.this.dateFormat(tar, src, format, def);
            }
            return DataRow.this;
        }

        public DataRow date(String format, Class ... classes) {
            List<String> keys = DataRow.this.keys();
            for (String key : keys) {
                Object value = DataRow.this.get(key);
                if (null == value) continue;
                Class<?> vc = value.getClass();
                boolean exe = false;
                for (Class c : classes) {
                    if (!vc.equals(c)) continue;
                    exe = true;
                    break;
                }
                if (!exe) continue;
                DataRow.this.dateFormat(key, key, format, "");
            }
            return DataRow.this;
        }

        public DataRow date(boolean greedy, String format, String def) {
            ArrayList<String> checked = new ArrayList<String>();
            List<String> keys = DataRow.this.keys();
            for (String key : keys) {
                Column column;
                Object value = DataRow.this.get(key);
                if (null == value) continue;
                String vc = value.getClass().getSimpleName();
                boolean exe = false;
                if (vc.toUpperCase().contains("DATE")) {
                    exe = true;
                }
                if (!exe && null != (column = DataRow.this.getMetadata(key)) && column.getTypeName().toUpperCase().contains("DATE")) {
                    exe = true;
                }
                if (!exe) continue;
                checked.add(key);
                DataRow.this.dateFormat(key, key, format, "");
            }
            if (greedy) {
                for (String key : keys) {
                    if (checked.contains(key) || !key.toUpperCase().contains("DATE")) continue;
                    DataRow.this.dateFormat(key, key, format, def);
                }
            }
            return DataRow.this;
        }

        public DataRow date(boolean greedy, String format, java.util.Date def) {
            ArrayList<String> checked = new ArrayList<String>();
            List<String> keys = DataRow.this.keys();
            for (String key : keys) {
                Column column;
                Object value = DataRow.this.get(key);
                if (null == value) continue;
                String vc = value.getClass().getSimpleName();
                boolean exe = false;
                if (vc.toUpperCase().contains("DATE")) {
                    exe = true;
                }
                if (!exe && null != (column = DataRow.this.getMetadata(key)) && column.getTypeName().toUpperCase().contains("DATE")) {
                    exe = true;
                }
                if (!exe) continue;
                checked.add(key);
                DataRow.this.dateFormat(key, key, format, def);
            }
            if (greedy) {
                for (String key : keys) {
                    if (checked.contains(key)) continue;
                    Column column = DataRow.this.metadatas.get(key);
                    if (!key.toUpperCase().contains("DATE")) continue;
                    DataRow.this.dateFormat(key, key, format, def);
                }
            }
            return DataRow.this;
        }

        public DataRow date(boolean greedy, String format) {
            return this.date(greedy, format, "");
        }

        public DataRow number(String format, String ... cols) {
            if (null == cols || BasicUtil.isEmpty((Object)format)) {
                return DataRow.this;
            }
            String[] stringArray = cols;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String col;
                String src = col = stringArray[i];
                String tar = col;
                String def = "";
                if (col.contains(":")) {
                    String[] tmps = col.split(":");
                    if (tmps.length >= 2) {
                        src = tmps[0];
                        tar = tmps[1];
                    }
                    if (tmps.length > 2) {
                        def = tmps[2];
                    }
                }
                DataRow.this.numberFormat(tar, src, format, def);
            }
            return DataRow.this;
        }

        public DataRow number(String format, Class ... classes) {
            List<String> keys = DataRow.this.keys();
            for (String key : keys) {
                Object value = DataRow.this.get(key);
                if (null == value) continue;
                Class<?> vc = value.getClass();
                boolean exe = false;
                for (Class c : classes) {
                    if (!vc.equals(c)) continue;
                    exe = true;
                    break;
                }
                if (!exe) continue;
                DataRow.this.numberFormat(key, key, format, "");
            }
            return DataRow.this;
        }

        public DataRow number(boolean greedy, String format, String def) {
            if (!greedy) {
                return DataRow.this;
            }
            ArrayList checked = new ArrayList();
            List<String> keys = DataRow.this.keys();
            for (String key : keys) {
                Column column;
                Object value = DataRow.this.get(key);
                if (null == value) continue;
                String vc = value.getClass().getSimpleName().toUpperCase();
                boolean exe = false;
                if (vc.startsWith("INT") || vc.contains("SHORT") || vc.contains("LONG") || vc.contains("FLOAT") || vc.contains("DOUBLE") || vc.contains("DECIMAL") || vc.contains("NUMERIC") || vc.contains("NUMBER")) {
                    exe = true;
                }
                if (!exe && null != (column = DataRow.this.getMetadata(key)) && ((vc = column.getTypeName().toUpperCase()).startsWith("INT") || vc.contains("SHORT") || vc.contains("LONG") || vc.contains("FLOAT") || vc.contains("DOUBLE") || vc.contains("DECIMAL") || vc.contains("NUMERIC") || vc.contains("NUMBER"))) {
                    exe = true;
                }
                if (!exe) continue;
                DataRow.this.numberFormat(key, key, format, def);
            }
            return DataRow.this;
        }

        public DataRow number(boolean greedy, String format) {
            return this.number(greedy, format, "");
        }
    }

    public class Parse
    implements Serializable {
        public DataRow date(String ... cols) {
            String[] stringArray = cols;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String col;
                String src = col = stringArray[i];
                String tar = col;
                java.util.Date def = null;
                if (!col.contains(":")) continue;
                String[] tmps = col.split(":");
                if (tmps.length >= 2) {
                    src = tmps[0];
                    tar = tmps[1];
                }
                if (tmps.length > 2) {
                    def = DateUtil.parse(col.replace(src + ":" + tar + ":", "").trim());
                }
                DataRow.this.dateParse(src, tar, null, def);
            }
            return DataRow.this;
        }

        public DataRow number(String ... cols) {
            String[] stringArray = cols;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String col;
                String src = col = stringArray[i];
                String tar = col;
                String def = null;
                if (!col.contains(":")) continue;
                String[] tmps = col.split(":");
                if (tmps.length >= 2) {
                    src = tmps[0];
                    tar = tmps[1];
                }
                if (tmps.length > 2) {
                    def = col.replace(src + ":" + tar + ":", "").trim();
                }
                DataRow.this.numberParse(src, tar, def);
            }
            return DataRow.this;
        }
    }
}

