/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.encrypt;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.anyline.util.BasicUtil;
import org.anyline.util.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Util {
    private static final Logger log = LoggerFactory.getLogger(MD5Util.class);

    public static String sign(String src) {
        return MD5Util.sign(src, "UTF-8");
    }

    public static String sign(String src, String encode) {
        if (null == src) {
            return "";
        }
        String result = null;
        if (!"".equals(src)) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                result = BasicUtil.isEmpty((Object)encode) ? NumberUtil.byte2hex(md.digest(src.getBytes())) : NumberUtil.byte2hex(md.digest(src.getBytes(encode)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String crypto(String src) {
        return MD5Util.sign(src, "UTF-8");
    }

    public static String crypto(String src, String encode) {
        return MD5Util.sign(src, encode);
    }

    public static String crypto2(String str) {
        return MD5Util.crypto2(str, "UTF-8");
    }

    public static String crypto2(String str, String encode) {
        return MD5Util.crypto(MD5Util.crypto(str, encode), encode);
    }

    public static String crypto(File file) {
        if (null == file || !file.isFile() || !file.exists()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }

    public static Map<String, String> crypto(File file, boolean recursion) {
        if (null == file || !file.isDirectory() || !file.exists()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory() && recursion) {
                map.putAll(MD5Util.crypto(f, recursion));
                continue;
            }
            String md5 = MD5Util.crypto(f);
            if (md5 == null) continue;
            map.put(f.getPath(), md5);
        }
        return map;
    }
}

