/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.List;
import org.anyline.util.ConfigTable;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLUtil {
    static final Logger log = LoggerFactory.getLogger(SQLUtil.class);
    private static String config_holder = null;
    private static String[] static_holder = null;

    public static StringBuilder delimiter(StringBuilder builder, String src, String delimiter) {
        if (!ConfigTable.IS_SQL_DELIMITER_OPEN) {
            builder.append(src);
            return builder;
        }
        if (delimiter == null) {
            builder.append(src);
            return builder;
        }
        String delimiterFr = "";
        String delimiterTo = "";
        if ((delimiter = delimiter.replaceAll("\\s", "")).length() == 0) {
            return builder;
        }
        if (delimiter.length() == 1) {
            delimiterFr = delimiter;
            delimiterTo = delimiter;
        } else {
            delimiterFr = delimiter.substring(0, 1);
            delimiterTo = delimiter.substring(1, 2);
        }
        return SQLUtil.delimiter(builder, src, delimiterFr, delimiterTo);
    }

    public static StringBuilder delimiter(StringBuilder builder, String src, String delimiterFr, String delimiterTo) {
        if (!ConfigTable.IS_SQL_DELIMITER_OPEN) {
            builder.append(src);
            return builder;
        }
        if ((src = src.trim()).startsWith(delimiterFr) || src.endsWith(delimiterTo)) {
            builder.append(src);
            return builder;
        }
        String[] holder = SQLUtil.placeholder();
        if (null != holder && (src.startsWith(holder[0]) || src.endsWith(holder[1]))) {
            builder.append(src);
            return builder;
        }
        if (src.contains(".")) {
            String[] cols = src.split("\\.");
            int size = cols.length;
            for (int i = 0; i < size; ++i) {
                String col = cols[i];
                builder.append(delimiterFr).append(col).append(delimiterTo);
                if (i >= size - 1) continue;
                builder.append(".");
            }
        } else {
            builder.append(delimiterFr).append(src).append(delimiterTo);
        }
        return builder;
    }

    public static String delimiter(String src, String delimiterFr, String delimiterTo) {
        if (!ConfigTable.IS_SQL_DELIMITER_OPEN) {
            return src;
        }
        if (src.startsWith(delimiterFr) || src.endsWith(delimiterTo)) {
            return src;
        }
        String result = SQLUtil.delimiter(new StringBuilder(), src, delimiterFr, delimiterTo).toString();
        return result;
    }

    public static String placeholder(String src, String delimiterFr, String delimiterTo) {
        if (null == src) {
            return src;
        }
        if (!ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return src;
        }
        String[] holder = SQLUtil.placeholder();
        if (null == holder) {
            return src;
        }
        String holderFr = holder[0];
        String holderTo = holder[1];
        if (null == holderFr || null == holderTo || null == delimiterFr || null == delimiterTo) {
            return src;
        }
        if (holderFr.equals(holderTo) && delimiterFr.equals(delimiterTo)) {
            src = src.replace(holderFr, delimiterFr);
        } else {
            try {
                String regxFr = holderFr.replace("(", "\\(").replace("{", "\u3001\\{").replace("[", "\\[");
                String regxTo = holderTo.replace(")", "\\)").replace("}", "\u3001\\}").replace("]", "\\]");
                List<List<String>> lists = RegularUtil.fetchs(src, "(" + regxFr + ")" + "(.+?)" + "(" + regxTo + ")");
                for (List<String> list : lists) {
                    String full = list.get(0);
                    String key = list.get(2).trim();
                    String replace = delimiterFr + key + delimiterTo;
                    src = src.replace(full, replace);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return src;
    }

    public static String[] placeholder() {
        if (config_holder != null && config_holder.equals(ConfigTable.SQL_DELIMITER_PLACEHOLDER) && null != static_holder) {
            return static_holder;
        }
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            config_holder = ConfigTable.SQL_DELIMITER_PLACEHOLDER;
            if (null == config_holder) {
                return null;
            }
            String holderFr = "";
            String holderTo = "";
            if ((config_holder = config_holder.replaceAll("\\s", "")).length() == 0) {
                return null;
            }
            if (config_holder.length() == 1) {
                holderFr = config_holder;
                holderTo = config_holder;
            } else {
                holderFr = config_holder.substring(0, 1);
                holderTo = config_holder.substring(1, 2);
            }
            static_holder = new String[]{holderFr, holderTo};
            return static_holder;
        }
        return null;
    }
}

