/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.anyline.util.BasicUtil;
import org.anyline.util.NumberTextUtil;

public class NumberUtil {
    public static String format(String src, String pattern) {
        if (BasicUtil.isEmpty((Object)src) || BasicUtil.isEmpty((Object)src.trim())) {
            return "";
        }
        BigDecimal num = null;
        try {
            num = new BigDecimal(src);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return NumberUtil.format(num, pattern);
    }

    public static String format(Number src, String pattern) {
        if (null == src) {
            return "";
        }
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(src);
    }

    public static String upper(long num) {
        return NumberTextUtil.getInstance(NumberTextUtil.Lang.ChineseSimplified).getText(num);
    }

    public static BigDecimal max(BigDecimal ... nums) {
        BigDecimal max = nums[0];
        for (BigDecimal num : nums) {
            if (null == max) {
                max = num;
                continue;
            }
            if (null == num || max.compareTo(num) >= 0) continue;
            max = num;
        }
        return max;
    }

    public static BigDecimal min(BigDecimal ... nums) {
        BigDecimal min = nums[0];
        for (BigDecimal num : nums) {
            if (null == min) {
                min = num;
                continue;
            }
            if (null == num || min.compareTo(num) <= 0) continue;
            min = num;
        }
        return min;
    }

    public static double max(double ... nums) {
        double max = nums[0];
        for (double num : nums) {
            if (!(max < num)) continue;
            max = num;
        }
        return max;
    }

    public static double min(double ... nums) {
        double min = nums[0];
        for (double num : nums) {
            if (!(min > num)) continue;
            min = num;
        }
        return min;
    }

    public static int max(int ... nums) {
        int max = nums[0];
        for (int num : nums) {
            if (max >= num) continue;
            max = num;
        }
        return max;
    }

    public static int min(int ... nums) {
        int min = nums[0];
        for (int num : nums) {
            if (min <= num) continue;
            min = num;
        }
        return min;
    }

    public static long max(long ... nums) {
        long max = nums[0];
        int size = nums.length;
        for (int i = 0; i < size; ++i) {
            if (max >= nums[i]) continue;
            max = nums[i];
        }
        return max;
    }

    public static long min(long ... nums) {
        long min = nums[0];
        for (long num : nums) {
            if (min <= num) continue;
            min = num;
        }
        return min;
    }

    public static float max(float ... nums) {
        float max = nums[0];
        for (float num : nums) {
            if (!(max < num)) continue;
            max = num;
        }
        return max;
    }

    public static float min(float ... nums) {
        float min = nums[0];
        for (float num : nums) {
            if (!(min > num)) continue;
            min = num;
        }
        return min;
    }

    public static short max(short ... nums) {
        short max = nums[0];
        for (short num : nums) {
            if (max >= num) continue;
            max = num;
        }
        return max;
    }

    public static short min(short ... nums) {
        short min = nums[0];
        for (short num : nums) {
            if (min <= num) continue;
            min = num;
        }
        return min;
    }

    public static int random(int fr, int to) {
        int result = 0;
        Random r = new Random();
        result = fr + r.nextInt(to - fr);
        return result;
    }

    public static double random(double fr, double to) {
        double result = 0.0;
        Random r = new Random();
        result = fr + r.nextDouble() * (to - fr);
        return result;
    }

    public static long random(long fr, long to) {
        long result = 0L;
        Random r = new Random();
        result = fr + r.nextLong() * (to - fr);
        return result;
    }

    public static float random(float fr, float to) {
        float result = 0.0f;
        Random r = new Random();
        result = fr + r.nextFloat() * (to - fr);
        return result;
    }

    public static List<Integer> random(int fr, int to, int qty) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Random r = new Random();
        while (true) {
            int rdm;
            if (list.contains(rdm = fr + r.nextInt(to - fr))) {
                continue;
            }
            list.add(rdm);
            if (list.size() == qty) break;
        }
        return list;
    }

    public static List<Double> random(double fr, double to, int qty) {
        ArrayList<Double> list = new ArrayList<Double>();
        Random r = new Random();
        while (true) {
            double rdm;
            if (list.contains(rdm = fr + r.nextDouble() * (to - fr))) {
                continue;
            }
            list.add(rdm);
            if (list.size() == qty) break;
        }
        return list;
    }

    public static List<Float> random(float fr, float to, int qty) {
        ArrayList<Float> list = new ArrayList<Float>();
        Random r = new Random();
        while (true) {
            float rdm;
            if (list.contains(Float.valueOf(rdm = fr + r.nextFloat() * (to - fr)))) {
                continue;
            }
            list.add(Float.valueOf(rdm));
            if (list.size() == qty) break;
        }
        return list;
    }

    public static List<Long> random(long fr, long to, int qty) {
        ArrayList<Long> list = new ArrayList<Long>();
        Random r = new Random();
        while (true) {
            long rdm;
            if (list.contains(rdm = fr + r.nextLong() * (to - fr))) {
                continue;
            }
            list.add(rdm);
            if (list.size() == qty) break;
        }
        return list;
    }

    public static boolean isInt(double src) {
        return src == (double)((int)src);
    }

    public static boolean isInt(float src) {
        return src == (float)((int)src);
    }

    public static int binary2decimal(String number) {
        return Integer.parseInt(number, 2);
    }

    public static String decimal2binary(int number) {
        return Integer.toBinaryString((number & 0xFF) + 256).substring(1);
    }

    public byte[] int2bytes(int i) {
        byte[] bytes = new byte[]{(byte)(0xFF & i >> 0), (byte)(0xFF & i >> 8), (byte)(0xFF & i >> 16), (byte)(0xFF & i >> 24)};
        return bytes;
    }

    public static int byte2int(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] long2bytes(long l) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & l >> i * 8);
        }
        return bytes;
    }

    public static byte[] int32bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                tmpd[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byte2big(byte[] bytes) {
        if (bytes[0] < 0) {
            byte[] temp = new byte[bytes.length + 1];
            temp[0] = 0;
            System.arraycopy(bytes, 0, temp, 1, bytes.length);
            return new BigInteger(temp);
        }
        return new BigInteger(bytes);
    }

    public static int hex2decimal(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static int hex2decimal(String[] hex, int fr, int to) {
        StringBuilder builder = new StringBuilder();
        for (int i = fr; i <= to; ++i) {
            builder.append(hex[i]);
        }
        return Integer.valueOf(builder.toString(), 16);
    }

    public static String byte2hex(byte[] bytes, String split) {
        return NumberUtil.byte2hex(bytes, bytes.length, split);
    }

    public static String byte2hex(byte[] bytes, int len) {
        return NumberUtil.byte2hex(bytes, len, null);
    }

    public static String byte2hex(byte[] bytes, int len, String split) {
        StringBuffer builder = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                builder.append(0);
            }
            builder.append(hex);
            if (i >= len - 1 || null == split) continue;
            builder.append(split);
        }
        return builder.toString();
    }

    public static String byte2hex(byte[] bytes) {
        return NumberUtil.byte2hex(bytes, null);
    }

    public static String[] byte2hexs(byte[] bytes) {
        String[] hexs = new String[bytes.length];
        for (int i = 0; i < hexs.length; ++i) {
            hexs[i] = NumberUtil.byte2hex(bytes[i]);
        }
        return hexs;
    }

    public static String byte2hex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String decimal2hex(int number) {
        String hex = Integer.toHexString(number & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String[] decimal2hex(int[] numbers) {
        String[] hex = new String[numbers.length];
        for (int i = 0; i < hex.length; ++i) {
            hex[i] = Integer.toHexString(numbers[i]);
        }
        return hex;
    }

    public static String byte2string(byte[] bytes, int fr, int to, String charset) {
        byte[] bts = new byte[to - fr + 1];
        for (int i = fr; i <= to; ++i) {
            bts[i - fr] = bytes[i];
        }
        return new String(bts, Charset.forName(charset));
    }

    public static String byte2string(byte[] bytes, int fr, int to) {
        return NumberUtil.byte2string(bytes, fr, to, "UTF-8");
    }

    public static String byte2string(byte[] bytes) {
        return NumberUtil.byte2string(bytes, 0, bytes.length - 1, "UTF-8");
    }

    public static String byte2string(byte[] bytes, String charset) {
        return NumberUtil.byte2string(bytes, 0, bytes.length - 1, charset);
    }

    public static byte[] hex2bytes(String hex) {
        byte[] result;
        int hexlen = hex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            hex = "0" + hex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = NumberUtil.hex2byte(hex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static byte hex2byte(String hex) {
        return (byte)Integer.parseInt(hex, 16);
    }

    public static byte[] decimal2bcd(long num) {
        byte tmp;
        int i;
        int digits = 0;
        for (long temp = num; temp != 0L; temp /= 10L) {
            ++digits;
        }
        int len = digits % 2 == 0 ? digits / 2 : (digits + 1) / 2;
        byte[] bcd = new byte[len];
        for (i = 0; i < digits; ++i) {
            tmp = (byte)(num % 10L);
            if (i % 2 == 0) {
                bcd[i / 2] = tmp;
            } else {
                int n = i / 2;
                bcd[n] = (byte)(bcd[n] | (byte)(tmp << 4));
            }
            num /= 10L;
        }
        for (i = 0; i < len / 2; ++i) {
            tmp = bcd[i];
            bcd[i] = bcd[len - i - 1];
            bcd[len - i - 1] = tmp;
        }
        return bcd;
    }

    public static String byte2binary(byte b) {
        String value = Integer.toBinaryString((b & 0xFF) + 256).substring(1);
        return value;
    }

    public static int byte2decimal(byte res) {
        return res & 0xFF;
    }

    public static String byte2ascii(byte b) {
        StringBuilder sb = new StringBuilder();
        int value = NumberUtil.byte2decimal(b);
        sb.append((char)value);
        return sb.toString();
    }

    public static String byte2bcd(byte bit) {
        StringBuffer sb = new StringBuffer();
        byte high = (byte)(bit & 0xF0);
        high = (byte)(high >>> 4);
        high = (byte)(high & 0xF);
        byte low = (byte)(bit & 0xF);
        sb.append(high);
        sb.append(low);
        return sb.toString();
    }

    public static String bytes2bcd(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(NumberUtil.byte2bcd(bytes[i]));
        }
        return sb.toString();
    }

    public static String string2hex(String origin, String charset) {
        byte[] bytes = origin.getBytes(Charset.forName(charset));
        String hex = NumberUtil.byte2hex(bytes);
        return hex;
    }

    public static String string2hex(String origin) {
        return NumberUtil.string2hex(origin, "UTF-8");
    }

    public static String hex2string(String hex, String charset) {
        byte[] bytes = NumberUtil.hex2bytes(hex);
        return new String(bytes, Charset.forName(charset));
    }

    public static String hex2string(String hex) {
        return NumberUtil.hex2string(hex, "UTF-8");
    }

    public static String[] hex2array(String hex) {
        String[] array = new String[hex.length() / 2];
        int k = 2;
        for (int i = 0; i < array.length; ++i) {
            array[i] = hex.substring(i * 2, k);
            k += 2;
        }
        return array;
    }

    public static byte[] string2bytes(String src, String charset) {
        return src.getBytes(Charset.forName(charset));
    }

    public static byte[] string2bytes(String src) {
        return src.getBytes(Charset.forName("UTF-8"));
    }

    public static String string2ascii(String str) {
        String result = "";
        int max = str.length();
        for (int i = 0; i < max; ++i) {
            char c = str.charAt(i);
            String b = Integer.toHexString(c);
            result = result + b;
        }
        return result;
    }

    public static String ascii2string(String content) {
        String result = "";
        int length = content.length() / 2;
        for (int i = 0; i < length; ++i) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = NumberUtil.hex2decimal(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result = result + d;
        }
        return result;
    }
}

