/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

public class HtmlUtil {
    public static String display(String src) {
        String result = src;
        for (ESCAPE item : ESCAPE.values()) {
            result = result.replace(item.getName(), item.getDisplay()).replace(item.getCode(), item.getDisplay());
        }
        return result;
    }

    public static String name2code(String src) {
        String result = src;
        for (ESCAPE item : ESCAPE.values()) {
            result = result.replace(item.getName(), item.getCode());
        }
        return result;
    }

    public static String code2display(String src) {
        String result = src;
        for (ESCAPE item : ESCAPE.values()) {
            result = result.replace(item.getCode(), item.getDisplay());
        }
        return result;
    }

    public static String table(String cells, int cols, String split) {
        StringBuilder table = new StringBuilder();
        String[] tds = cells.split(split);
        table.append("<table>");
        for (int i = 0; i < tds.length; ++i) {
            if (i % cols == 0) {
                table.append("<tr>");
            }
            table.append("<td>").append(tds[i]).append("</td>");
            if ((i + 1) % cols != 0) continue;
            table.append("</tr>");
        }
        table.append("</table>");
        return table.toString();
    }

    public static String table(String cells, int cols) {
        return HtmlUtil.table(cells, cols, "\n");
    }

    public static enum ESCAPE {
        yen{

            @Override
            public String getDisplay() {
                return "\u00a5";
            }

            @Override
            public String getName() {
                return "&yen;";
            }

            @Override
            public String getCode() {
                return "&#165;";
            }

            @Override
            public String getRemark() {
                return "&#165;";
            }
        }
        ,
        ordf{

            @Override
            public String getDisplay() {
                return "\u00aa";
            }

            @Override
            public String getName() {
                return "&ordf;";
            }

            @Override
            public String getCode() {
                return "&#170;";
            }

            @Override
            public String getRemark() {
                return "&#170;";
            }
        }
        ,
        macr{

            @Override
            public String getDisplay() {
                return "\u00af";
            }

            @Override
            public String getName() {
                return "&macr;";
            }

            @Override
            public String getCode() {
                return "&#175;";
            }

            @Override
            public String getRemark() {
                return "&#175;";
            }
        }
        ,
        acute{

            @Override
            public String getDisplay() {
                return "\u00b4";
            }

            @Override
            public String getName() {
                return "&acute;";
            }

            @Override
            public String getCode() {
                return "&#180;";
            }

            @Override
            public String getRemark() {
                return "&#180;";
            }
        }
        ,
        sup1{

            @Override
            public String getDisplay() {
                return "\u00b9";
            }

            @Override
            public String getName() {
                return "&sup1;";
            }

            @Override
            public String getCode() {
                return "&#185;";
            }

            @Override
            public String getRemark() {
                return "&#185;";
            }
        }
        ,
        frac34{

            @Override
            public String getDisplay() {
                return "\u00be";
            }

            @Override
            public String getName() {
                return "&frac34;";
            }

            @Override
            public String getCode() {
                return "&#190;";
            }

            @Override
            public String getRemark() {
                return "&#190;";
            }
        }
        ,
        Atilde{

            @Override
            public String getDisplay() {
                return "\u00c3";
            }

            @Override
            public String getName() {
                return "&Atilde;";
            }

            @Override
            public String getCode() {
                return "&#195;";
            }

            @Override
            public String getRemark() {
                return "&#195;";
            }
        }
        ,
        Egrave{

            @Override
            public String getDisplay() {
                return "\u00c8";
            }

            @Override
            public String getName() {
                return "&Egrave;";
            }

            @Override
            public String getCode() {
                return "&#200;";
            }

            @Override
            public String getRemark() {
                return "&#200;";
            }
        }
        ,
        Iacute{

            @Override
            public String getDisplay() {
                return "\u00cd";
            }

            @Override
            public String getName() {
                return "&Iacute;";
            }

            @Override
            public String getCode() {
                return "&#205;";
            }

            @Override
            public String getRemark() {
                return "&#205;";
            }
        }
        ,
        Ograve{

            @Override
            public String getDisplay() {
                return "\u00d2";
            }

            @Override
            public String getName() {
                return "&Ograve;";
            }

            @Override
            public String getCode() {
                return "&#210;";
            }

            @Override
            public String getRemark() {
                return "&#210;";
            }
        }
        ,
        Uuml{

            @Override
            public String getDisplay() {
                return "\u00dc";
            }

            @Override
            public String getName() {
                return "&Uuml;";
            }

            @Override
            public String getCode() {
                return "&#220;";
            }

            @Override
            public String getRemark() {
                return "&#220;";
            }
        }
        ,
        aacute{

            @Override
            public String getDisplay() {
                return "\u00e1";
            }

            @Override
            public String getName() {
                return "&aacute;";
            }

            @Override
            public String getCode() {
                return "&#225;";
            }

            @Override
            public String getRemark() {
                return "&#225;";
            }
        }
        ,
        aelig{

            @Override
            public String getDisplay() {
                return "\u00e6";
            }

            @Override
            public String getName() {
                return "&aelig;";
            }

            @Override
            public String getCode() {
                return "&#230;";
            }

            @Override
            public String getRemark() {
                return "&#230;";
            }
        }
        ,
        euml{

            @Override
            public String getDisplay() {
                return "\u00eb";
            }

            @Override
            public String getName() {
                return "&euml;";
            }

            @Override
            public String getCode() {
                return "&#235;";
            }

            @Override
            public String getRemark() {
                return "&#235;";
            }
        }
        ,
        eth{

            @Override
            public String getDisplay() {
                return "\u00f0";
            }

            @Override
            public String getName() {
                return "&eth;";
            }

            @Override
            public String getCode() {
                return "&#240;";
            }

            @Override
            public String getRemark() {
                return "&#240;";
            }
        }
        ,
        otilde{

            @Override
            public String getDisplay() {
                return "\u00f5";
            }

            @Override
            public String getName() {
                return "&otilde;";
            }

            @Override
            public String getCode() {
                return "&#245;";
            }

            @Override
            public String getRemark() {
                return "&#245;";
            }
        }
        ,
        uacute{

            @Override
            public String getDisplay() {
                return "\u00fa";
            }

            @Override
            public String getName() {
                return "&uacute;";
            }

            @Override
            public String getCode() {
                return "&#250;";
            }

            @Override
            public String getRemark() {
                return "&#250;";
            }
        }
        ,
        yuml{

            @Override
            public String getDisplay() {
                return "\u00ff";
            }

            @Override
            public String getName() {
                return "&yuml;";
            }

            @Override
            public String getCode() {
                return "&#255;";
            }

            @Override
            public String getRemark() {
                return "&#255;";
            }
        }
        ,
        fnof{

            @Override
            public String getDisplay() {
                return "\u0192";
            }

            @Override
            public String getName() {
                return "&fnof;";
            }

            @Override
            public String getCode() {
                return "&#402;";
            }

            @Override
            public String getRemark() {
                return "&#402;";
            }
        }
        ,
        Epsilon{

            @Override
            public String getDisplay() {
                return "\u0395";
            }

            @Override
            public String getName() {
                return "&Epsilon;";
            }

            @Override
            public String getCode() {
                return "&#917;";
            }

            @Override
            public String getRemark() {
                return "&#917;";
            }
        }
        ,
        Kappa{

            @Override
            public String getDisplay() {
                return "\u039a";
            }

            @Override
            public String getName() {
                return "&Kappa;";
            }

            @Override
            public String getCode() {
                return "&#922;";
            }

            @Override
            public String getRemark() {
                return "&#922;";
            }
        }
        ,
        Omicron{

            @Override
            public String getDisplay() {
                return "\u039f";
            }

            @Override
            public String getName() {
                return "&Omicron;";
            }

            @Override
            public String getCode() {
                return "&#927;";
            }

            @Override
            public String getRemark() {
                return "&#927;";
            }
        }
        ,
        Upsilon{

            @Override
            public String getDisplay() {
                return "\u03a5";
            }

            @Override
            public String getName() {
                return "&Upsilon;";
            }

            @Override
            public String getCode() {
                return "&#933;";
            }

            @Override
            public String getRemark() {
                return "&#933;";
            }
        }
        ,
        alpha{

            @Override
            public String getDisplay() {
                return "\u03b1";
            }

            @Override
            public String getName() {
                return "&alpha;";
            }

            @Override
            public String getCode() {
                return "&#945;";
            }

            @Override
            public String getRemark() {
                return "&#945;";
            }
        }
        ,
        zeta{

            @Override
            public String getDisplay() {
                return "\u03b6";
            }

            @Override
            public String getName() {
                return "&zeta;";
            }

            @Override
            public String getCode() {
                return "&#950;";
            }

            @Override
            public String getRemark() {
                return "&#950;";
            }
        }
        ,
        lambda{

            @Override
            public String getDisplay() {
                return "\u03bb";
            }

            @Override
            public String getName() {
                return "&lambda;";
            }

            @Override
            public String getCode() {
                return "&#955;";
            }

            @Override
            public String getRemark() {
                return "&#955;";
            }
        }
        ,
        pi{

            @Override
            public String getDisplay() {
                return "\u03c0";
            }

            @Override
            public String getName() {
                return "&pi;";
            }

            @Override
            public String getCode() {
                return "&#960;";
            }

            @Override
            public String getRemark() {
                return "&#960;";
            }
        }
        ,
        upsilon{

            @Override
            public String getDisplay() {
                return "\u03c5";
            }

            @Override
            public String getName() {
                return "&upsilon;";
            }

            @Override
            public String getCode() {
                return "&#965;";
            }

            @Override
            public String getRemark() {
                return "&#965;";
            }
        }
        ,
        thetasym{

            @Override
            public String getDisplay() {
                return "\u03d1";
            }

            @Override
            public String getName() {
                return "&thetasym;";
            }

            @Override
            public String getCode() {
                return "&#977;";
            }

            @Override
            public String getRemark() {
                return "&#977;";
            }
        }
        ,
        prime{

            @Override
            public String getDisplay() {
                return "\u2032";
            }

            @Override
            public String getName() {
                return "&prime;";
            }

            @Override
            public String getCode() {
                return "&#8242;";
            }

            @Override
            public String getRemark() {
                return "&#8242;";
            }
        }
        ,
        image{

            @Override
            public String getDisplay() {
                return "\u2111";
            }

            @Override
            public String getName() {
                return "&image;";
            }

            @Override
            public String getCode() {
                return "&#8465;";
            }

            @Override
            public String getRemark() {
                return "&#8465;";
            }
        }
        ,
        uarr{

            @Override
            public String getDisplay() {
                return "\u2191";
            }

            @Override
            public String getName() {
                return "&uarr;";
            }

            @Override
            public String getCode() {
                return "&#8593;";
            }

            @Override
            public String getRemark() {
                return "&#8593;";
            }
        }
        ,
        lArr{

            @Override
            public String getDisplay() {
                return "\u21d0";
            }

            @Override
            public String getName() {
                return "&lArr;";
            }

            @Override
            public String getCode() {
                return "&#8656;";
            }

            @Override
            public String getRemark() {
                return "&#8656;";
            }
        }
        ,
        forall{

            @Override
            public String getDisplay() {
                return "\u2200";
            }

            @Override
            public String getName() {
                return "&forall;";
            }

            @Override
            public String getCode() {
                return "&#8704;";
            }

            @Override
            public String getRemark() {
                return "&#8704;";
            }
        }
        ,
        isin{

            @Override
            public String getDisplay() {
                return "\u2208";
            }

            @Override
            public String getName() {
                return "&isin;";
            }

            @Override
            public String getCode() {
                return "&#8712;";
            }

            @Override
            public String getRemark() {
                return "&#8712;";
            }
        }
        ,
        minus{

            @Override
            public String getDisplay() {
                return "\u2212";
            }

            @Override
            public String getName() {
                return "&minus;";
            }

            @Override
            public String getCode() {
                return "&#8722;";
            }

            @Override
            public String getRemark() {
                return "&#8722;";
            }
        }
        ,
        ang{

            @Override
            public String getDisplay() {
                return "\u2220";
            }

            @Override
            public String getName() {
                return "&ang;";
            }

            @Override
            public String getCode() {
                return "&#8736;";
            }

            @Override
            public String getRemark() {
                return "&#8736;";
            }
        }
        ,
        Int{

            @Override
            public String getDisplay() {
                return "\u222b";
            }

            @Override
            public String getName() {
                return "&int;";
            }

            @Override
            public String getCode() {
                return "&#8747;";
            }

            @Override
            public String getRemark() {
                return "&#8747;";
            }
        }
        ,
        ne{

            @Override
            public String getDisplay() {
                return "\u2260";
            }

            @Override
            public String getName() {
                return "&ne;";
            }

            @Override
            public String getCode() {
                return "&#8800;";
            }

            @Override
            public String getRemark() {
                return "&#8800;";
            }
        }
        ,
        sup{

            @Override
            public String getDisplay() {
                return "\u2283";
            }

            @Override
            public String getName() {
                return "&sup;";
            }

            @Override
            public String getCode() {
                return "&#8835;";
            }

            @Override
            public String getRemark() {
                return "&#8835;";
            }
        }
        ,
        otimes{

            @Override
            public String getDisplay() {
                return "\u2297";
            }

            @Override
            public String getName() {
                return "&otimes;";
            }

            @Override
            public String getCode() {
                return "&#8855;";
            }

            @Override
            public String getRemark() {
                return "&#8855;";
            }
        }
        ,
        lfloor{

            @Override
            public String getDisplay() {
                return "\u230a";
            }

            @Override
            public String getName() {
                return "&lfloor;";
            }

            @Override
            public String getCode() {
                return "&#8970;";
            }

            @Override
            public String getRemark() {
                return "&#8970;";
            }
        }
        ,
        spades{

            @Override
            public String getDisplay() {
                return "\u2660";
            }

            @Override
            public String getName() {
                return "&spades;";
            }

            @Override
            public String getCode() {
                return "&#9824;";
            }

            @Override
            public String getRemark() {
                return "&#9824;";
            }
        }
        ,
        oelig{

            @Override
            public String getDisplay() {
                return "\u0153";
            }

            @Override
            public String getName() {
                return "&oelig;";
            }

            @Override
            public String getCode() {
                return "&#339;";
            }

            @Override
            public String getRemark() {
                return "&#339;";
            }
        }
        ,
        tilde{

            @Override
            public String getDisplay() {
                return "\u02dc";
            }

            @Override
            public String getName() {
                return "&tilde;";
            }

            @Override
            public String getCode() {
                return "&#732;";
            }

            @Override
            public String getRemark() {
                return "&#732;";
            }
        }
        ,
        zwj{

            @Override
            public String getDisplay() {
                return "\u200d";
            }

            @Override
            public String getName() {
                return "&zwj;";
            }

            @Override
            public String getCode() {
                return "&#8205;";
            }

            @Override
            public String getRemark() {
                return "&#8205;";
            }
        }
        ,
        lsquo{

            @Override
            public String getDisplay() {
                return "\u2018";
            }

            @Override
            public String getName() {
                return "&lsquo;";
            }

            @Override
            public String getCode() {
                return "&#8216;";
            }

            @Override
            public String getRemark() {
                return "&#8216;";
            }
        }
        ,
        bdquo{

            @Override
            public String getDisplay() {
                return "\u201e";
            }

            @Override
            public String getName() {
                return "&bdquo;";
            }

            @Override
            public String getCode() {
                return "&#8222;";
            }

            @Override
            public String getRemark() {
                return "&#8222;";
            }
        }
        ,
        rsaquo{

            @Override
            public String getDisplay() {
                return "\u203a";
            }

            @Override
            public String getName() {
                return "&rsaquo;";
            }

            @Override
            public String getCode() {
                return "&#8250;";
            }

            @Override
            public String getRemark() {
                return "&#8250;";
            }
        }
        ,
        ensp{

            @Override
            public String getDisplay() {
                return "\u2002";
            }

            @Override
            public String getName() {
                return "&ensp;";
            }

            @Override
            public String getCode() {
                return "&#8194;";
            }

            @Override
            public String getRemark() {
                return "&#8194;";
            }
        }
        ,
        emsp{

            @Override
            public String getDisplay() {
                return "\u2003";
            }

            @Override
            public String getName() {
                return "&emsp;";
            }

            @Override
            public String getCode() {
                return "&#8195;";
            }

            @Override
            public String getRemark() {
                return "&#8195;";
            }
        }
        ,
        nbsp{

            @Override
            public String getDisplay() {
                return " ";
            }

            @Override
            public String getName() {
                return "&nbsp;";
            }

            @Override
            public String getCode() {
                return "&#160;";
            }

            @Override
            public String getRemark() {
                return "&#160;";
            }
        }
        ,
        lt{

            @Override
            public String getDisplay() {
                return "<";
            }

            @Override
            public String getName() {
                return "&lt;";
            }

            @Override
            public String getCode() {
                return "&#60;";
            }

            @Override
            public String getRemark() {
                return "&#60;";
            }
        }
        ,
        gt{

            @Override
            public String getDisplay() {
                return ">";
            }

            @Override
            public String getName() {
                return "&gt;";
            }

            @Override
            public String getCode() {
                return "&#62;";
            }

            @Override
            public String getRemark() {
                return "&#62;";
            }
        }
        ,
        amp{

            @Override
            public String getDisplay() {
                return "&";
            }

            @Override
            public String getName() {
                return "&amp;";
            }

            @Override
            public String getCode() {
                return "&#38;";
            }

            @Override
            public String getRemark() {
                return "&#38;";
            }
        }
        ,
        quot{

            @Override
            public String getDisplay() {
                return "\"";
            }

            @Override
            public String getName() {
                return "&quot;";
            }

            @Override
            public String getCode() {
                return "&#34;";
            }

            @Override
            public String getRemark() {
                return "&#34;";
            }
        }
        ,
        copy{

            @Override
            public String getDisplay() {
                return "\u00a9";
            }

            @Override
            public String getName() {
                return "&copy;";
            }

            @Override
            public String getCode() {
                return "&#169;";
            }

            @Override
            public String getRemark() {
                return "&#169;";
            }
        }
        ,
        reg{

            @Override
            public String getDisplay() {
                return "\u00ae";
            }

            @Override
            public String getName() {
                return "&reg;";
            }

            @Override
            public String getCode() {
                return "&#174;";
            }

            @Override
            public String getRemark() {
                return "&#174;";
            }
        }
        ,
        divide{

            @Override
            public String getDisplay() {
                return "\u00f7";
            }

            @Override
            public String getName() {
                return "&divide;";
            }

            @Override
            public String getCode() {
                return "&#247;";
            }

            @Override
            public String getRemark() {
                return "&#247;";
            }
        }
        ,
        iexcl{

            @Override
            public String getDisplay() {
                return "\u00a1";
            }

            @Override
            public String getName() {
                return "&iexcl;";
            }

            @Override
            public String getCode() {
                return "&#161;";
            }

            @Override
            public String getRemark() {
                return "&#161;";
            }
        }
        ,
        brvbar{

            @Override
            public String getDisplay() {
                return "\u00a6";
            }

            @Override
            public String getName() {
                return "&brvbar;";
            }

            @Override
            public String getCode() {
                return "&#166;";
            }

            @Override
            public String getRemark() {
                return "&#166;";
            }
        }
        ,
        laquo{

            @Override
            public String getDisplay() {
                return "\u00ab";
            }

            @Override
            public String getName() {
                return "&laquo;";
            }

            @Override
            public String getCode() {
                return "&#171;";
            }

            @Override
            public String getRemark() {
                return "&#171;";
            }
        }
        ,
        deg{

            @Override
            public String getDisplay() {
                return "\u00b0";
            }

            @Override
            public String getName() {
                return "&deg;";
            }

            @Override
            public String getCode() {
                return "&#176;";
            }

            @Override
            public String getRemark() {
                return "&#176;";
            }
        }
        ,
        micro{

            @Override
            public String getDisplay() {
                return "\u00b5";
            }

            @Override
            public String getName() {
                return "&micro;";
            }

            @Override
            public String getCode() {
                return "&#181;";
            }

            @Override
            public String getRemark() {
                return "&#181;";
            }
        }
        ,
        ordm{

            @Override
            public String getDisplay() {
                return "\u00ba";
            }

            @Override
            public String getName() {
                return "&ordm;";
            }

            @Override
            public String getCode() {
                return "&#186;";
            }

            @Override
            public String getRemark() {
                return "&#186;";
            }
        }
        ,
        iquest{

            @Override
            public String getDisplay() {
                return "\u00bf";
            }

            @Override
            public String getName() {
                return "&iquest;";
            }

            @Override
            public String getCode() {
                return "&#191;";
            }

            @Override
            public String getRemark() {
                return "&#191;";
            }
        }
        ,
        Auml{

            @Override
            public String getDisplay() {
                return "\u00c4";
            }

            @Override
            public String getName() {
                return "&Auml;";
            }

            @Override
            public String getCode() {
                return "&#196;";
            }

            @Override
            public String getRemark() {
                return "&#196;";
            }
        }
        ,
        Eacute{

            @Override
            public String getDisplay() {
                return "\u00c9";
            }

            @Override
            public String getName() {
                return "&Eacute;";
            }

            @Override
            public String getCode() {
                return "&#201;";
            }

            @Override
            public String getRemark() {
                return "&#201;";
            }
        }
        ,
        Icirc{

            @Override
            public String getDisplay() {
                return "\u00ce";
            }

            @Override
            public String getName() {
                return "&Icirc;";
            }

            @Override
            public String getCode() {
                return "&#206;";
            }

            @Override
            public String getRemark() {
                return "&#206;";
            }
        }
        ,
        Oacute{

            @Override
            public String getDisplay() {
                return "\u00d3";
            }

            @Override
            public String getName() {
                return "&Oacute;";
            }

            @Override
            public String getCode() {
                return "&#211;";
            }

            @Override
            public String getRemark() {
                return "&#211;";
            }
        }
        ,
        Oslash{

            @Override
            public String getDisplay() {
                return "\u00d8";
            }

            @Override
            public String getName() {
                return "&Oslash;";
            }

            @Override
            public String getCode() {
                return "&#216;";
            }

            @Override
            public String getRemark() {
                return "&#216;";
            }
        }
        ,
        Yacute{

            @Override
            public String getDisplay() {
                return "\u00dd";
            }

            @Override
            public String getName() {
                return "&Yacute;";
            }

            @Override
            public String getCode() {
                return "&#221;";
            }

            @Override
            public String getRemark() {
                return "&#221;";
            }
        }
        ,
        acirc{

            @Override
            public String getDisplay() {
                return "\u00e2";
            }

            @Override
            public String getName() {
                return "&acirc;";
            }

            @Override
            public String getCode() {
                return "&#226;";
            }

            @Override
            public String getRemark() {
                return "&#226;";
            }
        }
        ,
        ccedil{

            @Override
            public String getDisplay() {
                return "\u00e7";
            }

            @Override
            public String getName() {
                return "&ccedil;";
            }

            @Override
            public String getCode() {
                return "&#231;";
            }

            @Override
            public String getRemark() {
                return "&#231;";
            }
        }
        ,
        igrave{

            @Override
            public String getDisplay() {
                return "\u00ec";
            }

            @Override
            public String getName() {
                return "&igrave;";
            }

            @Override
            public String getCode() {
                return "&#236;";
            }

            @Override
            public String getRemark() {
                return "&#236;";
            }
        }
        ,
        ntilde{

            @Override
            public String getDisplay() {
                return "\u00f1";
            }

            @Override
            public String getName() {
                return "&ntilde;";
            }

            @Override
            public String getCode() {
                return "&#241;";
            }

            @Override
            public String getRemark() {
                return "&#241;";
            }
        }
        ,
        ouml{

            @Override
            public String getDisplay() {
                return "\u00f6";
            }

            @Override
            public String getName() {
                return "&ouml;";
            }

            @Override
            public String getCode() {
                return "&#246;";
            }

            @Override
            public String getRemark() {
                return "&#246;";
            }
        }
        ,
        ucirc{

            @Override
            public String getDisplay() {
                return "\u00fb";
            }

            @Override
            public String getName() {
                return "&ucirc;";
            }

            @Override
            public String getCode() {
                return "&#251;";
            }

            @Override
            public String getRemark() {
                return "&#251;";
            }
        }
        ,
        Alpha{

            @Override
            public String getDisplay() {
                return "\u0391";
            }

            @Override
            public String getName() {
                return "&Alpha;";
            }

            @Override
            public String getCode() {
                return "&#913;";
            }

            @Override
            public String getRemark() {
                return "&#913;";
            }
        }
        ,
        Zeta{

            @Override
            public String getDisplay() {
                return "\u0396";
            }

            @Override
            public String getName() {
                return "&Zeta;";
            }

            @Override
            public String getCode() {
                return "&#918;";
            }

            @Override
            public String getRemark() {
                return "&#918;";
            }
        }
        ,
        Lambda{

            @Override
            public String getDisplay() {
                return "\u039b";
            }

            @Override
            public String getName() {
                return "&Lambda;";
            }

            @Override
            public String getCode() {
                return "&#923;";
            }

            @Override
            public String getRemark() {
                return "&#923;";
            }
        }
        ,
        Pi{

            @Override
            public String getDisplay() {
                return "\u03a0";
            }

            @Override
            public String getName() {
                return "&Pi;";
            }

            @Override
            public String getCode() {
                return "&#928;";
            }

            @Override
            public String getRemark() {
                return "&#928;";
            }
        }
        ,
        Phi{

            @Override
            public String getDisplay() {
                return "\u03a6";
            }

            @Override
            public String getName() {
                return "&Phi;";
            }

            @Override
            public String getCode() {
                return "&#934;";
            }

            @Override
            public String getRemark() {
                return "&#934;";
            }
        }
        ,
        beta{

            @Override
            public String getDisplay() {
                return "\u03b2";
            }

            @Override
            public String getName() {
                return "&beta;";
            }

            @Override
            public String getCode() {
                return "&#946;";
            }

            @Override
            public String getRemark() {
                return "&#946;";
            }
        }
        ,
        eta{

            @Override
            public String getDisplay() {
                return "\u03b7";
            }

            @Override
            public String getName() {
                return "&eta;";
            }

            @Override
            public String getCode() {
                return "&#951;";
            }

            @Override
            public String getRemark() {
                return "&#951;";
            }
        }
        ,
        mu{

            @Override
            public String getDisplay() {
                return "\u03bc";
            }

            @Override
            public String getName() {
                return "&mu;";
            }

            @Override
            public String getCode() {
                return "&#956;";
            }

            @Override
            public String getRemark() {
                return "&#956;";
            }
        }
        ,
        rho{

            @Override
            public String getDisplay() {
                return "\u03c1";
            }

            @Override
            public String getName() {
                return "&rho;";
            }

            @Override
            public String getCode() {
                return "&#961;";
            }

            @Override
            public String getRemark() {
                return "&#961;";
            }
        }
        ,
        phi{

            @Override
            public String getDisplay() {
                return "\u03c6";
            }

            @Override
            public String getName() {
                return "&phi;";
            }

            @Override
            public String getCode() {
                return "&#966;";
            }

            @Override
            public String getRemark() {
                return "&#966;";
            }
        }
        ,
        upsih{

            @Override
            public String getDisplay() {
                return "\u03d2";
            }

            @Override
            public String getName() {
                return "&upsih;";
            }

            @Override
            public String getCode() {
                return "&#978;";
            }

            @Override
            public String getRemark() {
                return "&#978;";
            }
        }
        ,
        Prime{

            @Override
            public String getDisplay() {
                return "\u2033";
            }

            @Override
            public String getName() {
                return "&Prime;";
            }

            @Override
            public String getCode() {
                return "&#8243;";
            }

            @Override
            public String getRemark() {
                return "&#8243;";
            }
        }
        ,
        real{

            @Override
            public String getDisplay() {
                return "\u211c";
            }

            @Override
            public String getName() {
                return "&real;";
            }

            @Override
            public String getCode() {
                return "&#8476;";
            }

            @Override
            public String getRemark() {
                return "&#8476;";
            }
        }
        ,
        rarr{

            @Override
            public String getDisplay() {
                return "\u2192";
            }

            @Override
            public String getName() {
                return "&rarr;";
            }

            @Override
            public String getCode() {
                return "&#8594;";
            }

            @Override
            public String getRemark() {
                return "&#8594;";
            }
        }
        ,
        uArr{

            @Override
            public String getDisplay() {
                return "\u21d1";
            }

            @Override
            public String getName() {
                return "&uArr;";
            }

            @Override
            public String getCode() {
                return "&#8657;";
            }

            @Override
            public String getRemark() {
                return "&#8657;";
            }
        }
        ,
        part{

            @Override
            public String getDisplay() {
                return "\u2202";
            }

            @Override
            public String getName() {
                return "&part;";
            }

            @Override
            public String getCode() {
                return "&#8706;";
            }

            @Override
            public String getRemark() {
                return "&#8706;";
            }
        }
        ,
        notin{

            @Override
            public String getDisplay() {
                return "\u2209";
            }

            @Override
            public String getName() {
                return "&notin;";
            }

            @Override
            public String getCode() {
                return "&#8713;";
            }

            @Override
            public String getRemark() {
                return "&#8713;";
            }
        }
        ,
        lowast{

            @Override
            public String getDisplay() {
                return "\u2217";
            }

            @Override
            public String getName() {
                return "&lowast;";
            }

            @Override
            public String getCode() {
                return "&#8727;";
            }

            @Override
            public String getRemark() {
                return "&#8727;";
            }
        }
        ,
        and{

            @Override
            public String getDisplay() {
                return "\u2227";
            }

            @Override
            public String getName() {
                return "&and;";
            }

            @Override
            public String getCode() {
                return "&#8743;";
            }

            @Override
            public String getRemark() {
                return "&#8743;";
            }
        }
        ,
        there4{

            @Override
            public String getDisplay() {
                return "\u2234";
            }

            @Override
            public String getName() {
                return "&there4;";
            }

            @Override
            public String getCode() {
                return "&#8756;";
            }

            @Override
            public String getRemark() {
                return "&#8756;";
            }
        }
        ,
        equiv{

            @Override
            public String getDisplay() {
                return "\u2261";
            }

            @Override
            public String getName() {
                return "&equiv;";
            }

            @Override
            public String getCode() {
                return "&#8801;";
            }

            @Override
            public String getRemark() {
                return "&#8801;";
            }
        }
        ,
        nsub{

            @Override
            public String getDisplay() {
                return "\u2284";
            }

            @Override
            public String getName() {
                return "&nsub;";
            }

            @Override
            public String getCode() {
                return "&#8836;";
            }

            @Override
            public String getRemark() {
                return "&#8836;";
            }
        }
        ,
        perp{

            @Override
            public String getDisplay() {
                return "\u22a5";
            }

            @Override
            public String getName() {
                return "&perp;";
            }

            @Override
            public String getCode() {
                return "&#8869;";
            }

            @Override
            public String getRemark() {
                return "&#8869;";
            }
        }
        ,
        rfloor{

            @Override
            public String getDisplay() {
                return "\u230b";
            }

            @Override
            public String getName() {
                return "&rfloor;";
            }

            @Override
            public String getCode() {
                return "&#8971;";
            }

            @Override
            public String getRemark() {
                return "&#8971;";
            }
        }
        ,
        clubs{

            @Override
            public String getDisplay() {
                return "\u2663";
            }

            @Override
            public String getName() {
                return "&clubs;";
            }

            @Override
            public String getCode() {
                return "&#9827;";
            }

            @Override
            public String getRemark() {
                return "&#9827;";
            }
        }
        ,
        Scaron{

            @Override
            public String getDisplay() {
                return "\u0160";
            }

            @Override
            public String getName() {
                return "&Scaron;";
            }

            @Override
            public String getCode() {
                return "&#352;";
            }

            @Override
            public String getRemark() {
                return "&#352;";
            }
        }
        ,
        lrm{

            @Override
            public String getDisplay() {
                return "\u200e";
            }

            @Override
            public String getName() {
                return "&lrm;";
            }

            @Override
            public String getCode() {
                return "&#8206;";
            }

            @Override
            public String getRemark() {
                return "&#8206;";
            }
        }
        ,
        rsquo{

            @Override
            public String getDisplay() {
                return "\u2019";
            }

            @Override
            public String getName() {
                return "&rsquo;";
            }

            @Override
            public String getCode() {
                return "&#8217;";
            }

            @Override
            public String getRemark() {
                return "&#8217;";
            }
        }
        ,
        dagger{

            @Override
            public String getDisplay() {
                return "\u2020";
            }

            @Override
            public String getName() {
                return "&dagger;";
            }

            @Override
            public String getCode() {
                return "&#8224;";
            }

            @Override
            public String getRemark() {
                return "&#8224;";
            }
        }
        ,
        euro{

            @Override
            public String getDisplay() {
                return "\u20ac";
            }

            @Override
            public String getName() {
                return "&euro;";
            }

            @Override
            public String getCode() {
                return "&#8364;";
            }

            @Override
            public String getRemark() {
                return "&#8364;";
            }
        }
        ,
        cent{

            @Override
            public String getDisplay() {
                return "\u00a2";
            }

            @Override
            public String getName() {
                return "&cent;";
            }

            @Override
            public String getCode() {
                return "&#162;";
            }

            @Override
            public String getRemark() {
                return "&#162;";
            }
        }
        ,
        sect{

            @Override
            public String getDisplay() {
                return "\u00a7";
            }

            @Override
            public String getName() {
                return "&sect;";
            }

            @Override
            public String getCode() {
                return "&#167;";
            }

            @Override
            public String getRemark() {
                return "&#167;";
            }
        }
        ,
        not{

            @Override
            public String getDisplay() {
                return "\u00ac";
            }

            @Override
            public String getName() {
                return "&not;";
            }

            @Override
            public String getCode() {
                return "&#172;";
            }

            @Override
            public String getRemark() {
                return "&#172;";
            }
        }
        ,
        plusmn{

            @Override
            public String getDisplay() {
                return "\u00b1";
            }

            @Override
            public String getName() {
                return "&plusmn;";
            }

            @Override
            public String getCode() {
                return "&#177;";
            }

            @Override
            public String getRemark() {
                return "&#177;";
            }
        }
        ,
        para{

            @Override
            public String getDisplay() {
                return "\u00b6";
            }

            @Override
            public String getName() {
                return "&para;";
            }

            @Override
            public String getCode() {
                return "&#182;";
            }

            @Override
            public String getRemark() {
                return "&#182;";
            }
        }
        ,
        raquo{

            @Override
            public String getDisplay() {
                return "\u00bb";
            }

            @Override
            public String getName() {
                return "&raquo;";
            }

            @Override
            public String getCode() {
                return "&#187;";
            }

            @Override
            public String getRemark() {
                return "&#187;";
            }
        }
        ,
        Agrave{

            @Override
            public String getDisplay() {
                return "\u00c0";
            }

            @Override
            public String getName() {
                return "&Agrave;";
            }

            @Override
            public String getCode() {
                return "&#192;";
            }

            @Override
            public String getRemark() {
                return "&#192;";
            }
        }
        ,
        Aring{

            @Override
            public String getDisplay() {
                return "\u00c5";
            }

            @Override
            public String getName() {
                return "&Aring;";
            }

            @Override
            public String getCode() {
                return "&#197;";
            }

            @Override
            public String getRemark() {
                return "&#197;";
            }
        }
        ,
        Ecirc{

            @Override
            public String getDisplay() {
                return "\u00ca";
            }

            @Override
            public String getName() {
                return "&Ecirc;";
            }

            @Override
            public String getCode() {
                return "&#202;";
            }

            @Override
            public String getRemark() {
                return "&#202;";
            }
        }
        ,
        Iuml{

            @Override
            public String getDisplay() {
                return "\u00cf";
            }

            @Override
            public String getName() {
                return "&Iuml;";
            }

            @Override
            public String getCode() {
                return "&#207;";
            }

            @Override
            public String getRemark() {
                return "&#207;";
            }
        }
        ,
        Ocirc{

            @Override
            public String getDisplay() {
                return "\u00d4";
            }

            @Override
            public String getName() {
                return "&Ocirc;";
            }

            @Override
            public String getCode() {
                return "&#212;";
            }

            @Override
            public String getRemark() {
                return "&#212;";
            }
        }
        ,
        Ugrave{

            @Override
            public String getDisplay() {
                return "\u00d9";
            }

            @Override
            public String getName() {
                return "&Ugrave;";
            }

            @Override
            public String getCode() {
                return "&#217;";
            }

            @Override
            public String getRemark() {
                return "&#217;";
            }
        }
        ,
        THORN{

            @Override
            public String getDisplay() {
                return "\u00de";
            }

            @Override
            public String getName() {
                return "&THORN;";
            }

            @Override
            public String getCode() {
                return "&#222;";
            }

            @Override
            public String getRemark() {
                return "&#222;";
            }
        }
        ,
        atilde{

            @Override
            public String getDisplay() {
                return "\u00e3";
            }

            @Override
            public String getName() {
                return "&atilde;";
            }

            @Override
            public String getCode() {
                return "&#227;";
            }

            @Override
            public String getRemark() {
                return "&#227;";
            }
        }
        ,
        egrave{

            @Override
            public String getDisplay() {
                return "\u00e8";
            }

            @Override
            public String getName() {
                return "&egrave;";
            }

            @Override
            public String getCode() {
                return "&#232;";
            }

            @Override
            public String getRemark() {
                return "&#232;";
            }
        }
        ,
        iacute{

            @Override
            public String getDisplay() {
                return "\u00ed";
            }

            @Override
            public String getName() {
                return "&iacute;";
            }

            @Override
            public String getCode() {
                return "&#237;";
            }

            @Override
            public String getRemark() {
                return "&#237;";
            }
        }
        ,
        ograve{

            @Override
            public String getDisplay() {
                return "\u00f2";
            }

            @Override
            public String getName() {
                return "&ograve;";
            }

            @Override
            public String getCode() {
                return "&#242;";
            }

            @Override
            public String getRemark() {
                return "&#242;";
            }
        }
        ,
        uuml{

            @Override
            public String getDisplay() {
                return "\u00fc";
            }

            @Override
            public String getName() {
                return "&uuml;";
            }

            @Override
            public String getCode() {
                return "&#252;";
            }

            @Override
            public String getRemark() {
                return "&#252;";
            }
        }
        ,
        Beta{

            @Override
            public String getDisplay() {
                return "\u0392";
            }

            @Override
            public String getName() {
                return "&Beta;";
            }

            @Override
            public String getCode() {
                return "&#914;";
            }

            @Override
            public String getRemark() {
                return "&#914;";
            }
        }
        ,
        Eta{

            @Override
            public String getDisplay() {
                return "\u0397";
            }

            @Override
            public String getName() {
                return "&Eta;";
            }

            @Override
            public String getCode() {
                return "&#919;";
            }

            @Override
            public String getRemark() {
                return "&#919;";
            }
        }
        ,
        Mu{

            @Override
            public String getDisplay() {
                return "\u039c";
            }

            @Override
            public String getName() {
                return "&Mu;";
            }

            @Override
            public String getCode() {
                return "&#924;";
            }

            @Override
            public String getRemark() {
                return "&#924;";
            }
        }
        ,
        Rho{

            @Override
            public String getDisplay() {
                return "\u03a1";
            }

            @Override
            public String getName() {
                return "&Rho;";
            }

            @Override
            public String getCode() {
                return "&#929;";
            }

            @Override
            public String getRemark() {
                return "&#929;";
            }
        }
        ,
        Chi{

            @Override
            public String getDisplay() {
                return "\u03a7";
            }

            @Override
            public String getName() {
                return "&Chi;";
            }

            @Override
            public String getCode() {
                return "&#935;";
            }

            @Override
            public String getRemark() {
                return "&#935;";
            }
        }
        ,
        gamma{

            @Override
            public String getDisplay() {
                return "\u03b3";
            }

            @Override
            public String getName() {
                return "&gamma;";
            }

            @Override
            public String getCode() {
                return "&#947;";
            }

            @Override
            public String getRemark() {
                return "&#947;";
            }
        }
        ,
        theta{

            @Override
            public String getDisplay() {
                return "\u03b8";
            }

            @Override
            public String getName() {
                return "&theta;";
            }

            @Override
            public String getCode() {
                return "&#952;";
            }

            @Override
            public String getRemark() {
                return "&#952;";
            }
        }
        ,
        nu{

            @Override
            public String getDisplay() {
                return "\u03bd";
            }

            @Override
            public String getName() {
                return "&nu;";
            }

            @Override
            public String getCode() {
                return "&#957;";
            }

            @Override
            public String getRemark() {
                return "&#957;";
            }
        }
        ,
        sigmaf{

            @Override
            public String getDisplay() {
                return "\u03c2";
            }

            @Override
            public String getName() {
                return "&sigmaf;";
            }

            @Override
            public String getCode() {
                return "&#962;";
            }

            @Override
            public String getRemark() {
                return "&#962;";
            }
        }
        ,
        chi{

            @Override
            public String getDisplay() {
                return "\u03c7";
            }

            @Override
            public String getName() {
                return "&chi;";
            }

            @Override
            public String getCode() {
                return "&#967;";
            }

            @Override
            public String getRemark() {
                return "&#967;";
            }
        }
        ,
        piv{

            @Override
            public String getDisplay() {
                return "\u03d6";
            }

            @Override
            public String getName() {
                return "&piv;";
            }

            @Override
            public String getCode() {
                return "&#982;";
            }

            @Override
            public String getRemark() {
                return "&#982;";
            }
        }
        ,
        oline{

            @Override
            public String getDisplay() {
                return "\u203e";
            }

            @Override
            public String getName() {
                return "&oline;";
            }

            @Override
            public String getCode() {
                return "&#8254;";
            }

            @Override
            public String getRemark() {
                return "&#8254;";
            }
        }
        ,
        trade{

            @Override
            public String getDisplay() {
                return "\u2122";
            }

            @Override
            public String getName() {
                return "&trade;";
            }

            @Override
            public String getCode() {
                return "&#8482;";
            }

            @Override
            public String getRemark() {
                return "&#8482;";
            }
        }
        ,
        darr{

            @Override
            public String getDisplay() {
                return "\u2193";
            }

            @Override
            public String getName() {
                return "&darr;";
            }

            @Override
            public String getCode() {
                return "&#8595;";
            }

            @Override
            public String getRemark() {
                return "&#8595;";
            }
        }
        ,
        rArr{

            @Override
            public String getDisplay() {
                return "\u21d2";
            }

            @Override
            public String getName() {
                return "&rArr;";
            }

            @Override
            public String getCode() {
                return "&#8658;";
            }

            @Override
            public String getRemark() {
                return "&#8658;";
            }
        }
        ,
        exist{

            @Override
            public String getDisplay() {
                return "\u2203";
            }

            @Override
            public String getName() {
                return "&exist;";
            }

            @Override
            public String getCode() {
                return "&#8707;";
            }

            @Override
            public String getRemark() {
                return "&#8707;";
            }
        }
        ,
        ni{

            @Override
            public String getDisplay() {
                return "\u220b";
            }

            @Override
            public String getName() {
                return "&ni;";
            }

            @Override
            public String getCode() {
                return "&#8715;";
            }

            @Override
            public String getRemark() {
                return "&#8715;";
            }
        }
        ,
        radic{

            @Override
            public String getDisplay() {
                return "\u221a";
            }

            @Override
            public String getName() {
                return "&radic;";
            }

            @Override
            public String getCode() {
                return "&#8730;";
            }

            @Override
            public String getRemark() {
                return "&#8730;";
            }
        }
        ,
        or{

            @Override
            public String getDisplay() {
                return "\u2228";
            }

            @Override
            public String getName() {
                return "&or;";
            }

            @Override
            public String getCode() {
                return "&#8744;";
            }

            @Override
            public String getRemark() {
                return "&#8744;";
            }
        }
        ,
        sim{

            @Override
            public String getDisplay() {
                return "\u223c";
            }

            @Override
            public String getName() {
                return "&sim;";
            }

            @Override
            public String getCode() {
                return "&#8764;";
            }

            @Override
            public String getRemark() {
                return "&#8764;";
            }
        }
        ,
        le{

            @Override
            public String getDisplay() {
                return "\u2264";
            }

            @Override
            public String getName() {
                return "&le;";
            }

            @Override
            public String getCode() {
                return "&#8804;";
            }

            @Override
            public String getRemark() {
                return "&#8804;";
            }
        }
        ,
        sube{

            @Override
            public String getDisplay() {
                return "\u2286";
            }

            @Override
            public String getName() {
                return "&sube;";
            }

            @Override
            public String getCode() {
                return "&#8838;";
            }

            @Override
            public String getRemark() {
                return "&#8838;";
            }
        }
        ,
        sdot{

            @Override
            public String getDisplay() {
                return "\u22c5";
            }

            @Override
            public String getName() {
                return "&sdot;";
            }

            @Override
            public String getCode() {
                return "&#8901;";
            }

            @Override
            public String getRemark() {
                return "&#8901;";
            }
        }
        ,
        lang{

            @Override
            public String getDisplay() {
                return "\u27e8";
            }

            @Override
            public String getName() {
                return "&lang;";
            }

            @Override
            public String getCode() {
                return "&#9001;";
            }

            @Override
            public String getRemark() {
                return "&#9001;";
            }
        }
        ,
        hearts{

            @Override
            public String getDisplay() {
                return "\u2665";
            }

            @Override
            public String getName() {
                return "&hearts;";
            }

            @Override
            public String getCode() {
                return "&#9829;";
            }

            @Override
            public String getRemark() {
                return "&#9829;";
            }
        }
        ,
        scaron{

            @Override
            public String getDisplay() {
                return "\u0161";
            }

            @Override
            public String getName() {
                return "&scaron;";
            }

            @Override
            public String getCode() {
                return "&#353;";
            }

            @Override
            public String getRemark() {
                return "&#353;";
            }
        }
        ,
        rlm{

            @Override
            public String getDisplay() {
                return "\u200f";
            }

            @Override
            public String getName() {
                return "&rlm;";
            }

            @Override
            public String getCode() {
                return "&#8207;";
            }

            @Override
            public String getRemark() {
                return "&#8207;";
            }
        }
        ,
        sbquo{

            @Override
            public String getDisplay() {
                return "\u201a";
            }

            @Override
            public String getName() {
                return "&sbquo;";
            }

            @Override
            public String getCode() {
                return "&#8218;";
            }

            @Override
            public String getRemark() {
                return "&#8218;";
            }
        }
        ,
        Dagger{

            @Override
            public String getDisplay() {
                return "\u2021";
            }

            @Override
            public String getName() {
                return "&Dagger;";
            }

            @Override
            public String getCode() {
                return "&#8225;";
            }

            @Override
            public String getRemark() {
                return "&#8225;";
            }
        }
        ,
        pound{

            @Override
            public String getDisplay() {
                return "\u00a3";
            }

            @Override
            public String getName() {
                return "&pound;";
            }

            @Override
            public String getCode() {
                return "&#163;";
            }

            @Override
            public String getRemark() {
                return "&#163;";
            }
        }
        ,
        uml{

            @Override
            public String getDisplay() {
                return "\u00a8";
            }

            @Override
            public String getName() {
                return "&uml;";
            }

            @Override
            public String getCode() {
                return "&#168;";
            }

            @Override
            public String getRemark() {
                return "&#168;";
            }
        }
        ,
        shy{

            @Override
            public String getDisplay() {
                return "\u00ad";
            }

            @Override
            public String getName() {
                return "&shy;";
            }

            @Override
            public String getCode() {
                return "&#173;";
            }

            @Override
            public String getRemark() {
                return "&#173;";
            }
        }
        ,
        sup2{

            @Override
            public String getDisplay() {
                return "\u00b2";
            }

            @Override
            public String getName() {
                return "&sup2;";
            }

            @Override
            public String getCode() {
                return "&#178;";
            }

            @Override
            public String getRemark() {
                return "&#178;";
            }
        }
        ,
        middot{

            @Override
            public String getDisplay() {
                return "\u00b7";
            }

            @Override
            public String getName() {
                return "&middot;";
            }

            @Override
            public String getCode() {
                return "&#183;";
            }

            @Override
            public String getRemark() {
                return "&#183;";
            }
        }
        ,
        frac14{

            @Override
            public String getDisplay() {
                return "\u00bc";
            }

            @Override
            public String getName() {
                return "&frac14;";
            }

            @Override
            public String getCode() {
                return "&#188;";
            }

            @Override
            public String getRemark() {
                return "&#188;";
            }
        }
        ,
        Aacute{

            @Override
            public String getDisplay() {
                return "\u00c1";
            }

            @Override
            public String getName() {
                return "&Aacute;";
            }

            @Override
            public String getCode() {
                return "&#193;";
            }

            @Override
            public String getRemark() {
                return "&#193;";
            }
        }
        ,
        AElig{

            @Override
            public String getDisplay() {
                return "\u00c6";
            }

            @Override
            public String getName() {
                return "&AElig;";
            }

            @Override
            public String getCode() {
                return "&#198;";
            }

            @Override
            public String getRemark() {
                return "&#198;";
            }
        }
        ,
        Euml{

            @Override
            public String getDisplay() {
                return "\u00cb";
            }

            @Override
            public String getName() {
                return "&Euml;";
            }

            @Override
            public String getCode() {
                return "&#203;";
            }

            @Override
            public String getRemark() {
                return "&#203;";
            }
        }
        ,
        ETH{

            @Override
            public String getDisplay() {
                return "\u00d0";
            }

            @Override
            public String getName() {
                return "&ETH;";
            }

            @Override
            public String getCode() {
                return "&#208;";
            }

            @Override
            public String getRemark() {
                return "&#208;";
            }
        }
        ,
        Otilde{

            @Override
            public String getDisplay() {
                return "\u00d5";
            }

            @Override
            public String getName() {
                return "&Otilde;";
            }

            @Override
            public String getCode() {
                return "&#213;";
            }

            @Override
            public String getRemark() {
                return "&#213;";
            }
        }
        ,
        Uacute{

            @Override
            public String getDisplay() {
                return "\u00da";
            }

            @Override
            public String getName() {
                return "&Uacute;";
            }

            @Override
            public String getCode() {
                return "&#218;";
            }

            @Override
            public String getRemark() {
                return "&#218;";
            }
        }
        ,
        szlig{

            @Override
            public String getDisplay() {
                return "\u00df";
            }

            @Override
            public String getName() {
                return "&szlig;";
            }

            @Override
            public String getCode() {
                return "&#223;";
            }

            @Override
            public String getRemark() {
                return "&#223;";
            }
        }
        ,
        auml{

            @Override
            public String getDisplay() {
                return "\u00e4";
            }

            @Override
            public String getName() {
                return "&auml;";
            }

            @Override
            public String getCode() {
                return "&#228;";
            }

            @Override
            public String getRemark() {
                return "&#228;";
            }
        }
        ,
        eacute{

            @Override
            public String getDisplay() {
                return "\u00e9";
            }

            @Override
            public String getName() {
                return "&eacute;";
            }

            @Override
            public String getCode() {
                return "&#233;";
            }

            @Override
            public String getRemark() {
                return "&#233;";
            }
        }
        ,
        icirc{

            @Override
            public String getDisplay() {
                return "\u00ee";
            }

            @Override
            public String getName() {
                return "&icirc;";
            }

            @Override
            public String getCode() {
                return "&#238;";
            }

            @Override
            public String getRemark() {
                return "&#238;";
            }
        }
        ,
        oacute{

            @Override
            public String getDisplay() {
                return "\u00f3";
            }

            @Override
            public String getName() {
                return "&oacute;";
            }

            @Override
            public String getCode() {
                return "&#243;";
            }

            @Override
            public String getRemark() {
                return "&#243;";
            }
        }
        ,
        oslash{

            @Override
            public String getDisplay() {
                return "\u00f8";
            }

            @Override
            public String getName() {
                return "&oslash;";
            }

            @Override
            public String getCode() {
                return "&#248;";
            }

            @Override
            public String getRemark() {
                return "&#248;";
            }
        }
        ,
        yacute{

            @Override
            public String getDisplay() {
                return "\u00fd";
            }

            @Override
            public String getName() {
                return "&yacute;";
            }

            @Override
            public String getCode() {
                return "&#253;";
            }

            @Override
            public String getRemark() {
                return "&#253;";
            }
        }
        ,
        Gamma{

            @Override
            public String getDisplay() {
                return "\u0393";
            }

            @Override
            public String getName() {
                return "&Gamma;";
            }

            @Override
            public String getCode() {
                return "&#915;";
            }

            @Override
            public String getRemark() {
                return "&#915;";
            }
        }
        ,
        Theta{

            @Override
            public String getDisplay() {
                return "\u0398";
            }

            @Override
            public String getName() {
                return "&Theta;";
            }

            @Override
            public String getCode() {
                return "&#920;";
            }

            @Override
            public String getRemark() {
                return "&#920;";
            }
        }
        ,
        Nu{

            @Override
            public String getDisplay() {
                return "\u039d";
            }

            @Override
            public String getName() {
                return "&Nu;";
            }

            @Override
            public String getCode() {
                return "&#925;";
            }

            @Override
            public String getRemark() {
                return "&#925;";
            }
        }
        ,
        Sigma{

            @Override
            public String getDisplay() {
                return "\u03a3";
            }

            @Override
            public String getName() {
                return "&Sigma;";
            }

            @Override
            public String getCode() {
                return "&#931;";
            }

            @Override
            public String getRemark() {
                return "&#931;";
            }
        }
        ,
        Psi{

            @Override
            public String getDisplay() {
                return "\u03a8";
            }

            @Override
            public String getName() {
                return "&Psi;";
            }

            @Override
            public String getCode() {
                return "&#936;";
            }

            @Override
            public String getRemark() {
                return "&#936;";
            }
        }
        ,
        delta{

            @Override
            public String getDisplay() {
                return "\u03b4";
            }

            @Override
            public String getName() {
                return "&delta;";
            }

            @Override
            public String getCode() {
                return "&#948;";
            }

            @Override
            public String getRemark() {
                return "&#948;";
            }
        }
        ,
        iota{

            @Override
            public String getDisplay() {
                return "\u03b9";
            }

            @Override
            public String getName() {
                return "&iota;";
            }

            @Override
            public String getCode() {
                return "&#953;";
            }

            @Override
            public String getRemark() {
                return "&#953;";
            }
        }
        ,
        xi{

            @Override
            public String getDisplay() {
                return "\u03be";
            }

            @Override
            public String getName() {
                return "&xi;";
            }

            @Override
            public String getCode() {
                return "&#958;";
            }

            @Override
            public String getRemark() {
                return "&#958;";
            }
        }
        ,
        sigma{

            @Override
            public String getDisplay() {
                return "\u03c3";
            }

            @Override
            public String getName() {
                return "&sigma;";
            }

            @Override
            public String getCode() {
                return "&#963;";
            }

            @Override
            public String getRemark() {
                return "&#963;";
            }
        }
        ,
        psi{

            @Override
            public String getDisplay() {
                return "\u03c8";
            }

            @Override
            public String getName() {
                return "&psi;";
            }

            @Override
            public String getCode() {
                return "&#968;";
            }

            @Override
            public String getRemark() {
                return "&#968;";
            }
        }
        ,
        bull{

            @Override
            public String getDisplay() {
                return "\u2022";
            }

            @Override
            public String getName() {
                return "&bull;";
            }

            @Override
            public String getCode() {
                return "&#8226;";
            }

            @Override
            public String getRemark() {
                return "&#8226;";
            }
        }
        ,
        frasl{

            @Override
            public String getDisplay() {
                return "\u2044";
            }

            @Override
            public String getName() {
                return "&frasl;";
            }

            @Override
            public String getCode() {
                return "&#8260;";
            }

            @Override
            public String getRemark() {
                return "&#8260;";
            }
        }
        ,
        alefsym{

            @Override
            public String getDisplay() {
                return "\u2135";
            }

            @Override
            public String getName() {
                return "&alefsym;";
            }

            @Override
            public String getCode() {
                return "&#8501;";
            }

            @Override
            public String getRemark() {
                return "&#8501;";
            }
        }
        ,
        harr{

            @Override
            public String getDisplay() {
                return "\u2194";
            }

            @Override
            public String getName() {
                return "&harr;";
            }

            @Override
            public String getCode() {
                return "&#8596;";
            }

            @Override
            public String getRemark() {
                return "&#8596;";
            }
        }
        ,
        dArr{

            @Override
            public String getDisplay() {
                return "\u21d3";
            }

            @Override
            public String getName() {
                return "&dArr;";
            }

            @Override
            public String getCode() {
                return "&#8659;";
            }

            @Override
            public String getRemark() {
                return "&#8659;";
            }
        }
        ,
        empty{

            @Override
            public String getDisplay() {
                return "\u2205";
            }

            @Override
            public String getName() {
                return "&empty;";
            }

            @Override
            public String getCode() {
                return "&#8709;";
            }

            @Override
            public String getRemark() {
                return "&#8709;";
            }
        }
        ,
        prod{

            @Override
            public String getDisplay() {
                return "\u220f";
            }

            @Override
            public String getName() {
                return "&prod;";
            }

            @Override
            public String getCode() {
                return "&#8719;";
            }

            @Override
            public String getRemark() {
                return "&#8719;";
            }
        }
        ,
        prop{

            @Override
            public String getDisplay() {
                return "\u221d";
            }

            @Override
            public String getName() {
                return "&prop;";
            }

            @Override
            public String getCode() {
                return "&#8733;";
            }

            @Override
            public String getRemark() {
                return "&#8733;";
            }
        }
        ,
        cap{

            @Override
            public String getDisplay() {
                return "\u2229";
            }

            @Override
            public String getName() {
                return "&cap;";
            }

            @Override
            public String getCode() {
                return "&#8745;";
            }

            @Override
            public String getRemark() {
                return "&#8745;";
            }
        }
        ,
        cong{

            @Override
            public String getDisplay() {
                return "\u2245";
            }

            @Override
            public String getName() {
                return "&cong;";
            }

            @Override
            public String getCode() {
                return "&#8773;";
            }

            @Override
            public String getRemark() {
                return "&#8773;";
            }
        }
        ,
        ge{

            @Override
            public String getDisplay() {
                return "\u2265";
            }

            @Override
            public String getName() {
                return "&ge;";
            }

            @Override
            public String getCode() {
                return "&#8805;";
            }

            @Override
            public String getRemark() {
                return "&#8805;";
            }
        }
        ,
        supe{

            @Override
            public String getDisplay() {
                return "\u2287";
            }

            @Override
            public String getName() {
                return "&supe;";
            }

            @Override
            public String getCode() {
                return "&#8839;";
            }

            @Override
            public String getRemark() {
                return "&#8839;";
            }
        }
        ,
        lceil{

            @Override
            public String getDisplay() {
                return "\u2308";
            }

            @Override
            public String getName() {
                return "&lceil;";
            }

            @Override
            public String getCode() {
                return "&#8968;";
            }

            @Override
            public String getRemark() {
                return "&#8968;";
            }
        }
        ,
        rang{

            @Override
            public String getDisplay() {
                return "\u27e9";
            }

            @Override
            public String getName() {
                return "&rang;";
            }

            @Override
            public String getCode() {
                return "&#9002;";
            }

            @Override
            public String getRemark() {
                return "&#9002;";
            }
        }
        ,
        diams{

            @Override
            public String getDisplay() {
                return "\u2666";
            }

            @Override
            public String getName() {
                return "&diams;";
            }

            @Override
            public String getCode() {
                return "&#9830;";
            }

            @Override
            public String getRemark() {
                return "&#9830;";
            }
        }
        ,
        Yuml{

            @Override
            public String getDisplay() {
                return "\u0178";
            }

            @Override
            public String getName() {
                return "&Yuml;";
            }

            @Override
            public String getCode() {
                return "&#376;";
            }

            @Override
            public String getRemark() {
                return "&#376;";
            }
        }
        ,
        thinsp{

            @Override
            public String getDisplay() {
                return "";
            }

            @Override
            public String getName() {
                return "&thinsp;";
            }

            @Override
            public String getCode() {
                return "&#8201;";
            }

            @Override
            public String getRemark() {
                return "&#8201;";
            }
        }
        ,
        ndash{

            @Override
            public String getDisplay() {
                return "\u2013";
            }

            @Override
            public String getName() {
                return "&ndash;";
            }

            @Override
            public String getCode() {
                return "&#8211;";
            }

            @Override
            public String getRemark() {
                return "&#8211;";
            }
        }
        ,
        ldquo{

            @Override
            public String getDisplay() {
                return "\u201c";
            }

            @Override
            public String getName() {
                return "&ldquo;";
            }

            @Override
            public String getCode() {
                return "&#8220;";
            }

            @Override
            public String getRemark() {
                return "&#8220;";
            }
        }
        ,
        permil{

            @Override
            public String getDisplay() {
                return "\u2030";
            }

            @Override
            public String getName() {
                return "&permil;";
            }

            @Override
            public String getCode() {
                return "&#8240;";
            }

            @Override
            public String getRemark() {
                return "&#8240;";
            }
        }
        ,
        curren{

            @Override
            public String getDisplay() {
                return "\u00a4";
            }

            @Override
            public String getName() {
                return "&curren;";
            }

            @Override
            public String getCode() {
                return "&#164;";
            }

            @Override
            public String getRemark() {
                return "&#164;";
            }
        }
        ,
        sup3{

            @Override
            public String getDisplay() {
                return "\u00b3";
            }

            @Override
            public String getName() {
                return "&sup3;";
            }

            @Override
            public String getCode() {
                return "&#179;";
            }

            @Override
            public String getRemark() {
                return "&#179;";
            }
        }
        ,
        cedil{

            @Override
            public String getDisplay() {
                return "\u00b8";
            }

            @Override
            public String getName() {
                return "&cedil;";
            }

            @Override
            public String getCode() {
                return "&#184;";
            }

            @Override
            public String getRemark() {
                return "&#184;";
            }
        }
        ,
        frac12{

            @Override
            public String getDisplay() {
                return "\u00bd";
            }

            @Override
            public String getName() {
                return "&frac12;";
            }

            @Override
            public String getCode() {
                return "&#189;";
            }

            @Override
            public String getRemark() {
                return "&#189;";
            }
        }
        ,
        Acirc{

            @Override
            public String getDisplay() {
                return "\u00c2";
            }

            @Override
            public String getName() {
                return "&Acirc;";
            }

            @Override
            public String getCode() {
                return "&#194;";
            }

            @Override
            public String getRemark() {
                return "&#194;";
            }
        }
        ,
        Ccedil{

            @Override
            public String getDisplay() {
                return "\u00c7";
            }

            @Override
            public String getName() {
                return "&Ccedil;";
            }

            @Override
            public String getCode() {
                return "&#199;";
            }

            @Override
            public String getRemark() {
                return "&#199;";
            }
        }
        ,
        Igrave{

            @Override
            public String getDisplay() {
                return "\u00cc";
            }

            @Override
            public String getName() {
                return "&Igrave;";
            }

            @Override
            public String getCode() {
                return "&#204;";
            }

            @Override
            public String getRemark() {
                return "&#204;";
            }
        }
        ,
        Ntilde{

            @Override
            public String getDisplay() {
                return "\u00d1";
            }

            @Override
            public String getName() {
                return "&Ntilde;";
            }

            @Override
            public String getCode() {
                return "&#209;";
            }

            @Override
            public String getRemark() {
                return "&#209;";
            }
        }
        ,
        Ouml{

            @Override
            public String getDisplay() {
                return "\u00d6";
            }

            @Override
            public String getName() {
                return "&Ouml;";
            }

            @Override
            public String getCode() {
                return "&#214;";
            }

            @Override
            public String getRemark() {
                return "&#214;";
            }
        }
        ,
        Ucirc{

            @Override
            public String getDisplay() {
                return "\u00db";
            }

            @Override
            public String getName() {
                return "&Ucirc;";
            }

            @Override
            public String getCode() {
                return "&#219;";
            }

            @Override
            public String getRemark() {
                return "&#219;";
            }
        }
        ,
        agrave{

            @Override
            public String getDisplay() {
                return "\u00e0";
            }

            @Override
            public String getName() {
                return "&agrave;";
            }

            @Override
            public String getCode() {
                return "&#224;";
            }

            @Override
            public String getRemark() {
                return "&#224;";
            }
        }
        ,
        aring{

            @Override
            public String getDisplay() {
                return "\u00e5";
            }

            @Override
            public String getName() {
                return "&aring;";
            }

            @Override
            public String getCode() {
                return "&#229;";
            }

            @Override
            public String getRemark() {
                return "&#229;";
            }
        }
        ,
        ecirc{

            @Override
            public String getDisplay() {
                return "\u00ea";
            }

            @Override
            public String getName() {
                return "&ecirc;";
            }

            @Override
            public String getCode() {
                return "&#234;";
            }

            @Override
            public String getRemark() {
                return "&#234;";
            }
        }
        ,
        iuml{

            @Override
            public String getDisplay() {
                return "\u00ef";
            }

            @Override
            public String getName() {
                return "&iuml;";
            }

            @Override
            public String getCode() {
                return "&#239;";
            }

            @Override
            public String getRemark() {
                return "&#239;";
            }
        }
        ,
        ocirc{

            @Override
            public String getDisplay() {
                return "\u00f4";
            }

            @Override
            public String getName() {
                return "&ocirc;";
            }

            @Override
            public String getCode() {
                return "&#244;";
            }

            @Override
            public String getRemark() {
                return "&#244;";
            }
        }
        ,
        ugrave{

            @Override
            public String getDisplay() {
                return "\u00f9";
            }

            @Override
            public String getName() {
                return "&ugrave;";
            }

            @Override
            public String getCode() {
                return "&#249;";
            }

            @Override
            public String getRemark() {
                return "&#249;";
            }
        }
        ,
        thorn{

            @Override
            public String getDisplay() {
                return "\u00fe";
            }

            @Override
            public String getName() {
                return "&thorn;";
            }

            @Override
            public String getCode() {
                return "&#254;";
            }

            @Override
            public String getRemark() {
                return "&#254;";
            }
        }
        ,
        Delta{

            @Override
            public String getDisplay() {
                return "\u0394";
            }

            @Override
            public String getName() {
                return "&Delta;";
            }

            @Override
            public String getCode() {
                return "&#916;";
            }

            @Override
            public String getRemark() {
                return "&#916;";
            }
        }
        ,
        Iota{

            @Override
            public String getDisplay() {
                return "\u0399";
            }

            @Override
            public String getName() {
                return "&Iota;";
            }

            @Override
            public String getCode() {
                return "&#921;";
            }

            @Override
            public String getRemark() {
                return "&#921;";
            }
        }
        ,
        Xi{

            @Override
            public String getDisplay() {
                return "\u039e";
            }

            @Override
            public String getName() {
                return "&Xi;";
            }

            @Override
            public String getCode() {
                return "&#926;";
            }

            @Override
            public String getRemark() {
                return "&#926;";
            }
        }
        ,
        Tau{

            @Override
            public String getDisplay() {
                return "\u03a4";
            }

            @Override
            public String getName() {
                return "&Tau;";
            }

            @Override
            public String getCode() {
                return "&#932;";
            }

            @Override
            public String getRemark() {
                return "&#932;";
            }
        }
        ,
        Omega{

            @Override
            public String getDisplay() {
                return "\u03a9";
            }

            @Override
            public String getName() {
                return "&Omega;";
            }

            @Override
            public String getCode() {
                return "&#937;";
            }

            @Override
            public String getRemark() {
                return "&#937;";
            }
        }
        ,
        epsilon{

            @Override
            public String getDisplay() {
                return "\u03b5";
            }

            @Override
            public String getName() {
                return "&epsilon;";
            }

            @Override
            public String getCode() {
                return "&#949;";
            }

            @Override
            public String getRemark() {
                return "&#949;";
            }
        }
        ,
        kappa{

            @Override
            public String getDisplay() {
                return "\u03ba";
            }

            @Override
            public String getName() {
                return "&kappa;";
            }

            @Override
            public String getCode() {
                return "&#954;";
            }

            @Override
            public String getRemark() {
                return "&#954;";
            }
        }
        ,
        omicron{

            @Override
            public String getDisplay() {
                return "\u03bf";
            }

            @Override
            public String getName() {
                return "&omicron;";
            }

            @Override
            public String getCode() {
                return "&#959;";
            }

            @Override
            public String getRemark() {
                return "&#959;";
            }
        }
        ,
        tau{

            @Override
            public String getDisplay() {
                return "\u03c4";
            }

            @Override
            public String getName() {
                return "&tau;";
            }

            @Override
            public String getCode() {
                return "&#964;";
            }

            @Override
            public String getRemark() {
                return "&#964;";
            }
        }
        ,
        omega{

            @Override
            public String getDisplay() {
                return "\u03c9";
            }

            @Override
            public String getName() {
                return "&omega;";
            }

            @Override
            public String getCode() {
                return "&#969;";
            }

            @Override
            public String getRemark() {
                return "&#969;";
            }
        }
        ,
        hellip{

            @Override
            public String getDisplay() {
                return "\u2026";
            }

            @Override
            public String getName() {
                return "&hellip;";
            }

            @Override
            public String getCode() {
                return "&#8230;";
            }

            @Override
            public String getRemark() {
                return "&#8230;";
            }
        }
        ,
        weierp{

            @Override
            public String getDisplay() {
                return "\u2118";
            }

            @Override
            public String getName() {
                return "&weierp;";
            }

            @Override
            public String getCode() {
                return "&#8472;";
            }

            @Override
            public String getRemark() {
                return "&#8472;";
            }
        }
        ,
        larr{

            @Override
            public String getDisplay() {
                return "\u2190";
            }

            @Override
            public String getName() {
                return "&larr;";
            }

            @Override
            public String getCode() {
                return "&#8592;";
            }

            @Override
            public String getRemark() {
                return "&#8592;";
            }
        }
        ,
        crarr{

            @Override
            public String getDisplay() {
                return "\u21b5";
            }

            @Override
            public String getName() {
                return "&crarr;";
            }

            @Override
            public String getCode() {
                return "&#8629;";
            }

            @Override
            public String getRemark() {
                return "&#8629;";
            }
        }
        ,
        hArr{

            @Override
            public String getDisplay() {
                return "\u21d4";
            }

            @Override
            public String getName() {
                return "&hArr;";
            }

            @Override
            public String getCode() {
                return "&#8660;";
            }

            @Override
            public String getRemark() {
                return "&#8660;";
            }
        }
        ,
        nabla{

            @Override
            public String getDisplay() {
                return "\u2207";
            }

            @Override
            public String getName() {
                return "&nabla;";
            }

            @Override
            public String getCode() {
                return "&#8711;";
            }

            @Override
            public String getRemark() {
                return "&#8711;";
            }
        }
        ,
        sum{

            @Override
            public String getDisplay() {
                return "\u2211";
            }

            @Override
            public String getName() {
                return "&sum;";
            }

            @Override
            public String getCode() {
                return "&#8721;";
            }

            @Override
            public String getRemark() {
                return "&#8721;";
            }
        }
        ,
        infin{

            @Override
            public String getDisplay() {
                return "\u221e";
            }

            @Override
            public String getName() {
                return "&infin;";
            }

            @Override
            public String getCode() {
                return "&#8734;";
            }

            @Override
            public String getRemark() {
                return "&#8734;";
            }
        }
        ,
        cup{

            @Override
            public String getDisplay() {
                return "\u222a";
            }

            @Override
            public String getName() {
                return "&cup;";
            }

            @Override
            public String getCode() {
                return "&#8746;";
            }

            @Override
            public String getRemark() {
                return "&#8746;";
            }
        }
        ,
        asymp{

            @Override
            public String getDisplay() {
                return "\u2248";
            }

            @Override
            public String getName() {
                return "&asymp;";
            }

            @Override
            public String getCode() {
                return "&#8776;";
            }

            @Override
            public String getRemark() {
                return "&#8776;";
            }
        }
        ,
        sub{

            @Override
            public String getDisplay() {
                return "\u2282";
            }

            @Override
            public String getName() {
                return "&sub;";
            }

            @Override
            public String getCode() {
                return "&#8834;";
            }

            @Override
            public String getRemark() {
                return "&#8834;";
            }
        }
        ,
        oplus{

            @Override
            public String getDisplay() {
                return "\u2295";
            }

            @Override
            public String getName() {
                return "&oplus;";
            }

            @Override
            public String getCode() {
                return "&#8853;";
            }

            @Override
            public String getRemark() {
                return "&#8853;";
            }
        }
        ,
        rceil{

            @Override
            public String getDisplay() {
                return "\u2309";
            }

            @Override
            public String getName() {
                return "&rceil;";
            }

            @Override
            public String getCode() {
                return "&#8969;";
            }

            @Override
            public String getRemark() {
                return "&#8969;";
            }
        }
        ,
        loz{

            @Override
            public String getDisplay() {
                return "\u25ca";
            }

            @Override
            public String getName() {
                return "&loz;";
            }

            @Override
            public String getCode() {
                return "&#9674;";
            }

            @Override
            public String getRemark() {
                return "&#9674;";
            }
        }
        ,
        OElig{

            @Override
            public String getDisplay() {
                return "\u0152";
            }

            @Override
            public String getName() {
                return "&OElig;";
            }

            @Override
            public String getCode() {
                return "&#338;";
            }

            @Override
            public String getRemark() {
                return "&#338;";
            }
        }
        ,
        circ{

            @Override
            public String getDisplay() {
                return "\u02c6";
            }

            @Override
            public String getName() {
                return "&circ;";
            }

            @Override
            public String getCode() {
                return "&#710;";
            }

            @Override
            public String getRemark() {
                return "&#710;";
            }
        }
        ,
        zwnj{

            @Override
            public String getDisplay() {
                return "\u200c";
            }

            @Override
            public String getName() {
                return "&zwnj;";
            }

            @Override
            public String getCode() {
                return "&#8204;";
            }

            @Override
            public String getRemark() {
                return "&#8204;";
            }
        }
        ,
        mdash{

            @Override
            public String getDisplay() {
                return "\u2014";
            }

            @Override
            public String getName() {
                return "&mdash;";
            }

            @Override
            public String getCode() {
                return "&#8212;";
            }

            @Override
            public String getRemark() {
                return "&#8212;";
            }
        }
        ,
        rdquo{

            @Override
            public String getDisplay() {
                return "\u201d";
            }

            @Override
            public String getName() {
                return "&rdquo;";
            }

            @Override
            public String getCode() {
                return "&#8221;";
            }

            @Override
            public String getRemark() {
                return "&#8221;";
            }
        }
        ,
        lsaquo{

            @Override
            public String getDisplay() {
                return "\u2039";
            }

            @Override
            public String getName() {
                return "&lsaquo;";
            }

            @Override
            public String getCode() {
                return "&#8249;";
            }

            @Override
            public String getRemark() {
                return "&#8249;";
            }
        };


        public abstract String getCode();

        public abstract String getDisplay();

        public abstract String getName();

        public abstract String getRemark();
    }
}

