/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.FileUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTable {
    private static final Logger log = LoggerFactory.getLogger(ConfigTable.class);
    private static Map<String, Long> listener_files = new Hashtable<String, Long>();
    protected static String root;
    protected static String webRoot;
    protected static String classpath;
    protected static Hashtable<String, Object> configs;
    protected static long lastLoadTime;
    protected static int reload;
    protected static final String version = "8.6.1-20221209";
    protected static final String minVersion = "0007";
    protected static boolean isLoading;
    private static boolean listener_running;
    public static boolean IS_DEBUG;
    public static boolean IS_SHOW_SQL;
    public static boolean IS_SHOW_SQL_PARAM;
    public static boolean IS_SHOW_SQL_WHEN_ERROR;
    public static boolean IS_SHOW_SQL_PARAM_WHEN_ERROR;
    public static boolean IS_SQL_DEBUG;
    public static boolean IS_HTTP_LOG;
    public static int HTTP_PARAM_ENCODE;
    public static boolean IS_UPPER_KEY;
    public static boolean IS_LOWER_KEY;
    public static boolean IS_KEY_IGNORE_CASE;
    public static boolean IS_THROW_SQL_QUERY_EXCEPTION;
    public static boolean IS_THROW_SQL_UPDATE_EXCEPTION;
    public static boolean IS_UPDATE_NULL_COLUMN;
    public static boolean IS_UPDATE_EMPTY_COLUMN;
    public static boolean IS_INSERT_NULL_COLUMN;
    public static boolean IS_INSERT_EMPTY_COLUMN;
    public static boolean IS_SQL_DELIMITER_OPEN;
    public static boolean IS_SQL_DELIMITER_PLACEHOLDER_OPEN;
    public static boolean IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL;
    public static boolean IS_AUTO_CHECK_METADATA;
    public static String DEFAULT_PRIMARY_KEY;
    public static int AFTER_ALTER_COLUMN_EXCEPTION_ACTION;
    public static boolean IS_DDL_AUTO_DROP_COLUMN;
    public static String SQL_STORE_DIR;
    public static String ENTITY_TABLE_ANNOTATION;
    public static String ENTITY_COLUMN_ANNOTATION;
    public static String ENTITY_PRIMARY_KEY_ANNOTATION;
    public static String HTTP_PARAM_KEY_CASE;
    public static String TABLE_METADATA_CACHE_KEY;
    public static int TABLE_METADATA_CACHE_SECOND;
    public static String SQL_DELIMITER_PLACEHOLDER;
    public static String CONFIG_NAME;

    private static synchronized void listener() {
        if (listener_running) {
            return;
        }
        listener_running = true;
        log.warn("[\u542f\u52a8\u76d1\u542c]");
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (Map.Entry item : listener_files.entrySet()) {
                        File file = new File((String)item.getKey());
                        Long lastLoad = (Long)item.getValue();
                        Long lastModify = file.lastModified();
                        if (lastLoad != 0L && lastModify <= lastLoad) continue;
                        ConfigTable.parse(file);
                    }
                    if (ConfigTable.getInt("RELOAD", 0) != 0) break;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                listener_running = false;
            }
        }).start();
    }

    protected ConfigTable() {
    }

    public static void addConfig(String content) {
        ConfigTable.loadConfig(content);
    }

    public static void addConfig(File ... files) {
        if (null == files) {
            return;
        }
        for (File file : files) {
            ConfigTable.loadConfig(file);
        }
    }

    public static Hashtable<String, Object> getConfigs() {
        return configs;
    }

    public static String getWebRoot() {
        return webRoot;
    }

    public static void setWebRoot(String webRoot) {
        ConfigTable.webRoot = webRoot;
        ConfigTable.init();
    }

    public static String getRoot() {
        return root;
    }

    public static void setRoot(String root) {
        ConfigTable.root = root;
        ConfigTable.init();
    }

    public static String getWebClassPath() {
        String result = webRoot + File.separator + "WEB-INF" + File.separator + "classes" + File.separator;
        return result;
    }

    public static String getClassPath() {
        return classpath;
    }

    public static void init() {
        ConfigTable.init("anyline");
    }

    public static String getPackageType() {
        String type = "war";
        String path = ConfigTable.class.getResource("/").getPath();
        if (path.contains(".jar!")) {
            type = "jar";
        }
        return type;
    }

    public static void init(String flag) {
        if (isLoading) {
            return;
        }
        lastLoadTime = System.currentTimeMillis();
        isLoading = true;
        String path = "";
        try {
            path = ConfigTable.class.getResource("/").getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.warn("path={}", (Object)path);
        Properties props = System.getProperties();
        String osName = props.getProperty("os.name");
        if (null != osName && osName.toUpperCase().contains("WINDOWS") && path.startsWith("/")) {
            path = path.substring(1);
            path = path.replace("file:/", "");
        }
        path = path.replace("file:", "");
        if (null == root && null != path) {
            root = path;
            if (root.contains(".jar")) {
                root = root.substring(0, root.indexOf(".jar"));
                root = root.substring(0, root.lastIndexOf("/"));
            }
            if (path.indexOf("bin") > 0) {
                root = path.substring(0, path.indexOf("bin") - 1);
            }
            if (path.indexOf("target") > 0) {
                root = path.substring(0, path.indexOf("target") - 1);
            }
        }
        if (null == webRoot && null != path) {
            webRoot = path;
            if (path.indexOf("WEB-INF") > 0) {
                webRoot = path.substring(0, path.indexOf("WEB-INF") - 1);
            }
        }
        classpath = path.contains("classes") ? path : (path.contains("WEB-INF") ? webRoot + File.separator + "WEB-INF" + File.separator + "classes" + File.separator : root + File.separator + "bin" + File.separator + "classes" + File.separator);
        ConfigTable.loadConfig(flag);
    }

    protected static synchronized void loadConfig(String flag) {
        try {
            if (null == configs) {
                configs = new Hashtable();
            }
            if (null != root) {
                configs.put("HOME_DIR", root);
            }
            if ("jar".equals(ConfigTable.getPackageType())) {
                InputStream in;
                log.warn("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6][type:jar][file:{}]", (Object)(flag + "-config.xml"));
                if (FileUtil.getPathType(AnylineConfig.class) == 0) {
                    String name;
                    JarEntry entry;
                    ArrayList<JarEntry> list = new ArrayList<JarEntry>();
                    JarFile jFile = new JarFile(System.getProperty("java.class.path"));
                    Enumeration<JarEntry> jarEntrys = jFile.entries();
                    while (jarEntrys.hasMoreElements()) {
                        entry = jarEntrys.nextElement();
                        name = entry.getName();
                        if (!name.endsWith(flag + "-config.xml")) continue;
                        list.add(entry);
                    }
                    while (jarEntrys.hasMoreElements()) {
                        entry = jarEntrys.nextElement();
                        name = entry.getName();
                        if (!name.contains(flag + "-config") || name.endsWith(flag + "-config.xml")) continue;
                        list.add(entry);
                    }
                    for (JarEntry jarEntry : list) {
                        in = AnylineConfig.class.getClassLoader().getResourceAsStream(jarEntry.getName());
                        ConfigTable.parse(in);
                    }
                } else {
                    in = ConfigTable.class.getClassLoader().getResourceAsStream("/" + flag + "-config.xml");
                    String txt = FileUtil.read(in, Charset.forName("UTF-8")).toString();
                    ConfigTable.parse(txt);
                }
                File dir = new File(FileUtil.merge(root, "config"));
                ConfigTable.loadConfigDir(dir, flag);
                ConfigTable.loadConfig(new File(root, flag + "-config.xml"));
            } else {
                File dir = new File(classpath);
                ConfigTable.loadConfigDir(dir, flag);
            }
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u5f02\u5e38:" + e);
            e.printStackTrace();
        }
        lastLoadTime = System.currentTimeMillis();
        reload = ConfigTable.getInt("RELOAD");
        String isUpper = ConfigTable.getString("IS_UPPER_KEY");
        if (null != isUpper && ("false".equals(isUpper.toLowerCase()) || "0".equals(isUpper))) {
            IS_UPPER_KEY = false;
        }
    }

    protected static synchronized void loadConfigDir(File dir, String flag) {
        String name;
        log.warn("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6][dir:{}]", (Object)dir.getAbsolutePath());
        List<File> files = FileUtil.getAllChildrenFile(dir, "xml");
        for (File f : files) {
            name = f.getName();
            if (!(flag + "-config.xml").equals(name)) continue;
            ConfigTable.loadConfig(f);
        }
        for (File f : files) {
            name = f.getName();
            if (!name.startsWith(flag + "-config") || (flag + "-config.xml").equals(name)) continue;
            ConfigTable.loadConfig(f);
        }
        log.warn("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210]");
    }

    public static void parse(File file) {
        ConfigTable.parse(FileUtil.read(file).toString());
        listener_files.put(file.getAbsolutePath(), System.currentTimeMillis());
    }

    public static void parse(String xml) {
        try {
            if (BasicUtil.isEmpty((Object)xml)) {
                return;
            }
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            Iterator itrProperty = root.elementIterator("property");
            while (itrProperty.hasNext()) {
                Element propertyElement = (Element)itrProperty.next();
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.getTextTrim();
                configs.put(key.toUpperCase().trim(), value);
                if (!IS_DEBUG) continue;
                log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][{}={}]", (Object)key, (Object)value);
            }
            ConfigTable.map2field();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parse(InputStream is) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(is);
            Element root = document.getRootElement();
            Iterator itrProperty = root.elementIterator("property");
            while (itrProperty.hasNext()) {
                Element propertyElement = (Element)itrProperty.next();
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.getTextTrim();
                configs.put(key.toUpperCase().trim(), value);
                if (!IS_DEBUG) continue;
                log.info("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][{}={}]", (Object)key, (Object)value);
            }
            ConfigTable.map2field();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void map2field() {
        Field[] fields;
        for (Field field : fields = ConfigTable.class.getDeclaredFields()) {
            String name = field.getName();
            if (!configs.containsKey(name)) continue;
            BeanUtil.setFieldValue(null, field, configs.get(name));
        }
    }

    protected static void loadConfig(File file) {
        try {
            if (IS_DEBUG) {
                log.info("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6] [file:{}]", (Object)file);
            }
            if (null != file && !file.exists()) {
                log.info("[\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728] [file:{}]", (Object)file.getAbsolutePath());
                return;
            }
            if (file.isDirectory()) {
                List<File> files = FileUtil.getAllChildrenDirectory(file);
                for (File f : files) {
                    ConfigTable.loadConfig(f);
                }
            } else {
                ConfigTable.parse(file);
                if (ConfigTable.getInt("RELOAD", 0) == 0) {
                    ConfigTable.listener();
                }
            }
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u5f02\u5e38:" + e);
        }
    }

    public static Object get(String key) {
        if (null == key) {
            return null;
        }
        Object val = null;
        if (reload > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)reload) {
            isLoading = false;
            ConfigTable.init();
        }
        return configs.get(key.toUpperCase().trim());
    }

    public static String getString(String key) {
        Object val = ConfigTable.get(key);
        if (null != val) {
            return val.toString();
        }
        return null;
    }

    public static String getString(String key, String def) {
        String val = ConfigTable.getString(key);
        if (null == val) {
            val = def;
        }
        return val;
    }

    public static Object get(String key, Object def) {
        Object val = ConfigTable.get(key);
        if (null == val) {
            val = def;
        }
        return val;
    }

    public static boolean getBoolean(String key) {
        return ConfigTable.getBoolean(key, false);
    }

    public static boolean getBoolean(String key, boolean def) {
        return BasicUtil.parseBoolean(ConfigTable.get(key), def);
    }

    public static int getInt(String key) {
        return BasicUtil.parseInt(ConfigTable.get(key), 0);
    }

    public static int getInt(String key, int def) {
        return BasicUtil.parseInt(ConfigTable.get(key), def);
    }

    public static void put(String key, String value) {
        configs.put(key, value);
        if (IS_DEBUG) {
            log.warn("[ConfigTable\u52a8\u6001\u66f4\u65b0][{}={}]", (Object)key, (Object)value);
        }
    }

    public static void put(String key, Object value) {
        configs.put(key, value);
        if (IS_DEBUG) {
            log.warn("[ConfigTable\u52a8\u6001\u66f4\u65b0][{}={}]", (Object)key, value);
        }
    }

    public static String getVersion() {
        return version;
    }

    public static String getMinVersion() {
        return minVersion;
    }

    public static int getReload() {
        return reload;
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isSQLDebug() {
        return IS_SQL_DEBUG;
    }

    protected static void line(String src, String chr, int append, boolean center) {
        int len = 80 + append;
        String line = "";
        if (center) {
            int fillLeft = (len - src.length() - 2) / 2;
            int fillRight = (len - src.length() - 2) / 2;
            if ((len - src.length()) % 2 != 0) {
                ++fillRight;
            }
            line = "*" + BasicUtil.fillChar("", chr, fillLeft) + src + BasicUtil.fillChar("", chr, fillRight) + "*";
        } else {
            int fill = len - src.length() - 2;
            line = "*" + src + BasicUtil.fillChar("", chr, fill) + "";
        }
        System.out.println(line);
    }

    protected static void debug() {
        if (!IS_DEBUG) {
            return;
        }
        try {
            String time = null;
            String version = version;
            String project = null;
            try {
                Properties props;
                String osName;
                String path = ConfigTable.class.getResource("").getPath();
                if (path.startsWith("file:")) {
                    path = path.substring(path.indexOf(":") + 1);
                }
                if (null != (osName = (props = System.getProperties()).getProperty("os.name")) && osName.toUpperCase().contains("WINDOWS") && path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.contains("!")) {
                    path = path.substring(0, path.indexOf("!"));
                }
                if (path.contains("/WEB-INF")) {
                    project = path.substring(0, path.indexOf("/WEB-INF"));
                }
                File file = new File(path);
                try {
                    String anylineJarPath = ConfigTable.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                    String anylineJarName = new File(anylineJarPath).getName();
                    if ((anylineJarName.endsWith("jar") || anylineJarName.endsWith("jar!")) && anylineJarName.contains("-")) {
                        version = anylineJarName.replace("anyline-", "").replace(".jar", "").replace("!", "");
                        version = version.substring(version.indexOf("-") + 1);
                    }
                    file = new File(anylineJarPath);
                }
                catch (Exception e) {
                    // empty catch block
                }
                time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINESE).format(new Date(file.lastModified()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println();
            ConfigTable.line("", "*", 0, true);
            ConfigTable.line("Anyline Core [" + version + "]", " ", 0, true);
            ConfigTable.line("doc.anyline.org ", " ", 0, true);
            ConfigTable.line("", " ", 0, true);
            if (null != time && time.startsWith("2")) {
                ConfigTable.line("Last Modified [" + time + "] ", " ", 0, true);
            } else {
                ConfigTable.line("MinVersion [0007]", " ", 0, true);
            }
            ConfigTable.line("", " ", 0, true);
            ConfigTable.line("", "*", 0, true);
            ConfigTable.line("", "*", 0, true);
            if (null != project) {
                ConfigTable.line(" project root > " + project, "", 0, false);
            }
            ConfigTable.line(" debug status > anyline-config.xml:<property key=\"DEBUG\">boolean</property>", "", 0, false);
            ConfigTable.line(" =================== \u751f\u4ea7\u73af\u5883\u8bf7\u52a1\u5fc5\u4fee\u6539\u5bc6\u94a5\u6587\u4ef6key.xml ========================", "", 0, false);
            ConfigTable.line("", "*", 0, true);
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setUpperKey(boolean bol) {
        IS_UPPER_KEY = bol;
    }

    public static void setLowerKey(boolean bol) {
        IS_LOWER_KEY = bol;
    }

    static {
        lastLoadTime = 0L;
        reload = 0;
        isLoading = false;
        listener_running = false;
        IS_DEBUG = true;
        IS_SHOW_SQL = true;
        IS_SHOW_SQL_PARAM = true;
        IS_SHOW_SQL_WHEN_ERROR = true;
        IS_SHOW_SQL_PARAM_WHEN_ERROR = true;
        IS_SQL_DEBUG = false;
        IS_HTTP_LOG = true;
        HTTP_PARAM_ENCODE = 0;
        IS_UPPER_KEY = true;
        IS_LOWER_KEY = false;
        IS_KEY_IGNORE_CASE = true;
        IS_THROW_SQL_QUERY_EXCEPTION = true;
        IS_THROW_SQL_UPDATE_EXCEPTION = true;
        IS_UPDATE_NULL_COLUMN = false;
        IS_UPDATE_EMPTY_COLUMN = false;
        IS_INSERT_NULL_COLUMN = false;
        IS_INSERT_EMPTY_COLUMN = false;
        IS_SQL_DELIMITER_OPEN = false;
        IS_SQL_DELIMITER_PLACEHOLDER_OPEN = false;
        IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL = false;
        IS_AUTO_CHECK_METADATA = false;
        DEFAULT_PRIMARY_KEY = "ID";
        AFTER_ALTER_COLUMN_EXCEPTION_ACTION = 1000;
        IS_DDL_AUTO_DROP_COLUMN = false;
        SQL_STORE_DIR = null;
        ENTITY_TABLE_ANNOTATION = null;
        ENTITY_COLUMN_ANNOTATION = null;
        ENTITY_PRIMARY_KEY_ANNOTATION = null;
        HTTP_PARAM_KEY_CASE = "camel";
        TABLE_METADATA_CACHE_KEY = "";
        TABLE_METADATA_CACHE_SECOND = 86400;
        SQL_DELIMITER_PLACEHOLDER = "`";
        CONFIG_NAME = "anyline-config.xml";
        ConfigTable.init();
        ConfigTable.debug();
    }
}

