/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);

    public static boolean isPrimitiveClass(Object obj) {
        try {
            Class<?> clazz = null;
            clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            return clazz.isPrimitive() || ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWrapClass(Object obj) {
        return !ClassUtil.isPrimitiveClass(obj);
    }

    public static List<Class<?>> list(String packageName, boolean recursion, Class<?> ... bases) {
        ArrayList list = new ArrayList();
        try {
            List<String> names = ClassUtil.getClassNames(packageName, recursion);
            for (String name : names) {
                try {
                    Class<?> c;
                    if (name.startsWith("java") || !ClassUtil.isInSub(c = Class.forName(name), bases)) continue;
                    list.add(c);
                }
                catch (NoClassDefFoundError e) {
                }
                catch (Exception e) {}
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    public static List<String> names(String packageName, boolean recursion, Class<?> ... bases) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<String> names = ClassUtil.getClassNames(packageName, recursion);
            for (String name : names) {
                try {
                    Class<?> c = Class.forName(name);
                    if (!ClassUtil.isInSub(c, bases)) continue;
                    list.add(name);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean isInSub(Class<?> c, Class<?> ... bases) {
        if (null == bases || bases.length == 0) {
            return true;
        }
        for (Class<?> base : bases) {
            if (!base.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllSub(Class<?> c, Class<?> ... bases) {
        if (null == bases || bases.length == 0) {
            return true;
        }
        for (Class<?> base : bases) {
            if (!base.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getClassNames(String packageName, boolean childPackage) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        log.warn("[\u6b63\u5728\u52a0\u8f7d\u672c\u5730\u7c7b][package:{}]", (Object)packageName);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace(".", "/");
        Enumeration<URL> urls = loader.getResources(packagePath);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) continue;
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames.addAll(ClassUtil.getClassNameListFromFile(url.getPath(), childPackage));
                continue;
            }
            if (!type.equals("jar")) continue;
            fileNames.addAll(ClassUtil.getClassNameListFromJar(url.getPath(), childPackage));
        }
        return fileNames;
    }

    private static List<String> getClassNameListFromFile(String filePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        File[] childFiles = file.listFiles();
        if (childFiles == null) {
            return myClassName;
        }
        for (File childFile : childFiles) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(ClassUtil.getClassNameListFromFile(childFile.getPath(), childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class") || childFilePath.contains("$")) continue;
            String c = childFilePath.split("classes")[1].replace(".class", "");
            if ((c = c.replace("\\", ".").replace("//", ".")).startsWith(".")) {
                c = c.substring(1);
            }
            myClassName.add(c);
        }
        return myClassName;
    }

    private static List<String> getClassNameListFromJar(String jarPath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> names = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    names.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                names.add(entryName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return names;
    }

    private static List<String> getClassNameListFromJar(URL[] urls, String packagePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> names = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                names.addAll(ClassUtil.getClassNameListFromJar(jarPath, childPackage));
            }
        }
        return names;
    }

    public static List<Object> parseAnnotationFieldValues(Class target, String annotation, String field, int qty) {
        Annotation[] annotations = target.getAnnotations();
        return ClassUtil.parseAnnotationFieldValues(annotations, annotation, field, qty);
    }

    public static List<Object> parseAnnotationFieldValues(Class target, String annotation, String field) {
        return ClassUtil.parseAnnotationFieldValues(target, annotation, field, -1);
    }

    public static Object parseAnnotationFieldValue(Class target, String annotation, String field) {
        List<Object> values = ClassUtil.parseAnnotationFieldValues(target, annotation, field, 1);
        if (values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public static List<Object> parseAnnotationFieldValues(Field target, String annotation, String field, int qty) {
        Annotation[] annotations = target.getAnnotations();
        return ClassUtil.parseAnnotationFieldValues(annotations, annotation, field, qty);
    }

    public static List<Object> parseAnnotationFieldValues(Field target, String annotation, String field) {
        return ClassUtil.parseAnnotationFieldValues(target, annotation, field, -1);
    }

    public static Object parseAnnotationFieldValue(Field target, String annotation, String field) {
        List<Object> values = ClassUtil.parseAnnotationFieldValues(target, annotation, field, 1);
        if (values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    private static List<Object> parseAnnotationFieldValues(Annotation[] annotations, String annotation, String field, int qty) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Annotation an : annotations) {
            Method[] methods;
            String name = an.annotationType().getSimpleName();
            if (!ClassUtil.match(name, annotation)) continue;
            for (Method method : methods = an.annotationType().getMethods()) {
                name = method.getName();
                if (!ClassUtil.match(name, field)) continue;
                try {
                    Object value = method.invoke((Object)an, new Object[0]);
                    if (value instanceof Object[]) {
                        Object[] values;
                        for (Object v : values = (Object[])value) {
                            list.add(v);
                            if (qty <= 0 || list.size() < qty) continue;
                            return list;
                        }
                        continue;
                    }
                    list.add(value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    private static boolean match(String value, String regex) {
        regex = regex.replace("*", ".*").toUpperCase();
        return value.toUpperCase().matches(regex);
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (null != clazz) {
            Field[] tmp;
            for (Field field : tmp = clazz.getDeclaredFields()) {
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static List<String> getFieldsName(Class<?> clazz) {
        List<Field> fields = ClassUtil.getFields(clazz);
        ArrayList<String> keys = new ArrayList<String>();
        for (Field field : fields) {
            keys.add(field.getName());
        }
        return keys;
    }

    public static Method getMethod(Class<?> clazz, String name, boolean recursion, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == method) {
            try {
                method = clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == method && recursion && null != (clazz = clazz.getSuperclass())) {
            method = ClassUtil.getMethod(clazz, name, recursion, parameterTypes);
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ClassUtil.getMethod(clazz, name, false, parameterTypes);
    }

    public static Field getField(Class<?> clazz, String name, boolean recursion) {
        Field field = null;
        try {
            field = clazz.getField(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == field) {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == field && recursion && null != (clazz = clazz.getSuperclass())) {
            field = ClassUtil.getField(clazz, name);
        }
        return field;
    }

    public static Field getField(List<Field> fields, String name, boolean ignoreCase, boolean ignoreSplit) {
        if (null == name) {
            return null;
        }
        Field field = null;
        for (Field item : fields) {
            String itemName = item.getName();
            if (ignoreCase) {
                itemName = itemName.toUpperCase();
                name = name.toUpperCase();
            }
            if (ignoreSplit) {
                itemName = itemName.replace("-", "").replace("_", "");
                name = name.replace("-", "").replace("_", "");
            }
            if (!name.equals(itemName)) continue;
            field = item;
        }
        return field;
    }

    public static Field getField(Class<?> clazz, String name) {
        return ClassUtil.getField(clazz, name, true);
    }

    public static List<Field> getFieldsByAnnotation(Class clazz, Class annotation) {
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            List<Field> fields = ClassUtil.getFields(clazz);
            for (Field field : fields) {
                Object at = field.getAnnotation(annotation);
                if (null == at) continue;
                list.add(field);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Field> getFieldsByAnnotation(Class clazz, String ... annotations) {
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            List<Field> fields = ClassUtil.getFields(clazz);
            for (Field field : fields) {
                Annotation[] ans;
                block3: for (Annotation an : ans = field.getAnnotations()) {
                    for (String annotation : annotations) {
                        if (!ClassUtil.match(an.annotationType().getSimpleName(), annotation)) continue;
                        list.add(field);
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Class> getClasses(String pack, Class ... bases) {
        ArrayList<Class> list = new ArrayList<Class>();
        File dir = new File(ClassUtil.class.getResource("/").getFile(), pack.replace(".", File.separator));
        List<File> files = FileUtil.getAllChildrenFile(dir, ".class");
        for (File file : files) {
            try {
                Class<?> clazz;
                String path = file.getAbsolutePath();
                if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                    log.warn("[\u68c0\u7d22\u7c7b][file:{}]", (Object)path);
                }
                if (path.contains(File.separator + "classes" + File.separator)) {
                    path = path.substring(path.indexOf(File.separator + "classes" + File.separator));
                }
                path = path.replace(File.separator, ".");
                path = path.replace(".classes.", "").replace(".class", "");
                if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                    log.warn("[\u68c0\u7d22\u7c7b][class:{}]", (Object)path);
                }
                if ((clazz = Class.forName(path)).getName().contains("$")) continue;
                if (null != bases && bases.length > 0) {
                    for (Class base : bases) {
                        if (clazz.equals(base) || !base.isAssignableFrom(clazz)) continue;
                        list.add(clazz);
                    }
                    continue;
                }
                list.add(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static String parseAnnotationFieldValue(Class clazz, String ... configs) {
        for (String config : configs) {
            Object name;
            String[] tmps = config.split("\\.");
            if (tmps.length < 2 || !BasicUtil.isNotEmpty(name = ClassUtil.parseAnnotationFieldValue(clazz, tmps[0], tmps[1]))) continue;
            return name.toString();
        }
        return null;
    }

    public static String parseAnnotationFieldValue(Field field, String ... configs) {
        for (String config : configs) {
            Object value;
            String[] tmps = config.split("\\.");
            if (tmps.length >= 2) {
                value = ClassUtil.parseAnnotationFieldValue(field, tmps[0], tmps[1]);
                if (!BasicUtil.isNotEmpty(value)) continue;
                return value.toString();
            }
            value = ClassUtil.parseAnnotationFieldValue(field, config, "name");
            if (BasicUtil.isNotEmpty(value)) {
                return value.toString();
            }
            value = ClassUtil.parseAnnotationFieldValue(field, config, "value");
            if (!BasicUtil.isNotEmpty(value)) continue;
            return value.toString();
        }
        return null;
    }
}

