/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.init;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.entity.EntityAdapter;
import org.anyline.entity.adapter.KeyAdapter;
import org.anyline.entity.data.Column;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.CharUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.springframework.stereotype.Component;

@Component(value="anyline.entity.adapter")
public class DefaultAdapter
implements EntityAdapter {
    private static Map<String, String> class2table = new HashMap<String, String>();
    private static Map<String, String> field2column = new HashMap<String, String>();
    private static Map<String, Field> column2field = new HashMap<String, Field>();
    private static Map<String, List<String>> primarys = new HashMap<String, List<String>>();
    private static Map<String, List<String>> insert_columns = new HashMap<String, List<String>>();
    private static Map<String, List<String>> update_columns = new HashMap<String, List<String>>();

    public static void clear() {
        class2table = new HashMap<String, String>();
        field2column = new HashMap<String, String>();
        column2field = new HashMap<String, Field>();
        primarys = new HashMap<String, List<String>>();
        insert_columns = new HashMap<String, List<String>>();
        update_columns = new HashMap<String, List<String>>();
    }

    @Override
    public String table(Class clazz) {
        String key = clazz.getName();
        String name = class2table.get(key);
        if (BasicUtil.isNotEmpty(name)) {
            return name;
        }
        name = ClassUtil.parseAnnotationFieldValue(clazz, "table.name", "table.value", "tableName.name", "tableName.value");
        if (BasicUtil.isNotEmpty(name)) {
            class2table.put(key, name.toString());
            return name;
        }
        name = clazz.getSimpleName();
        class2table.put(key, name.toString());
        return name;
    }

    @Override
    public List<String> columns(Class clazz) {
        return this.columns(clazz, false, false);
    }

    @Override
    public List<String> columns(Class clazz, boolean insert, boolean update) {
        List<String> columns = null;
        if (insert) {
            columns = insert_columns.get(clazz.getName());
        } else if (update) {
            columns = update_columns.get(clazz.getName());
        }
        if (null == columns) {
            columns = new ArrayList<String>();
            List<Field> fields = ClassUtil.getFields(clazz);
            List<Field> ignores = ClassUtil.getFieldsByAnnotation(clazz, "Transient");
            fields.removeAll(ignores);
            for (Field field : fields) {
                String updatable;
                String insertable;
                String column = this.column(clazz, field, new String[0]);
                if (insert && "false".equalsIgnoreCase(insertable = ClassUtil.parseAnnotationFieldValue(field, "column.insertable")) || update && "false".equalsIgnoreCase(updatable = ClassUtil.parseAnnotationFieldValue(field, "column.updatable")) || !BasicUtil.isNotEmpty(column)) continue;
                columns.add(column);
            }
            if (insert) {
                insert_columns.put(clazz.getName(), columns);
            } else if (update) {
                update_columns.put(clazz.getName(), columns);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(columns);
        return list;
    }

    @Override
    public String column(Class clazz, Field field, String ... annotations) {
        String key = clazz.getName() + ":" + field.getName().toUpperCase();
        String name = field2column.get(key);
        if (BasicUtil.isNotEmpty(name)) {
            return name;
        }
        if (null == annotations || annotations.length == 0) {
            annotations = BasicUtil.isNotEmpty(ConfigTable.ENTITY_COLUMN_ANNOTATION) ? ConfigTable.ENTITY_COLUMN_ANNOTATION.split(",") : "column.name,column.value,TableField.name,TableField.value,TableId.name,TableId.value,Id.name,Id.value".split(",");
        }
        if (BasicUtil.isNotEmpty(name = ClassUtil.parseAnnotationFieldValue(field, annotations))) {
            field2column.put(key, name);
            column2field.put(clazz.getName() + ":" + name.toUpperCase(), field);
            return name;
        }
        if ("camel_".equals(ConfigTable.getString("ENTITY_FIELD_COLUMN_MAP"))) {
            name = BeanUtil.camel_(field.getName());
            field2column.put(key, name);
            column2field.put(clazz.getName() + ":" + name.toUpperCase(), field);
            return name;
        }
        Class<?> c = field.getType();
        if (c == String.class || c == Date.class || ClassUtil.isPrimitiveClass(c)) {
            name = field.getName();
            field2column.put(key, name);
            column2field.put(clazz.getName() + ":" + name.toUpperCase(), field);
            return name;
        }
        return null;
    }

    @Override
    public Field field(Class clazz, String column) {
        return column2field.get(clazz.getName() + ":" + column.toUpperCase());
    }

    @Override
    public String primaryKey(Class clazz) {
        List<String> list = this.primaryKeys(clazz);
        if (list.size() > 0) {
            return list.get(0);
        }
        return DataRow.DEFAULT_PRIMARY_KEY;
    }

    @Override
    public List<String> primaryKeys(Class clazz) {
        List<String> list = primarys.get(clazz.getName());
        if (null == list) {
            String name;
            Field field;
            list = new ArrayList<String>();
            String annotations = ConfigTable.ENTITY_PRIMARY_KEY_ANNOTATION;
            if (BasicUtil.isEmpty((Object)annotations)) {
                annotations = "TableId,Id";
            }
            List<Field> fields = ClassUtil.getFieldsByAnnotation(clazz, annotations.split(","));
            for (Field field2 : fields) {
                String name2 = this.column(clazz, field2, annotations.split(","));
                if (!BasicUtil.isNotEmpty(name2)) continue;
                list.add(name2);
            }
            if (list.isEmpty() && null != (field = ClassUtil.getField(fields = ClassUtil.getFields(clazz), DataRow.DEFAULT_PRIMARY_KEY, true, true)) && BasicUtil.isNotEmpty(name = this.column(clazz, field, new String[0]))) {
                list.add(name);
            }
            if (list.size() == 0) {
                list.add(DataRow.DEFAULT_PRIMARY_KEY);
            }
            primarys.put(clazz.getName(), list);
        }
        return list;
    }

    @Override
    public <T> T entity(T entity, Class<T> clazz, Map<String, Object> map, Map columns) {
        List<Field> fields = ClassUtil.getFields(clazz);
        HashMap fk = new HashMap();
        entity = BeanUtil.map2object(entity, map, clazz, columns, false, true, true, new String[0]);
        for (Field field : fields) {
            String column = this.column(clazz, field, new String[0]);
            Object value = map.get(column);
            if (null == value) continue;
            BeanUtil.setFieldValue(entity, field, (Column)columns.get(column.toUpperCase()), map.get(column));
        }
        return entity;
    }

    @Override
    public <T> T entity(Class<T> clazz, Map<String, Object> map, Map columns) {
        return this.entity(null, clazz, map, columns);
    }

    @Override
    public Map<String, Object> primaryValue(Object obj) {
        String primary = this.primaryKey(obj.getClass());
        Field field = column2field.get(obj.getClass().getName() + ":" + primary.toUpperCase());
        Object value = BeanUtil.getFieldValue(obj, field);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(primary, value);
        return map;
    }

    @Override
    public void createPrimaryValue(Object obj) {
    }

    @Override
    public Map<String, Object> primaryValues(Object obj) {
        List<String> primarys = this.primaryKeys(obj.getClass());
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String primary : primarys) {
            Field field = column2field.get(obj.getClass().getName() + ":" + primary.toUpperCase());
            Object value = BeanUtil.getFieldValue(obj, field);
            map.put(primary, value);
        }
        return map;
    }

    @Override
    public DataRow row(DataRow row, Object obj, String ... keys) {
        return DataRow.parse(row, KeyAdapter.KEY_CASE.CONFIG, obj, keys);
    }

    @Override
    public DataRow row(Object obj, String ... keys) {
        return this.row(null, obj, keys);
    }

    @Override
    public List<String> column2param(List<String> metadatas) {
        ArrayList<String> params = new ArrayList<String>();
        for (String metadata : metadatas) {
            params.add(this.column2param(metadata));
        }
        return params;
    }

    @Override
    public String column2param(String metadata) {
        String param = null;
        String keyCase = ConfigTable.HTTP_PARAM_KEY_CASE;
        if ("camel".equals(keyCase)) {
            param = metadata + ":" + BeanUtil.camel(metadata.toLowerCase());
        } else if ("Camel".equals(keyCase)) {
            String key = CharUtil.toUpperCaseHeader(metadata.toLowerCase());
            param = metadata + ":" + BeanUtil.Camel(key);
        } else {
            param = "lower".equalsIgnoreCase(keyCase) ? metadata + ":" + metadata.toLowerCase() : ("upper".equalsIgnoreCase(keyCase) ? metadata + ":" + metadata.toUpperCase() : metadata + ":" + metadata);
        }
        return param;
    }
}

