/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.entity.DefaultOrder;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.PageNaviConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageNavi
implements PageNavi {
    protected static final long serialVersionUID = 3593100423479113410L;
    protected static final Logger log = LoggerFactory.getLogger(DefaultPageNavi.class);
    protected static final String BR = "\n";
    protected static final String TAB = "\t";
    protected static final String BR_TAB = "\n\t";
    protected int totalRow = 0;
    protected int totalPage = 0;
    protected int curPage = 1;
    protected int pageRange = 10;
    protected int pageRows = 10;
    protected int displayPageFirst = 0;
    protected int displayPageLast = 0;
    protected String baseLink = null;
    protected OrderStore orders = null;
    protected int calType = 0;
    protected int firstRow = 0;
    protected int lastRow = -1;
    protected boolean lazy = false;
    protected String flag = "";
    protected long lazyPeriod = 0L;
    protected String lazyKey = null;
    protected int type = 0;
    protected Map<String, List<Object>> params = null;
    protected String method = "post";
    protected String style = "";
    protected boolean showStat = true;
    protected boolean showJump = true;
    protected boolean showVol = true;
    protected String loadMoreFormat = "";

    public DefaultPageNavi() {
    }

    public DefaultPageNavi(int page) {
        this.curPage = page;
    }

    public DefaultPageNavi(int page, int vol) {
        this.curPage = page;
        this.pageRows = vol;
    }

    public DefaultPageNavi(int totalRow, int curPage, int pageRows, String baseLink) {
        this.totalRow = totalRow;
        this.curPage = curPage;
        this.setPageRows(pageRows);
        this.baseLink = baseLink;
    }

    public DefaultPageNavi(int curPage, int pageRows, String baseLink) {
        this.curPage = curPage;
        this.setPageRows(pageRows);
        this.baseLink = baseLink;
    }

    public DefaultPageNavi(String baseLink) {
        this.curPage = 1;
        this.baseLink = baseLink;
    }

    public static PageNavi parse(DataRow row) {
        if (null == row) {
            return null;
        }
        PageNavi navi = row.entity(DefaultPageNavi.class, new String[0]);
        return navi;
    }

    @Override
    public void setCalType(int type) {
        this.calType = type;
    }

    @Override
    public int getCalType() {
        return this.calType;
    }

    @Override
    public void calculate() {
        PageNaviConfig config;
        int totalPage = (this.totalRow - 1) / this.pageRows + 1;
        if (this.curPage > totalPage && null != (config = PageNaviConfig.getInstance(this.style)) && config.VAR_LIMIT_SCOPE) {
            this.curPage = totalPage;
        }
        this.setTotalPage(totalPage);
        this.setDisplayPageFirst(NumberUtil.min(this.curPage, totalPage) - this.pageRange / 2);
        if (this.displayPageFirst > totalPage - this.pageRange) {
            this.setDisplayPageFirst(totalPage - this.pageRange + 1);
        }
        if (this.displayPageFirst < 1) {
            this.setDisplayPageFirst(1);
        }
        this.setDisplayPageLast(this.displayPageFirst + this.pageRange - 1);
        if (this.displayPageLast > totalPage) {
            this.setDisplayPageLast(totalPage);
        }
    }

    @Override
    public int getFirstRow() {
        if (this.calType == 0) {
            if (this.curPage <= 0) {
                return 0;
            }
            return (this.curPage - 1) * this.pageRows;
        }
        return this.firstRow;
    }

    @Override
    public int getLastRow() {
        if (this.calType == 0) {
            if (this.curPage == 0) {
                return this.pageRows - 1;
            }
            return this.curPage * this.pageRows - 1;
        }
        return this.lastRow;
    }

    @Override
    public int getDisplayPageFirst() {
        return this.displayPageFirst;
    }

    @Override
    public void setDisplayPageFirst(int displayPageFirst) {
        this.displayPageFirst = displayPageFirst;
    }

    @Override
    public int getDisplayPageLast() {
        return this.displayPageLast;
    }

    @Override
    public void setDisplayPageLast(int displayPageLast) {
        this.displayPageLast = displayPageLast;
    }

    @Override
    public void addParam(String key, Object value) {
        List<Object> values;
        if (null == key || null == value) {
            return;
        }
        if (null == this.params) {
            this.params = new HashMap<String, List<Object>>();
        }
        if (null == (values = this.params.get(key))) {
            values = new ArrayList<Object>();
        }
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        this.params.put(key, values);
    }

    @Override
    public Object getParams(String key) {
        List<Object> result = null;
        if (null != this.params) {
            result = this.params.get(key);
        }
        return result;
    }

    @Override
    public Object getParam(String key) {
        Object result = null;
        if (null != this.params) {
            Object values = this.getParams(key);
            result = null != values && values instanceof List ? ((List)values).get(0) : values;
        }
        return result;
    }

    @Override
    public String getOrderText(boolean require) {
        return null;
    }

    public String getOrderText(boolean require, OrderStore store, String delimiter) {
        String result = "";
        if (null == this.orders) {
            this.orders = store;
        } else if (null != store) {
            for (Order order : store.getOrders()) {
                this.orders.order(order);
            }
        }
        if (null != this.orders) {
            result = this.orders.getRunText(delimiter);
        }
        if (require && result.length() == 0) {
            result = "ORDER BY " + ConfigTable.getString("DEFAULT_PRIMARY_KEY", "ID");
        }
        return result;
    }

    public PageNavi order(Order order) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(order);
        return this;
    }

    @Override
    public PageNavi order(String order, String type) {
        return this.order(new DefaultOrder(order, type));
    }

    @Override
    public PageNavi order(String order) {
        return this.order(new DefaultOrder(order));
    }

    @Override
    public PageNavi setTotalRow(int totalRow) {
        this.totalRow = totalRow;
        this.calculate();
        return this;
    }

    @Override
    public PageNavi setTotalPage(int totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    @Override
    public PageNavi setCurPage(int curPage) {
        this.curPage = curPage;
        return this;
    }

    @Override
    public PageNavi setPageRows(int pageRows) {
        if (pageRows > 0) {
            this.pageRows = pageRows;
        }
        return this;
    }

    @Override
    public int getTotalRow() {
        return this.totalRow;
    }

    @Override
    public int getTotalPage() {
        return this.totalPage;
    }

    @Override
    public int getCurPage() {
        return this.curPage;
    }

    @Override
    public int getPageRows() {
        return this.pageRows;
    }

    @Override
    public String getBaseLink() {
        return this.baseLink;
    }

    @Override
    public PageNavi setBaseLink(String baseLink) {
        this.baseLink = baseLink;
        return this;
    }

    @Override
    public PageNavi setFirstRow(int firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @Override
    public PageNavi setLastRow(int lastRow) {
        this.lastRow = lastRow;
        return this;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public long getLazyPeriod() {
        return this.lazyPeriod;
    }

    @Override
    public PageNavi setLazy(long ms) {
        this.lazy = true;
        this.lazyPeriod = ms;
        return this;
    }

    @Override
    public PageNavi setLazyPeriod(long ms) {
        this.lazy = true;
        this.lazyPeriod = ms;
        return this;
    }

    @Override
    public PageNavi setLazyKey(String key) {
        this.lazyKey = key;
        return this;
    }

    @Override
    public String getLazyKey() {
        return this.lazyKey;
    }

    @Override
    public String getFlag() {
        return this.flag;
    }

    @Override
    public PageNavi setFlag(String flag) {
        this.flag = flag;
        return this;
    }

    @Override
    public boolean isShowStat() {
        return this.showStat;
    }

    @Override
    public PageNavi setShowStat(boolean showStat) {
        this.showStat = showStat;
        return this;
    }

    @Override
    public boolean isShowJump() {
        return this.showJump;
    }

    @Override
    public PageNavi setShowJump(boolean showJump) {
        this.showJump = showJump;
        return this;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public PageNavi setType(int type) {
        this.type = type;
        return this;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public PageNavi setStyle(String style) {
        this.style = style;
        return this;
    }

    @Override
    public String getGuide() {
        return this.loadMoreFormat;
    }

    @Override
    public PageNavi setGuide(String guide) {
        this.loadMoreFormat = guide;
        return this;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public PageNavi setMethod(String method) {
        this.method = method;
        return this;
    }

    @Override
    public boolean isShowVol() {
        return this.showVol;
    }

    @Override
    public PageNavi setShowVol(boolean showVol) {
        this.showVol = showVol;
        return this;
    }

    @Override
    public String html(String adapter) {
        String layout_html;
        PageNaviConfig config = PageNaviConfig.getInstance(this.style);
        if (null == config) {
            config = new PageNaviConfig();
        }
        this.calculate();
        StringBuilder navi = new StringBuilder();
        StringBuilder index = new StringBuilder();
        StringBuilder stat = new StringBuilder();
        StringBuilder vol = new StringBuilder();
        StringBuilder jump = new StringBuilder();
        String configVarKey = "";
        if (null == this.flag) {
            this.flag = "";
        }
        if ("ajax".equals(adapter)) {
            configVarKey = config.KEY_ID_FLAG + this.flag;
        }
        if ("html".equals(adapter)) {
            navi.append("<link rel=\"stylesheet\" href=\"" + config.STYLE_FILE_PATH + "\" type=\"text/css\"/>\n");
            navi.append("<script type=\"text/javascript\" src=\"" + config.SCRIPT_FILE_PATH + "\"></script>\n");
        }
        if ("html".equals(adapter)) {
            navi.append("<form class=\"form\" action=\"" + this.baseLink + "\" method=\"post\">\n");
        }
        if ("ajax".equals(adapter)) {
            navi.append("<div class=\"form\">\n");
        }
        navi.append("<input type='hidden' id='hid_cur_page_" + this.flag + "' name='" + config.KEY_PAGE_NO + "' class='_anyline_navi_cur_page' value='" + this.curPage + "'/>\n");
        navi.append("<input type='hidden' id='hid_total_page_" + this.flag + "' name='" + config.KEY_TOTAL_PAGE + "' class='_anyline_navi_total_page' value='" + this.totalPage + "'/>\n");
        navi.append("<input type='hidden' id='hid_total_row_" + this.flag + "' name='" + config.KEY_TOTAL_ROW + "' class='_anyline_navi_total_row' value='" + this.totalRow + "'/>\n");
        if (config.VAR_CLIENT_SET_VOL_ENABLE) {
            navi.append("<input type='hidden' id='hid_page_rows_key_" + this.flag + "'  class='_anyline_navi_page_rows_key' value='" + config.KEY_PAGE_ROWS + "'/>\n");
            navi.append("<input type='hidden' id='hid_page_rows_" + this.flag + "' name='" + config.KEY_PAGE_ROWS + "' class='_anyline_navi_page_rows' value='" + this.pageRows + "'/>\n");
        }
        if ("ajax".equals(adapter)) {
            navi.append("<input type='hidden' class='" + config.KEY_ID_FLAG + "' value='" + this.flag + "'/>");
        }
        navi.append(this.createHidParams(config));
        navi.append("<div class=\"anyline_navi\">\n");
        String statFormat = config.STYLE_STAT_FORMAT;
        statFormat = statFormat.replace("${totalRow}", this.totalRow + "").replace("${curPage}", this.curPage + "").replace("${totalPage}", this.totalPage + "");
        statFormat = statFormat.replace("${total-row}", this.totalRow + "").replace("${cur-page}", this.curPage + "").replace("${total-page}", this.totalPage + "");
        if (this.showStat) {
            stat.append(statFormat).append(BR);
        }
        int range = config.VAR_PAGE_RANGE;
        int fr = NumberUtil.max(1, this.curPage - range / 2);
        int to = fr + range - 1;
        boolean match = false;
        if (this.totalPage > range && this.curPage > range / 2) {
            match = true;
        }
        if (match) {
            to = this.curPage + range / 2;
        }
        if (this.totalPage - this.curPage < range / 2) {
            fr = this.totalPage - range;
        }
        fr = NumberUtil.max(fr, 1);
        to = NumberUtil.min(to, this.totalPage);
        if (this.type == 0) {
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[vol set][enable:{}][vol:{}][sort:{}]", new Object[]{config.VAR_CLIENT_SET_VOL_ENABLE, this.pageRows, config.CONFIG_PAGE_VAL_SET_SORT});
            }
            if (config.VAR_CLIENT_SET_VOL_ENABLE) {
                if (config.CONFIG_PAGE_VAL_SET_SORT == 2) {
                    vol.append(config.STYLE_PAGE_VOL.replace("{navi-conf}", configVarKey).replace("{navi-conf-key}", this.flag));
                } else {
                    String[] nums = config.VAR_PAGE_VOL_NUMBERS.split(",");
                    String clazz = config.VAR_PAGE_VOL_CLASS;
                    if (BasicUtil.isEmpty((Object)clazz)) {
                        clazz = "navi-rows-set";
                    }
                    vol.append("<select class='").append(clazz).append("' id='navi_val_set_").append(this.flag).append("' onchange='_navi_change_vol(").append(configVarKey).append(")'>");
                    for (String num : nums) {
                        vol.append("<option value='").append(num).append("' id='navi_val_set_").append(this.flag).append("_item_").append(num).append("'");
                        if (this.pageRows == BasicUtil.parseInt(num, 0)) {
                            vol.append(" selected=\"selected\"");
                        }
                        vol.append(">").append(num).append(" \u6761/\u9875</option>\n");
                    }
                    vol.append("</select>");
                }
            }
            if (config.VAR_SHOW_INDEX_ELLIPSIS) {
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, "navi-button navi-prev-button", config.STYLE_BUTTON_PREV, NumberUtil.max(this.curPage - 1, 1), configVarKey);
                }
                if (config.VAR_SHOW_INDEX) {
                    if (fr < 2) {
                        fr = 2;
                    }
                    if (to > this.totalPage - 1) {
                        to = this.totalPage - 1;
                    }
                    index.append("<div class='navi-num-border'>\n");
                    this.createPageTag(index, "navi-num-item", "1", 1, configVarKey);
                    if (fr > 2) {
                        this.createPageTag(index, "navi-num-item", config.STYLE_INDEX_ELLIPSIS, 0, configVarKey);
                    }
                    for (int i = fr; i <= to; ++i) {
                        this.createPageTag(index, "navi-num-item", i + "", i, configVarKey);
                    }
                    if (to < this.totalPage - 1) {
                        this.createPageTag(index, "navi-num-item", config.STYLE_INDEX_ELLIPSIS, 0, configVarKey);
                    }
                    if (this.totalPage > 1) {
                        this.createPageTag(index, "navi-num-item", this.totalPage + "", this.totalPage, configVarKey);
                    }
                    index.append("</div>\n");
                }
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, "navi-button navi-next-button", config.STYLE_BUTTON_NEXT, NumberUtil.min(this.curPage + 1, this.totalPage), configVarKey);
                }
            } else {
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, "navi-button navi-first-button", config.STYLE_BUTTON_FIRST, 1, configVarKey);
                    this.createPageTag(index, "navi-button navi-prev-button", config.STYLE_BUTTON_PREV, NumberUtil.max(this.curPage - 1, 1), configVarKey);
                }
                if (config.VAR_SHOW_INDEX) {
                    index.append("<div class='navi-num-border'>\n");
                    for (int i = fr; i <= to; ++i) {
                        this.createPageTag(index, "navi-num-item", i + "", i, configVarKey);
                    }
                    index.append("</div>\n");
                }
                if (config.VAR_SHOW_BUTTON) {
                    this.createPageTag(index, "navi-button navi-next-button", config.STYLE_BUTTON_NEXT, NumberUtil.min(this.curPage + 1, this.totalPage), configVarKey);
                    this.createPageTag(index, "navi-button navi-last-button", config.STYLE_BUTTON_LAST, this.totalPage, configVarKey);
                }
            }
            if (this.showJump) {
                jump.append(config.STYLE_LABEL_JUMP).append("<input type='text' value='").append(this.curPage).append("' class='navi-go-txt _anyline_jump_txt' id='hid_jump_txt_" + this.flag + "' onkeydown='_navi_jump_enter(" + configVarKey + ")'/>").append(config.STYLE_LABEL_JUMP_PAGE).append("<span class='navi-go-button' onclick='_navi_jump(" + configVarKey + ")'>").append(config.STYLE_BUTTON_JUMP).append("</span>\n");
            }
        } else if (this.type == 1) {
            if (this.curPage + 1 <= this.totalPage) {
                this.createPageTag(index, "navi-more-button", this.loadMoreFormat, NumberUtil.min(this.curPage + 1, this.totalPage + 1), configVarKey);
            } else {
                index.append(config.STYLE_PAGE_OVER);
            }
        }
        if (null == (layout_html = config.VAR_COMPONENT_LAYOUT)) {
            layout_html = "${navi-stat}${navi-index}${navi-vol}${navi-jump}";
        }
        layout_html = layout_html.replace("${stat}", stat.toString());
        layout_html = layout_html.replace("${index}", index.toString());
        layout_html = layout_html.replace("${vol}", vol.toString());
        layout_html = layout_html.replace("${jump}", jump.toString());
        layout_html = layout_html.replace("${navi-stat}", stat.toString());
        layout_html = layout_html.replace("${navi-index}", index.toString());
        layout_html = layout_html.replace("${navi-vol}", vol.toString());
        layout_html = layout_html.replace("${navi-jump}", jump.toString());
        navi.append(layout_html);
        navi.append("</div>");
        if ("html".equals(adapter)) {
            navi.append("</form>\n");
        }
        if ("ajax".equals(adapter)) {
            navi.append("</div>\n");
        }
        return navi.toString();
    }

    private void createPageTag(StringBuilder builder, String clazz, String tag, int page, String configFlag) {
        builder.append("<span class ='").append(clazz);
        if (page == this.curPage && 0 == this.type) {
            if (clazz.contains("navi-num-item")) {
                builder.append(" navi-num-item-cur");
            } else {
                builder.append(" navi-disabled");
            }
            builder.append("'");
        } else {
            builder.append("'");
            if (page > 0) {
                builder.append(" onclick='_navi_go(").append(page);
                if (BasicUtil.isNotEmpty(configFlag)) {
                    builder.append(",").append(configFlag);
                }
                builder.append(")'");
            }
        }
        builder.append(">");
        builder.append(tag).append("</span>\n");
    }

    private String createHidParams(PageNaviConfig config) {
        String html = "";
        try {
            if (null != this.params) {
                for (String key : this.params.keySet()) {
                    List<Object> values = this.params.get(key);
                    html = html + this.createHidParam(key, values);
                }
            }
            html = html + this.createHidParam(config.KEY_SHOW_STAT, this.showStat);
            html = html + this.createHidParam(config.KEY_SHOW_JUMP, this.showJump);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return html;
    }

    @Override
    public String createHidParam(String name, Object values) {
        String html = "";
        if (null == values) {
            html = "<input type='hidden' name='" + name + "' value=''>\n";
        } else if (values instanceof Collection) {
            Collection list = (Collection)values;
            for (Object obj : list) {
                html = html + "<input type='hidden' name='" + name + "' value='" + obj + "'>\n";
            }
        } else {
            html = html + "<input type='hidden' name='" + name + "' value='" + values + "'>\n";
        }
        return html;
    }

    @Override
    public String getHtml() {
        return this.html("html");
    }
}

