/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import org.anyline.entity.DataSet;
import org.anyline.entity.adapter.KeyAdapter;
import org.anyline.entity.adapter.LowerKeyAdapter;
import org.anyline.entity.adapter.SrcKeyAdapter;
import org.anyline.entity.adapter.UpperKeyAdapter;
import org.anyline.entity.data.Column;
import org.anyline.util.AdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.DefaultOgnlMemberAccess;
import org.anyline.util.NumberUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRow
extends LinkedHashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = -2098827041540802313L;
    protected static final Logger log = LoggerFactory.getLogger(DataRow.class);
    public static String KEY_PARENT = "PARENT";
    public static String KEY_ALL_PARENT = "ALL_PARENT";
    public static String KEY_CHILDREN = "CHILDREN";
    public static String KEY_ALL_CHILDREN = "CHILDREN";
    public static String KEY_ITEMS = "ITEMS";
    public static KeyAdapter.KEY_CASE DEFAULT_KEY_KASE = KeyAdapter.KEY_CASE.CONFIG;
    public static String DEFAULT_PRIMARY_KEY = ConfigTable.getString("DEFAULT_PRIMARY_KEY", "ID");
    private boolean updateNullColumn = ConfigTable.IS_UPDATE_NULL_COLUMN;
    private boolean updateEmptyColumn = ConfigTable.IS_UPDATE_EMPTY_COLUMN;
    private boolean insertNullColumn = ConfigTable.IS_INSERT_NULL_COLUMN;
    private boolean insertEmptyColumn = ConfigTable.IS_INSERT_EMPTY_COLUMN;
    private String category = null;
    private LinkedHashMap<String, Column> metadatas = null;
    private transient DataSet container = null;
    private List<String> primaryKeys = new ArrayList<String>();
    private List<String> updateColumns = new ArrayList<String>();
    private List<String> ignoreUpdateColumns = new ArrayList<String>();
    private String datalink = null;
    private String dataSource = null;
    private String schema = null;
    private String table = null;
    private DataRow attributes = null;
    private DataRow tags = null;
    private DataRow relations = null;
    private long createTime = 0L;
    private long nanoTime = 0L;
    private long expires = -1L;
    protected Boolean isNew = false;
    protected boolean isFromCache = false;
    private Map<String, String> keymap = new HashMap<String, String>();
    private boolean isUpperKey = false;
    private Map<String, String> converts = new HashMap<String, String>();
    public boolean skip = false;
    private KeyAdapter keyAdapter = null;
    private KeyAdapter.KEY_CASE keyCase = DEFAULT_KEY_KASE;

    public DataRow() {
        this.parseKeycase(null);
        String pk = this.keyAdapter.key(DEFAULT_PRIMARY_KEY);
        if (null != pk) {
            this.primaryKeys.add(DEFAULT_PRIMARY_KEY);
        }
        this.createTime = System.currentTimeMillis();
        this.nanoTime = System.currentTimeMillis();
    }

    private void parseKeycase(KeyAdapter.KEY_CASE keyCase) {
        if (null == keyCase) {
            keyCase = this.keyCase;
        }
        if (null != keyCase) {
            this.keyAdapter = KeyAdapter.parse(keyCase);
            if (keyCase == KeyAdapter.KEY_CASE.CONFIG) {
                if (ConfigTable.IS_UPPER_KEY) {
                    this.keyAdapter = UpperKeyAdapter.getInstance();
                } else if (ConfigTable.IS_LOWER_KEY) {
                    this.keyAdapter = LowerKeyAdapter.getInstance();
                }
            }
        } else {
            this.keyAdapter = SrcKeyAdapter.getInstance();
        }
    }

    public DataRow(KeyAdapter.KEY_CASE keyCase) {
        this();
        this.parseKeycase(keyCase);
    }

    public DataRow(String table) {
        this();
        this.setTable(table);
    }

    public DataRow(Map<String, Object> map) {
        this(null, map);
    }

    public DataRow(LinkedHashMap columns, Map<String, Object> map) {
        this();
        this.setMetadatas(columns);
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entity : set) {
            Object value = entity.getValue();
            if (null != value) {
                String type;
                if (value instanceof Map) {
                    value = new DataRow((Map)value);
                }
                if (null != (type = this.getMetadataTypeName(entity.getKey())) && type.toUpperCase().contains("JSON")) {
                    String str = value.toString().trim();
                    if (str.startsWith("{")) {
                        value = DataRow.parseJson(str);
                    } else if (str.startsWith("[")) {
                        value = DataSet.parseJson(str);
                    }
                }
            }
            this.put(this.keyAdapter.key(entity.getKey()), value);
        }
    }

    public DataRow serCreateTime(Long time) {
        this.createTime = time;
        return this;
    }

    public DataRow serCreateTime(java.util.Date time) {
        this.createTime = time.getTime();
        return this;
    }

    public long getNanoTime() {
        return this.nanoTime;
    }

    public void setNanoTime(long nanoTime) {
        this.nanoTime = nanoTime;
    }

    public static DataRow parseList(DataRow row, Collection<?> list, String ... fields) {
        block6: {
            if (null == row) {
                row = new DataRow();
            }
            if (null == list) break block6;
            if (null == fields || fields.length == 0) {
                int i = 0;
                for (Object obj : list) {
                    row.put("" + i++, obj);
                }
            } else {
                Object[] items = list.toArray();
                int len = fields.length;
                for (int i = 0; i < len; ++i) {
                    String field = fields[i];
                    Object value = null;
                    if (i < items.length - 1) {
                        value = items[i];
                    }
                    row.put(field, value);
                }
            }
        }
        return row;
    }

    public static DataRow parseList(Collection<?> list, String ... fields) {
        return DataRow.parseList(null, list, fields);
    }

    public DataRow setKeyCase(KeyAdapter.KEY_CASE keyCase) {
        this.parseKeycase(keyCase);
        return this;
    }

    public static DataRow parse(DataRow row, Object obj, String ... keys) {
        if (AdapterProxy.hasAdapter() && null != (row = AdapterProxy.row(row, obj, keys))) {
            return row;
        }
        return DataRow.parse(row, KeyAdapter.KEY_CASE.CONFIG, obj, keys);
    }

    public static DataRow parse(Object obj, String ... keys) {
        return DataRow.parse((DataRow)null, obj, keys);
    }

    public static DataRow parse(KeyAdapter.KEY_CASE keyCase, String txt, String ... keys) {
        return DataRow.parse((DataRow)null, keyCase, (Object)txt, keys);
    }

    public static DataRow build(DataRow row, Object obj, String ... keys) {
        return DataRow.parse(row, obj, keys);
    }

    public static DataRow build(Object obj, String ... keys) {
        return DataRow.parse((DataRow)null, obj, keys);
    }

    public static DataRow parse(DataRow row, KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        block14: {
            if (null != obj && obj instanceof String) {
                return DataRow.parseJson(row, keyCase, (String)obj);
            }
            if (null == row) {
                row = new DataRow(keyCase);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            if (null != keys) {
                for (String key : keys) {
                    String[] tmp = key.split(":");
                    if (null == tmp || tmp.length <= 1) continue;
                    map.put(DataRow.putKeyCase(tmp[1].trim()), DataRow.putKeyCase(tmp[0].trim()));
                }
            }
            if (null == obj) break block14;
            if (obj instanceof JsonNode) {
                row = DataRow.parseJson(keyCase, (JsonNode)obj);
            } else if (obj instanceof DataRow) {
                row = (DataRow)obj;
            } else if (obj instanceof Map) {
                Map mp = (Map)obj;
                List<String> ks = BeanUtil.getMapKeys(mp);
                for (String k : ks) {
                    Object value = mp.get(k);
                    if (null != value && value instanceof Map) {
                        value = DataRow.parse(value, new String[0]);
                    }
                    row.put(k, value);
                }
            } else {
                List<Field> fields = ClassUtil.getFields(obj.getClass());
                for (Field field : fields) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    String fieldName = field.getName();
                    String col = (String)map.get(fieldName);
                    if (null == col) {
                        col = fieldName;
                    }
                    row.put(keyCase, col, BeanUtil.getFieldValue(obj, field));
                }
            }
        }
        return row;
    }

    public static DataRow parse(KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        return DataRow.parse(null, keyCase, obj, keys);
    }

    public static DataRow build(DataRow row, KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        return DataRow.parse(row, keyCase, obj, keys);
    }

    public static DataRow build(KeyAdapter.KEY_CASE keyCase, Object obj, String ... keys) {
        return DataRow.parse(null, keyCase, obj, keys);
    }

    public static DataRow parseJson(DataRow row, KeyAdapter.KEY_CASE keyCase, String json) {
        if (null != json) {
            try {
                return DataRow.parseJson(row, keyCase, BeanUtil.JSON_MAPPER.readTree(json));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static DataRow parseJson(KeyAdapter.KEY_CASE keyCase, String json) {
        return DataRow.parseJson(null, keyCase, json);
    }

    public static DataRow parseJson(DataRow row, String json) {
        return DataRow.parseJson(row, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static DataRow parseJson(String json) {
        return DataRow.parseJson(null, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static DataRow parseJson(DataRow row, KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        return (DataRow)DataRow.parse((Object)row, keyCase, json);
    }

    public static DataRow parseJson(KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        return (DataRow)DataRow.parse(null, keyCase, json);
    }

    public static DataRow parseJson(DataRow row, JsonNode json) {
        return DataRow.parseJson(row, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    public static DataRow parseJson(JsonNode json) {
        return DataRow.parseJson(null, KeyAdapter.KEY_CASE.CONFIG, json);
    }

    private static Object parse(Object obj, KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        if (null == json) {
            return obj;
        }
        if (json.isValueNode()) {
            return BeanUtil.value(json);
        }
        if (json.isArray()) {
            Collection list = null;
            list = null != obj && obj instanceof Collection ? (Collection)obj : new ArrayList();
            for (JsonNode item : json) {
                list.add(DataRow.parse(obj, keyCase, item));
            }
            return list;
        }
        if (json.isObject()) {
            DataRow row = null;
            row = null != obj && obj instanceof DataRow ? (DataRow)obj : new DataRow(keyCase);
            Iterator fields = json.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode value = (JsonNode)field.getValue();
                String key = (String)field.getKey();
                if (null != value) {
                    if (value.isValueNode()) {
                        row.put(key, BeanUtil.value(value));
                        continue;
                    }
                    if (value.isArray()) {
                        row.put(key, DataRow.parse(keyCase, value));
                        continue;
                    }
                    if (!value.isObject()) continue;
                    row.put(key, (Object)DataRow.parseJson(keyCase, value));
                    continue;
                }
                row.put(key, (Object)null);
            }
            return row;
        }
        return null;
    }

    private static Object parse(KeyAdapter.KEY_CASE keyCase, JsonNode json) {
        return DataRow.parse(null, keyCase, json);
    }

    public static DataRow parseXml(DataRow row, KeyAdapter.KEY_CASE keyCase, String xml) {
        if (null != xml) {
            try {
                Document doc = DocumentHelper.parseText((String)xml);
                return DataRow.parseXml(row, keyCase, doc.getRootElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static DataRow parseXml(DataRow row, String xml) {
        return DataRow.parseXml(row, KeyAdapter.KEY_CASE.CONFIG, xml);
    }

    public static DataRow parseXml(String xml) {
        return DataRow.parseXml(null, KeyAdapter.KEY_CASE.CONFIG, xml);
    }

    public static DataRow parseXml(DataRow row, KeyAdapter.KEY_CASE keyCase, Element element) {
        if (null == row) {
            row = new DataRow(keyCase);
        }
        if (null == element) {
            return row;
        }
        Iterator childs = element.elementIterator();
        String key = element.getName();
        String namespace = element.getNamespacePrefix();
        if (BasicUtil.isNotEmpty(namespace)) {
            key = namespace + ":" + key;
        }
        if (element.isTextOnly() || !childs.hasNext()) {
            row.put(key, (Object)element.getTextTrim());
        } else {
            while (childs.hasNext()) {
                Element child = (Element)childs.next();
                String childKey = child.getName();
                String childNamespace = child.getNamespacePrefix();
                if (BasicUtil.isNotEmpty(childNamespace)) {
                    childKey = childNamespace + ":" + childKey;
                }
                if (child.isTextOnly() || !child.elementIterator().hasNext()) {
                    row.put(childKey, (Object)child.getTextTrim());
                    continue;
                }
                DataRow childRow = DataRow.parseXml(row, keyCase, child);
                Object childStore = row.get(childKey);
                if (null == childStore) {
                    row.put(childKey, (Object)childRow);
                    continue;
                }
                if (childStore instanceof DataRow) {
                    DataSet childSet = new DataSet();
                    childSet.add((DataRow)childStore);
                    childSet.add(childRow);
                    row.put(childKey, (Object)childSet);
                    continue;
                }
                if (!(childStore instanceof DataSet)) continue;
                ((DataSet)childStore).add(childRow);
            }
        }
        Iterator attrs = element.attributeIterator();
        while (attrs.hasNext()) {
            Attribute attr = (Attribute)attrs.next();
            row.attr(attr.getName(), attr.getValue());
        }
        return row;
    }

    public static DataRow parseXml(KeyAdapter.KEY_CASE keyCase, Element element) {
        return DataRow.parseXml(null, keyCase, element);
    }

    public static DataRow parseArray(DataRow row, String ... kvs) {
        if (null == row) {
            row = new DataRow();
        }
        int len = kvs.length;
        int i = 0;
        while (i < len) {
            String p1 = kvs[i];
            if (BasicUtil.isEmpty((Object)p1)) {
                ++i;
                continue;
            }
            if (p1.contains(":")) {
                String[] ks = BeanUtil.parseKeyValue(p1);
                row.put(ks[0], (Object)ks[1]);
                ++i;
                continue;
            }
            if (i + 1 < len) {
                String p2 = kvs[i + 1];
                if (BasicUtil.isEmpty((Object)p2) || !p2.contains(":")) {
                    row.put(p1, (Object)p2);
                    i += 2;
                    continue;
                }
                String[] ks = BeanUtil.parseKeyValue(p2);
                row.put(ks[0], (Object)ks[1]);
                i += 2;
                continue;
            }
            ++i;
        }
        return row;
    }

    public static DataRow parseArray(String ... kvs) {
        return DataRow.parseArray((DataRow)null, kvs);
    }

    public DataRow setMetadatas(LinkedHashMap<String, Column> metadatas) {
        this.metadatas = metadatas;
        return this;
    }

    public LinkedHashMap<String, Column> getMetadatas() {
        if (null == this.metadatas && null != this.container) {
            return this.container.getMetadatas();
        }
        return this.metadatas;
    }

    public Column getMetadata(String column) {
        LinkedHashMap<String, Column> metadatas = this.getMetadatas();
        if (null == metadatas) {
            return null;
        }
        return metadatas.get(column.toUpperCase());
    }

    public String getMetadataTypeName(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getTypeName();
        }
        return null;
    }

    public Integer getMetadataType(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getType();
        }
        return null;
    }

    public String getMetadataFullType(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getFullType();
        }
        return null;
    }

    public String getMetadataClassName(String column) {
        Column col = this.getMetadata(column);
        if (null != col) {
            return col.getClassName();
        }
        return null;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public DataRow setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public long getExpires() {
        return this.expires;
    }

    public DataRow setExpires(long millisecond) {
        this.expires = millisecond;
        return this;
    }

    public DataRow setExpires(int millisecond) {
        this.expires = millisecond;
        return this;
    }

    public DataRow merge(DataRow row, boolean over) {
        List<String> keys = row.keys();
        for (String key : keys) {
            if (!over && null != this.get(key)) continue;
            this.put(key, row.get(KeyAdapter.KEY_CASE.SRC, key));
        }
        return this;
    }

    public Object ognl(String formula, Object values) throws Exception {
        if (null == values) {
            values = this;
        }
        formula = BeanUtil.parseRuntimeValue(values, formula);
        OgnlContext context = new OgnlContext(null, null, (MemberAccess)new DefaultOgnlMemberAccess(true));
        Object value = Ognl.getValue((String)formula, (Map)context, (Object)values);
        return value;
    }

    public Object ognl(String formula) throws Exception {
        return this.ognl(formula, this);
    }

    public DataRow ognl(String key, String formula, Object values) throws Exception {
        this.put(key, (Object)this.ognl(key, formula, values));
        return this;
    }

    public DataRow ognl(String key, String formula) throws Exception {
        return this.ognl(key, formula, this);
    }

    public DataRow merge(DataRow row) {
        return this.merge(row, false);
    }

    public Boolean isNew() {
        String pk = this.getPrimaryKey();
        String pv = this.getString(pk);
        return null == pv || null == this.isNew || this.isNew != false || BasicUtil.isEmpty((Object)pv);
    }

    public boolean isFromCache() {
        return this.isFromCache;
    }

    public DataRow setIsFromCache(boolean bol) {
        this.isFromCache = bol;
        return this;
    }

    public String getCd() {
        return this.getString("cd");
    }

    public String getId() {
        return this.getString("id");
    }

    public String getCode() {
        return this.getString("code");
    }

    public String getNm() {
        return this.getString("nm");
    }

    public String getName() {
        return this.getString("name");
    }

    public String getTitle() {
        return this.getString("title");
    }

    public DataSet getItems() {
        Object items = this.get(KEY_ITEMS);
        if (items instanceof DataSet) {
            return (DataSet)items;
        }
        return null;
    }

    public DataRow putItems(Object obj) {
        this.put(KEY_ITEMS, obj);
        return this;
    }

    public DataRow toLowerKey(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                Object value = this.get(key);
                this.remove(this.keyAdapter.key(key));
                key = key.toLowerCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        } else {
            for (String key : this.keys()) {
                Object value = this.get(key);
                this.remove(this.keyAdapter.key(key));
                key = key.toLowerCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        }
        this.parseKeycase(KeyAdapter.KEY_CASE.LOWER);
        return this;
    }

    public DataRow toUpperKey(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                Object value = this.get(key);
                this.remove(this.keyAdapter.key(key));
                key = key.toUpperCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        } else {
            for (String key : this.keys()) {
                Object value = this.get(key);
                this.remove(this.keyAdapter.key(key));
                key = key.toUpperCase();
                this.put(KeyAdapter.KEY_CASE.SRC, key, value);
            }
        }
        this.parseKeycase(KeyAdapter.KEY_CASE.UPPER);
        return this;
    }

    public DataRow formatNumber(String format, String ... cols) {
        if (null == cols || BasicUtil.isEmpty((Object)format)) {
            return this;
        }
        for (String col : cols) {
            String value = this.getString(col);
            if (null == value) continue;
            value = NumberUtil.format(value, format);
            this.put(col, (Object)value);
        }
        return this;
    }

    public DataRow numberFormat(String target, String key, String format) {
        if (null == target || null == key || this.isEmpty(key) || null == format) {
            return this;
        }
        this.put(target, (Object)NumberUtil.format(this.getString(key), format));
        return this;
    }

    public DataRow formatDate(String format, String ... cols) {
        if (null == cols || BasicUtil.isEmpty((Object)format)) {
            return this;
        }
        for (String col : cols) {
            String value = this.getString(col);
            if (null == value) continue;
            value = DateUtil.format(value, format);
            this.put(col, (Object)value);
        }
        return this;
    }

    public DataRow dateFormat(String target, String key, String format) {
        if (null == target || null == key || this.isEmpty(key) || null == format) {
            return this;
        }
        this.put(target, (Object)DateUtil.format(this.getString(key), format));
        return this;
    }

    public DataRow dateParse(String target, String key, String format) {
        if (null == target || null == key || this.isEmpty(key) || null == format) {
            return this;
        }
        this.put(target, (Object)DateUtil.parse(this.getString(key), format));
        return this;
    }

    public DataRow dateParse(String target, String key) {
        if (null == target || null == key || this.isEmpty(key)) {
            return this;
        }
        this.put(target, (Object)DateUtil.parse(this.getString(key)));
        return this;
    }

    public DataRow dateFormat(String key, String format) {
        return this.dateFormat(key, key, format);
    }

    public boolean isNull(String key) {
        Object obj = this.get(key);
        return obj == null;
    }

    public boolean isNotNull(String key) {
        return !this.isNull(key);
    }

    public boolean isEmpty(String key) {
        Object obj = this.get(key);
        return BasicUtil.isEmpty(obj);
    }

    public boolean isNotEmpty(String key) {
        return !this.isEmpty(key);
    }

    public DataRow addPrimaryKey(boolean applyContainer, String ... pks) {
        if (null != pks) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : pks) {
                list.add(pk);
            }
            return this.addPrimaryKey(applyContainer, list);
        }
        return this;
    }

    public DataRow addPrimaryKey(String ... pks) {
        return this.addPrimaryKey(false, pks);
    }

    public DataRow addPrimaryKey(boolean applyContainer, Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        for (String item : pks) {
            if (BasicUtil.isEmpty((Object)item) || this.primaryKeys.contains(item = this.keyAdapter.key(item))) continue;
            this.primaryKeys.add(item);
        }
        if (this.hasContainer() && applyContainer) {
            this.getContainer().setPrimaryKey(false, this.primaryKeys);
        }
        return this;
    }

    public DataRow setPrimaryKey(boolean applyContainer, String ... pks) {
        if (null != pks) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : pks) {
                list.add(pk);
            }
            return this.setPrimaryKey(applyContainer, list);
        }
        return this;
    }

    public DataRow setPrimaryKey(String ... pks) {
        return this.setPrimaryKey(false, pks);
    }

    public DataRow setPrimaryKey(boolean applyContainer, Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (this.hasContainer() && applyContainer) {
            this.getContainer().setPrimaryKey(pks);
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        } else {
            this.primaryKeys.clear();
        }
        return this.addPrimaryKey(applyContainer, pks);
    }

    public DataRow setPrimaryKey(Collection<String> pks) {
        return this.setPrimaryKey(false, pks);
    }

    public List<String> getPrimaryKeys() {
        if (this.hasSelfPrimaryKeys()) {
            return this.primaryKeys;
        }
        if (this.hasContainer() && this.getContainer().hasPrimaryKeys()) {
            return this.getContainer().getPrimaryKeys();
        }
        ArrayList<String> defaultPrimary = new ArrayList<String>();
        String configKey = ConfigTable.getString("DEFAULT_PRIMARY_KEY", "ID");
        if (null != configKey && !configKey.trim().equals("")) {
            defaultPrimary.add(configKey);
        }
        return defaultPrimary;
    }

    public String getPrimaryKey() {
        List<String> keys = this.getPrimaryKeys();
        if (null != keys && keys.size() > 0) {
            return keys.get(0);
        }
        return null;
    }

    public List<Object> getPrimaryValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        List<String> keys = this.getPrimaryKeys();
        if (null != keys) {
            for (String key : keys) {
                values.add(this.get(key));
            }
        }
        return values;
    }

    public Object getPrimaryValue() {
        String key = this.getPrimaryKey();
        if (null != key) {
            return this.get(key);
        }
        return null;
    }

    public boolean hasPrimaryKeys() {
        if (this.hasSelfPrimaryKeys()) {
            return true;
        }
        if (null != this.getContainer()) {
            return this.getContainer().hasPrimaryKeys();
        }
        return this.keys().contains(ConfigTable.getString("DEFAULT_PRIMARY_KEY", "ID"));
    }

    public boolean hasSelfPrimaryKeys() {
        return null != this.primaryKeys && this.primaryKeys.size() > 0;
    }

    public String getDataSource() {
        String ds = this.table;
        if (BasicUtil.isNotEmpty(ds) && BasicUtil.isNotEmpty(this.schema)) {
            ds = this.schema + "." + ds;
        }
        if (BasicUtil.isEmpty((Object)ds)) {
            ds = this.dataSource;
        }
        if (null == ds && null != this.getContainer()) {
            ds = this.getContainer().getDataSource();
        }
        return ds;
    }

    public String getCategory() {
        return this.category;
    }

    public DataRow setCategory(String category) {
        this.category = category;
        return this;
    }

    public DataRow getRelations() {
        return this.relations;
    }

    public DataRow setRelations(DataRow relations) {
        this.relations = relations;
        return this;
    }

    public DataRow addRelation(DataRow relation) {
        if (null == this.relations) {
            this.relations = new DataRow();
        }
        this.relations.put(relation.getCategory(), (Object)relation);
        return this;
    }

    public DataRow addRelation(String relation) {
        if (null == this.relations) {
            this.relations = new DataRow();
        }
        DataRow row = new DataRow();
        row.setCategory(relation);
        this.relations.put(relation, (Object)row);
        return this;
    }

    public DataRow getRelation(String key) {
        if (null == this.relations) {
            this.relations = new DataRow();
        }
        return (DataRow)this.relations.get(key);
    }

    public String getDataLink() {
        if (BasicUtil.isEmpty((Object)this.datalink) && null != this.getContainer()) {
            return this.getContainer().getDatalink();
        }
        return this.datalink;
    }

    public DataRow setDataSource(String dataSource) {
        if (null == dataSource) {
            return this;
        }
        if (null != this.getContainer()) {
            this.getContainer().setDataSource(dataSource);
        } else {
            this.dataSource = dataSource;
            if (dataSource.contains(".") && !dataSource.contains(":")) {
                this.schema = dataSource.substring(0, dataSource.indexOf("."));
                this.table = dataSource.substring(dataSource.indexOf(".") + 1);
            }
        }
        return this;
    }

    public Object getChildren() {
        return this.get(KEY_CHILDREN);
    }

    public DataRow setChildren(Object children) {
        this.put(KEY_CHILDREN, children);
        return this;
    }

    public Object getParent() {
        return this.getParent(KEY_PARENT);
    }

    public Object getParent(String key) {
        return this.get(key);
    }

    public DataRow setParent(Object parent) {
        this.put(KEY_PARENT, parent);
        return this;
    }

    public DataRow setParent(String key, Object parent) {
        this.put(key, parent);
        return this;
    }

    public List<Object> getAllParent(String key) {
        if (null != this.get(KEY_ALL_PARENT)) {
            return (List)this.get(KEY_ALL_PARENT);
        }
        ArrayList<Object> parents = new ArrayList<Object>();
        Object parent = this.getParent(key);
        if (null != parent) {
            parents.add(parent);
            if (parent instanceof DataRow) {
                DataRow tmp = (DataRow)parent;
                parents.addAll(tmp.getAllParent(key));
            }
        }
        this.put(KEY_ALL_PARENT, (Object)parents);
        return parents;
    }

    public List<Object> getAllParent() {
        return this.getAllParent(KEY_PARENT);
    }

    public DataSet getAllChild(String key) {
        Object obj = this.get(KEY_ALL_CHILDREN);
        if (null != obj) {
            return (DataSet)obj;
        }
        DataSet set = new DataSet();
        DataSet childs = this.getSet(key);
        for (DataRow child : childs) {
            set.add(child);
            set.addAll((Collection)child.getAllChild(key));
        }
        this.put(KEY_ALL_CHILDREN, (Object)set);
        return set;
    }

    public <T> T entity(Class<T> clazz, String ... configs) {
        T entity = null;
        if (null == clazz) {
            return entity;
        }
        if (AdapterProxy.hasAdapter() && null != (entity = (T)AdapterProxy.entity(clazz, this, this.metadatas))) {
            return entity;
        }
        try {
            entity = clazz.newInstance();
            List<Field> fields = ClassUtil.getFields(clazz);
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                Object value = this.get(field.getName());
                BeanUtil.setFieldValue(entity, field, value);
            }
            if (null != configs) {
                String[] stringArray = configs;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String[] tmps;
                    String config;
                    String field = config = stringArray[i];
                    String column = config;
                    if (config.contains(":") && (tmps = config.split(":")).length >= 2) {
                        field = tmps[0];
                        column = tmps[1];
                    }
                    Object value = this.get(column);
                    BeanUtil.setFieldValue(entity, field, value);
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public boolean hasValue(String key) {
        return this.get(key) != null;
    }

    public boolean hasKey(String key) {
        return this.keys().contains(this.keyAdapter.key(key));
    }

    public boolean containsKey(String key) {
        return this.keys().contains(this.keyAdapter.key(key));
    }

    public List<String> keys() {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator itr = this.keySet().iterator();
        while (itr.hasNext()) {
            keys.add((String)itr.next());
        }
        return keys;
    }

    public DataRow put(KeyAdapter.KEY_CASE keyCase, String key, Object value) {
        return this.put(true, keyCase, key, value);
    }

    public DataRow put(boolean checkUpdate, String key, Object value) {
        return this.put(checkUpdate, null, key, value);
    }

    public DataRow put(boolean checkUpdate, KeyAdapter.KEY_CASE keyCase, String key, Object value) {
        KeyAdapter keyAdapter = this.keyAdapter;
        if (null != keyCase) {
            keyAdapter = KeyAdapter.parse(keyCase);
        }
        if (null != key) {
            key = keyAdapter.key(key);
            boolean ignore = false;
            if (checkUpdate) {
                if (key.startsWith("+")) {
                    key = key.substring(1);
                    this.addUpdateColumns(key);
                } else if (key.startsWith("-")) {
                    key = key.substring(1);
                    this.addIgnoreColumns(key);
                    ignore = true;
                }
                Object oldValue = this.get(keyCase, key);
                if (null == oldValue || !oldValue.equals(value)) {
                    super.put(key, value);
                }
                if (!ignore && !BasicUtil.equals(oldValue, value)) {
                    this.addUpdateColumns(key);
                }
            } else {
                super.put(key, value);
            }
            if (ConfigTable.IS_KEY_IGNORE_CASE) {
                String ignoreKey = key.replace("_", "").replace("-", "").toUpperCase();
                this.keymap.put(ignoreKey, key);
            }
        }
        return this;
    }

    public DataRow put(boolean checkUpdate, KeyAdapter.KEY_CASE keyCase, String key, Object value, boolean pk, boolean override) {
        if (pk) {
            if (override) {
                this.primaryKeys.clear();
            }
            this.addPrimaryKey(key);
        }
        this.put(checkUpdate, keyCase, key, value);
        return this;
    }

    public DataRow put(KeyAdapter.KEY_CASE keyCase, String key, Object value, boolean pk, boolean override) {
        return this.put(true, keyCase, key, value, pk, override);
    }

    public DataRow put(String key, Object value, boolean pk, boolean override) {
        return this.put(null, key, value, pk, override);
    }

    public DataRow put(KeyAdapter.KEY_CASE keyCase, String key, Object value, boolean pk) {
        this.put(keyCase, key, value, pk, true);
        return this;
    }

    public DataRow put(String key, Object value, boolean pk) {
        this.put(null, key, value, pk, true);
        return this;
    }

    @Override
    public Object put(String key, Object value) {
        this.put(null, key, value, false, true);
        return this;
    }

    public DataRow putWithoutNull(String key, Object value) {
        if (null != value) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow putWithoutEmpty(String key, Object value) {
        if (BasicUtil.isNotEmpty(value)) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow putIfEmpty(String key, Object value) {
        if (this.isEmpty(key)) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow putIfNull(String key, Object value) {
        if (this.isNull(key)) {
            this.put(key, value);
        }
        return this;
    }

    public DataRow set(String key, Object value) {
        if (BasicUtil.isEmpty(value)) {
            return this;
        }
        this.put(null, key, value, false, true);
        return this;
    }

    public DataRow attr(String key, Object value) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        this.attributes.put(key, value);
        return this;
    }

    public DataRow setAttribute(String key, Object value) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        this.attributes.put(key, value);
        return this;
    }

    public Object attr(String key) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        return this.attributes.get(key);
    }

    public Object getAttribute(String key) {
        if (null == this.attributes) {
            this.attributes = new DataRow();
        }
        return this.attributes.get(key);
    }

    public DataRow tag(String key, Object value) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        this.tags.put(key, value);
        return this;
    }

    public DataRow setTag(String key, Object value) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        this.tags.put(key, value);
        return this;
    }

    public Object tag(String key) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        return this.tags.get(key);
    }

    public Object getTag(String key) {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        return this.tags.get(key);
    }

    public Map<String, Object> getTags() {
        if (null == this.tags) {
            this.tags = new DataRow();
        }
        return this.tags;
    }

    public DataRow getRow(String key) {
        if (null == key) {
            if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
                return new DataRow();
            }
            return null;
        }
        Object obj = this.get(key);
        if (null != obj && obj instanceof DataRow) {
            return (DataRow)obj;
        }
        if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return null;
    }

    public DataRow getRow(String ... keys) {
        if (null == keys || keys.length == 0) {
            if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
                return new DataRow();
            }
            return null;
        }
        DataRow result = this;
        for (String key : keys) {
            if (null == result) {
                if (ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
                    return new DataRow();
                }
                return null;
            }
            result = result.getRow(key);
        }
        if (null == result && ConfigTable.IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL) {
            return new DataRow();
        }
        return result;
    }

    public DataSet getSet(String key) {
        if (null == key) {
            return null;
        }
        Object obj = this.get(key);
        if (null != obj) {
            if (obj instanceof DataSet) {
                return (DataSet)obj;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                DataSet set = new DataSet();
                for (Object item : list) {
                    set.add(DataRow.parse(item, new String[0]));
                }
                return set;
            }
        }
        return null;
    }

    public List<?> getList(String key) {
        if (null == key) {
            return null;
        }
        Object obj = this.get(key);
        if (null != obj && obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    public String getStringNvl(String key, String ... defs) {
        String result = this.getString(key);
        if (BasicUtil.isEmpty((Object)result)) {
            result = null == defs || defs.length == 0 ? "" : BasicUtil.nvl(defs).toString();
        }
        return result;
    }

    public String getString(String key) {
        String result = null;
        if (null == key) {
            return result;
        }
        if (key.contains("${") && key.contains("}")) {
            result = BeanUtil.parseFinalValue(this, key);
        } else {
            Object value = this.get(key);
            if (null != value) {
                result = value.toString();
            }
        }
        return result;
    }

    public Integer getInt(String key) throws Exception {
        Object val = this.get(key);
        if (val instanceof Boolean) {
            boolean bol = (Boolean)val;
            if (bol) {
                return 1;
            }
            return 0;
        }
        return (int)Double.parseDouble(val.toString());
    }

    public Integer getInt(String key, Integer def) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Double getDouble(String key) throws Exception {
        Object value = this.get(key);
        return Double.parseDouble(value.toString());
    }

    public Double getDouble(String key, Double def) {
        try {
            return this.getDouble(key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Double getDouble(String key, Integer def) {
        if (null == def) {
            return this.getDouble(key, (Double)null);
        }
        return this.getDouble(key, def.doubleValue());
    }

    public Long getLong(String key) throws Exception {
        Object value = this.get(key);
        if (null != value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                return date.getTime();
            }
            if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                return timestamp.getTime();
            }
            if (value instanceof Date) {
                Date date = (Date)value;
                return date.getTime();
            }
            if (value instanceof LocalDateTime || value instanceof Locale) {
                return DateUtil.parse(value).getTime();
            }
        }
        return Long.parseLong(value.toString());
    }

    public Long getLong(String key, Long def) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Long getLong(String key, Integer def) {
        if (null == def) {
            return this.getLong(key, (Long)null);
        }
        return this.getLong(key, def.longValue());
    }

    public Float getFloat(String key) throws Exception {
        Object value = this.get(key);
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    public Float getFloat(String key, Float def) {
        try {
            return this.getFloat(key);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Float getFloat(String key, Integer def) {
        if (null == def) {
            return this.getFloat(key, (Float)null);
        }
        return this.getFloat(key, Float.valueOf(def.floatValue()));
    }

    public Boolean getBoolean(String key, Boolean def) {
        return BasicUtil.parseBoolean(this.getString(key), def);
    }

    public Boolean getBoolean(String key) throws Exception {
        return BasicUtil.parseBoolean(this.getString(key));
    }

    public BigDecimal getDecimal(String key) throws Exception {
        return new BigDecimal(this.getString(key));
    }

    public BigDecimal getDecimal(String key, Double def) {
        return this.getDecimal(key, new BigDecimal(def));
    }

    public BigDecimal getDecimal(String key, Integer def) {
        return this.getDecimal(key, new BigDecimal(def));
    }

    public BigDecimal getDecimal(String key, BigDecimal def) {
        try {
            BigDecimal result = this.getDecimal(key);
            if (null == result) {
                return def;
            }
            return result;
        }
        catch (Exception e) {
            return def;
        }
    }

    public String getDecimal(String key, String format) throws Exception {
        BigDecimal result = this.getDecimal(key);
        return NumberUtil.format(result, format);
    }

    public String getDecimal(String key, double def, String format) {
        return this.getDecimal(key, new BigDecimal(def), format);
    }

    public String getDecimal(String key, BigDecimal def, String format) {
        BigDecimal result = null;
        try {
            result = this.getDecimal(key);
            if (null == result) {
                result = def;
            }
        }
        catch (Exception e) {
            result = def;
        }
        return NumberUtil.format(result, format);
    }

    public java.util.Date getDate(String key, java.util.Date def) {
        java.util.Date result = def;
        Object date = this.get(key);
        if (null == date) {
            return result;
        }
        result = date instanceof java.util.Date ? (java.util.Date)date : DateUtil.parse(date);
        if (null == result) {
            result = def;
        }
        return result;
    }

    public java.util.Date getDate(String key, String def) {
        try {
            return this.getDate(key);
        }
        catch (Exception e) {
            return DateUtil.parse(def);
        }
    }

    public java.util.Date getDate(String key) throws Exception {
        return DateUtil.parse(this.getString(key));
    }

    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    public String toJSON() {
        return BeanUtil.map2json(this);
    }

    public String toJson() {
        return this.toJSON();
    }

    public String getJson() {
        return BeanUtil.map2json(this);
    }

    public String toJSON(JsonInclude.Include include) {
        return BeanUtil.map2json(this, include);
    }

    public String toJson(JsonInclude.Include include) {
        return this.toJSON(include);
    }

    public String getJson(JsonInclude.Include include) {
        return BeanUtil.map2json(this, include);
    }

    public DataRow removeEmpty(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                if (!this.isEmpty(key)) continue;
                this.remove(key);
            }
        } else {
            List<String> cols = this.keys();
            for (String key : cols) {
                if (!this.isEmpty(key)) continue;
                this.remove(key);
            }
        }
        return this;
    }

    public DataRow removeNull(String ... keys) {
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                if (null != this.get(key)) continue;
                this.remove(key);
            }
        }
        List<String> cols = this.keys();
        for (String key : cols) {
            if (null != this.get(key)) continue;
            this.remove(key);
        }
        return this;
    }

    public String toXML() {
        return BeanUtil.map2xml(this);
    }

    public String toXML(boolean border, boolean order) {
        return BeanUtil.map2xml(this, border, order);
    }

    public boolean hasContainer() {
        return null != this.getContainer();
    }

    public DataSet getContainer() {
        return this.container;
    }

    public DataRow setContainer(DataSet container) {
        this.container = container;
        return this;
    }

    public String getSchema() {
        if (null != this.schema) {
            return this.schema;
        }
        DataSet container = this.getContainer();
        if (null != container) {
            return container.getSchema();
        }
        return null;
    }

    public DataRow setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getTable() {
        if (null != this.table) {
            return this.table;
        }
        DataSet container = this.getContainer();
        if (null != container) {
            return container.getTable();
        }
        return null;
    }

    public DataRow setTable(String table) {
        if (null != table && table.contains(".")) {
            String[] tbs = table.split("\\.");
            this.table = tbs[1];
            this.schema = tbs[0];
        } else {
            this.table = table;
        }
        return this;
    }

    public boolean isExpire(int millisecond) {
        return System.currentTimeMillis() - this.createTime > (long)millisecond;
    }

    public boolean isExpire(long millisecond) {
        return System.currentTimeMillis() - this.createTime > millisecond;
    }

    public boolean isExpire() {
        if (this.getExpires() == -1L) {
            return false;
        }
        return System.currentTimeMillis() - this.createTime > this.getExpires();
    }

    @Override
    public Object clone() {
        DataRow row = (DataRow)super.clone();
        row.container = this.container;
        row.primaryKeys = this.primaryKeys;
        row.dataSource = this.dataSource;
        row.schema = this.schema;
        row.table = this.table;
        row.createTime = this.createTime;
        row.nanoTime = this.nanoTime;
        row.isNew = this.isNew;
        return row;
    }

    public Boolean getIsNew() {
        return this.isNew;
    }

    public DataRow setIsNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public List<String> getUpdateColumns() {
        return this.updateColumns;
    }

    public List<String> getIgnoreUpdateColumns() {
        return this.ignoreUpdateColumns;
    }

    public DataRow removes(String ... keys) {
        if (null != keys) {
            for (String key : keys) {
                if (null == key) continue;
                key = this.keyAdapter.key(key);
                super.remove(key);
                this.updateColumns.remove(key);
            }
        }
        return this;
    }

    public DataRow removes(List<String> keys) {
        if (null != keys) {
            for (String key : keys) {
                if (null == key) continue;
                key = this.keyAdapter.key(key);
                super.remove(key);
                this.updateColumns.remove(key);
            }
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        if (null == key) {
            return null;
        }
        this.updateColumns.remove(this.keyAdapter.key(key.toString()));
        return super.remove(this.keyAdapter.key(key.toString()));
    }

    public DataRow clearUpdateColumns() {
        this.updateColumns.clear();
        return this;
    }

    public DataRow clearIgnoreUpdateColumns() {
        this.ignoreUpdateColumns.clear();
        return this;
    }

    public DataRow removeUpdateColumns(String ... cols) {
        if (null != cols) {
            for (String col : cols) {
                String key = this.keyAdapter.key(col);
                this.updateColumns.remove(key);
                this.ignoreUpdateColumns.add(key);
            }
        }
        return this;
    }

    public DataRow addUpdateColumns(String ... cols) {
        if (null != cols) {
            for (String col : cols) {
                String key = this.keyAdapter.key(col);
                if (this.updateColumns.contains(key)) continue;
                this.updateColumns.add(key);
                this.ignoreUpdateColumns.remove(key);
            }
        }
        return this;
    }

    public DataRow addIgnoreColumns(String ... cols) {
        if (null != cols) {
            for (String col : cols) {
                String key = this.keyAdapter.key(col);
                if (this.ignoreUpdateColumns.contains(key)) continue;
                this.ignoreUpdateColumns.add(key);
                this.updateColumns.remove(key);
            }
        }
        return this;
    }

    public DataRow addAllUpdateColumns() {
        this.updateColumns.clear();
        this.updateColumns.addAll(this.keys());
        this.ignoreUpdateColumns.clear();
        return this;
    }

    public DataRow copy(boolean regex, DataRow data, String[] fixs, String ... keys) {
        return this.copy(data, BeanUtil.array2list(fixs, keys), new String[0]);
    }

    public DataRow copy(boolean regex, DataRow data, String ... keys) {
        if (null == data) {
            return this;
        }
        if (null == keys || keys.length == 0) {
            return this.copy(data, data.keys(), new String[0]);
        }
        return this.copy(data, BeanUtil.array2list(new String[][]{keys}), new String[0]);
    }

    public DataRow copy(boolean regex, DataRow data, List<String> fixs, String ... keys) {
        if (null == data || data.isEmpty()) {
            return this;
        }
        List<String> list = BeanUtil.merge(fixs, keys);
        for (String key : list) {
            String[] ks = BeanUtil.parseKeyValue(key);
            if (null != ks && ks.length > 1) {
                this.put(ks[0], data.get(ks[1]));
                continue;
            }
            this.put(key, data.get(key));
        }
        return this;
    }

    public DataRow copy(DataRow data, String[] fixs, String ... keys) {
        return this.copy(false, data, fixs, keys);
    }

    public DataRow copy(DataRow data, String ... keys) {
        return this.copy(false, data, keys);
    }

    public DataRow copy(DataRow data, List<String> fixs, String ... keys) {
        return this.copy(false, data, fixs, keys);
    }

    public DataRow extract(boolean regex, String ... keys) {
        DataRow result = new DataRow();
        result.copy(regex, this, keys);
        return result;
    }

    public DataRow extract(boolean regex, List<String> keys) {
        DataRow result = new DataRow();
        result.copy(regex, this, keys, new String[0]);
        return result;
    }

    public DataRow extract(String ... keys) {
        return this.extract(false, keys);
    }

    public DataRow extract(List<String> keys) {
        return this.extract(false, keys);
    }

    public DataRow copyString(DataRow data, String ... keys) {
        if (null == data || null == keys) {
            return this;
        }
        for (String key : keys) {
            String[] ks = BeanUtil.parseKeyValue(key);
            Object obj = data.get(ks[1]);
            if (BasicUtil.isNotEmpty(obj)) {
                this.put(ks[0], (Object)obj.toString());
                continue;
            }
            this.put(ks[0], (Object)null);
        }
        return this;
    }

    public List<String> numberKeys() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> keys = this.keys();
        for (String key : keys) {
            if (!(this.get(key) instanceof Number)) continue;
            result.add(key);
        }
        return result;
    }

    public boolean checkRequired(String ... keys) {
        ArrayList<String> ks = new ArrayList<String>();
        if (null != keys && keys.length > 0) {
            for (String key : keys) {
                ks.add(key);
            }
        }
        return this.checkRequired(ks);
    }

    public boolean checkRequired(List<String> keys) {
        if (null != keys) {
            for (String key : keys) {
                if (!this.isEmpty(key)) continue;
                return false;
            }
        }
        return true;
    }

    public DataRow camel() {
        List<String> keys = this.keys();
        for (String key : keys) {
            Object value = this.get(key);
            String camel = BeanUtil.camel(key);
            this.updateColumns.remove(key);
            super.remove(key);
            this.put(KeyAdapter.KEY_CASE.SRC, camel, value);
        }
        this.setKeyCase(KeyAdapter.KEY_CASE.camel);
        return this;
    }

    public DataRow Camel() {
        List<String> keys = this.keys();
        for (String key : keys) {
            Object value = this.get(key);
            String Camel = BeanUtil.Camel(key);
            this.updateColumns.remove(key);
            super.remove(key);
            this.put(KeyAdapter.KEY_CASE.SRC, Camel, value);
        }
        this.setKeyCase(KeyAdapter.KEY_CASE.Camel);
        return this;
    }

    private static String getKeyCase(KeyAdapter.KEY_CASE keyCase, String key) {
        if (null == key || keyCase == KeyAdapter.KEY_CASE.SRC) {
            return key;
        }
        if (keyCase == KeyAdapter.KEY_CASE.LOWER) {
            key = key.toLowerCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.UPPER) {
            key = key.toUpperCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.Camel) {
            key = BeanUtil.Camel(key);
        } else if (keyCase == KeyAdapter.KEY_CASE.camel) {
            key = BeanUtil.camel(key);
        }
        return key;
    }

    public static String getKeyCase(String key) {
        return DataRow.getKeyCase(KeyAdapter.KEY_CASE.CONFIG, key);
    }

    private static String putKeyCase(KeyAdapter.KEY_CASE keyCase, String key) {
        if (null == key || keyCase == KeyAdapter.KEY_CASE.SRC) {
            return key;
        }
        if (keyCase == KeyAdapter.KEY_CASE.UPPER) {
            key = key.toUpperCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.LOWER) {
            key = key.toLowerCase();
        } else if (keyCase == KeyAdapter.KEY_CASE.Camel) {
            key = BeanUtil.Camel(key);
        } else if (keyCase == KeyAdapter.KEY_CASE.camel) {
            key = BeanUtil.camel(key);
        } else if (keyCase.getCode().contains("_")) {
            key = BeanUtil.camel_(key);
            if (keyCase == KeyAdapter.KEY_CASE.CAMEL_CONFIG) {
                if (ConfigTable.IS_UPPER_KEY) {
                    key = key.toUpperCase();
                }
                if (ConfigTable.IS_LOWER_KEY) {
                    key = key.toLowerCase();
                }
            } else if (keyCase == KeyAdapter.KEY_CASE.CAMEL_LOWER) {
                key = key.toLowerCase();
            } else if (keyCase == KeyAdapter.KEY_CASE.CAMEL_UPPER) {
                key = key.toUpperCase();
            }
        }
        return key;
    }

    public static String putKeyCase(String key) {
        return DataRow.putKeyCase(KeyAdapter.KEY_CASE.CONFIG, key);
    }

    public boolean isUpdateNullColumn() {
        return this.updateNullColumn;
    }

    public DataRow setUpdateNullColumn(boolean updateNullColumn) {
        this.updateNullColumn = updateNullColumn;
        return this;
    }

    public boolean isUpdateEmptyColumn() {
        return this.updateEmptyColumn;
    }

    public DataRow setUpdateEmptyColumn(boolean updateEmptyColumn) {
        this.updateEmptyColumn = updateEmptyColumn;
        return this;
    }

    public boolean isInsertNullColumn() {
        return this.insertNullColumn;
    }

    public void setInsertNullColumn(boolean insertNullColumn) {
        this.insertNullColumn = insertNullColumn;
    }

    public boolean isInsertEmptyColumn() {
        return this.insertEmptyColumn;
    }

    public void setInsertEmptyColumn(boolean insertEmptyColumn) {
        this.insertEmptyColumn = insertEmptyColumn;
    }

    public DataRow changeKey(String key, String target, boolean remove) {
        this.put(target, this.get(key));
        if (remove && !target.equalsIgnoreCase(key)) {
            this.remove(this.keyAdapter.key(key));
        }
        return this;
    }

    public DataRow changeKey(String key, String target) {
        return this.changeKey(key, target, true);
    }

    public DataRow replaceEmpty(String value) {
        List<String> keys = this.keys();
        for (String key : keys) {
            if (!this.isEmpty(key)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)value);
        }
        return this;
    }

    public DataRow trim() {
        List<String> keys = this.keys();
        for (String key : keys) {
            Object value = this.get(key);
            if (null == value || !(value instanceof String)) continue;
            this.put(KeyAdapter.KEY_CASE.SRC, key, (Object)value.toString().trim());
        }
        return this;
    }

    public DataRow replaceEmpty(String key, String value) {
        if (this.isEmpty(key)) {
            this.put(key, (Object)value);
        }
        return this;
    }

    public DataRow replaceNull(String key, String value) {
        if (null == this.get(key)) {
            this.put(key, (Object)value);
        }
        return this;
    }

    public DataRow replaceNull(String value) {
        List<String> keys = this.keys();
        for (String key : keys) {
            if (null != this.get(key)) continue;
            this.put(key, (Object)value);
        }
        return this;
    }

    public DataRow replace(String key, String oldChar, String newChar) {
        if (null == key || null == oldChar || null == newChar) {
            return this;
        }
        this.put(key, (Object)this.getStringNvl(key, new String[0]).replace(oldChar, newChar));
        return this;
    }

    @Override
    public DataRow replace(String oldChar, String newChar) {
        List<String> keys = this.keys();
        if (null == newChar) {
            newChar = "";
        }
        for (String key : keys) {
            Object value = this.get(key);
            if (value == null || !(value instanceof String)) continue;
            this.put(key, (Object)((String)value).replace(oldChar, newChar));
        }
        return this;
    }

    public String join(String ... keys) {
        String result = "";
        if (null != keys) {
            for (String key : keys) {
                String val = this.getString(key);
                if (!BasicUtil.isNotEmpty(val)) continue;
                result = "".equals(result) ? val : result + "," + val;
            }
        }
        return result;
    }

    public DataRow convertNumber(String ... keys) {
        if (null != keys) {
            for (String key : keys) {
                String v = this.getString(key);
                if (null == v) continue;
                this.remove(this.keyAdapter.key(key));
                this.put(key, (Object)new BigDecimal(v));
            }
        }
        return this;
    }

    public DataRow convertString(String ... keys) {
        List<String> list = null;
        list = null == keys || keys.length == 0 ? this.keys() : BeanUtil.array2list(new String[][]{keys});
        for (String key : list) {
            String v = this.getString(key);
            if (null == v) continue;
            this.put(key, (Object)v.toString());
        }
        return this;
    }

    public Object get(String key) {
        Object result = null;
        if (null != key) {
            key = this.keyAdapter.key(key);
            if (ConfigTable.IS_KEY_IGNORE_CASE) {
                String ignoreKey = key.replace("_", "").replace("-", "").toUpperCase();
                key = this.keymap.get(ignoreKey);
                result = super.get(key);
            } else {
                result = super.get(key);
            }
        }
        return result;
    }

    public Object get(KeyAdapter.KEY_CASE keyCase, String key) {
        KeyAdapter keyAdapter = this.keyAdapter;
        if (null != keyCase) {
            keyAdapter = KeyAdapter.parse(keyCase);
        }
        Object result = null;
        if (null != key) {
            result = super.get(keyAdapter.key(key));
        }
        return result;
    }

    public Object get(boolean voluntary, String ... keys) {
        if (null == keys || keys.length == 0) {
            return null;
        }
        Object result = this;
        for (String key : keys) {
            if (null == result) continue;
            if (result instanceof DataRow) {
                result = ((DataRow)result).get(voluntary, key);
                continue;
            }
            if (ClassUtil.isWrapClass(result) && !(result instanceof String)) {
                result = BeanUtil.getFieldValue(result, key);
                continue;
            }
            if (voluntary) {
                return result;
            }
            result = null;
        }
        return result;
    }

    public Object get(String ... keys) {
        return this.get(false, keys);
    }

    public Object nvl(String ... keys) {
        return BeanUtil.nvl(this, keys);
    }

    public Object evl(String ... keys) {
        return BeanUtil.evl(this, keys);
    }

    public DataRow add(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, 0) + value));
        return this;
    }

    public DataRow add(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, 0.0) + value));
        return this;
    }

    public DataRow add(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, 0) + value));
        return this;
    }

    public DataRow add(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() + value));
        return this;
    }

    public DataRow add(String target, String key, BigDecimal value) {
        this.put(target, (Object)this.getDecimal(key, 0).add(value));
        return this;
    }

    public DataRow add(String key, int value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, double value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, short value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, float value) {
        return this.add(key, key, value);
    }

    public DataRow add(String key, BigDecimal value) {
        return this.add(key, key, value);
    }

    public DataRow subtract(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, 0) - value));
        return this;
    }

    public DataRow subtract(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, 0.0) - value));
        return this;
    }

    public DataRow subtract(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, 0) - value));
        return this;
    }

    public DataRow subtract(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() - value));
        return this;
    }

    public DataRow subtract(String target, String key, BigDecimal value) {
        this.put(target, (Object)this.getDecimal(key, 0).subtract(value));
        return this;
    }

    public DataRow subtract(String key, int value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, double value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, short value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, float value) {
        return this.subtract(key, key, value);
    }

    public DataRow subtract(String key, BigDecimal value) {
        return this.subtract(key, key, value);
    }

    public DataRow multiply(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, 0) * value));
        return this;
    }

    public DataRow multiply(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, 0.0) * value));
        return this;
    }

    public DataRow multiply(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, 0) * value));
        return this;
    }

    public DataRow multiply(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() * value));
        return this;
    }

    public DataRow multiply(String target, String key, BigDecimal value) {
        this.put(target, (Object)this.getDecimal(key, 0).multiply(value));
        return this;
    }

    public DataRow multiply(String key, int value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, double value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, short value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, float value) {
        return this.multiply(key, key, value);
    }

    public DataRow multiply(String key, BigDecimal value) {
        return this.multiply(key, key, value);
    }

    public DataRow divide(String target, String key, int value) {
        this.put(target, (Object)(this.getInt(key, 0) / value));
        return this;
    }

    public DataRow divide(String target, String key, double value) {
        this.put(target, (Object)(this.getDouble(key, 0.0) / value));
        return this;
    }

    public DataRow divide(String target, String key, short value) {
        this.put(target, (Object)(this.getInt(key, 0) / value));
        return this;
    }

    public DataRow divide(String target, String key, float value) {
        this.put(target, (Object)Float.valueOf(this.getFloat(key, Float.valueOf(0.0f)).floatValue() / value));
        return this;
    }

    public DataRow divide(String target, String key, BigDecimal value, int mode) {
        this.put(target, (Object)this.getDecimal(key, 0).divide(value, mode));
        return this;
    }

    public DataRow divide(String key, int value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, double value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, short value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, float value) {
        return this.divide(key, key, value);
    }

    public DataRow divide(String key, BigDecimal value, int mode) {
        return this.divide(key, key, value, mode);
    }

    public DataRow round(String target, String key, int scale, int mode) {
        BigDecimal value = this.getDecimal(key, 0);
        value.setScale(scale, mode);
        this.put(target, (Object)value);
        return this;
    }

    public DataRow round(String key, int scale, int mode) {
        return this.round(key, key, scale, mode);
    }

    @Override
    public String toString() {
        return this.toJSON();
    }
}

