/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.util.List;
import org.anyline.util.BasicUtil;
import org.anyline.util.GISUtil;

public class Coordinate {
    private Double[] point = new Double[2];
    private Double[] center = new Double[2];
    private TYPE type;
    private String provinceCode;
    private String provinceName;
    private String cityCode;
    private String cityName;
    private String countyCode;
    private String countyName;
    private String townCode;
    private String townName;
    private String villageCode;
    private String villageName;
    private String street;
    private String streetNumber;
    private List<Double[]> border;
    private String code;
    private int level;
    private String address;
    private boolean success = true;
    private String message = null;
    private int reliability;
    private int accuracy;

    public Coordinate(String location) {
        String[] tmps;
        if (BasicUtil.isNotEmpty(location) && (tmps = location.split(",")).length > 1) {
            this.point[0] = BasicUtil.parseDouble(tmps[0], null);
            this.point[1] = BasicUtil.parseDouble(tmps[1], null);
        }
    }

    public Coordinate() {
    }

    public Coordinate(TYPE type, String lng, String lat) {
        this.type = type;
        this.point[0] = BasicUtil.parseDouble(lng, null);
        this.point[1] = BasicUtil.parseDouble(lat, null);
    }

    public Coordinate(TYPE type, Double lng, Double lat) {
        this.type = type;
        this.point[0] = lng;
        this.point[1] = lat;
    }

    public Coordinate(String lng, String lat) {
        this.point[0] = BasicUtil.parseDouble(lng, null);
        this.point[1] = BasicUtil.parseDouble(lat, null);
    }

    public Coordinate(Double lng, Double lat) {
        this.point[0] = lng;
        this.point[1] = lat;
    }

    public Coordinate convert(TYPE type) {
        this.point = GISUtil.convert(this.type, this.point[0], this.point[1], type);
        this.setType(type);
        return this;
    }

    public boolean isEmpty() {
        return this.point.length != 2 || null == this.point[0] || null == this.point[1];
    }

    public void setLocation(String location) {
        String[] tmps;
        if (BasicUtil.isNotEmpty(location) && (tmps = location.split(",")).length > 1) {
            this.point[0] = BasicUtil.parseDouble(tmps[0], null);
            this.point[1] = BasicUtil.parseDouble(tmps[1], null);
        }
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountyName() {
        return this.countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getTownCode() {
        return this.townCode;
    }

    public void setTownCode(String townCode) {
        this.townCode = townCode;
    }

    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public Double getLng() {
        return this.point[0];
    }

    public void setLng(Double lng) {
        this.point[0] = lng;
    }

    public void setLng(String lng) {
        this.point[0] = BasicUtil.parseDouble(lng, null);
    }

    public Double getLat() {
        return this.point[1];
    }

    public void setLat(Double lat) {
        this.point[1] = lat;
    }

    public void setLat(String lat) {
        this.point[1] = BasicUtil.parseDouble(lat, null);
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return this.countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public Double[] getPoint() {
        return this.point;
    }

    public void setPoint(Double[] point) {
        this.point = point;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Double[] getCenter() {
        return this.center;
    }

    public void setCenter(Double[] center) {
        this.center = center;
    }

    public String getVillageCode() {
        return this.villageCode;
    }

    public void setVillageCode(String villageCode) {
        this.villageCode = villageCode;
    }

    public String getVillageName() {
        return this.villageName;
    }

    public void setVillageName(String villageName) {
        this.villageName = villageName;
    }

    public List<Double[]> getBorder() {
        return this.border;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public void setBorder(List<Double[]> border) {
        this.border = border;
    }

    public int getReliability() {
        return this.reliability;
    }

    public void setReliability(int reliability) {
        this.reliability = reliability;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public static enum TYPE {
        WGS84LL{

            @Override
            public String getCode() {
                return "WGS84LL";
            }

            @Override
            public String getName() {
                return "\u5927\u5730\u5750\u6807\u7cfb";
            }

            @Override
            public String getRemark() {
                return "GPS/\u56fd\u5916\u8c37\u6b4c";
            }
        }
        ,
        GCJ02LL{

            @Override
            public String getCode() {
                return "GCJ02LL";
            }

            @Override
            public String getName() {
                return "\u706b\u661f\u5750\u6807\u7cfb";
            }

            @Override
            public String getRemark() {
                return "\u56fd\u5bb6\u6d4b\u7ed8\u5c40\u5236\u5b9a(\u56fd\u5185\u8c37\u6b4c/\u9ad8\u5fb7/\u817e\u8baf)";
            }
        }
        ,
        BD09LL{

            @Override
            public String getCode() {
                return "BD09LL";
            }

            @Override
            public String getName() {
                return "\u767e\u5ea6\u5750\u6807\u7cfb";
            }

            @Override
            public String getRemark() {
                return "\u767e\u5ea6\u5750\u6807\u7cfb";
            }
        }
        ,
        BD09MC{

            @Override
            public String getCode() {
                return "BD09MC";
            }

            @Override
            public String getName() {
                return "\u767e\u5ea6\u7c73\u5236\u5750\u6807\u7cfb";
            }

            @Override
            public String getRemark() {
                return "\u767e\u5ea6\u7c73\u5236\u5750\u6807\u7cfb";
            }
        };


        public abstract String getCode();

        public abstract String getName();

        public abstract String getRemark();
    }
}

