/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.anyline.util.BasicUtil;

public enum Compare {
    AUTO{

        @Override
        public boolean compare(Object value, Object target) {
            return false;
        }

        @Override
        public String getSQL() {
            return null;
        }

        @Override
        public int getCode() {
            return 0;
        }

        @Override
        public String getName() {
            return null;
        }
    }
    ,
    EQUAL{

        @Override
        public int getCode() {
            return 10;
        }

        @Override
        public String getSQL() {
            return " = ?";
        }

        @Override
        public String getName() {
            return "\u7b49\u4e8e";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target) {
                return null == value;
            }
            return target.toString().equalsIgnoreCase(value.toString());
        }
    }
    ,
    GREAT{

        @Override
        public int getCode() {
            return 20;
        }

        @Override
        public String getSQL() {
            return " > ?";
        }

        @Override
        public String getName() {
            return "\u5927\u4e8e";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) > 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    GREAT_EQUAL{

        @Override
        public int getCode() {
            return 21;
        }

        @Override
        public String getSQL() {
            return " >= ?";
        }

        @Override
        public String getName() {
            return "\u5927\u4e8e\u7b49\u4e8e";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) >= 0;
        }
    }
    ,
    LESS{

        @Override
        public int getCode() {
            return 30;
        }

        @Override
        public String getSQL() {
            return " < ?";
        }

        @Override
        public String getName() {
            return "\u5c0f\u4e8e";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) < 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    LESS_EQUAL{

        @Override
        public int getCode() {
            return 31;
        }

        @Override
        public String getSQL() {
            return " <= ?";
        }

        @Override
        public String getName() {
            return "\u5c0f\u4e8e\u7b49\u4e8e";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) <= 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    IN{

        @Override
        public int getCode() {
            return 40;
        }

        @Override
        public String getSQL() {
            return " IN ";
        }

        @Override
        public String getName() {
            return "in";
        }

        @Override
        public boolean compare(Object value, Object targets) {
            if (null != targets && targets instanceof Collection) {
                Collection cols = (Collection)targets;
                for (Object v : cols) {
                    if (null == v || !v.toString().equalsIgnoreCase(value.toString())) continue;
                    return true;
                }
            }
            return false;
        }
    }
    ,
    LIKE{

        @Override
        public int getCode() {
            return 50;
        }

        @Override
        public String getSQL() {
            return " LIKE ";
        }

        @Override
        public String getName() {
            return "%like%";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().contains(target.toString().toUpperCase());
        }
    }
    ,
    LIKE_PREFIX{

        @Override
        public int getCode() {
            return 51;
        }

        @Override
        public String getSQL() {
            return " LIKE ";
        }

        @Override
        public String getName() {
            return "%like";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().startsWith(target.toString().toUpperCase());
        }
    }
    ,
    LIKE_SUFFIX{

        @Override
        public int getCode() {
            return 52;
        }

        @Override
        public String getSQL() {
            return " LIKE ";
        }

        @Override
        public String getName() {
            return "like%";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().endsWith(target.toString().toUpperCase());
        }
    }
    ,
    BETWEEN{

        @Override
        public int getCode() {
            return 80;
        }

        @Override
        public String getSQL() {
            return " BETWEEN ? AND ? ";
        }

        @Override
        public String getName() {
            return "\u533a\u95f4";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == value) {
                return false;
            }
            if (target instanceof List) {
                List list = (List)target;
                Object min = list.get(0);
                Object max = list.get(1);
                return this.compare(value, BasicUtil.parseDecimal(min, null), BasicUtil.parseDecimal(max, null));
            }
            return false;
        }

        public boolean compare(Object value, BigDecimal min, BigDecimal max) {
            if (null == value || null == min || null == max) {
                return false;
            }
            try {
                BigDecimal v = new BigDecimal(value.toString());
                if (v.compareTo(min) >= 0 && v.compareTo(max) <= 0) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }
    ,
    NOT_EQUAL{

        @Override
        public int getCode() {
            return 110;
        }

        @Override
        public String getSQL() {
            return " != ?";
        }

        @Override
        public String getName() {
            return "\u4e0d\u7b49\u4e8e";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return !value.toString().toUpperCase().equals(target.toString().toUpperCase());
        }
    }
    ,
    NOT_IN{

        @Override
        public int getCode() {
            return 140;
        }

        @Override
        public String getSQL() {
            return " NOT IN ";
        }

        @Override
        public String getName() {
            return "\u4e0d\u5305\u542b";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }
    };


    public abstract boolean compare(Object var1, Object var2);

    public abstract String getSQL();

    public abstract int getCode();

    public abstract String getName();
}

