/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.redis.util;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.util.BeanUtil;
import redis.clients.jedis.JedisCluster;

public class RedisUtil {
    private static Hashtable<String, RedisUtil> instances = new Hashtable();
    private JedisCluster cluster;
    private String prefix = "";

    public static RedisUtil newInstance(String key, JedisCluster cluster, String prefix) {
        RedisUtil util = instances.get(key);
        if (null == util) {
            util = new RedisUtil();
            util.cluster = cluster;
            util.prefix = prefix;
            instances.put(key, util);
        }
        return util;
    }

    public static RedisUtil getInstance(String key) {
        return instances.get(key);
    }

    public String key(String key) {
        return this.prefix + key;
    }

    public String set(String key, String value) {
        return this.cluster.set(this.key(key), value);
    }

    public String setex(String key, int seconds, String value) {
        return this.cluster.setex(this.key(key), seconds, value);
    }

    public String get(String key) {
        return this.cluster.get(this.key(key));
    }

    public Long delete(String key) {
        return this.cluster.del(this.key(key));
    }

    public String string(String key, String value) {
        return this.cluster.set(this.key(key), value);
    }

    public String string(String key) {
        return this.cluster.get(this.key(key));
    }

    public boolean exists(String key) {
        return this.cluster.exists(this.key(key));
    }

    public String object(String key, Object value) {
        key = this.key(key);
        if (null != value) {
            if (value instanceof String) {
                return this.cluster.set(key, (String)value);
            }
            return this.cluster.set(key.getBytes(), BeanUtil.serialize((Object)value));
        }
        return null;
    }

    public Object object(String key) {
        Object result = null;
        if (this.cluster.exists((key = this.key(key)).getBytes()).booleanValue()) {
            return null;
        }
        byte[] in = this.cluster.get(key.getBytes());
        result = BeanUtil.deserialize((byte[])in);
        return result;
    }

    public <T> List<T> list(String key) {
        return (List)this.object(key);
    }

    public <T> Map<String, T> map(String key) {
        return (Map)this.object(key);
    }
}

